/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.internal;

import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.team.core.history.IFileRevision;
import org.osgi.service.log.LogService;

public class StorageAdapter
implements IAdapterFactory {
    private Class[] adapters = new Class[]{IStoragePathProvider.class};
    private static final List<String> stbModelExtensions = Arrays.asList("tech", "tech_ext", "md", "proc", "map", "tpc");
    public static final Path inexistentResourcePath = new Path("/__dummy/__dummy");
    private static byte[] NEW_FILES_EMPTY_CONTENT = "".getBytes();

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof StreamAccessorStorage && adapterType == IStoragePathProvider.class) {
            return (T)new IStoragePathProvider(){

                public IPath computeFixedPath(IStorage storage) {
                    IFile file;
                    IPath path = storage.getFullPath();
                    IStreamContentAccessor accessor = (IStreamContentAccessor)storage.getAdapter(IStreamContentAccessor.class);
                    if (accessor instanceof EditableRevision) {
                        try {
                            DirCache cache;
                            int firstIndex;
                            IFileRevision rev = ((EditableRevision)accessor).getFileRevision();
                            if (rev instanceof IndexFileRevision && (firstIndex = (cache = ((IndexFileRevision)rev).getRepository().readDirCache()).findEntry(((IndexFileRevision)rev).getGitPath())) < 0) {
                                if (((EditableRevision)accessor).getModifiedContent() == null || ((EditableRevision)accessor).getModifiedContent() == NEW_FILES_EMPTY_CONTENT) {
                                    ((EditableRevision)accessor).setContent(NEW_FILES_EMPTY_CONTENT);
                                }
                                return inexistentResourcePath.addFileExtension(path.getFileExtension());
                            }
                        }
                        catch (Exception e) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(StorageAdapter.class).warn(String.format("Failed to detect non indexed resource %s", path), (Object)e);
                        }
                    }
                    boolean readOnly = true;
                    try {
                        readOnly = storage.isReadOnly();
                    }
                    catch (Exception cache) {
                        // empty catch block
                    }
                    if (!readOnly && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) {
                        FullPathVisitor v = new FullPathVisitor(storage.getFullPath());
                        try {
                            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)v);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!v.files.isEmpty()) {
                            return v.files.get(0).getFullPath();
                        }
                    }
                    return path;
                }
            };
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return this.adapters;
    }

    public static class FullPathVisitor
    implements IResourceVisitor {
        List<IFile> files = new ArrayList<IFile>();
        IPath storageFullPath;

        public FullPathVisitor(IPath storageFullPath) {
            if (!stbModelExtensions.contains(storageFullPath.getFileExtension())) {
                String ext = storageFullPath.getFileExtension();
                if (ext.contains(" ")) {
                    this.storageFullPath = storageFullPath.removeFileExtension().addFileExtension(ext.substring(0, storageFullPath.getFileExtension().indexOf(" ")));
                } else if (ext.contains("%20")) {
                    this.storageFullPath = storageFullPath.removeFileExtension().addFileExtension(ext.substring(0, storageFullPath.getFileExtension().indexOf("%20")));
                }
            } else {
                this.storageFullPath = storageFullPath;
            }
        }

        public List<IFile> getMatchingFiles() {
            return this.files;
        }

        public boolean visit(IResource resource) throws CoreException {
            URI u;
            URI uu;
            if (resource.getType() == 4 && !resource.getProject().isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && (resource.getName().equals("indy.build") || resource.getName().equals("indy.diagram") || resource.getName().startsWith("."))) {
                return false;
            }
            if (resource.getType() == 1 && this.storageFullPath.getFileExtension().equals(resource.getFileExtension()) && (uu = resource.getLocationURI()).equals(u = URIUtil.toURI((IPath)this.storageFullPath.setDevice(resource.getRawLocation().getDevice())))) {
                this.files.add((IFile)resource);
            }
            return true;
        }
    }
}

