/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.md;

import com.google.common.base.Function;
import com.indy.emf.compare.integration.md.CompareMdPackage;
import com.indy.emf.compare.integration.md.Messages;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Externalize;
import com.stambia.md.MdLink;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.spec.ReferenceChangeSpec;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MdPostProcessor
implements IPostProcessor {
    private List<Match> matches = new ArrayList<Match>();

    String getPath(Match parent, MdNode node) {
        String res = "";
        if (node == parent.getLeft() || node == parent.getRight() || node == parent.getOrigin()) {
            return res;
        }
        res = "/" + this.getName((Configuration)node);
        if (node.eContainer() instanceof MdNode) {
            res = String.valueOf(this.getPath(parent, (MdNode)node.eContainer())) + res;
        }
        return res;
    }

    private String getName(Configuration node) {
        String name = node.getName();
        if (node.eClass() == CompareMdPackage.eINSTANCE.getConfiguration()) {
            if (name != null && !name.isEmpty()) {
                return "(" + name + ")";
            }
            return "(conf[" + ((MdNode)node.eContainer()).getConfiguration().indexOf((Object)node) + "])";
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        int count = 0;
        if (node.eContainer() instanceof MdNode) {
            MdNode parent = (MdNode)node.eContainer();
            int i = 0;
            while (i < parent.getNode().size()) {
                if (((MdNode)parent.getNode().get(i)).getDefType().equals(node.getDefType())) {
                    ++count;
                }
                if (parent.getNode().get(i) == node) break;
                ++i;
            }
            return "{" + node.getDefType() + "}[" + count + "]";
        }
        return "[ROOT]";
    }

    private void collectInterestingMatches(Match match) {
        if (match.getLeft() == null || match.getRight() == null) {
            if (match.getLeft() instanceof MdNode) {
                if (match.getRight() == null) {
                    this.matches.add(match);
                    return;
                }
            } else if (match.getRight() instanceof MdNode && match.getLeft() == null) {
                this.matches.add(match);
                return;
            }
        }
        for (Match subMatch : match.getSubmatches()) {
            this.collectInterestingMatches(subMatch);
        }
    }

    private HashMap<Match, Match> computeReplacement() {
        HashMap<Match, Match> res = new HashMap<Match, Match>();
        Iterator<Match> it = this.matches.iterator();
        while (it.hasNext()) {
            Match match = it.next();
            Match alternative = null;
            for (Match m : this.matches) {
                boolean b;
                if (m == match || m.eContainer() != match.eContainer() || !(b = this.isAlternative(match, m))) continue;
                alternative = m;
                break;
            }
            if (alternative == null) continue;
            it.remove();
            res.put(match, alternative);
        }
        return res;
    }

    public void postMatch(Comparison comparison, Monitor monitor) throws MdPostProcessorException {
        for (Match m : comparison.getMatches()) {
            this.collectInterestingMatches(m);
        }
        HashMap<Match, Match> replacement = this.computeReplacement();
        try {
            for (Match match : replacement.keySet()) {
                Match alternative = replacement.get(match);
                Match parentMatch = (Match)match.eContainer();
                if (alternative.eContainer() != null) {
                    ((Match)alternative.eContainer()).getSubmatches().remove((Object)alternative);
                }
                if (match.eContainer() != null) {
                    ((Match)match.eContainer()).getSubmatches().remove((Object)match);
                }
                comparison.getMatches().remove((Object)alternative);
                comparison.getMatches().remove((Object)match);
                Match newMatch = CompareFactory.eINSTANCE.createMatch();
                if (match.getLeft() != null) {
                    newMatch.setLeft(match.getLeft());
                } else {
                    newMatch.setLeft(alternative.getLeft());
                }
                if (match.getRight() != null) {
                    newMatch.setRight(match.getRight());
                } else {
                    newMatch.setRight(alternative.getRight());
                }
                if (match.getOrigin() != null) {
                    newMatch.setOrigin(match.getOrigin());
                } else {
                    newMatch.setOrigin(alternative.getOrigin());
                }
                Comparison subComparison = CompareFactory.eINSTANCE.createComparison();
                TreeIterator itLeft = EcoreUtil.getAllProperContents((EObject)newMatch.getLeft(), (boolean)false);
                TreeIterator itRight = EcoreUtil.getAllProperContents((EObject)newMatch.getRight(), (boolean)false);
                TreeIterator itOrigin = EcoreUtil.getAllProperContents((EObject)newMatch.getOrigin(), (boolean)false);
                IdentifierEObjectMatcher pathMatcher = new IdentifierEObjectMatcher((Function)new PathFunction(parentMatch));
                pathMatcher.createMatches(subComparison, (Iterator)itLeft, (Iterator)itRight, (Iterator)itOrigin, monitor);
                for (Match m : new ArrayList(subComparison.getMatches())) {
                    newMatch.getSubmatches().add((Object)m);
                }
                parentMatch.getSubmatches().add((Object)newMatch);
            }
        }
        catch (Exception ex) {
            throw new MdPostProcessorException(ex);
        }
    }

    List<Match> getAncestors(Match m) {
        ArrayList<Match> r = new ArrayList<Match>();
        if (m.eContainer() instanceof Match) {
            m = (Match)m.eContainer();
            r.add(m);
            r.addAll(this.getAncestors(m));
        }
        return r;
    }

    private boolean isAlternative(Match match, Match alternative) {
        List<Match> matchAncestors = this.getAncestors(match);
        List<Match> altAncestorrs = this.getAncestors(alternative);
        matchAncestors.retainAll(altAncestorrs);
        if (matchAncestors.isEmpty()) {
            return false;
        }
        Match commonAncestor = matchAncestors.get(0);
        String matchName = null;
        matchName = match.getLeft() instanceof MdNode ? this.getPath(commonAncestor, (MdNode)match.getLeft()) : this.getPath(commonAncestor, (MdNode)match.getRight());
        String alternativeName = null;
        alternativeName = alternative.getLeft() instanceof MdNode ? this.getPath(commonAncestor, (MdNode)alternative.getLeft()) : this.getPath(commonAncestor, (MdNode)alternative.getRight());
        return matchName.equals(alternativeName);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) throws MdPostProcessorException {
        ArrayList<ReferenceChangeSpec> referenceChanges = new ArrayList<ReferenceChangeSpec>();
        HashMap<String, AttributeChange> idChanges = new HashMap<String, AttributeChange>();
        try {
            for (Diff d : comparison.getDifferences()) {
                AttributeChange a;
                if (d instanceof ReferenceChangeSpec) {
                    ReferenceChangeSpec ref = (ReferenceChangeSpec)d;
                    if (ref.getReference() != CompareMdPackage.eINSTANCE.getAttribute_Ref() && ref.getReference() != CompareMdPackage.eINSTANCE.getAttribute_Refs()) continue;
                    referenceChanges.add(ref);
                    continue;
                }
                if (!(d instanceof AttributeChange) || (a = (AttributeChange)d).getAttribute() != CompareMdPackage.eINSTANCE.getElement_Id() || (d.getMatch().getLeft() == null || d.getMatch().getLeft().eClass() != CompareMdPackage.eINSTANCE.getMdNode()) && (d.getMatch().getRight() == null || d.getMatch().getRight().eClass() != CompareMdPackage.eINSTANCE.getMdNode())) continue;
                switch (a.getSource()) {
                    case LEFT: {
                        idChanges.put((String)a.getMatch().getLeft().eGet((EStructuralFeature)a.getAttribute()), a);
                        break;
                    }
                    case RIGHT: {
                        idChanges.put((String)a.getMatch().getRight().eGet((EStructuralFeature)a.getAttribute()), a);
                    }
                }
            }
            for (ReferenceChangeSpec r : referenceChanges) {
                EObject o = r.getValue();
                String fileID = CacheHelper.extractFileID((EObject)o);
                String eltID = CacheHelper.extractEltID((EObject)o);
                AttributeChange a = (AttributeChange)idChanges.get(fileID);
                if (a != null && r.getSource() == a.getSource()) {
                    r.getRequires().add((Object)a);
                    a.getRequires().add((Object)r);
                }
                if ((a = (AttributeChange)idChanges.get(eltID)) == null || r.getSource() != a.getSource()) continue;
                r.getRequires().add((Object)a);
                a.getRequires().add((Object)r);
            }
        }
        catch (Exception ex) {
            throw new MdPostProcessorException(ex);
        }
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    class MdPostProcessorException
    extends RuntimeException {
        public MdPostProcessorException(Exception cause) {
            super(String.format(Messages.MdPostProcessor_0, EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry().getItemDescriptor(MdPostProcessor.class.getName())), cause);
        }
    }

    class PathFunction
    implements Function<EObject, String> {
        Match parent;
        HashMap<MdNode, String> paths = new HashMap();

        PathFunction(Match parent) {
            this.parent = parent;
        }

        public String apply(EObject input) {
            if (input instanceof Attribute) {
                String confName = "";
                MdNode parentNode = null;
                if (input.eContainer().eClass() == CompareMdPackage.eINSTANCE.getConfiguration()) {
                    confName = MdPostProcessor.this.getName((Configuration)input.eContainer());
                    parentNode = (MdNode)input.eContainer().eContainer();
                } else {
                    parentNode = (MdNode)input.eContainer();
                }
                String res = String.valueOf(MdPostProcessor.this.getPath(this.parent, parentNode)) + confName + "@" + ((Attribute)input).getDefType();
                return res;
            }
            if (input instanceof MdNode) {
                return MdPostProcessor.this.getPath(this.parent, (MdNode)input);
            }
            if (input instanceof MdLink) {
                return String.valueOf(MdPostProcessor.this.getPath(this.parent, (MdNode)input.eContainer())) + "->" + ((MdLink)input).getName();
            }
            if (input instanceof Externalize) {
                String confName = "";
                MdNode parentNode = null;
                if (input.eContainer().eClass() == CompareMdPackage.eINSTANCE.getConfiguration()) {
                    confName = MdPostProcessor.this.getName((Configuration)input.eContainer());
                    parentNode = (MdNode)input.eContainer().eContainer();
                } else {
                    parentNode = (MdNode)input.eContainer();
                }
                String res = String.valueOf(MdPostProcessor.this.getPath(this.parent, parentNode)) + confName + "*" + ((Externalize)input).getDefType();
                return res;
            }
            if (input instanceof Configuration) {
                String res = String.valueOf(MdPostProcessor.this.getPath(this.parent, (MdNode)input.eContainer())) + "*" + ((Externalize)input).getDefType();
                return res;
            }
            return null;
        }
    }
}

