/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.proc;

import com.google.common.base.Function;
import com.indy.emf.compare.integration.proc.Messages;
import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.AltId;
import com.indy.gmf.proc.Common;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.XslVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProcPostProcessor
implements IPostProcessor {
    private List<Match> matches = new ArrayList<Match>();

    String getPath(Match parent, EObject node) {
        if (node == parent.getLeft() || node == parent.getRight() || node == parent.getOrigin()) {
            return "";
        }
        String name = null;
        if (node instanceof Action) {
            name = ((Action)node).getName();
        } else if (node instanceof AltId) {
            name = "[altdId=" + ((AltId)node).getOrigin() + "]";
        } else if (node instanceof MetaDataLink) {
            name = "->" + ((MetaDataLink)node).getName().getLocalPart();
        } else if (node instanceof Parameter) {
            name = "[param=" + ((Parameter)node).getName() + "]";
        } else if (node instanceof XslVariable) {
            name = "[var=" + ((XslVariable)node).getName() + "]";
        }
        if (name != null && node.eContainer() instanceof Action) {
            String res = String.valueOf(this.getPath(parent, node.eContainer())) + "/" + name;
            return res;
        }
        return null;
    }

    private void collectInterestingMatches(Match match) {
        if (match.getLeft() == null || match.getRight() == null) {
            if (match.getLeft() != null) {
                if (match.getRight() == null) {
                    this.matches.add(match);
                    return;
                }
            } else if (match.getRight() != null && match.getLeft() == null) {
                this.matches.add(match);
                return;
            }
        }
        for (Match subMatch : match.getSubmatches()) {
            this.collectInterestingMatches(subMatch);
        }
    }

    private HashMap<Match, Match> computeReplacement() {
        HashMap<Match, Match> res = new HashMap<Match, Match>();
        Iterator<Match> it = this.matches.iterator();
        while (it.hasNext()) {
            Match match = it.next();
            Match alternative = null;
            for (Match m : this.matches) {
                boolean b;
                if (m == match || m.eContainer() != match.eContainer() || !(b = this.isAlternative(match, m))) continue;
                alternative = m;
                break;
            }
            if (alternative == null) continue;
            it.remove();
            res.put(match, alternative);
        }
        return res;
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
        for (Match m : comparison.getMatches()) {
            this.collectInterestingMatches(m);
        }
        HashMap<Match, Match> replacement = this.computeReplacement();
        try {
            for (Match match : replacement.keySet()) {
                Match alternative = replacement.get(match);
                Match parentMatch = (Match)match.eContainer();
                if (alternative.eContainer() != null) {
                    ((Match)alternative.eContainer()).getSubmatches().remove((Object)alternative);
                }
                if (match.eContainer() != null) {
                    ((Match)match.eContainer()).getSubmatches().remove((Object)match);
                }
                comparison.getMatches().remove((Object)alternative);
                comparison.getMatches().remove((Object)match);
                Match newMatch = CompareFactory.eINSTANCE.createMatch();
                if (match.getLeft() != null) {
                    newMatch.setLeft(match.getLeft());
                } else {
                    newMatch.setLeft(alternative.getLeft());
                }
                if (match.getRight() != null) {
                    newMatch.setRight(match.getRight());
                } else {
                    newMatch.setRight(alternative.getRight());
                }
                if (match.getOrigin() != null) {
                    newMatch.setOrigin(match.getOrigin());
                } else {
                    newMatch.setOrigin(alternative.getOrigin());
                }
                Comparison subComparison = CompareFactory.eINSTANCE.createComparison();
                TreeIterator itLeft = EcoreUtil.getAllProperContents((EObject)newMatch.getLeft(), (boolean)false);
                TreeIterator itRight = EcoreUtil.getAllProperContents((EObject)newMatch.getRight(), (boolean)false);
                TreeIterator itOrigin = newMatch.getOrigin() == null ? Collections.EMPTY_LIST.iterator() : EcoreUtil.getAllProperContents((EObject)newMatch.getOrigin(), (boolean)false);
                IdentifierEObjectMatcher pathMatcher = new IdentifierEObjectMatcher((Function)new PathFunction(parentMatch));
                pathMatcher.createMatches(subComparison, (Iterator)itLeft, (Iterator)itRight, (Iterator)itOrigin, monitor);
                for (Match m : new ArrayList(subComparison.getMatches())) {
                    newMatch.getSubmatches().add((Object)m);
                }
                parentMatch.getSubmatches().add((Object)newMatch);
            }
        }
        catch (Exception ex) {
            throw new ProcPostProcessorException(ex);
        }
    }

    List<Match> getAncestors(Match m) {
        ArrayList<Match> r = new ArrayList<Match>();
        if (m.eContainer() instanceof Match) {
            m = (Match)m.eContainer();
            r.add(m);
            r.addAll(this.getAncestors(m));
        }
        return r;
    }

    private boolean isAlternative(Match match, Match alternative) {
        List<Match> matchAncestors = this.getAncestors(match);
        List<Match> altAncestorrs = this.getAncestors(alternative);
        matchAncestors.retainAll(altAncestorrs);
        if (matchAncestors.isEmpty()) {
            return false;
        }
        Match commonAncestor = matchAncestors.get(0);
        String matchName = null;
        matchName = match.getLeft() != null ? this.getPath(commonAncestor, match.getLeft()) : this.getPath(commonAncestor, match.getRight());
        if (matchName == null) {
            return false;
        }
        String alternativeName = null;
        alternativeName = alternative.getLeft() != null ? this.getPath(commonAncestor, alternative.getLeft()) : this.getPath(commonAncestor, alternative.getRight());
        if (alternativeName == null) {
            return false;
        }
        return matchName.equals(alternativeName);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    class PathFunction
    implements Function<EObject, String> {
        Match parent;
        HashMap<Common, String> paths = new HashMap();

        PathFunction(Match parent) {
            this.parent = parent;
        }

        public String apply(EObject input) {
            if (input instanceof Action) {
                return ProcPostProcessor.this.getPath(this.parent, input);
            }
            if (input instanceof AltId) {
                return ProcPostProcessor.this.getPath(this.parent, input);
            }
            if (input instanceof XslVariable) {
                return ProcPostProcessor.this.getPath(this.parent, input);
            }
            if (input instanceof MetaDataLink) {
                return ProcPostProcessor.this.getPath(this.parent, input);
            }
            if (input instanceof Parameter) {
                return ProcPostProcessor.this.getPath(this.parent, input);
            }
            return null;
        }
    }

    class ProcPostProcessorException
    extends RuntimeException {
        public ProcPostProcessorException(Exception cause) {
            super(String.format(Messages.ProcPostProcessor_0, EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry().getItemDescriptor(ProcPostProcessor.class.getName())), cause);
        }
    }
}

