/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class OAuth2Utils {
    public static void setLog4JLogger(OAuth2Metadata meta, Logger logger) {
        meta.setLogger(OAuth2Utils.wrapLog4JLogger(logger));
    }

    private static OAuth2Metadata.Logger wrapLog4JLogger(final Logger logger) {
        return new OAuth2Metadata.Logger(){

            @Override
            public void debug(String message) {
                logger.debug(message);
            }

            @Override
            public void warn(String message, Exception e) {
                logger.warn(message, (Throwable)e);
            }

            @Override
            public void warn(String message) {
                logger.warn(message);
            }
        };
    }

    public static Map<String, Object> convertPropertiesToMap(Properties props) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        HashMap keysMap = new HashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            ArrayList strings;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] splitKey = key.split("\\.");
            if (splitKey.length == 1) {
                newMap.put(key, value);
                continue;
            }
            if (splitKey.length == 2) {
                if (!newMap.containsKey(splitKey[0])) {
                    ArrayList<String> strings2 = new ArrayList<String>();
                    strings2.add(value);
                    newMap.put(splitKey[0], strings2);
                    continue;
                }
                int index = Integer.parseInt(splitKey[1]);
                if (index > (strings = (ArrayList)newMap.get(splitKey[0])).size()) {
                    strings.add(value);
                    continue;
                }
                strings.add(index, value);
                continue;
            }
            if (splitKey.length != 3) continue;
            if (!keysMap.containsKey(splitKey[0])) {
                ArrayList<String> strings3 = new ArrayList<String>();
                strings3.add(value);
                keysMap.put(splitKey[0], strings3);
                continue;
            }
            int index = Integer.parseInt(splitKey[1]);
            if (index > (strings = (ArrayList)keysMap.get(splitKey[0])).size()) {
                strings.add(value);
                continue;
            }
            strings.add(index, value);
        }
        for (Map.Entry<Object, Object> entry : keysMap.entrySet()) {
            List values = (List)newMap.get(entry.getKey());
            HashMap<String, String> kvMap = new HashMap<String, String>();
            int i = 0;
            while (i < values.size()) {
                kvMap.put((String)((List)entry.getValue()).get(i), (String)values.get(i));
                ++i;
            }
            newMap.put((String)entry.getKey(), kvMap);
        }
        return newMap;
    }

    public static Properties authJsonToProperties(String json) throws Exception {
        Map root = (Map)JsonUtils.jsonNodeToObject((String)json);
        Map node = (Map)root.get("security");
        Properties props = new Properties();
        for (Object o : node.keySet()) {
            OAuth2Utils.authJsonToProperties(node.get(o), (String)o, props);
        }
        return props;
    }

    private static void authJsonToProperties(Object node, String name, Properties props) {
        block3: {
            block4: {
                block2: {
                    if (!(node instanceof String)) break block2;
                    props.put(name, node);
                    break block3;
                }
                if (!(node instanceof Map)) break block4;
                int i = 1;
                for (String k : ((Map)node).keySet()) {
                    if (!(((Map)node).get(k) instanceof String)) continue;
                    props.put(String.valueOf(name) + "." + i + ".key", k);
                    props.put(String.valueOf(name) + "." + i, ((Map)node).get(k));
                    ++i;
                }
                break block3;
            }
            if (!(node instanceof List)) break block3;
            int i = 1;
            for (Object v : (List)node) {
                if (!(v instanceof String)) continue;
                props.put(String.valueOf(name) + "." + i, v);
                ++i;
            }
        }
    }
}

