/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseGenTag {
    List<TagPart> parts = new ArrayList<TagPart>();

    public ParseGenTag(String expression) throws Exception {
        String startPattern = "%[^{%]+\\{";
        Pattern pDeb = Pattern.compile(startPattern);
        Matcher mDeb = pDeb.matcher(expression);
        int precEnd = 0;
        String endPart = null;
        boolean find = false;
        while (mDeb.find()) {
            find = true;
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            String before = null;
            if (iDeb > precEnd) {
                before = expression.substring(precEnd, iDeb);
                this.parts.add(new TagPart(before, "text"));
            } else {
                before = "";
            }
            String keyWord = expression.substring(iDeb + 1, iFin - 1);
            String tmp = iFin < expression.length() ? expression.substring(iFin) : "";
            String part = "";
            String endKeyWord = "}" + keyWord + "%";
            int index = tmp.indexOf(endKeyWord);
            precEnd = index + iFin + endKeyWord.length();
            if (index > -1) {
                part = tmp.substring(0, index);
                this.parts.add(new TagPart(part, keyWord));
                if (tmp.length() > index + endKeyWord.length()) {
                    endPart = tmp.substring(index + endKeyWord.length());
                    continue;
                }
                endPart = null;
                continue;
            }
            throw new Exception("Error no enclosing tag, " + endKeyWord + " was expected");
        }
        if (!expression.isEmpty()) {
            if (!find) {
                this.parts.add(new TagPart(expression, "text"));
            } else if (endPart != null) {
                this.parts.add(new TagPart(endPart, "text"));
            }
        }
    }

    public List<String> getParts(String type) {
        ArrayList<String> retour = new ArrayList<String>();
        for (TagPart tagPart : this.parts) {
            if (!tagPart.type.equals(type)) continue;
            retour.add(tagPart.code);
        }
        return retour;
    }

    public String printOriginal() {
        String retour = "";
        for (TagPart tagPart : this.parts) {
            retour = String.valueOf(retour) + tagPart.toString();
        }
        return retour;
    }

    public int size() {
        return this.parts.size();
    }

    public static void main(String[] argv) {
        String text = " hello les gars %x{ test }x% hey comment ca va %s(rhino){coucouc}s(rhino)% hey hey hey";
        try {
            ParseGenTag pgt = new ParseGenTag(text);
            System.out.println(pgt.size());
            System.out.println(text);
            System.out.println(pgt.printOriginal());
            text = "%x{ test }x% hey comment ca va %s(rhino){coucouc}s(rhino)%";
            pgt = new ParseGenTag(text);
            System.out.println(pgt.size());
            System.out.println(text);
            System.out.println(pgt.printOriginal());
            text = "%x{ test }x%%s(rhino){coucouc}s(rhino)%";
            pgt = new ParseGenTag(text);
            System.out.println(pgt.size());
            System.out.println(text);
            System.out.println(pgt.printOriginal());
            text = " %x{ test coucouc";
            pgt = new ParseGenTag(text);
            System.out.println(pgt.size());
            System.out.println(text);
            System.out.println(pgt.printOriginal());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class TagPart {
        String code;
        String type;

        public String toString() {
            return this.type == "text" ? this.code : "%" + this.type + "{" + this.code + "}" + this.type + "%";
        }

        public TagPart(String code, String type) {
            this.code = code;
            this.type = type;
        }
    }
}

