/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.internal;

import com.indy.environment.EnvironmentPlugin;
import com.indy.environment.Messages;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.variableresolvers.PathVariableResolver;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DevModeVariableResolver
extends PathVariableResolver {
    private static final String VARIABLE_GIT_DESIGNER_LOCATION = "GIT_DESIGNER_LOCATION";

    public String[] getVariableNames(String variable, IResource resource) {
        if (resource.getProject().getName().equals("global") || resource.getProject().getName().equals("technology")) {
            return new String[]{VARIABLE_GIT_DESIGNER_LOCATION};
        }
        return super.getVariableNames(variable, resource);
    }

    private void checkLocation(String location) throws Exception {
        boolean folderIsValid = true;
        if (location != null && !location.isEmpty()) {
            File f = new File(location);
            if (f.exists() && f.isDirectory()) {
                File addons = new File(f, "addons");
                if (!addons.exists() || !addons.isDirectory()) {
                    folderIsValid = false;
                } else {
                    File templates = new File(f, "templates");
                    if (!templates.exists() || !templates.isDirectory()) {
                        folderIsValid = false;
                    }
                }
            } else {
                folderIsValid = false;
            }
        } else {
            folderIsValid = false;
        }
        if (!folderIsValid) {
            throw new Exception(Messages.bind((String)Messages.DevModeVariableResolver_10, (Object)location));
        }
    }

    public String getValue(String variable, IResource resource) {
        if (variable.equals(VARIABLE_GIT_DESIGNER_LOCATION) && (resource.getProject().getName().equals("global") || resource.getProject().getName().equals("technology"))) {
            String folder = EnvironmentPlugin.getDefault().getPreferenceStore().getString("com.indy.environment.preferences.importInternalResources.linkedRootFolder");
            try {
                this.checkLocation(folder);
            }
            catch (Exception ex) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LinkedPopup popup = new LinkedPopup(PlatformUI.getWorkbench().getModalDialogShellProvider());
                        popup.open();
                    }
                });
                folder = EnvironmentPlugin.getDefault().getPreferenceStore().getString("com.indy.environment.preferences.importInternalResources.linkedRootFolder");
            }
            return "file:/" + folder.replace("\\", "/");
        }
        return null;
    }

    private class LinkedPopup
    extends Dialog {
        private String location;
        private Label message;
        private Text tlocation;

        protected LinkedPopup(IShellProvider parentShell) {
            super(parentShell);
            this.setShellStyle(48);
        }

        public void create() {
            super.create();
            this.getShell().addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.detail == 2) {
                        e.doit = false;
                    }
                }
            });
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.DevModeVariableResolver_0);
            newShell.setMinimumSize(300, 200);
            String rootFolder = EnvironmentPlugin.getDefault().getPreferenceStore().getString("com.indy.environment.preferences.importInternalResources.linkedRootFolder");
            if (rootFolder != null) {
                this.location = rootFolder;
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        private void updateButtons() {
            Button b = this.getButton(0);
            try {
                DevModeVariableResolver.this.checkLocation(this.location);
                b.setEnabled(true);
                this.setErrorMessage(null);
            }
            catch (Exception ex) {
                this.setErrorMessage(ex.getMessage());
                b.setEnabled(false);
            }
        }

        private void setErrorMessage(String message) {
            if (message == null) {
                this.message.setText("");
            } else {
                this.message.setText(message);
            }
        }

        protected void okPressed() {
            EnvironmentPlugin.getDefault().getPreferenceStore().setValue("com.indy.environment.preferences.importInternalResources.linkedRootFolder", this.location);
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Text location;
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(3, false));
            main.setLayoutData((Object)new GridData(1808));
            Label l = new Label(main, 0);
            l.setText(Messages.DevModeVariableResolver_2);
            l.setToolTipText(Messages.DevModeVariableResolver_3);
            l.setLayoutData((Object)new GridData());
            this.tlocation = location = new Text(main, 2048);
            if (this.location != null) {
                this.tlocation.setText(this.location);
            }
            location.setLayoutData((Object)new GridData(4, 1, true, false));
            location.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LinkedPopup.this.location = ((Text)e.widget).getText();
                    LinkedPopup.this.updateButtons();
                }
            });
            Button browse = new Button(main, 8);
            browse.setText("...");
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog d = new DirectoryDialog(LinkedPopup.this.getShell(), 4096);
                    LinkedPopup.this.location = d.open();
                    LinkedPopup.this.updateButtons();
                }
            });
            this.message = new Label(main, 2112);
            this.message.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            this.message.setForeground(this.getShell().getDisplay().getSystemColor(3));
            return main;
        }
    }
}

