/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import com.indy.administration.AdministrationListener;
import com.indy.administration.AdministrationService;
import com.indy.environment.EnvironmentPlugin;
import com.indy.environment.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InternalResourceContentProvider
implements ITreeContentProvider,
IStateListener {
    private TreeNode model;
    private TreeNode techNode;
    private boolean listLayout = true;
    private volatile IInternalResourceRegistry internalResourceRegistry = null;
    private LoadJob loadJob = new LoadJob();
    private Viewer viewer;

    public InternalResourceContentProvider() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand("com.indy.environment.command.internalResourceLayoutList");
            if (cmd != null) {
                State s = cmd.getState("org.eclipse.ui.commands.toggleState");
                s.addListener((IStateListener)this);
            }
        }
        catch (Exception ex) {
            EnvironmentPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.indy.environment", Messages.InternalResourceLabelProvider_9, (Throwable)ex));
        }
        this.initModel();
    }

    private IInternalResourceRegistry getInternalResourceRegistry() {
        if (this.internalResourceRegistry == null) {
            this.internalResourceRegistry = (IInternalResourceRegistry)PlatformUI.getWorkbench().getService(IInternalResourceRegistry.class);
        }
        return this.internalResourceRegistry;
    }

    protected void initModel() {
        if (this.model != null) {
            return;
        }
        this.model = new TreeNode((Object)"root");
        final ICacheService s = (ICacheService)EnvironmentPlugin.getDefault().getWorkbench().getService(ICacheService.class);
        if (s != null) {
            if (!s.isInit()) {
                s.addCacheServiceListener(new ICacheService.ICacheServiceListener(){

                    public void handleCacheInitialized() {
                        InternalResourceContentProvider.this.loadJob.schedule();
                        s.removeCacheServiceListener((ICacheService.ICacheServiceListener)this);
                    }

                    public void handleCacheInitializing() {
                    }
                });
            } else if (this.loadJob.cancel()) {
                this.loadJob.schedule();
            }
        } else {
            this.loadJob.setWaitForCacheService();
        }
        AdministrationService adminService = (AdministrationService)E4InjectorHelper.getService(AdministrationService.class);
        adminService.addListener(new AdministrationListener(){

            public void handleRoleChanged() {
                if (InternalResourceContentProvider.this.loadJob.cancel()) {
                    InternalResourceContentProvider.this.loadJob.schedule();
                }
            }
        });
    }

    private void createNode(TreeNode node, String[] segments, URI uri, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.createNodeHiera(node, segments, uri);
    }

    private void createNodeHiera(TreeNode node, String[] segments, URI uri) {
        TreeNode[] children = node.getChildren();
        children = children == null ? new TreeNode[1] : Arrays.copyOf(node.getChildren(), children.length + 1);
        if (segments.length == 1) {
            children[children.length - 1] = new TreeNode((Object)uri);
            children[children.length - 1].setParent(node);
            node.setChildren(children);
        } else {
            CTreeNode child = null;
            TreeNode[] treeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode n3 = treeNodeArray[n2];
                if (n3 != null && n3.getValue().equals(segments[0])) {
                    child = n3;
                    break;
                }
                ++n2;
            }
            if (child == null) {
                child = new CTreeNode(segments[0]);
                children[children.length - 1] = child;
                children[children.length - 1].setParent(node);
                node.setChildren(children);
            }
            this.createNodeHiera(child, Arrays.copyOfRange(segments, 1, segments.length), uri);
        }
    }

    public void dispose() {
        if (this.loadJob != null) {
            this.loadJob.cancel();
            this.loadJob = null;
        }
        this.techNode = null;
        this.model = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        boolean b;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.listLayout = b = ((Boolean)commandService.getCommand("com.indy.environment.command.internalResourceLayoutList").getState("org.eclipse.ui.commands.toggleState").getValue()).booleanValue();
        if (this.model == null) {
            this.initModel();
        } else {
            try {
                if (!(this.model.getChildren() == null && this.model.getChildren().length == 0 || this.model.getChildren()[0].hasChildren())) {
                    this.initModel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getChildren(this.model);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeNode) {
            if (this.listLayout && parentElement instanceof CTreeNode) {
                return ((CTreeNode)((Object)parentElement)).getFlatChildren();
            }
            return ((TreeNode)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            if (this.listLayout && element instanceof CTreeNode) {
                return ((CTreeNode)((Object)element)).getFlatParent();
            }
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            if (this.listLayout && element instanceof CTreeNode) {
                return true;
            }
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public void handleStateChange(State state, Object oldValue) {
        if (state.getValue() instanceof Boolean && ((Boolean)state.getValue()).booleanValue()) {
            this.viewer.refresh();
        }
    }

    public static class CTreeNode
    extends TreeNode {
        private String hierarchicalLabel = null;

        public CTreeNode(Object value) {
            super(value);
        }

        public int hashCode() {
            return this.getHierchicalLabel().hashCode();
        }

        private String getHierchicalLabel() {
            if (this.hierarchicalLabel == null) {
                String tmp = (String)this.getValue();
                if (this.getParent() instanceof CTreeNode) {
                    tmp = String.valueOf(((CTreeNode)this.getParent()).getHierchicalLabel()) + "/" + tmp;
                }
                this.hierarchicalLabel = tmp;
            }
            return this.hierarchicalLabel;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CTreeNode) {
                return this.getHierchicalLabel().equals(((CTreeNode)((Object)object)).getHierchicalLabel());
            }
            return false;
        }

        public Object[] getFlatChildren() {
            ArrayList<Object> l = new ArrayList<Object>();
            TreeNode[] treeNodeArray = this.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode n3 = treeNodeArray[n2];
                if (n3 instanceof CTreeNode) {
                    l.addAll(Arrays.asList(((CTreeNode)n3).getFlatChildren()));
                } else {
                    l.add(n3);
                }
                ++n2;
            }
            return l.toArray(new Object[l.size()]);
        }

        public Object getFlatParent() {
            TreeNode p = this.getParent();
            while (p.getParent() != null && p instanceof CTreeNode) {
                p = p.getParent();
            }
            return p;
        }

        public void addChild(CTreeNode child) {
            TreeNode[] childs = null;
            childs = this.hasChildren() ? Arrays.copyOf(this.getChildren(), this.getChildren().length + 1) : new TreeNode[1];
            childs[childs.length - 1] = child;
            child.setParent(this);
            this.setChildren(childs);
        }
    }

    private class LoadJob
    extends Job {
        List<TreeNode> children;
        ServiceTracker<ICacheService, ICacheService> tracker;

        public LoadJob() {
            super(Messages.InternalResourceContentProvider_0);
            this.children = new ArrayList<TreeNode>();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (InternalResourceContentProvider.this.model == null || monitor.isCanceled()) {
                this.schedule();
                return Status.CANCEL_STATUS;
            }
            this.children.clear();
            for (IInternalResourceRegistry.InternalResourceProvider p : InternalResourceContentProvider.this.getInternalResourceRegistry().getProviders()) {
                if (!p.isAuthorized()) continue;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CTreeNode folderNode = null;
                if (folderNode == null) {
                    String[] nodes = p.getInternalResourcePath().split("/");
                    CTreeNode current = null;
                    String[] stringArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        CTreeNode n3 = this.findChildrenNode(current, s);
                        if (n3 == null) {
                            folderNode = new CTreeNode(s);
                            if (current == null) {
                                current = folderNode;
                                this.children.add(current);
                            } else {
                                CTreeNode cTreeNode = current;
                                current = folderNode;
                                cTreeNode.addChild(current);
                            }
                        } else {
                            current = n3;
                        }
                        ++n2;
                    }
                    folderNode = current;
                }
                for (URI uri : p.getProvidedResourceURI()) {
                    if ("proc_diagram".equals(uri.fileExtension()) || "properties".equals(uri.fileExtension())) continue;
                    int segmentIndex = 3;
                    try {
                        if (folderNode.getValue().equals(uri.segment(3))) {
                            ++segmentIndex;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    InternalResourceContentProvider.this.createNode(folderNode, Arrays.copyOfRange(uri.segments(), segmentIndex, uri.segmentCount()), uri, monitor);
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
            }
            InternalResourceContentProvider.this.model.setChildren(this.children.toArray(new TreeNode[this.children.size()]));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (InternalResourceContentProvider.this.viewer != null) {
                        InternalResourceContentProvider.this.viewer.refresh();
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private CTreeNode findChildrenNode(CTreeNode current, String nodeName) {
            block4: {
                block3: {
                    if (current != null) break block3;
                    for (TreeNode n : this.children) {
                        if (!n.getValue().equals(nodeName)) continue;
                        return (CTreeNode)n;
                    }
                    break block4;
                }
                if (!current.hasChildren()) break block4;
                TreeNode[] treeNodeArray = current.getChildren();
                int n = treeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode n3 = treeNodeArray[n2];
                    if (n3.getValue().equals(nodeName)) {
                        return (CTreeNode)n3;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public void setWaitForCacheService() {
            if (this.tracker == null) {
                this.tracker = new ServiceTracker(EnvironmentPlugin.getDefault().getBundle().getBundleContext(), ICacheService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ICacheService, ICacheService>(){

                    public ICacheService addingService(ServiceReference<ICacheService> reference) {
                        final ICacheService s = (ICacheService)reference.getBundle().getBundleContext().getService(reference);
                        if (s.isInit()) {
                            LoadJob.this.schedule();
                        } else {
                            s.addCacheServiceListener(new ICacheService.ICacheServiceListener(){

                                public void handleCacheInitialized() {
                                    LoadJob.this.schedule();
                                    s.removeCacheServiceListener((ICacheService.ICacheServiceListener)this);
                                }

                                public void handleCacheInitializing() {
                                }
                            });
                        }
                        return s;
                    }

                    public void modifiedService(ServiceReference<ICacheService> reference, ICacheService service) {
                    }

                    public void removedService(ServiceReference<ICacheService> reference, ICacheService service) {
                    }
                });
                this.tracker.open();
            }
        }
    }
}

