/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import com.indy.environment.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.osgi.framework.Bundle;

public class ResourceActionProvider
extends CommonActionProvider {
    private OpenAction openAction;
    private ImportAction importAction;
    private ImportAction importIntoAction;
    private boolean shouldContribute = false;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            this.shouldContribute = true;
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.createActions(workbenchSite);
        } else {
            this.shouldContribute = false;
        }
    }

    private void createActions(ICommonViewerWorkbenchSite workbenchSite) {
        this.openAction = new OpenAction(workbenchSite);
        this.importAction = new ImportAction(workbenchSite);
        this.importIntoAction = new ImportInto(workbenchSite);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.shouldContribute) {
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            this.openAction.selectionChanged(selection);
            if (this.openAction.isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.shouldContribute) {
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            this.importAction.selectionChanged(selection);
            this.importIntoAction.selectionChanged(selection);
            if (this.importAction.isEnabled()) {
                menu.add((IAction)this.importAction);
                menu.add((IAction)this.importIntoAction);
            }
        }
    }

    private class ImportAction
    extends Action {
        protected ICommonViewerWorkbenchSite myViewerSite;
        protected List<URI> selectedURIs;

        public ImportAction(ICommonViewerWorkbenchSite viewerSite) {
            super(Messages.ResourceActionProvider_1);
            this.myViewerSite = viewerSite;
            this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_IMPORT_WIZ"));
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selectedURIs = null;
            if (selection.isEmpty()) {
                return;
            }
            this.selectedURIs = new ArrayList<URI>();
            for (Object obj : selection.toList()) {
                Object val;
                if (!(obj instanceof TreeNode) || !((val = ((TreeNode)obj).getValue()) instanceof URI)) continue;
                URI uri = (URI)val;
                this.selectedURIs.add(uri);
                URI diagramURI = this.getDiagramURI(uri);
                if (diagramURI == null) continue;
                this.selectedURIs.add(diagramURI);
            }
        }

        private URI getDiagramURI(URI uri) {
            if ("proc".equals(uri.fileExtension())) {
                URI diagramURI = URI.createPlatformPluginURI((String)uri.segment(1), (boolean)false);
                int i = 2;
                while (i < uri.segmentCount() - 1) {
                    diagramURI = diagramURI.appendSegment(uri.segment(i));
                    ++i;
                }
                diagramURI = diagramURI.appendSegment("indy.diagram").appendSegment(uri.fileExtension()).appendSegment(String.valueOf(uri.lastSegment()) + "_diagram");
                return diagramURI;
            }
            return null;
        }

        public boolean isEnabled() {
            return this.selectedURIs != null && this.selectedURIs.size() > 0;
        }

        public void run() {
            IInternalResourceRegistry reg = (IInternalResourceRegistry)PlatformUI.getWorkbench().getService(IInternalResourceRegistry.class);
            for (URI selectedURI : this.selectedURIs) {
                IInternalResourceRegistry.InternalResourceProvider p = reg.getProvider(selectedURI);
                if (p == null) continue;
                String importPath = p.getResourceFolderPath();
                if (importPath == null) {
                    importPath = "";
                }
                boolean closed = true;
                String resourcePath = "";
                int i = 2;
                while (i < selectedURI.segmentCount()) {
                    if ((resourcePath = String.valueOf(resourcePath) + "/" + URI.decode((String)selectedURI.segment(i))).equals("/.tech")) {
                        resourcePath = "/technology";
                    } else if (resourcePath.startsWith("/.")) {
                        resourcePath = "/" + URI.decode((String)resourcePath.substring(2));
                    }
                    ++i;
                }
                importPath = String.valueOf(importPath) + resourcePath;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(importPath));
                boolean initProjectCharSet = false;
                if (file.getProject().exists()) {
                    if (file.getProject().isOpen()) {
                        closed = false;
                    }
                } else {
                    if (!MessageDialog.openQuestion((Shell)this.myViewerSite.getShell(), (String)Messages.ResourceActionProvider_12, (String)Messages.bind((String)Messages.ResourceActionProvider_13, (Object)file.getProject().getName()))) {
                        return;
                    }
                    initProjectCharSet = true;
                }
                Util.mkdirs((IResource)file, (IProgressMonitor)new NullProgressMonitor());
                if (initProjectCharSet) {
                    try {
                        file.getProject().setDefaultCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    if (file.exists() && !MessageDialog.openQuestion((Shell)this.myViewerSite.getShell(), (String)Messages.ResourceActionProvider_15, (String)Messages.bind((String)Messages.ResourceActionProvider_16, (Object)file.getFullPath().toOSString()))) {
                        if (closed && file.getProject().exists()) {
                            file.getProject().close((IProgressMonitor)new NullProgressMonitor());
                            ((CommonViewer)this.myViewerSite.getSelectionProvider()).refresh(((IStructuredSelection)this.myViewerSite.getSelectionProvider().getSelection()).getFirstElement(), true);
                        }
                        return;
                    }
                    StringBuilder s = new StringBuilder();
                    URI u = p.getPathRelativeToBundle(selectedURI);
                    int i2 = 0;
                    while (i2 < u.segmentCount()) {
                        s.append("/");
                        s.append(URI.decode((String)u.segment(i2)));
                        ++i2;
                    }
                    Path relativePathToBundle = new Path(s.toString());
                    Throwable throwable = null;
                    Object var14_19 = null;
                    try (InputStream is = FileLocator.openStream((Bundle)Platform.getBundle((String)p.getBundleName()), (IPath)relativePathToBundle, (boolean)false);){
                        file.create(is, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (!"UTF-8".equalsIgnoreCase(file.getCharset())) {
                        file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (!(this.myViewerSite.getSelectionProvider() instanceof CommonViewer)) continue;
                    ((CommonViewer)this.myViewerSite.getSelectionProvider()).refresh(((IStructuredSelection)this.myViewerSite.getSelectionProvider().getSelection()).getFirstElement(), true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class ImportInto
    extends ImportAction {
        public ImportInto(ICommonViewerWorkbenchSite viewerSite) {
            super(viewerSite);
            this.setText(Messages.ResourceActionProvider_23);
        }

        @Override
        public void run() {
            Object obj;
            Shell shell = this.myViewerSite.getShell();
            ResourcesPlugin.getPlugin();
            ContainerSelectionDialog dial = new ContainerSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.ResourceActionProvider_24);
            dial.setHelpAvailable(false);
            dial.create();
            dial.getOkButton().setEnabled(false);
            dial.setValidator(new ISelectionValidator(){

                public String isValid(Object selection) {
                    return selection == null ? "" : null;
                }
            });
            if (dial.open() == 0 && dial.getResult() != null && dial.getResult().length > 0 && (obj = dial.getResult()[0]) instanceof IPath) {
                HashMap<URI, IFile> targetFile = new HashMap<URI, IFile>();
                HashMap<URI, Path> relativePath = new HashMap<URI, Path>();
                HashMap<URI, IInternalResourceRegistry.InternalResourceProvider> provider = new HashMap<URI, IInternalResourceRegistry.InternalResourceProvider>();
                IInternalResourceRegistry reg = (IInternalResourceRegistry)PlatformUI.getWorkbench().getService(IInternalResourceRegistry.class);
                for (URI selectedURI : this.selectedURIs) {
                    IPath targetPath = ((IPath)obj).append(URI.decode((String)selectedURI.lastSegment()));
                    ResourcesPlugin.getPlugin();
                    IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
                    try {
                        IInternalResourceRegistry.InternalResourceProvider p = reg.getProvider(selectedURI);
                        if (p == null) continue;
                        provider.put(selectedURI, p);
                        StringBuilder s = new StringBuilder();
                        URI u = p.getPathRelativeToBundle(selectedURI);
                        int i = 0;
                        while (i < u.segmentCount()) {
                            s.append("/");
                            s.append(URI.decode((String)u.segment(i)));
                            ++i;
                        }
                        Path relativePathToBundle = new Path(s.toString());
                        relativePath.put(selectedURI, relativePathToBundle);
                        if (f.exists() && !MessageDialog.openQuestion((Shell)this.myViewerSite.getShell(), (String)Messages.ResourceActionProvider_15, (String)Messages.bind((String)Messages.ResourceActionProvider_16, (Object)f.getFullPath().toOSString()))) {
                            return;
                        }
                        targetFile.put(selectedURI, f);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (URI selectedURI : this.selectedURIs) {
                    try {
                        IFile f = (IFile)targetFile.get(selectedURI);
                        if (f == null) continue;
                        Path relativePathToBundle = (Path)relativePath.get(selectedURI);
                        Throwable throwable = null;
                        Object var12_15 = null;
                        try (InputStream is = FileLocator.openStream((Bundle)Platform.getBundle((String)((IInternalResourceRegistry.InternalResourceProvider)provider.get(selectedURI)).getBundleName()), (IPath)relativePathToBundle, (boolean)false);){
                            f.create(is, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        if (!(this.myViewerSite.getSelectionProvider() instanceof CommonViewer)) continue;
                        ((CommonViewer)this.myViewerSite.getSelectionProvider()).refresh(((IStructuredSelection)this.myViewerSite.getSelectionProvider().getSelection()).getFirstElement(), true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    private class OpenAction
    extends Action {
        protected ICommonViewerWorkbenchSite myViewerSite;
        protected URI selectedURI;

        public OpenAction(ICommonViewerWorkbenchSite viewerSite) {
            super(Messages.ResourceActionProvider_0);
            this.myViewerSite = viewerSite;
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object val;
            this.selectedURI = null;
            if (selection.isEmpty()) {
                return;
            }
            Object obj = selection.getFirstElement();
            if (obj instanceof TreeNode && (val = ((TreeNode)obj).getValue()) instanceof URI) {
                this.selectedURI = (URI)val;
            }
        }

        public boolean isEnabled() {
            return this.selectedURI != null;
        }

        public void run() {
            IWorkbenchPage page = this.myViewerSite.getPage();
            try {
                IEditorDescriptor d = IDE.getEditorDescriptor((String)this.selectedURI.lastSegment());
                URIEditorInput editorInput = new URIEditorInput(this.selectedURI);
                page.openEditor((IEditorInput)editorInput, d.getId());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

