/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.tool;

import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class URINode
extends BufferedContent
implements IEncodedStreamContentAccessor,
IStructureComparator,
ITypedElement,
IEditableContent,
IEditableContentExtension {
    private URI uri;

    public URINode(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        if (this.uri != null) {
            return this.uri.toString();
        }
        return null;
    }

    public String getType() {
        return "txt";
    }

    public Image getImage() {
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object[] getChildren() {
        return new Object[0];
    }

    protected IStructureComparator createChild(IResource child) {
        return new ResourceNode(child);
    }

    protected InputStream createStream() throws CoreException {
        InputStream is = null;
        try {
            is = this.getUnderlyingURL().openStream();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.indy.environment", e.getMessage(), (Throwable)e));
        }
        if (is != null) {
            return new BufferedInputStream(is);
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return child;
    }

    public String getCharset() {
        return "UTF-8";
    }

    public boolean isReadOnly() {
        return true;
    }

    public IStatus validateEdit(Shell shell) {
        return Status.CANCEL_STATUS;
    }

    public URL getUnderlyingURL() {
        IInternalResourceRegistry reg = (IInternalResourceRegistry)PlatformUI.getWorkbench().getService(IInternalResourceRegistry.class);
        IInternalResourceRegistry.InternalResourceProvider p = reg.getProvider(this.uri);
        URI u = p.getPathRelativeToBundle(this.uri);
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < u.segmentCount()) {
            s.append("/");
            s.append(URI.decode((String)u.segment(i)));
            ++i;
        }
        Path relativePathToBundle = new Path(s.toString());
        return FileLocator.find((Bundle)Platform.getBundle((String)p.getBundleName()), (IPath)relativePathToBundle);
    }
}

