/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.editor;

import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.engine.log.exchange.DeliveryMapWrapper;
import com.indy.engine.log.object.impl.EngineRuntimeHeader;
import com.indy.ui.common.editor.input.ConfigurationNode;
import com.indy.ui.common.editor.input.ConnectionData;
import com.indy.ui.common.editor.input.DeliveryEditorInput;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.editor.Messages;
import com.stambia.ui.tools.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ConnectionEditorPage
extends FormPage {
    private ScrolledForm form;
    private FormToolkit toolkit;
    private TreeViewer connectionTableViewer;
    private List<ConfigurationNode> configurations;
    private List<EngineRuntimeHeader> runtimes;
    private Map<String, DeliveryMapWrapper> configuredDeliveries;
    private int nbConnectionsToTest;
    private Map<String, Exception> errorRuntimes;
    private Font labelFont = new Font((Device)Display.getCurrent(), new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), Display.getCurrent().getSystemFont().getFontData()[0].getHeight(), 1));

    public ConnectionEditorPage(FormEditor editor) {
        super(editor, UUID.randomUUID().toString(), Messages.ConnectionEditorPage_0);
        if (editor.getEditorInput() instanceof DeliveryEditorInput) {
            DeliveryEditorInput editorInput = (DeliveryEditorInput)editor.getEditorInput();
            if (editorInput.getConfigurations() != null && !editorInput.getConfigurations().isEmpty()) {
                this.configurations = editorInput.getConfigurations();
                this.runtimes = editorInput.getRuntimes();
            } else {
                try {
                    this.configuredDeliveries = editorInput.getDeliveryWrapper();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.runtimes = editorInput.getRuntimes();
                this.configurations = new ArrayList<ConfigurationNode>();
                if (editorInput.getConnections() != null) {
                    this.configurations.add(new ConfigurationNode(editorInput.getName(), editorInput.getConnections()));
                } else {
                    for (String conf : this.configuredDeliveries.keySet()) {
                        this.configurations.add(new ConfigurationNode(conf, this.getConnectionFromDelivery(this.configuredDeliveries.get(conf))));
                    }
                    Collections.sort(this.configurations);
                }
            }
        }
    }

    public void dispose() {
        this.labelFont.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.form = this.getManagedForm().getForm();
        this.toolkit = this.getManagedForm().getToolkit();
        GridLayout layout = new GridLayout();
        this.form.getBody().setLayout((Layout)layout);
        this.createHeaderSection();
        this.createBodySection(this.form.getBody());
    }

    private void createHeaderSection() {
        this.form.setText(Messages.ConnectionEditorPage_1);
        this.toolkit.decorateFormHeading(this.form.getForm());
        Action testConnections = new Action(Messages.ConnectionEditorPage_2){

            public void run() {
                ConnectionEditorPage.this.testAllConnections();
                ConnectionEditorPage.this.connectionTableViewer.refresh();
            }
        };
        this.form.getToolBarManager().add((IAction)testConnections);
        this.form.getToolBarManager().update(true);
        this.form.getForm().getHead().setBackground(null);
    }

    private List<ConnectionData> getConnectionFromDelivery(DeliveryMapWrapper delivery) {
        ArrayList<ConnectionData> connections = new ArrayList<ConnectionData>();
        for (Map.Entry entry : delivery.getConnections().entrySet()) {
            int nbTransaction = 0;
            String connectionName = (String)entry.getKey();
            Map mapParameter = null;
            for (Map.Entry entryConnection : ((Map)entry.getValue()).entrySet()) {
                List transaction = null;
                if (((String)entryConnection.getKey()).equals("transaction")) {
                    transaction = (List)entryConnection.getValue();
                    nbTransaction = transaction.size();
                    continue;
                }
                if (((String)entryConnection.getKey()).equals("parameter")) {
                    mapParameter = (Map)entryConnection.getValue();
                    continue;
                }
                ((String)entryConnection.getKey()).equals("type");
            }
            connections.add(new ConnectionData(connectionName, Integer.valueOf(nbTransaction), mapParameter));
        }
        return connections;
    }

    private void createBodySection(Composite body) {
        Section section = Utils.createSection((FormToolkit)this.toolkit, (Composite)body, (String)Messages.ConnectionEditorPage_6);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp = this.toolkit.createComposite((Composite)section);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)comp);
        this.connectionTableViewer = new TreeViewer(comp, 68096);
        this.connectionTableViewer.setAutoExpandLevel(-1);
        this.createConnectionTableColumns(comp, this.connectionTableViewer);
        Tree connectionTable = this.connectionTableViewer.getTree();
        connectionTable.setLayoutData((Object)new GridData(4, 4, true, true));
        connectionTable.setHeaderVisible(true);
        connectionTable.setLinesVisible(true);
        this.handledViewerChanged((Viewer)this.connectionTableViewer);
        this.connectionTableViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ConfigurationNode) {
                    return !((ConfigurationNode)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return ConnectionEditorPage.this.configurations.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ConfigurationNode) {
                    return ((ConfigurationNode)parentElement).getChildren().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }
        });
        this.connectionTableViewer.setInput(this.configurations);
        this.connectionTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection;
                if (event.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)event.getSelection()).getFirstElement() instanceof ConnectionData && ((ConnectionData)selection.getFirstElement()).getParameter() != null) {
                    ConnectiondataDialog dialog = new ConnectiondataDialog(Display.getCurrent().getActiveShell(), (ConnectionData)selection.getFirstElement());
                    dialog.open();
                }
            }
        });
    }

    private void initLabelAndText(String labelName, String labelValue, Composite parent) {
        Color defaultColor = Display.getDefault().getSystemColor(1);
        parent.setBackground(defaultColor);
        Composite comp = this.toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)gd);
        comp.setBackground(defaultColor);
        Text labelText = new Text(comp, 8);
        labelText.setText(String.valueOf(labelName) + ":");
        labelText.setBackground(defaultColor);
        labelText.setFont(this.labelFont);
        Text valueText = new Text(comp, 8);
        valueText.setText(labelValue);
        valueText.setBackground(defaultColor);
    }

    private void createConnectionTableColumns(Composite comp, TreeViewer connectiontTableViewer) {
        String[] titles = new String[]{Messages.ConnectionEditorPage_8, Messages.ConnectionEditorPage_9, Messages.ConnectionEditorPage_10, Messages.ConnectionEditorPage_11};
        int[] bounds = new int[]{500, 150, 40, 60};
        TreeViewerColumn colName = this.createTableViewerColumn(titles[0], bounds[0]);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IConnectionLabeViewer) {
                    return ((IConnectionLabeViewer)element).getText();
                }
                if (element instanceof ConfigurationNode) {
                    return ((ConfigurationNode)element).getText();
                }
                if (element instanceof ConnectionData) {
                    return ((ConnectionData)element).getText();
                }
                return null;
            }
        });
        TreeViewerColumn colNbtransac = this.createTableViewerColumn(titles[1], bounds[1]);
        colNbtransac.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ConnectionData) {
                    ConnectionData elt = (ConnectionData)element;
                    return String.valueOf(elt.getTransaction());
                }
                return null;
            }
        });
        TreeViewerColumn colTestButton = this.createTableViewerColumn(titles[2], bounds[2]);
        colTestButton.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)NavigatorActivator.getDefault().getImage("connection_editor/test_connection_cell_btn.png")).createImage();
            }
        });
        for (final EngineRuntimeHeader runtime : this.runtimes) {
            String columnName = runtime.getName();
            TreeViewerColumn colStatus = this.createTableViewerColumn(columnName, 100);
            colStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return "";
                }

                public String getToolTipText(Object element) {
                    if (element instanceof ConnectionData) {
                        ConnectionData elt = (ConnectionData)element;
                        return elt.getRuntimeErrorMsg(runtime.getName());
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    if (element instanceof ConnectionData) {
                        ConnectionData elt = (ConnectionData)element;
                        if (elt.getRuntimeStatut(runtime.getName()) != null) {
                            if (elt.getRuntimeStatut(runtime.getName()) == 1) {
                                return ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)NavigatorActivator.getDefault().getImage("connection_editor/connection_ok.png")).createImage();
                            }
                            if (elt.getRuntimeStatut(runtime.getName()) == 0) {
                                return ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)NavigatorActivator.getDefault().getImage("connection_editor/connection_error.png")).createImage();
                            }
                            return null;
                        }
                        return null;
                    }
                    return null;
                }
            });
        }
        CellEditor[] editors = new CellEditor[4];
        CheckboxCellEditor btnCellEdit = new CheckboxCellEditor((Composite)connectiontTableViewer.getTree());
        editors[2] = btnCellEdit;
        connectiontTableViewer.setCellEditors(editors);
        connectiontTableViewer.setCellModifier((ICellModifier)new StatusCellModifier((Viewer)connectiontTableViewer));
        connectiontTableViewer.setColumnProperties(titles);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)connectiontTableViewer);
    }

    private TreeViewerColumn createTableViewerColumn(String title, int bound) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.connectionTableViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    public void testAllConnections() {
        this.errorRuntimes = new HashMap<String, Exception>();
        for (EngineRuntimeHeader engine : this.runtimes) {
            try {
                AnalyticsEngineWrapper analyticsEngineWrapper = EngineRegistry.getDefault().getEngine(engine.getHost(), engine.getPort(), engine.getUser(), engine.getPassword());
            }
            catch (Exception e) {
                this.errorRuntimes.put(String.valueOf(engine.getHost()) + "/" + engine.getPort(), e);
            }
        }
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.ConnectionEditorPage_18, ConnectionEditorPage.this.nbConnectionsToTest);
                for (ConfigurationNode config : ConnectionEditorPage.this.configurations) {
                    monitor.subTask(String.valueOf(Messages.ConnectionEditorPage_19) + config.getText());
                    ConnectionEditorPage.this.testConfigurationNode(config, monitor);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, rwp);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void testConfigurationNode(final ConfigurationNode config, IProgressMonitor monitor) {
        if (monitor == null) {
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(String.valueOf(Messages.ConnectionEditorPage_20) + config.getText() + " ...", ConnectionEditorPage.this.nbConnectionsToTest);
                    for (ConnectionData cnxData : config.getConnections()) {
                        monitor.subTask(String.valueOf(Messages.ConnectionEditorPage_22) + cnxData.getConnectionLabel());
                        ConnectionEditorPage.this.testConnectionData(cnxData);
                        monitor.worked(1);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, rwp);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (ConnectionData cnxData : config.getConnections()) {
                monitor.subTask(String.valueOf(Messages.ConnectionEditorPage_23) + cnxData.getConnectionLabel());
                this.testConnectionData(cnxData);
                monitor.worked(1);
            }
        }
    }

    public void testConnection(final ConnectionData cnxData) throws IllegalArgumentException {
        if (cnxData.getParameter() != null) {
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setTaskName(Messages.ConnectionEditorPage_24);
                    monitor.beginTask(String.valueOf(Messages.ConnectionEditorPage_25) + cnxData.getConnectionLabel(), -1);
                    try {
                        ConnectionEditorPage.this.testConnectionData(cnxData);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, rwp);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void testConnectionData(ConnectionData cnxData) {
        if (cnxData.getParameter() != null) {
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put(ParameterType.url.name(), (String)cnxData.getParameter().get("JDBC.URL"));
            mapParam.put(ParameterType.driver.name(), (String)cnxData.getParameter().get("JDBC.DRIVER"));
            mapParam.put(ParameterType.user.name(), (String)cnxData.getParameter().get("JDBC.USER"));
            mapParam.put(ParameterType.password.name(), (String)cnxData.getParameter().get("JDBC.PASSWORD"));
            mapParam.put(ParameterType.moduleName.name(), (String)cnxData.getParameter().get("JDBC.MODULE"));
            for (EngineRuntimeHeader runtime : this.runtimes) {
                if (this.errorRuntimes != null && this.errorRuntimes.containsKey(String.valueOf(runtime.getHost()) + "/" + runtime.getPort())) {
                    cnxData.addRuntimeStatut(runtime.getName(), Integer.valueOf(0));
                    cnxData.addRuntimeError(runtime.getName(), this.errorRuntimes.get(String.valueOf(runtime.getHost()) + "/" + runtime.getPort()).getMessage());
                    continue;
                }
                try {
                    AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(runtime.getHost(), runtime.getPort(), runtime.getUser(), runtime.getPassword());
                    HashMap<String, HashMap<String, String>> mapQuestion = new HashMap<String, HashMap<String, String>>();
                    mapQuestion.put(FunctionType.testConnection.name(), mapParam);
                    Map mapAnswer = engine.get(mapQuestion);
                    String answer = (String)mapAnswer.get(FunctionType.testConnection.name());
                    if (answer != null) {
                        cnxData.addRuntimeStatut(runtime.getName(), Integer.valueOf(0));
                        cnxData.addRuntimeError(runtime.getName(), answer);
                        continue;
                    }
                    cnxData.addRuntimeStatut(runtime.getName(), Integer.valueOf(1));
                }
                catch (Exception e) {
                    cnxData.addRuntimeStatut(runtime.getName(), Integer.valueOf(0));
                    cnxData.addRuntimeError(runtime.getName(), e.getMessage());
                }
            }
        }
    }

    public abstract void handledViewerChanged(Viewer var1);

    public class ConnectiondataDialog
    extends TrayDialog {
        ConnectionData connectionData;

        public ConnectiondataDialog(Shell parentShell, ConnectionData connectionData) {
            super(parentShell);
            this.connectionData = connectionData;
        }

        public void create() {
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout layout = new GridLayout();
            parent.setLayout((Layout)layout);
            if (this.connectionData.getParameter() != null) {
                for (String key : this.connectionData.getParameter().keySet()) {
                    ConnectionEditorPage.this.initLabelAndText(key, (String)this.connectionData.getParameter().get(key), parent);
                }
            }
            return parent;
        }
    }

    public static interface IConnectionLabeViewer {
        public String getText();

        public Image getImage();
    }

    class StatusCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public StatusCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ConnectionData) {
                ConnectionData cnxData = (ConnectionData)element;
                ConnectionEditorPage.this.testConnection(cnxData);
            } else if (element instanceof ConfigurationNode) {
                ConnectionEditorPage.this.testConfigurationNode((ConfigurationNode)element, null);
            }
            return false;
        }

        public void modify(Object element, String property, Object value) {
            this.viewer.refresh();
        }
    }
}

