/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest;

import com.indy.addons.httprest.Messages;
import com.indy.addons.httprest.NtlmAuthentication;
import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.RegistryFactory;

public class HttpHelper {
    public static final String NET_PLUGIN_ID = "org.eclipse.core.net";
    public static final String PT_AUTHENTICATOR = "authenticator";

    public static void configureHttps(HttpsURLConnection urlConnection) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        urlConnection.setSSLSocketFactory(sc.getSocketFactory());
        urlConnection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
    }

    public HttpURLConnection connect(URL url, AuthenticationInfo authorizationInfo, AuthenticationInfo proxyAuthorizationInfo, Map<String, String> headers, String httpMethod, byte[] rawData) throws Exception {
        String authenticationHeader;
        String s;
        String authenticationHeader22;
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (urlConnection instanceof HttpsURLConnection) {
            HttpHelper.configureHttps((HttpsURLConnection)urlConnection);
        }
        if ("PATCH".equals(httpMethod)) {
            urlConnection.setRequestProperty("X-HTTP-Method-Override", httpMethod);
            urlConnection.setRequestMethod("POST");
        } else {
            urlConnection.setRequestMethod(httpMethod);
        }
        if (headers != null) {
            for (String k : headers.keySet()) {
                urlConnection.setRequestProperty(k, headers.get(k));
            }
        }
        if ((headers == null || headers.get("Authorization") == null) && authorizationInfo != null) {
            if (authorizationInfo instanceof NtlmAuthentication) {
                try {
                    Method setAuthMethod = urlConnection.getClass().getMethod("setAuthenticator", Authenticator.class);
                    setAuthMethod.invoke((Object)urlConnection, ((NtlmAuthentication)authorizationInfo).getAuthenticator());
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(Messages.HttpHelper_1, e);
                }
            }
            try {
                authenticationHeader22 = authorizationInfo.getAuthenticationHeaderValue(null);
                urlConnection.setRequestProperty("Authorization", authenticationHeader22);
            }
            catch (Exception authenticationHeader22) {
                // empty catch block
            }
        }
        if ((headers == null || headers.get("Proxy-Authorization") == null) && proxyAuthorizationInfo != null) {
            try {
                authenticationHeader22 = proxyAuthorizationInfo.getAuthenticationHeaderValue(null);
                urlConnection.setRequestProperty("Proxy-Authorization", authenticationHeader22);
            }
            catch (Exception authenticationHeader3) {
                // empty catch block
            }
        }
        if (rawData != null && (rawData.length > 0 || headers.containsKey("Content-Type") || headers.containsKey("Content-type"))) {
            urlConnection.setDoOutput(true);
        }
        urlConnection.connect();
        if (rawData != null && (rawData.length > 0 || headers.containsKey("Content-Type") || headers.containsKey("Content-type"))) {
            OutputStream os = urlConnection.getOutputStream();
            os.write(rawData);
            os.close();
        }
        int responseCode = urlConnection.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 302: 
            case 303: {
                String newUrl = urlConnection.getHeaderField("Location");
                urlConnection.disconnect();
                return this.connect(new URL(newUrl), authorizationInfo, proxyAuthorizationInfo, headers, httpMethod, rawData);
            }
            case 200: {
                return urlConnection;
            }
            case 407: {
                String s2;
                if (proxyAuthorizationInfo != null) {
                    s2 = urlConnection.getHeaderField("Proxy-Authenticate");
                    urlConnection.disconnect();
                    if (s2 != null) {
                        String authenticationHeader4 = proxyAuthorizationInfo.getAuthenticationHeaderValue(s2);
                        headers.put("Proxy-Authorization", authenticationHeader4);
                        return this.connect(url, authorizationInfo, null, headers, httpMethod, rawData);
                    }
                }
            }
            case 401: {
                if (authorizationInfo == null) break;
                String s2 = urlConnection.getHeaderField("WWW-Authenticate");
                urlConnection.disconnect();
                String authenticationHeader5 = authorizationInfo.getAuthenticationHeaderValue(s2);
                headers.put("Authorization", authenticationHeader5);
                return this.connect(url, null, proxyAuthorizationInfo, headers, httpMethod, rawData);
            }
        }
        boolean attemptAuthentication = false;
        if (proxyAuthorizationInfo != null && (s = urlConnection.getHeaderField("Proxy-Authenticate")) != null) {
            authenticationHeader = proxyAuthorizationInfo.getAuthenticationHeaderValue(s);
            headers.put("Proxy-Authorization", authenticationHeader);
            proxyAuthorizationInfo = null;
            attemptAuthentication = true;
        }
        if (authorizationInfo != null && (s = urlConnection.getHeaderField("WWW-Authenticate")) != null) {
            authenticationHeader = authorizationInfo.getAuthenticationHeaderValue(s);
            headers.put("Authorization", authenticationHeader);
            authorizationInfo = null;
            attemptAuthentication = true;
        }
        if (attemptAuthentication) {
            urlConnection.disconnect();
            return this.connect(url, authorizationInfo, proxyAuthorizationInfo, headers, httpMethod, rawData);
        }
        return urlConnection;
    }

    public static void restoreHttpAuthenticator() {
        IExtension extension;
        IConfigurationElement[] configs;
        IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint(NET_PLUGIN_ID, PT_AUTHENTICATOR).getExtensions();
        if (extensions.length != 0 && (configs = (extension = extensions[0]).getConfigurationElements()).length != 0) {
            try {
                IConfigurationElement config = configs[0];
                Authenticator authenticator = (Authenticator)config.createExecutableExtension("class");
                Authenticator.setDefault(authenticator);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

