/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest;

import com.indy.addons.httprest.HttpHelper;
import com.indy.addons.httprest.Messages;
import com.indy.addons.httprest.internal.OpenApiVisitor;
import com.indy.addons.httprest.internal.Utils;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdAttributeReader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ReverseOpenApiAction
implements IExecute {
    private static final List<String> excludeAttributeToUpdate = new ArrayList<String>();
    private static final Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseModes = new HashMap<String, IncrementalReverser.IReverseMatchingStrategy>();
    private static final OpenAPIV3Parser openAPIParser = new OpenAPIV3Parser();
    private static final ParseOptions parseOptions = new ParseOptions();

    public final Object run(Object mdNode, String configuration, Map<String, String> params) throws ExecuteException {
        Utils.logger.debug("START openAPI reverse");
        MdNode rootNode = (MdNode)mdNode;
        try {
            MdNode openApiSchemaNode = null;
            try {
                openApiSchemaNode = ReverseOpenApiAction.createReversedMdNode(rootNode, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OpenAPIException ex) {
                if (MessageDialog.open((int)4, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ReverseOpenApiAction_4, (String)ex.getMessage(), (int)0, (String[])new String[]{Messages.ReverseOpenApiAction_5, Messages.ReverseOpenApiAction_6}) == 0) {
                    openApiSchemaNode = ex.getOpenAPIToMd();
                }
                throw ex;
            }
            ReverseOpenApiAction.incrementalReverse(rootNode, openApiSchemaNode);
        }
        catch (Exception exception) {
            throw new ExecuteException(exception);
        }
        Utils.logger.debug("STOP openAPI reverse");
        return null;
    }

    private static void incrementalReverse(MdNode rootNode, MdNode newRootNode) throws Exception {
        HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
        reversedMap.put(newRootNode, rootNode);
        IncrementalReverser reverser = new IncrementalReverser(rootNode.getSubstituteContainer(), reversedMap, excludeAttributeToUpdate, true, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, true);
        reverser.reverse();
    }

    public static final MdNode createReversedMdNode(MdNode rootNode, IProgressMonitor monitor) throws OpenAPIException, Exception {
        OpenAPI openAPISchema = null;
        OpenAPIException openAPiError = null;
        try {
            openAPISchema = ReverseOpenApiAction.getSchemaFromOpenApi(rootNode);
        }
        catch (OpenAPIException ex) {
            openAPISchema = ex.openAPI;
            openAPiError = ex;
        }
        MdNode openApiSchemaNode = null;
        try {
            int recursivityLevel = ReverseOpenApiAction.getRecursivityDepth(rootNode);
            openApiSchemaNode = rootNode.copy(1);
            openApiSchemaNode.setSubstituteContainer(rootNode.getSubstituteContainer());
            OpenApiVisitor openApiVisitor = new OpenApiVisitor(openApiSchemaNode, recursivityLevel, monitor);
            openApiVisitor.visit(openAPISchema);
            if (openAPiError != null) {
                throw openAPiError;
            }
            return openApiSchemaNode;
        }
        catch (OpenAPIException ex) {
            ex.openAPIToMd = openApiSchemaNode;
            throw ex;
        }
        catch (Exception ex) {
            throw new Exception(Messages.ReverseOpenApiAction_8, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final OpenAPI getSchemaFromOpenApi(MdNode rootNode) throws OpenAPIException, Exception {
        block20: {
            openApiReverseUrl = rootNode.evaluate("@reverseUrl");
            Utils.logger.debug("Open API reverse URL: " + openApiReverseUrl);
            if (openApiReverseUrl != null && openApiReverseUrl.trim().length() > 0) {
                authorizationHeader = null;
                securityNode = MdAttributeReader.readAttributeRef((String)"security", (MdNode)rootNode);
                proxyNode = MdAttributeReader.readAttributeRef((String)"proxy", (MdNode)rootNode);
                securityGenerationException = null;
                isHttps = false;
                isNtlm = false;
                if (securityNode != null) {
                    try {
                        props = securityNode.evaluate("./internal:toJavaProperties()");
                        p = new Properties();
                        p.load(new StringReader(props));
                        p.setProperty("type", securityNode.evaluate("name()"));
                        isNtlm = "ntlm".equals(securityNode.evaluate("name()"));
                        reverseURL = null;
                        try {
                            reverseURL = new URL(openApiReverseUrl);
                            isHttps = reverseURL.getProtocol().equals("https");
                        }
                        catch (Exception var12_12) {
                            // empty catch block
                        }
                        header = AuthenticationFactory.getAuthHeader((Map)OAuth2Utils.convertPropertiesToMap((Properties)p), (String)"GET", (URL)reverseURL, null);
                        authorizationHeader = new AuthorizationValue("Authorization", header, "header");
                    }
                    catch (Exception ex) {
                        securityGenerationException = ex;
                    }
                }
                authorizationValueList = null;
                if (authorizationHeader != null) {
                    authorizationValueList = Collections.singletonList(authorizationHeader);
                }
                proxySelector = null;
                sysPropBackup = new HashMap<String, String>();
                try {
                    if (isNtlm && securityNode != null) {
                        userNameNtlm = MdAttributeReader.readAttribute((String)"userName", (MdNode)securityNode);
                        passwordNtlm = MdAttributeReader.readAttribute((String)"password", (MdNode)securityNode);
                        domainNtlm = MdAttributeReader.readAttribute((String)"domain", (MdNode)securityNode);
                    } else {
                        userNameNtlm = null;
                        passwordNtlm = null;
                        domainNtlm = null;
                    }
                    Authenticator.setDefault(null);
                    if (proxyNode != null) {
                        proxySelector = new ReverseProxySelector(ProxySelector.getDefault(), openApiReverseUrl, MdAttributeReader.readAttribute((String)"host", (MdNode)proxyNode), Integer.valueOf(MdAttributeReader.readAttribute((String)"port", (MdNode)proxyNode)));
                        userName = MdAttributeReader.readAttribute((String)"username", (MdNode)proxyNode);
                        password = MdAttributeReader.readAttribute((String)"password", (MdNode)proxyNode);
                        rps = proxySelector;
                        ProxySelector.setDefault(proxySelector);
                        _isNtlm = isNtlm;
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                                    if (((InetSocketAddress)rps.proxy.address()).getPort() == this.getRequestingPort() && ((InetSocketAddress)rps.proxy.address()).getHostName().equals(this.getRequestingHost())) {
                                        return new PasswordAuthentication(userName, password == null ? new char[]{} : password.toCharArray());
                                    }
                                } else if (_isNtlm && this.getRequestorType() == Authenticator.RequestorType.SERVER) {
                                    String login = userNameNtlm;
                                    if (!userNameNtlm.startsWith(String.valueOf(domainNtlm) + "\\")) {
                                        login = String.valueOf(domainNtlm) + "\\" + userNameNtlm;
                                    }
                                    return new PasswordAuthentication(login, passwordNtlm == null ? new char[]{} : passwordNtlm.toCharArray());
                                }
                                return super.getPasswordAuthentication();
                            }
                        });
                    } else if (isNtlm) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
                                    String login = userNameNtlm;
                                    if (!userNameNtlm.startsWith(String.valueOf(domainNtlm) + "\\")) {
                                        login = String.valueOf(domainNtlm) + "\\" + userNameNtlm;
                                    }
                                    return new PasswordAuthentication(login, passwordNtlm == null ? new char[]{} : passwordNtlm.toCharArray());
                                }
                                return super.getPasswordAuthentication();
                            }
                        });
                    }
                    trustStore = MdAttributeReader.readAttributeRef((String)"truststore", (MdNode)rootNode);
                    if (trustStore != null) {
                        sysPropBackup.put("javax.net.ssl.trustStore", System.setProperty("javax.net.ssl.trustStore", MdAttributeReader.readAttribute((String)"filePath", (MdNode)trustStore)));
                        sysPropBackup.put("javax.net.ssl.trustStorePassword", System.setProperty("javax.net.ssl.trustStorePassword", MdAttributeReader.readAttribute((String)"password", (MdNode)trustStore)));
                        sysPropBackup.put("javax.net.ssl.trustStoreType", System.setProperty("javax.net.ssl.trustStoreType", MdAttributeReader.readAttribute((String)"type", (MdNode)trustStore)));
                    }
                    if ((messages = (swaggerParseResult = ReverseOpenApiAction.openAPIParser.readLocation(openApiReverseUrl, authorizationValueList, ReverseOpenApiAction.parseOptions)).getMessages()) != null && messages.size() > 0) {
                        throw new OpenAPIException(swaggerParseResult, securityGenerationException);
                    }
                    openAPISchema = swaggerParseResult.getOpenAPI();
                    Utils.logger.debug("Open API schema: " + openAPISchema);
                }
                finally {
                    HttpHelper.restoreHttpAuthenticator();
                    if (proxyNode != null) {
                        ProxySelector.setDefault(proxySelector.dps);
                    }
                    ** for (k : sysPropBackup.keySet())
                }
lbl-1000:
                // 1 sources

                {
                    if (sysPropBackup.get(k) == null) {
                        System.clearProperty(k);
                        continue;
                    }
                    System.setProperty(k, (String)sysPropBackup.get(k));
                    continue;
lbl81:
                    // 1 sources

                    break block20;
                }
            }
            throw new Exception(Messages.ReverseOpenApiAction_36);
        }
        return openAPISchema;
    }

    private static final int getRecursivityDepth(MdNode rootNode) throws Exception {
        int recursivityLevel;
        String recursivityDepth = MdAttributeReader.readAttribute((String)"recursivityDepth", (MdNode)rootNode);
        Utils.logger.debug("recursivity depth: " + recursivityDepth);
        try {
            recursivityLevel = Integer.valueOf(recursivityDepth);
        }
        catch (Exception exception) {
            throw new Exception(String.valueOf(Messages.ReverseOpenApiAction_39) + recursivityDepth);
        }
        if (recursivityLevel <= 0) {
            throw new Exception(String.valueOf(Messages.ReverseOpenApiAction_40) + recursivityDepth);
        }
        return recursivityLevel;
    }

    public static class OpenAPIException
    extends Exception {
        MdNode openAPIToMd;
        private OpenAPI openAPI;
        private String message;

        public OpenAPIException(SwaggerParseResult result, Exception securityGenerationException) {
            this.openAPI = result.getOpenAPI();
            if (securityGenerationException != null) {
                this.message = Messages.ReverseOpenApiAction_0;
            }
            StringBuilder b = new StringBuilder();
            for (String s : result.getMessages()) {
                if (b.length() > 0) {
                    b.append("\n");
                }
                b.append(s);
            }
            this.message = String.valueOf(Messages.ReverseOpenApiAction_2) + b.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public MdNode getOpenAPIToMd() {
            return this.openAPIToMd;
        }
    }

    private static class ReverseProxySelector
    extends ProxySelector {
        ProxySelector dps;
        Proxy proxy;
        URI uri;

        ReverseProxySelector(ProxySelector dps, String url, String proxyHost, int proxyport) throws URISyntaxException {
            this.dps = dps;
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyport));
            this.uri = new URI(url);
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (this.uri.equals(uri)) {
                ArrayList<Proxy> l = new ArrayList<Proxy>();
                l.add(this.proxy);
                return l;
            }
            return this.dps.select(uri);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }
}

