/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.indy.addons.httprest.internal.Utils;
import com.stambia.md.MdNode;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonSchemaVisitor {
    private final int maximumRecursivityLevel;
    private final Map<String, Schema<?>> knownReferencedSchemas;
    private final Stack<MdNode> nodes = new Stack();
    private final Map<String, Integer> recursivityCounter = new HashMap<String, Integer>();
    private Stack<String> dereferencedSchemasNames = new Stack();
    private static final String referencePathSeparator = "/";
    private static final String referenceStartMarkup = "#/";
    private static final String internalReferenceMarkup = "#/components/schemas/";
    private static final String EXTENSION_YAML = "YAML";
    private static final JsonFactory yamlFactory = new YAMLFactory();
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String NODE_ROOTOBJECT = "com.stambia.json.rootObject";
    private static final String NODE_OBJECT = "com.stambia.json.object";
    private static final String NODE_ROOTARRAY = "com.stambia.json.rootArray";
    private static final String NODE_ARRAY = "com.stambia.json.array";
    private static final String NODE_ROOTVALUE = "com.stambia.json.rootValue";
    private static final String NODE_VALUE = "com.stambia.json.value";
    private static final String ATTRIBUTE_OBJECT = "object";
    private static final String ATTRIBUTE_ARRAY = "array";
    private static final String ATTRIBUTE_BOOLEAN = "boolean";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_STRING = "string";
    private static final String ATTRIBUTE_INTEGER = "integer";
    private static final String ATTRIBUTE_TYPE = "type";
    private boolean root = true;

    protected JsonSchemaVisitor(MdNode jsonSchemaNode, int maximumRecursivityLevel, Map<String, Schema<?>> knownReferencedSchemas) {
        this.nodes.add(jsonSchemaNode);
        this.maximumRecursivityLevel = maximumRecursivityLevel;
        this.knownReferencedSchemas = knownReferencedSchemas;
    }

    protected void visit(Schema<?> schema) throws Exception {
        block14: {
            String reference;
            block15: {
                MdNode node;
                int recursivityLevel;
                Schema<?> dereferencedSchema;
                if (schema == null) break block14;
                reference = schema.get$ref();
                if (reference != null) {
                    dereferencedSchema = this.dereferenceSchema(schema, reference);
                    this.dereferencedSchemasNames.add(reference);
                    recursivityLevel = this.incrementRecursivityCounter();
                } else {
                    dereferencedSchema = schema;
                    recursivityLevel = 0;
                }
                String type = dereferencedSchema.getType();
                if (type == null || "null".equals(type)) break block15;
                switch (type) {
                    case "object": {
                        node = recursivityLevel <= this.maximumRecursivityLevel ? this.visitObject(dereferencedSchema) : null;
                        break;
                    }
                    case "array": {
                        node = recursivityLevel <= this.maximumRecursivityLevel ? this.visitArray(dereferencedSchema) : null;
                        break;
                    }
                    default: {
                        node = this.visitPrimitive(dereferencedSchema);
                    }
                }
                String schemaName = schema.getTitle();
                String usedSchemaName = schemaName != null && schemaName.trim().length() > 0 ? schemaName : dereferencedSchema.getTitle();
                JsonSchemaVisitor.setSchemaName(dereferencedSchema, usedSchemaName);
                String name = dereferencedSchema.getTitle();
                if (node != null) {
                    node.setName(name);
                }
                Utils.logger.debug("schema\tname:" + name);
            }
            if (reference != null) {
                this.decrementRecursivityCounter();
                this.dereferencedSchemasNames.pop();
            }
        }
    }

    private final Schema<?> dereferenceSchema(Schema<?> schema, String reference) throws Exception {
        Schema<?> dereferencedSchema;
        String localReferenceName;
        Utils.logger.debug("reference:" + reference);
        if (reference.startsWith(internalReferenceMarkup)) {
            localReferenceName = StringUtils.substringAfterLast((String)reference, (String)internalReferenceMarkup);
            dereferencedSchema = this.knownReferencedSchemas.get(localReferenceName);
        } else {
            dereferencedSchema = this.getSchemaFromUrl(reference);
            localReferenceName = null;
        }
        String dereferencedSchemaName = dereferencedSchema == null ? null : dereferencedSchema.getTitle();
        String usedSchemaName = dereferencedSchemaName != null && dereferencedSchemaName.trim().length() > 0 ? dereferencedSchemaName : localReferenceName;
        JsonSchemaVisitor.setSchemaName(dereferencedSchema, usedSchemaName);
        Utils.logger.debug("dereferenced schema:" + dereferencedSchema);
        return dereferencedSchema;
    }

    private final Schema<?> getSchemaFromUrl(String urlPath) throws Exception {
        if (!this.knownReferencedSchemas.containsKey(urlPath)) {
            Utils.logger.debug("url path:" + urlPath);
            String rootUrlPath = StringUtils.substringBefore((String)urlPath, (String)referenceStartMarkup);
            String extension = FilenameUtils.getExtension((String)rootUrlPath);
            JsonFactory factory = EXTENSION_YAML.equalsIgnoreCase(extension) ? yamlFactory : jsonFactory;
            URL url = new URL(urlPath);
            ObjectMapper objectMapper = new ObjectMapper(factory);
            JsonNode jsonNode = objectMapper.readTree(url);
            String name = null;
            String absoluteNodePath = StringUtils.substringAfter((String)urlPath, (String)referenceStartMarkup);
            if (absoluteNodePath.length() > 0) {
                String[] stringArray = absoluteNodePath.split(referencePathSeparator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String currentNode = stringArray[n2];
                    jsonNode = jsonNode.get(currentNode);
                    name = currentNode;
                    ++n2;
                }
            }
            String schemaContent = objectMapper.writeValueAsString((Object)jsonNode);
            Schema schema = (Schema)objectMapper.readValue(schemaContent, Schema.class);
            JsonSchemaVisitor.setSchemaName(schema, name);
            this.knownReferencedSchemas.put(urlPath, schema);
        }
        return this.knownReferencedSchemas.get(urlPath);
    }

    private final int incrementRecursivityCounter() {
        String dereferencedSchemaName = this.dereferencedSchemasNames.peek();
        int count = this.recursivityCounter.getOrDefault(dereferencedSchemaName, 0) + 1;
        this.recursivityCounter.put(dereferencedSchemaName, count);
        Utils.logger.debug("increment reference: " + dereferencedSchemaName + "=" + count);
        return count;
    }

    private final void decrementRecursivityCounter() {
        String dereferencedSchemaName = this.dereferencedSchemasNames.peek();
        int count = this.recursivityCounter.get(dereferencedSchemaName) - 1;
        this.recursivityCounter.put(dereferencedSchemaName, count);
        Utils.logger.debug("decrement reference: " + dereferencedSchemaName + "=" + count);
    }

    private final MdNode visitObject(Schema<?> object) throws Exception {
        Utils.logger.debug(ATTRIBUTE_OBJECT);
        MdNode parent = this.nodes.peek();
        String type = this.root ? NODE_ROOTOBJECT : NODE_OBJECT;
        MdNode node = Utils.createNode(parent, type);
        this.root = false;
        Map properties = object.getProperties();
        if (properties != null) {
            this.nodes.add(node);
            for (Map.Entry propertyEntry : properties.entrySet()) {
                String propertyName = (String)propertyEntry.getKey();
                Schema property = (Schema)propertyEntry.getValue();
                JsonSchemaVisitor.setSchemaName(property, propertyName);
                this.visit(property);
            }
            this.nodes.pop();
        }
        return node;
    }

    private final MdNode visitArray(Schema<?> array) throws Exception {
        Utils.logger.debug(ATTRIBUTE_ARRAY);
        MdNode parent = this.nodes.peek();
        String type = this.root ? NODE_ROOTARRAY : NODE_ARRAY;
        MdNode node = Utils.createNode(parent, type);
        this.root = false;
        this.nodes.add(node);
        if (array instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)array;
            Schema items = arraySchema.getItems();
            this.visit(items);
        }
        this.nodes.pop();
        return node;
    }

    private final MdNode visitPrimitive(Schema<?> primitive) {
        String stambiaType;
        String jsonType = primitive.getType();
        Utils.logger.debug("primitive:\ttype:" + jsonType);
        MdNode parent = this.nodes.peek();
        String value = this.root ? NODE_ROOTVALUE : NODE_VALUE;
        MdNode node = Utils.createNode(parent, value);
        switch (jsonType) {
            case "number": 
            case "string": 
            case "boolean": {
                stambiaType = jsonType;
                break;
            }
            case "integer": {
                stambiaType = ATTRIBUTE_NUMBER;
                break;
            }
            default: {
                stambiaType = ATTRIBUTE_STRING;
            }
        }
        Utils.setAttribute(node, ATTRIBUTE_TYPE, stambiaType);
        return node;
    }

    private static final void setSchemaName(Schema<?> schema, String name) {
        if (schema != null && name != null && name.trim().length() > 0) {
            schema.setTitle(name);
        }
    }
}

