/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.ConfigurableLabels;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.RestCollapsableUI;
import com.indy.addons.httprest.wizard.RestWizard;
import com.indy.addons.httprest.wizard.RestWizardBean;
import com.indy.addons.httprest.wizard.RestWizardControler;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class InvocationUI {
    public static Image runImage = null;
    public static Image stopImage = null;
    public static Image lnkImage = null;
    private int PLAIN_PARAMETER_COUNTER = 0;
    private List<RestWizardControler.BindingType> bindingTypes;
    private RestCollapsableUI commonControler;
    private Text result;
    private Text httpResponse;
    private ToolItem stop;
    private ToolItem headersBut;
    private TableViewer headerViewer;
    private Combo outputContentType;
    private Combo outputMediaTypeCombo;
    private AtomicBoolean lockButtons = new AtomicBoolean(false);
    private Text endPointText;
    private Text fullURLTxt;
    private Text inputTxt;
    private Combo method;
    private Combo inputContenTypeCombo;
    private Combo inputMediaTypeCombo;
    private TableViewer parametersViewer;
    private Text resourceTxt;
    private Composite inputComposite;
    private RestWizardControler controler;
    private ErrorHandler errorHandler;
    private ConfigurableLabels labels;
    private boolean contentTypeLinkedToMedaiType = true;
    private Job parseResultJob = null;
    private String inputBackText;

    static {
        try {
            runImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.debug.ui/icons/full/etool16/run_exc.png")).createImage();
            stopImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.debug.ui//icons/full/elcl16/terminate_co.png")).createImage();
            lnkImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.workbench.texteditor/icons/full/elcl16/link_to_editor.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public InvocationUI(RestWizardControler controler) {
        this.controler = controler;
        this.fillLabels();
        this.fillBindingTypes();
    }

    private Composite createInputComposite(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.RestConnectionUI_14);
        main.setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm((Composite)main, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Group parameterParent = new Group((Composite)sash, 0);
        parameterParent.setText(Messages.RestConnectionUI_15);
        parameterParent.setLayout((Layout)new GridLayout());
        parameterParent.setLayoutData((Object)new GridData(1808));
        ToolBar tb = new ToolBar((Composite)parameterParent, 256);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.RestConnectionUI_16);
        add.setImage(AbstractUnboundedControl.addIcon);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvocationUI.this.controler.getBean().addParameter("newParam", "value", RestWizardControler.BindingType.HTTP_URL_ENCODED, true, true);
                InvocationUI.this.parametersViewer.refresh();
                InvocationUI.this.refreshInputText();
                InvocationUI.this.refreshURL();
            }
        });
        final HashMap buttons = new HashMap();
        ToolItem delete = new ToolItem(tb, 8);
        delete.setToolTipText(Messages.RestConnectionUI_19);
        delete.setImage(AbstractUnboundedControl.delIcon);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List l = ((IStructuredSelection)InvocationUI.this.parametersViewer.getSelection()).toList();
                ((List)InvocationUI.this.parametersViewer.getInput()).removeAll(l);
                Object bParent = null;
                Object b = null;
                for (Object o : l) {
                    if (!(o instanceof RestWizardBean.Parameter) || ((RestWizardBean.Parameter)o).type != RestWizardControler.BindingType.MIME_CONTENT) continue;
                    InvocationUI invocationUI = InvocationUI.this;
                    invocationUI.PLAIN_PARAMETER_COUNTER = invocationUI.PLAIN_PARAMETER_COUNTER - 1;
                }
                if (bParent != null) {
                    bParent.layout(true);
                }
                InvocationUI.this.parametersViewer.refresh();
                InvocationUI.this.refreshInputText();
                InvocationUI.this.refreshURL();
            }
        });
        this.parametersViewer = new TableViewer((Composite)parameterParent, 68352);
        GridData gd = null;
        gd = new GridData(1808);
        this.parametersViewer.getControl().setLayoutData((Object)gd);
        gd.minimumHeight = 50;
        this.parametersViewer.getTable().setHeaderVisible(true);
        this.parametersViewer.getTable().setLinesVisible(true);
        this.parametersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.parametersViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return InvocationUI.this.bindingTypes.contains((Object)((RestWizardBean.Parameter)element).type);
            }
        });
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            TableViewerColumn send = new TableViewerColumn(this.parametersViewer, 16384);
            send.getColumn().setText(Messages.RestConnectionUI_25);
            send.getColumn().setWidth(50);
            send.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public void update(ViewerCell cell) {
                    Button button;
                    final TableItem item = (TableItem)cell.getItem();
                    if (buttons.containsKey(cell.getElement())) {
                        button = (Button)buttons.get(cell.getElement());
                    } else {
                        button = new Button((Composite)cell.getViewerRow().getControl(), 32);
                        button.setSelection(true);
                        buttons.put((RestWizardBean.Parameter)cell.getElement(), button);
                        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Button button = (Button)e.widget;
                                RestWizardBean.Parameter parameter = (RestWizardBean.Parameter)item.getData();
                                parameter.send = button.getSelection();
                                InvocationUI.this.parametersViewer.refresh((Object)parameter, true);
                                InvocationUI.this.refreshInputText();
                                InvocationUI.this.refreshURL();
                            }
                        });
                        final TableEditor editor = new TableEditor(item.getParent());
                        editor.grabHorizontal = true;
                        editor.grabVertical = true;
                        editor.setEditor((Control)button, item, cell.getColumnIndex());
                        editor.layout();
                        item.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                button.dispose();
                                editor.dispose();
                            }
                        });
                    }
                    if (!button.isDisposed()) {
                        if (((RestWizardBean.Parameter)cell.getElement()).type == RestWizardControler.BindingType.MIME_CONTENT) {
                            button.setSelection(true);
                            button.setEnabled(false);
                        } else {
                            button.setEnabled(true);
                        }
                    }
                }
            });
        }
        TableViewerColumn name = new TableViewerColumn(this.parametersViewer, 16384);
        name.getColumn().setText(Messages.RestConnectionUI_20);
        name.getColumn().setWidth(200);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RestWizardBean.Parameter)element).name;
            }
        });
        name.setEditingSupport(new EditingSupport((ColumnViewer)this.parametersViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)InvocationUI.this.parametersViewer.getTable());
            }

            protected Object getValue(Object element) {
                return ((RestWizardBean.Parameter)element).name;
            }

            protected void setValue(Object element, Object value) {
                ((RestWizardBean.Parameter)element).name = (String)value;
                InvocationUI.this.parametersViewer.refresh(element);
                InvocationUI.this.refreshInputText();
                InvocationUI.this.refreshURL();
            }
        });
        TableViewerColumn value = new TableViewerColumn(this.parametersViewer, 16384);
        value.getColumn().setText(Messages.RestConnectionUI_21);
        value.getColumn().setWidth(200);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RestWizardBean.Parameter)element).value;
            }
        });
        value.setEditingSupport(new EditingSupport((ColumnViewer)this.parametersViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)InvocationUI.this.parametersViewer.getTable());
            }

            protected Object getValue(Object element) {
                return ((RestWizardBean.Parameter)element).value;
            }

            protected void setValue(Object element, Object value) {
                ((RestWizardBean.Parameter)element).value = (String)value;
                if (InvocationUI.this.controler.getHint() != null) {
                    ((InvocationUI)InvocationUI.this).controler.getHint().parameterValues.put(((RestWizardBean.Parameter)element).name, ((RestWizardBean.Parameter)element).value);
                }
                InvocationUI.this.parametersViewer.refresh(element);
                InvocationUI.this.refreshInputText();
                InvocationUI.this.refreshURL();
            }
        });
        TableViewerColumn type = new TableViewerColumn(this.parametersViewer, 16384);
        type.getColumn().setText(Messages.RestConnectionUI_22);
        type.getColumn().setWidth(100);
        type.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return InvocationUI.this.labels.getBindingTypeLabel(((RestWizardBean.Parameter)element).type);
            }
        });
        type.setEditingSupport(new EditingSupport((ColumnViewer)this.parametersViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                String[] values = new String[InvocationUI.this.bindingTypes.size()];
                int i = 0;
                while (i < values.length) {
                    values[i] = InvocationUI.this.labels.getBindingTypeLabel((RestWizardControler.BindingType)((Object)InvocationUI.this.bindingTypes.get(i)));
                    ++i;
                }
                return new ComboBoxCellEditor((Composite)InvocationUI.this.parametersViewer.getTable(), values, 8);
            }

            protected Object getValue(Object element) {
                return InvocationUI.this.bindingTypes.indexOf((Object)((RestWizardBean.Parameter)element).type);
            }

            protected void setValue(Object element, Object value) {
                RestWizardControler.BindingType oldType = ((RestWizardBean.Parameter)element).type;
                ((RestWizardBean.Parameter)element).type = (RestWizardControler.BindingType)((Object)InvocationUI.this.bindingTypes.get((Integer)value));
                InvocationUI.this.parametersViewer.refresh(element);
                RestWizardControler.BindingType newType = ((RestWizardBean.Parameter)element).type;
                if (oldType != newType) {
                    if (oldType == RestWizardControler.BindingType.MIME_CONTENT) {
                        InvocationUI invocationUI = InvocationUI.this;
                        invocationUI.PLAIN_PARAMETER_COUNTER = invocationUI.PLAIN_PARAMETER_COUNTER - 1;
                    } else if (newType == RestWizardControler.BindingType.MIME_CONTENT) {
                        InvocationUI invocationUI = InvocationUI.this;
                        invocationUI.PLAIN_PARAMETER_COUNTER = invocationUI.PLAIN_PARAMETER_COUNTER + 1;
                    }
                    InvocationUI.this.refreshInputText();
                    InvocationUI.this.refreshURL();
                }
            }
        });
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            TableViewerColumn allowEmpty = new TableViewerColumn(this.parametersViewer, 16384);
            allowEmpty.getColumn().setText(Messages.InvocationUI_1);
            allowEmpty.getColumn().setWidth(110);
            allowEmpty.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                TableEditor editor = null;
                Map<RestWizardBean.Parameter, Button> buttons = new HashMap<RestWizardBean.Parameter, Button>();

                public void update(final ViewerCell cell) {
                    Button button;
                    final TableItem item = (TableItem)cell.getItem();
                    if (this.buttons.containsKey(cell.getElement())) {
                        button = this.buttons.get(cell.getElement());
                    } else {
                        button = new Button((Composite)cell.getViewerRow().getControl(), 32);
                        button.setSelection(((RestWizardBean.Parameter)cell.getElement()).allowEmptyValue.booleanValue());
                        this.buttons.put((RestWizardBean.Parameter)cell.getElement(), button);
                        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Button button = (Button)e.widget;
                                RestWizardBean.Parameter parameter = (RestWizardBean.Parameter)item.getData();
                                parameter.allowEmptyValue = button.getSelection();
                                InvocationUI.this.parametersViewer.refresh((Object)parameter, true);
                                InvocationUI.this.refreshInputText();
                                InvocationUI.this.refreshURL();
                            }
                        });
                        this.editor = new TableEditor(item.getParent());
                        this.editor.grabHorizontal = true;
                        this.editor.grabVertical = true;
                        this.editor.setEditor((Control)button, item, cell.getColumnIndex());
                        this.editor.layout();
                        item.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                buttons.remove(cell.getElement());
                                button.dispose();
                                editor.dispose();
                            }
                        });
                    }
                    if (!button.isDisposed()) {
                        if (((RestWizardBean.Parameter)cell.getElement()).type == RestWizardControler.BindingType.MIME_CONTENT) {
                            button.setSelection(true);
                            button.setEnabled(false);
                        } else {
                            button.setEnabled(true);
                        }
                    }
                }
            });
        }
        this.inputComposite = new Group((Composite)sash, 0);
        ((Group)this.inputComposite).setText(Messages.RestConnectionUI_23);
        this.inputComposite.setLayout((Layout)new GridLayout(3, false));
        final ToolBar xx = new ToolBar(this.inputComposite, 0x800000);
        xx.setLayoutData((Object)new GridData(2, 2, false, false, 1, 2));
        ((GridData)xx.getLayoutData()).exclude = true;
        xx.setVisible(false);
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            ((GridData)xx.getLayoutData()).exclude = false;
            xx.setVisible(true);
            ToolItem ii = new ToolItem(xx, 32);
            ii.setImage(lnkImage);
            ii.setToolTipText(Messages.InvocationUI_2);
            ii.setSelection(true);
            ii.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InvocationUI.this.contentTypeLinkedToMedaiType = !InvocationUI.this.contentTypeLinkedToMedaiType;
                }
            });
            final Label l = new Label(this.inputComposite, 0);
            l.setText(Messages.InvocationUI_3);
            l.setLayoutData((Object)new GridData());
            this.inputMediaTypeCombo = new Combo(this.inputComposite, 2048);
            this.inputMediaTypeCombo.setLayoutData((Object)new GridData(4, 1, true, false));
            this.inputMediaTypeCombo.setItems(MimeType.getMediaTypes());
            this.inputMediaTypeCombo.select(0);
            this.inputMediaTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InvocationUI.this.controler.getBean().setHttpInputMediaType(InvocationUI.this.inputMediaTypeCombo.getText());
                    if (InvocationUI.this.contentTypeLinkedToMedaiType) {
                        try {
                            MimeType mimeType = MimeType.valueOf(InvocationUI.this.inputMediaTypeCombo.getText());
                            if (mimeType != null) {
                                InvocationUI.this.inputContenTypeCombo.setText(mimeType.getDefaultContentType());
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    InvocationUI.this.refreshInputText();
                }
            });
            this.inputMediaTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InvocationUI.this.controler.getBean().setHttpInputMediaType(InvocationUI.this.inputMediaTypeCombo.getText());
                }
            });
            this.inputComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Rectangle buttonBounds = xx.getBounds();
                    Rectangle labelBounds = l.getBounds();
                    Rectangle label2Bounds = InvocationUI.this.inputComposite.getChildren()[3].getBounds();
                    Rectangle rect = new Rectangle(buttonBounds.x + buttonBounds.width / 2, labelBounds.y + labelBounds.height / 2, labelBounds.x - buttonBounds.x, buttonBounds.height + label2Bounds.height / 2);
                    e.gc.setClipping(new Rectangle(rect.x, rect.y, labelBounds.x - buttonBounds.x, rect.height + 1));
                    e.gc.drawRectangle(rect);
                }
            });
        }
        Label l = new Label(this.inputComposite, 0);
        l.setText(this.labels.mediaTypeLabel);
        l.setLayoutData((Object)new GridData());
        this.inputContenTypeCombo = new Combo(this.inputComposite, 2048);
        this.inputContenTypeCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.inputContenTypeCombo.setItems(MimeType.getContentTypes());
        this.inputContenTypeCombo.select(0);
        this.inputContenTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvocationUI.this.controler.getBean().setHttpInputContentType(InvocationUI.this.inputContenTypeCombo.getText());
            }
        });
        this.inputContenTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationUI.this.controler.getBean().setHttpInputContentType(InvocationUI.this.inputContenTypeCombo.getText());
            }
        });
        this.inputTxt = new Text(this.inputComposite, 2818);
        this.inputTxt.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.inputTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InvocationUI.this.controler.getHint() != null && InvocationUI.this.inputTxt.isEnabled() && !InvocationUI.this.inputTxt.getText().isEmpty()) {
                    ((InvocationUI)InvocationUI.this).controler.getHint().txtInput = InvocationUI.this.inputTxt.getText();
                    InvocationUI.this.controler.getBean().setInputData(InvocationUI.this.inputTxt.getText());
                }
            }
        });
        if (this.controler.getBean().getInputData() != null) {
            this.inputTxt.setText(this.controler.getBean().getInputData());
        }
        this.commonControler = new RestCollapsableUI(this.controler);
        Composite c = this.commonControler.createComposite((Composite)main, (Composite)sash);
        c.setLayoutData((Object)new GridData(4, 3, true, false));
        sash.setWeights(new int[]{33, 33, 33});
        return parameterParent;
    }

    private Composite createConnectionComposite(Composite parent) {
        Composite partComposite = new Composite(parent, 0);
        partComposite.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(partComposite, 0);
        l.setLayoutData((Object)new GridData(4, 1, false, false));
        l.setText(Messages.RestConnectionUI_2);
        Composite c = new Composite(partComposite, 0);
        GridLayout gl = null;
        gl = new GridLayout(2, true);
        c.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        GridData gd = null;
        gd = new GridData(4, 1, true, false, 1, 2);
        c.setLayoutData((Object)gd);
        gd.widthHint = 400;
        l = new Label(c, 0);
        l.setLayoutData((Object)new GridData(4, 1, true, false));
        l.setText(this.labels.endpointLabel);
        l = new Label(c, 0);
        l.setLayoutData((Object)new GridData(4, 1, true, false));
        l.setText(this.labels.resourceLabel);
        this.method = new Combo(partComposite, 8);
        this.method.setItems(new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "TRACE", "CONNECT", "PATCH"});
        this.method.setLayoutData((Object)new GridData(4, 1, false, false));
        this.method.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvocationUI.this.controler.getBean().setHttpMethod(InvocationUI.this.method.getText());
                InvocationUI.this.refreshInputText();
            }
        });
        this.endPointText = new Text(c, 2048);
        this.endPointText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.endPointText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationUI.this.controler.getBean().setHttpEndpoint(InvocationUI.this.endPointText.getText());
                InvocationUI.this.refreshURL();
            }
        });
        this.resourceTxt = new Text(c, 2048);
        this.resourceTxt.setLayoutData((Object)new GridData(4, 1, true, false));
        this.resourceTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationUI.this.controler.getBean().setHttpResourcePath(InvocationUI.this.resourceTxt.getText());
                InvocationUI.this.refreshURL();
            }
        });
        Composite urlComposite = new Composite(parent, 0);
        urlComposite.setLayout((Layout)new GridLayout(2, false));
        urlComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        l = new Label(urlComposite, 0);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        l.setText(Messages.RestConnectionUI_0);
        this.fullURLTxt = new Text(urlComposite, 2626);
        GridData gridData = new GridData(4, 1, true, false);
        this.fullURLTxt.setLayoutData((Object)gridData);
        gridData.heightHint = 70;
        this.fullURLTxt.setEditable(false);
        this.fullURLTxt.setBackground(urlComposite.getBackground());
        return partComposite;
    }

    public Composite createComposite(Composite parent) {
        final Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Composite addressBar = new Composite(main, 0);
        addressBar.setLayout((Layout)new GridLayout(2, false));
        addressBar.setLayoutData((Object)new GridData(4, 2, true, false));
        ToolBar tb = new ToolBar(addressBar, 256);
        tb.setLayoutData((Object)new GridData(1, 2, false, false));
        final ToolItem run = new ToolItem(tb, 8);
        run.setToolTipText(Messages.WSController_8);
        run.setImage(runImage);
        run.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvocationUI.this.stop.setEnabled(true);
                run.setEnabled(false);
                Job j = InvocationUI.this.controler.handleCallURL();
                this.scheduleParseResultJob(j);
            }

            private void scheduleParseResultJob(final Job j) {
                if (InvocationUI.this.parseResultJob != null) {
                    InvocationUI.this.parseResultJob.cancel();
                }
                InvocationUI.this.parseResultJob = new Job(Messages.InvocationUI_15){

                    public IStatus run(final IProgressMonitor monitor) {
                        while (!monitor.isCanceled() && j.getState() == 4) {
                            try {
                                j.join(100L, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        main.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (monitor.isCanceled() || !j.getResult().isOK()) {
                                        InvocationUI.this.result.setText("");
                                    } else {
                                        RestWizardControler.InvokeResult lastResult = InvocationUI.this.controler.getLastResult();
                                        InvocationUI.this.outputContentType.setText(lastResult.getContentType() == null ? "" : lastResult.getContentType());
                                        InvocationUI.this.httpResponse.setText(String.valueOf(lastResult.getHttpResponseCode()) + " : " + lastResult.getHttpResponseMessage());
                                        InvocationUI.this.result.setText(lastResult.getDatas());
                                        InvocationUI.this.stop.setEnabled(false);
                                        ArrayList<String[]> headerValues = new ArrayList<String[]>();
                                        for (String s : lastResult.getHeaders().keySet()) {
                                            if (s == null) continue;
                                            String[] entry = new String[2];
                                            entry[0] = s;
                                            StringBuffer buf = new StringBuffer();
                                            for (String v : lastResult.getHeaders().get(s)) {
                                                if (buf.length() > 0) {
                                                    buf.append(";");
                                                }
                                                buf.append(v);
                                            }
                                            entry[1] = buf.toString();
                                            headerValues.add(entry);
                                        }
                                        InvocationUI.this.headerViewer.setInput(headerValues);
                                        InvocationUI.this.headersBut.setText(String.format(Messages.InvocationUI_4, headerValues.size()));
                                        if (InvocationUI.this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
                                            InvocationUI.this.outputMediaTypeCombo.setText(lastResult.computeMediaType());
                                        }
                                    }
                                }
                                finally {
                                    InvocationUI.this.stop.setEnabled(false);
                                    run.setEnabled(true);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                InvocationUI.this.parseResultJob.setUser(true);
                InvocationUI.this.parseResultJob.schedule();
            }
        });
        this.stop = new ToolItem(tb, 8);
        this.stop.setToolTipText(Messages.WSController_9);
        this.stop.setEnabled(false);
        this.stop.setImage(stopImage);
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvocationUI.this.controler.handleCancelCall();
                if (InvocationUI.this.parseResultJob != null) {
                    InvocationUI.this.parseResultJob.cancel();
                    try {
                        InvocationUI.this.parseResultJob.join(30000L, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                InvocationUI.this.result.setText("");
                InvocationUI.this.stop.setEnabled(false);
                run.setEnabled(true);
            }
        });
        Composite connectionComposite = this.createConnectionComposite(addressBar);
        connectionComposite.setLayoutData((Object)new GridData(4, 2, true, false));
        SashForm sash = new SashForm(main, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite input = this.createInputComposite((Composite)sash);
        input.setLayoutData((Object)new GridData(1808));
        Group res = new Group((Composite)sash, 0);
        res.setText(Messages.WSController_11);
        res.setLayout((Layout)new GridLayout());
        res.setLayoutData((Object)new GridData(1808));
        SashForm s2 = new SashForm((Composite)res, 512);
        s2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.result = new Text((Composite)s2, 2626);
        this.result.setLayoutData((Object)new GridData(1808));
        this.result.setEditable(false);
        Composite content = new Composite((Composite)s2, 0);
        content.setLayout((Layout)new RestCollapsableUI.ShrinkedStackLayout());
        content.setVisible(false);
        ToolBar toolbar = new ToolBar((Composite)res, 0x800100);
        toolbar.setLayoutData((Object)new GridData(4, 3, true, false));
        ToolItem headers = new ToolItem(toolbar, 32);
        headers.setText(Messages.WSController_12);
        this.headersBut = headers;
        headers.addSelectionListener((SelectionListener)new RestCollapsableUI.PannelListener(headers, this.createHeadersComposite(content), Messages.WSController_13, this.lockButtons, content));
        Composite c = new Composite((Composite)res, 0);
        GridLayout gl = null;
        c.setLayoutData((Object)new GridData(4, 1, true, false));
        gl = new GridLayout(2, false);
        c.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        Label l = new Label(c, 0);
        l.setText(Messages.WSController_14);
        l.setLayoutData((Object)new GridData());
        this.httpResponse = new Text(c, 2048);
        this.httpResponse.setEditable(false);
        this.httpResponse.setLayoutData((Object)new GridData(4, 3, true, false));
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            l = new Label(c, 0);
            l.setText(Messages.InvocationUI_3);
            l.setLayoutData((Object)new GridData());
            this.outputMediaTypeCombo = new Combo(c, 2048);
            this.outputMediaTypeCombo.setLayoutData((Object)new GridData(1808));
            this.outputMediaTypeCombo.setItems(MimeType.getMediaTypes());
            this.outputMediaTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (InvocationUI.this.controler.getLastResult() != null) {
                        InvocationUI.this.controler.getBean().getHttpOutputMediaTypePerResultCode().put(String.valueOf(InvocationUI.this.controler.getLastResult().getHttpResponseCode()), InvocationUI.this.outputMediaTypeCombo.getText());
                    }
                    InvocationUI.this.controler.getBean().setHttpOutputMediaType(InvocationUI.this.outputMediaTypeCombo.getText());
                }
            });
            this.outputMediaTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (InvocationUI.this.controler.getLastResult() != null) {
                        InvocationUI.this.controler.getBean().getHttpOutputMediaTypePerResultCode().put(String.valueOf(InvocationUI.this.controler.getLastResult().getHttpResponseCode()), InvocationUI.this.outputMediaTypeCombo.getText());
                    }
                    InvocationUI.this.controler.getBean().setHttpOutputMediaType(InvocationUI.this.outputMediaTypeCombo.getText());
                }
            });
        }
        l = new Label(c, 0);
        l.setText(Messages.WSController_15);
        l.setLayoutData((Object)new GridData());
        this.outputContentType = new Combo(c, 2048);
        this.outputContentType.setLayoutData((Object)new GridData(1808));
        this.outputContentType.setItems(MimeType.getContentTypes());
        this.outputContentType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InvocationUI.this.controler.getLastResult() != null) {
                    InvocationUI.this.controler.getLastResult().setContentType(InvocationUI.this.outputContentType.getText());
                }
            }
        });
        this.outputContentType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InvocationUI.this.controler.getLastResult() != null) {
                    InvocationUI.this.controler.getLastResult().setContentType(InvocationUI.this.outputContentType.getText());
                }
            }
        });
        sash.setWeights(new int[]{50, 50});
        this.fillData();
        return main;
    }

    private Control createHeadersComposite(Composite parent) {
        this.headerViewer = new TableViewer(parent, 68352);
        GridData gd = null;
        gd = new GridData(1808);
        this.headerViewer.getControl().setLayoutData((Object)gd);
        gd.minimumHeight = 150;
        this.headerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.headerViewer.getTable().setLinesVisible(true);
        this.headerViewer.getTable().setHeaderVisible(true);
        TableViewerColumn name = new TableViewerColumn(this.headerViewer, 16384);
        name.getColumn().setWidth(200);
        name.getColumn().setText(Messages.WSController_18);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((String[])element)[0];
            }
        });
        TableViewerColumn value = new TableViewerColumn(this.headerViewer, 16384);
        value.getColumn().setWidth(200);
        value.getColumn().setText(Messages.WSController_19);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((String[])element)[1];
            }
        });
        return this.headerViewer.getControl();
    }

    private void refreshInputText() {
        boolean inputVisible = this.controler.getBean().allowedInput(this.method.getText());
        boolean wasInputManual = this.inputTxt.isEnabled();
        this.inputComposite.setVisible(inputVisible);
        if (inputVisible) {
            if (this.inputMediaTypeCombo != null) {
                this.inputMediaTypeCombo.setEnabled(this.PLAIN_PARAMETER_COUNTER == 0);
            }
            this.inputTxt.setEnabled(this.PLAIN_PARAMETER_COUNTER == 0);
            if (this.PLAIN_PARAMETER_COUNTER > 0) {
                this.inputContenTypeCombo.select(MimeType.FORM.ordinal());
                if (this.inputMediaTypeCombo != null) {
                    this.inputMediaTypeCombo.select(MimeType.FORM.ordinal());
                }
            } else if (this.inputMediaTypeCombo != null && this.inputMediaTypeCombo.getText().equals(MimeType.FORM.mediaType)) {
                this.inputTxt.setText("");
                this.inputTxt.setEnabled(false);
            }
        }
        this.inputComposite.getParent().layout(true, true);
        this.inputComposite.getParent().getParent().layout(true, true);
        if (this.PLAIN_PARAMETER_COUNTER > 0) {
            StringBuffer b = new StringBuffer();
            for (Object o : (List)this.parametersViewer.getInput()) {
                if (((RestWizardBean.Parameter)o).type != RestWizardControler.BindingType.MIME_CONTENT) continue;
                if (b.length() > 0) {
                    b.append("&");
                }
                if (((RestWizardBean.Parameter)o).name == null) continue;
                try {
                    b.append(URLEncoder.encode(((RestWizardBean.Parameter)o).name, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    b.append(((RestWizardBean.Parameter)o).name);
                }
                b.append("=");
                if (((RestWizardBean.Parameter)o).value == null) continue;
                try {
                    b.append(URLEncoder.encode(((RestWizardBean.Parameter)o).value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    b.append(((RestWizardBean.Parameter)o).value);
                }
            }
            this.inputTxt.setText(b.toString());
        } else if (this.inputTxt.isEnabled() && !wasInputManual) {
            if (this.controler.getBean().getInputData() != null) {
                this.inputTxt.setText(this.controler.getBean().getInputData());
            } else {
                this.inputTxt.setText("");
            }
        }
    }

    private void refreshURL() {
        if (this.fullURLTxt != null) {
            try {
                URL url = this.controler.getURL();
                if (!url.getProtocol().toLowerCase().equals("http") && !url.getProtocol().toLowerCase().equals("https")) {
                    throw new Exception(Messages.InvocationUI_0);
                }
                this.fullURLTxt.setText(url.toString());
                if (!this.fullURLTxt.getText().toLowerCase().startsWith("http://") && !this.fullURLTxt.getText().toLowerCase().startsWith("https://")) {
                    throw new Exception(Messages.InvocationUI_11);
                }
                if (this.errorHandler != null) {
                    this.errorHandler.handleError(null);
                }
            }
            catch (Exception e) {
                if (this.errorHandler != null) {
                    if (!this.fullURLTxt.getText().toLowerCase().startsWith("http://") && !this.fullURLTxt.getText().toLowerCase().startsWith("https://")) {
                        this.errorHandler.handleError(Messages.InvocationUI_11);
                    } else {
                        this.errorHandler.handleError(e.getMessage());
                    }
                }
                this.fullURLTxt.setText("");
            }
        }
    }

    private void fillData() {
        this.PLAIN_PARAMETER_COUNTER = 0;
        this.method.setText(this.controler.getBean().getHttpMethod());
        this.endPointText.setText(this.controler.getBean().getHttpEndpoint());
        this.resourceTxt.setText(this.controler.getBean().getHttpResourcePath());
        String initContentType = this.controler.getBean().getHttpInputContentType();
        if (this.inputMediaTypeCombo != null) {
            this.inputMediaTypeCombo.setText(this.controler.getBean().getHttpInputMediaType());
        }
        this.inputContenTypeCombo.setText(initContentType);
        this.parametersViewer.setInput(this.controler.getBean().getParameters());
        this.commonControler.fillData();
        for (RestWizardBean.Parameter p : this.controler.getBean().getParameters()) {
            if (p.type != RestWizardControler.BindingType.MIME_CONTENT) continue;
            ++this.PLAIN_PARAMETER_COUNTER;
        }
        this.inputTxt.setEnabled(this.PLAIN_PARAMETER_COUNTER > 0 || this.inputMediaTypeCombo != null && !this.inputMediaTypeCombo.getText().equals(MimeType.FORM.mediaType));
        this.refreshInputText();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void fillBindingTypes() {
        this.bindingTypes = new ArrayList<RestWizardControler.BindingType>();
        RestWizardControler.BindingType[] bindingTypeArray = RestWizardControler.BindingType.values();
        int n = bindingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RestWizardControler.BindingType bindingType = bindingTypeArray[n2];
            if (bindingType.isActive(this.controler.getReverseMode())) {
                this.bindingTypes.add(bindingType);
            }
            ++n2;
        }
    }

    private void fillLabels() {
        this.labels = new ConfigurableLabels();
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            this.labels.endpointLabel = Messages.RestConnectionUI_5;
            this.labels.resourceLabel = Messages.RestConnectionUI_6;
            this.labels.mediaTypeLabel = Messages.RestConnectionUI_7;
            this.labels.urlReplacementLabel = Messages.RestConnectionUI_13;
            this.labels.contentLabel = "FORM";
        } else {
            this.labels.endpointLabel = Messages.RestConnectionUI_3;
            this.labels.resourceLabel = Messages.RestConnectionUI_4;
            this.labels.mediaTypeLabel = Messages.RestConnectionUI_24;
            this.labels.urlReplacementLabel = Messages.RestConnectionUI_11;
            this.labels.contentLabel = Messages.RestConnectionUI_12;
        }
        this.labels.headerLabel = Messages.RestConnectionUI_8;
        this.labels.methodLabel = Messages.RestConnectionUI_9;
        this.labels.urlEncodedLabel = Messages.RestConnectionUI_10;
        this.labels.cookieLabel = Messages.RestConnectionUI_26;
    }

    public static interface ErrorHandler {
        public void handleError(String var1);
    }

    static enum MimeType {
        JSON("JSON", "application/json"),
        XML("XML", "application/xml"),
        TEXT("TEXT", "text/plain"),
        FORM("FORM", "application/x-www-form-urlencoded"),
        BINARY("BINARY", "application/octet-stream");

        String mediaType;
        String defaultContentType;

        private MimeType(String mediaType, String contentType) {
            this.mediaType = mediaType;
            this.defaultContentType = contentType;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        static String[] getMediaTypes() {
            String[] res = new String[MimeType.values().length];
            int i = 0;
            while (i < res.length) {
                res[i] = MimeType.values()[i].mediaType;
                ++i;
            }
            return res;
        }

        static String[] getContentTypes() {
            String[] res = new String[MimeType.values().length];
            int i = 0;
            while (i < res.length) {
                res[i] = MimeType.values()[i].defaultContentType;
                ++i;
            }
            return res;
        }
    }
}

