/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.Activator;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.RestWizard;
import com.indy.addons.httprest.wizard.RestWizardControler;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class RestCollapsableUI {
    public static final String NONE = "None";
    public static final String AUTH_NONE = "None";
    public static final String AUTH_BASIC = "Basic";
    public static final String AUTH_NTLM = "NTLM";
    public static final String AUTH_OAUTH2 = "OAuth 2.0";
    public static final String AUTH_OAUTH = "OAuth";
    public static Image editIcon = Activator.imageDescriptorFromPlugin((String)"com.indy.ui.text.editor", (String)"/icons/SDIEditor16x16.png").createImage();
    public static Image delIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/delete_obj.png").createImage();
    public static Image addIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/add_obj.png").createImage();
    private AtomicBoolean lockButtons = new AtomicBoolean(false);
    private Composite content;
    private Composite authComposite;
    private Composite headersComposite;
    private TableViewer headerViewer;
    private Combo authTYpe;
    private ComboViewer securityPickerViewer;
    private ComboViewer securityProxyPickerViewer;
    private ComboViewer keystorePickerViewer;
    private ComboViewer truststorePickerViewer;
    private ToolItem headersBut;
    private ToolItem authBut;
    private Button editSecurity;
    private Button securityCreate;
    private RestWizardControler controler;
    AuthMode autMode = AuthMode.NONE;

    public RestCollapsableUI(RestWizardControler controler) {
        this.controler = controler;
    }

    public Composite createComposite(Composite parent, Composite sash) {
        this.content = new Group(sash, 0);
        this.content.setLayoutData((Object)new GridData(1808));
        this.content.setLayout((Layout)new ShrinkedStackLayout());
        this.content.setVisible(false);
        ToolBar toolbar = new ToolBar(parent, 0x800100);
        toolbar.setLayoutData((Object)new GridData(4, 3, true, false));
        PannelListener listener = null;
        ToolItem headers = null;
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.WSDL)) {
            headers = new ToolItem(toolbar, 32);
            headers.setText(Messages.WSCommonControler_10);
            this.headersBut = headers;
        }
        ToolItem authentication = new ToolItem(toolbar, 32);
        authentication.setText(Messages.WSCommonControler_11);
        this.authBut = authentication;
        listener = new PannelListener(authentication, this.getAuthComposite(), Messages.WSCommonControler_13, this.lockButtons, this.content);
        authentication.addSelectionListener((SelectionListener)listener);
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.WSDL)) {
            listener.addOtherButton(headers);
            listener = new PannelListener(headers, this.getHeadersComposite(), Messages.WSCommonControler_12, this.lockButtons, this.content);
            headers.addSelectionListener((SelectionListener)listener);
            listener.addOtherButton(authentication);
        }
        return toolbar;
    }

    private Control getHeadersComposite() {
        if (this.headersComposite == null) {
            this.headersComposite = new Composite(this.content, 0);
            this.headersComposite.setLayout((Layout)new GridLayout());
            ToolBar tb = new ToolBar(this.headersComposite, 256);
            tb.setLayoutData((Object)new GridData(768));
            ToolItem add = new ToolItem(tb, 8);
            add.setImage(AbstractUnboundedControl.addIcon);
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RestCollapsableUI.this.controler.getBean().getHeaders().add(new String[]{"header", "value"});
                    RestCollapsableUI.this.headerViewer.refresh();
                    RestCollapsableUI.this.updateHeaderCount();
                }
            });
            ToolItem del = new ToolItem(tb, 8);
            del.setImage(AbstractUnboundedControl.delIcon);
            del.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RestCollapsableUI.this.controler.getBean().getHeaders().removeAll(((IStructuredSelection)RestCollapsableUI.this.headerViewer.getSelection()).toList());
                    RestCollapsableUI.this.headerViewer.refresh();
                    RestCollapsableUI.this.updateHeaderCount();
                }
            });
            this.headerViewer = new TableViewer(this.headersComposite, 68352);
            GridData gd = null;
            gd = new GridData(1808);
            this.headerViewer.getControl().setLayoutData((Object)gd);
            gd.minimumHeight = 50;
            this.headerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.headerViewer.getTable().setLinesVisible(true);
            this.headerViewer.getTable().setHeaderVisible(true);
            TableViewerColumn name = new TableViewerColumn(this.headerViewer, 16384);
            name.getColumn().setWidth(200);
            name.getColumn().setText(Messages.WSCommonControler_16);
            name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((String[])element)[0];
                }
            });
            name.setEditingSupport(new EditingSupport((ColumnViewer)this.headerViewer){

                protected void setValue(Object element, Object value) {
                    ((String[])element)[0] = (String)value;
                    RestCollapsableUI.this.headerViewer.refresh(element);
                }

                protected Object getValue(Object element) {
                    return ((String[])element)[0];
                }

                protected CellEditor getCellEditor(Object element) {
                    return new TextCellEditor((Composite)RestCollapsableUI.this.headerViewer.getTable());
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            TableViewerColumn value = new TableViewerColumn(this.headerViewer, 16384);
            value.getColumn().setWidth(200);
            value.getColumn().setText(Messages.WSCommonControler_17);
            value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((String[])element)[1];
                }
            });
            value.setEditingSupport(new EditingSupport((ColumnViewer)this.headerViewer){

                protected void setValue(Object element, Object value) {
                    ((String[])element)[1] = (String)value;
                    RestCollapsableUI.this.headerViewer.refresh(element);
                }

                protected Object getValue(Object element) {
                    return ((String[])element)[1];
                }

                protected CellEditor getCellEditor(Object element) {
                    return new TextCellEditor((Composite)RestCollapsableUI.this.headerViewer.getTable());
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
        }
        return this.headersComposite;
    }

    private Control getAuthComposite() {
        if (this.authComposite == null) {
            this.authComposite = new ScrolledComposite(this.content, 512);
            this.authComposite.setLayout((Layout)new GridLayout());
            this.authComposite.setLayoutData((Object)new GridData(4, 3, true, false));
            final Composite c = new Composite(this.authComposite, 0);
            c.setLayout((Layout)new GridLayout(4, false));
            c.setLayoutData((Object)new GridData(4, 1, true, false));
            Label l = new Label(c, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.WSCommonControler_18);
            this.authTYpe = new Combo(c, 8);
            this.authTYpe.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
            this.authTYpe.setItems(new String[]{"None", AUTH_BASIC, AUTH_OAUTH, AUTH_OAUTH2, AUTH_NTLM});
            this.authTYpe.select(0);
            l = new Label(c, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.WSCommonControler_19);
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.securityPickerViewer = new ComboViewer(c, 8);
            this.securityPickerViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.securityPickerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.securityPickerViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.WSDL)) {
                this.securityCreate = new Button(c, 8);
                this.securityCreate.setLayoutData((Object)new GridData(3, 1, false, false));
                this.securityCreate.setImage(addIcon);
                this.securityCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String securityNodeDefType = null;
                        switch (RestCollapsableUI.this.autMode) {
                            case BASIC: {
                                securityNodeDefType = "com.stambia.wsdl.basicauth";
                                break;
                            }
                            case NTLM: {
                                securityNodeDefType = "com.stambia.wsdl.ntlm";
                                break;
                            }
                            case OAUTH: {
                                securityNodeDefType = "com.stambia.wsdl.oauth";
                                break;
                            }
                            case OAUTH2: {
                                securityNodeDefType = "com.stambia.wsdl.oauth2";
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        MdNode node = MdFactoryHelper.createMdNode((String)securityNodeDefType);
                        node.setSubstituteContainer((EObject)RestCollapsableUI.this.controler.getSecurityParentNode());
                        String nm = "newAuthentication";
                        int i = 0;
                        boolean nameChecked = false;
                        while (!nameChecked) {
                            nameChecked = true;
                            for (MdNode c : RestCollapsableUI.this.controler.getSecurityParentNode().getNodeByCode(securityNodeDefType)) {
                                if (!nm.equals(c.getName())) continue;
                                nameChecked = false;
                                break;
                            }
                            if (nameChecked || ++i != 1) continue;
                            nm = String.valueOf(nm) + "_" + i;
                        }
                        node.setName(nm);
                        RestCollapsableUI.this.launchSecurityWizard(node);
                    }
                });
                this.editSecurity = new Button(c, 8);
                this.editSecurity.setLayoutData((Object)new GridData(3, 1, false, false));
                this.editSecurity.setImage(editIcon);
                this.editSecurity.setEnabled(false);
                this.editSecurity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MdNode node = ((MdNode)((IStructuredSelection)RestCollapsableUI.this.securityPickerViewer.getSelection()).getFirstElement()).copy(1);
                        node.setSubstituteContainer((EObject)RestCollapsableUI.this.controler.getSecurityParentNode());
                        RestCollapsableUI.this.launchSecurityWizard(node);
                    }
                });
            }
            this.securityPickerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty() || RestCollapsableUI.this.autMode == AuthMode.NONE) {
                        RestCollapsableUI.this.authBut.setText(Messages.WSCommonControler_25);
                        if (RestCollapsableUI.this.editSecurity != null) {
                            RestCollapsableUI.this.editSecurity.setEnabled(false);
                        }
                        RestCollapsableUI.this.controler.setAuthenticationMdNode(null);
                    } else {
                        RestCollapsableUI.this.authBut.setText(String.valueOf(Messages.WSCommonControler_26) + RestCollapsableUI.this.autMode.name() + ")");
                        if (RestCollapsableUI.this.editSecurity != null) {
                            RestCollapsableUI.this.editSecurity.setEnabled(true);
                        }
                        RestCollapsableUI.this.controler.setAuthenticationMdNode((MdNode)((IStructuredSelection)RestCollapsableUI.this.securityPickerViewer.getSelection()).getFirstElement());
                    }
                }
            });
            this.securityPickerViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof MdNode) {
                        if (RestCollapsableUI.this.autMode == AuthMode.OAUTH) {
                            return ((MdNode)element).getDefType().equals("com.stambia.wsdl.oauth") || ((MdNode)element).getDefType().equals("com.stambia.security.oauth");
                        }
                        if (RestCollapsableUI.this.autMode == AuthMode.OAUTH2) {
                            return ((MdNode)element).getDefType().equals("com.stambia.wsdl.oauth2") || ((MdNode)element).getDefType().equals("com.stambia.security.oauth2");
                        }
                        if (RestCollapsableUI.this.autMode == AuthMode.BASIC) {
                            return ((MdNode)element).getDefType().equals("com.stambia.wsdl.basicauth") || ((MdNode)element).getDefType().equals("com.stambia.security.basic");
                        }
                        if (RestCollapsableUI.this.autMode == AuthMode.NTLM) {
                            return ((MdNode)element).getDefType().equals("com.stambia.wsdl.ntlm") || ((MdNode)element).getDefType().equals("com.stambia.security.ntlm");
                        }
                        return false;
                    }
                    return true;
                }
            });
            l = new Label(c, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.WSCommonControler_31);
            this.securityProxyPickerViewer = new ComboViewer(c, 8);
            this.securityProxyPickerViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.securityProxyPickerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.securityProxyPickerViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.securityProxyPickerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty()) {
                        RestCollapsableUI.this.controler.setAuthenticationProxyMdNode(null);
                    } else if (event.getStructuredSelection().getFirstElement() == "None") {
                        RestCollapsableUI.this.controler.setAuthenticationProxyMdNode(null);
                    } else {
                        RestCollapsableUI.this.controler.setAuthenticationProxyMdNode((MdNode)((IStructuredSelection)RestCollapsableUI.this.securityProxyPickerViewer.getSelection()).getFirstElement());
                    }
                }
            });
            if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
                Composite storeComposite = new Composite(c, 0);
                storeComposite.setLayout((Layout)new GridLayout(2, false));
                ((GridLayout)storeComposite.getLayout()).marginWidth = 0;
                storeComposite.setLayoutData((Object)new GridData(4, 1, true, false, 4, 1));
                l = new Label(storeComposite, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.WSCommonControler_32);
                this.keystorePickerViewer = new ComboViewer(storeComposite, 8);
                this.keystorePickerViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
                this.keystorePickerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.keystorePickerViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
                this.keystorePickerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection().isEmpty()) {
                            RestCollapsableUI.this.controler.setKeyStoreNode(null);
                        } else if (event.getStructuredSelection().getFirstElement() == "None") {
                            RestCollapsableUI.this.controler.setKeyStoreNode(null);
                        } else {
                            RestCollapsableUI.this.controler.setKeyStoreNode((MdNode)((IStructuredSelection)RestCollapsableUI.this.keystorePickerViewer.getSelection()).getFirstElement());
                        }
                    }
                });
                l = new Label(storeComposite, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.WSCommonControler_33);
                this.truststorePickerViewer = new ComboViewer(storeComposite, 8);
                this.truststorePickerViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
                this.truststorePickerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.truststorePickerViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
                this.truststorePickerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection().isEmpty()) {
                            RestCollapsableUI.this.controler.setTrustStoreNode(null);
                        } else if (event.getStructuredSelection().getFirstElement() == "None") {
                            RestCollapsableUI.this.controler.setTrustStoreNode(null);
                        } else {
                            RestCollapsableUI.this.controler.setTrustStoreNode((MdNode)((IStructuredSelection)RestCollapsableUI.this.truststorePickerViewer.getSelection()).getFirstElement());
                        }
                    }
                });
            }
            this.authTYpe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int authenticationType = RestCollapsableUI.this.authTYpe.getSelectionIndex();
                    RestCollapsableUI.this.securityPickerViewer.getControl().setEnabled(authenticationType > 0);
                    RestCollapsableUI.this.autMode = AuthMode.values()[authenticationType];
                    if (RestCollapsableUI.this.autMode != AuthMode.NONE) {
                        RestCollapsableUI.this.authBut.setText(String.valueOf(Messages.WSCommonControler_1) + RestCollapsableUI.this.autMode.name() + ")");
                        if (RestCollapsableUI.this.securityCreate != null) {
                            RestCollapsableUI.this.securityCreate.setEnabled(true);
                        }
                    } else {
                        RestCollapsableUI.this.authBut.setText(Messages.WSCommonControler_34);
                        if (RestCollapsableUI.this.securityCreate != null) {
                            RestCollapsableUI.this.securityCreate.setEnabled(false);
                        }
                    }
                    RestCollapsableUI.this.securityPickerViewer.refresh();
                    RestCollapsableUI.this.authComposite.layout(true);
                    RestCollapsableUI.this.content.layout(true);
                    RestCollapsableUI.this.content.getParent().layout(true);
                    RestCollapsableUI.this.content.getParent().getParent().layout(true);
                    RestCollapsableUI.this.content.getParent().getParent().getParent().layout(true);
                }
            });
            this.securityPickerViewer.refresh();
            this.securityProxyPickerViewer.refresh();
            ((ScrolledComposite)this.authComposite).setContent((Control)c);
            ((ScrolledComposite)this.authComposite).setExpandVertical(true);
            ((ScrolledComposite)this.authComposite).setExpandHorizontal(true);
            ((ScrolledComposite)this.authComposite).addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = ((ScrolledComposite)RestCollapsableUI.this.authComposite).getClientArea();
                    ((ScrolledComposite)RestCollapsableUI.this.authComposite).setMinSize(c.computeSize(r.x, -1));
                }
            });
        }
        return this.authComposite;
    }

    private void launchSecurityWizard(MdNode securityNode) {
        String securityNodeDefType = securityNode.getDefType();
        Level lv = ((Tech)this.controler.getSecurityParentNode().getLevel().eContainer()).getLevel(securityNodeDefType);
        MdWizard wizard = null;
        if (lv != null) {
            try {
                wizard = MdWizard.retrieveWizard((Level)lv, (Util.ParameterWrapper[])new Util.ParameterWrapper[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (wizard != null) {
            wizard.setConfiguration(((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
            wizard.setNode(securityNode);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.setMinimumPageSize(690, 350);
            if (dialog.open() == 0) {
                ISelection s = this.securityPickerViewer.getSelection();
                this.securityPickerViewer.setInput(this.controler.refreshExistingAuthenticationMdNode());
                ArrayList<String> l = new ArrayList<String>();
                l.add(0, "None");
                this.securityProxyPickerViewer.setInput(this.controler.refreshExistingProxyMdNode());
                this.securityPickerViewer.setSelection(s);
                this.securityProxyPickerViewer.setSelection(this.securityProxyPickerViewer.getSelection());
            }
        } else {
            MessageDialog.openInformation((Shell)this.getAuthComposite().getShell(), (String)Messages.WSCommonControler_35, (String)Messages.WSCommonControler_36);
        }
    }

    private void setHeaders() {
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.WSDL)) {
            this.headerViewer.setInput(this.controler.getBean().getHeaders());
            this.updateHeaderCount();
        }
    }

    private void setSecurityNodes() {
        MdNode selected = this.controler.getAuthenticationMdNode();
        if (selected != null) {
            if (selected.getDefType().equals("com.stambia.wsdl.oauth") || selected.getDefType().equals("com.stambia.security.oauth")) {
                this.autMode = AuthMode.OAUTH;
            } else if (selected.getDefType().equals("com.stambia.wsdl.ntlm") || selected.getDefType().equals("com.stambia.security.ntlm")) {
                this.autMode = AuthMode.NTLM;
            } else if (selected.getDefType().equals("com.stambia.wsdl.oauth2") || selected.getDefType().equals("com.stambia.security.oauth2")) {
                this.autMode = AuthMode.OAUTH2;
            } else if (selected.getDefType().equals("com.stambia.wsdl.basicauth") || selected.getDefType().equals("com.stambia.security.basic")) {
                this.autMode = AuthMode.BASIC;
            }
            if (this.securityCreate != null) {
                this.securityCreate.setEnabled(true);
            }
        } else {
            this.autMode = AuthMode.NONE;
            if (this.securityCreate != null) {
                this.securityCreate.setEnabled(false);
            }
        }
        this.content.layout(true);
        this.content.getParent().layout();
        this.content.getParent().getParent().layout(true);
        this.securityPickerViewer.setInput(this.controler.refreshExistingAuthenticationMdNode());
        ArrayList<MdNode> l = new ArrayList<MdNode>(this.controler.refreshExistingProxyMdNode());
        l.add(0, (MdNode)"None");
        this.securityProxyPickerViewer.setInput(l);
        if (selected == null) {
            this.securityPickerViewer.setSelection((ISelection)new StructuredSelection());
            this.authBut.setText(Messages.WSCommonControler_42);
        } else {
            this.authTYpe.select(this.autMode.ordinal());
            this.securityPickerViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
            this.authBut.setText(String.valueOf(Messages.WSCommonControler_43) + this.autMode.name() + ")");
        }
        MdNode proxyNode = this.controler.getAuthenticationProxyMdNode();
        if (proxyNode != null) {
            this.securityProxyPickerViewer.setSelection((ISelection)new StructuredSelection((Object)proxyNode));
        } else {
            this.securityProxyPickerViewer.setSelection((ISelection)new StructuredSelection((Object)"None"));
        }
        if (this.controler.getReverseMode().equals((Object)RestWizard.RestReverseMode.HTTPREST)) {
            l = new ArrayList<MdNode>(this.controler.refreshExistingKeystoreAndTruststoreMdNode());
            l.add(0, (MdNode)"None");
            this.keystorePickerViewer.setInput(l);
            this.truststorePickerViewer.setInput(l);
            MdNode keystoreNode = this.controler.getKeyStoreMdNode();
            if (keystoreNode != null) {
                this.keystorePickerViewer.setSelection((ISelection)new StructuredSelection((Object)keystoreNode));
            } else {
                this.keystorePickerViewer.setSelection((ISelection)new StructuredSelection((Object)"None"));
            }
            MdNode trustStore = this.controler.getTrustStoreMdNode();
            if (trustStore != null) {
                this.truststorePickerViewer.setSelection((ISelection)new StructuredSelection((Object)trustStore));
            } else {
                this.truststorePickerViewer.setSelection((ISelection)new StructuredSelection((Object)"None"));
            }
        }
    }

    private void updateHeaderCount() {
        int count = 0;
        if (this.headerViewer != null && this.headerViewer.getInput() instanceof List) {
            count = ((List)this.headerViewer.getInput()).size();
        }
        this.headersBut.setText(String.valueOf(Messages.WSCommonControler_0) + count + ")");
    }

    public void fillData() {
        this.setHeaders();
        this.setSecurityNodes();
    }

    static enum AuthMode {
        NONE,
        BASIC,
        OAUTH,
        OAUTH2,
        NTLM;

    }

    public static class PannelListener
    extends SelectionAdapter {
        private ToolItem owner;
        private List<ToolItem> otherButtons = new ArrayList<ToolItem>();
        private Control controledComposite;
        private String label;
        private AtomicBoolean lockButtons;
        private Composite content;

        public PannelListener(ToolItem owner, Control controlledComposite, String label, AtomicBoolean lockButtons, Composite contentComposite) {
            this.owner = owner;
            this.controledComposite = controlledComposite;
            this.label = label;
            this.content = contentComposite;
            this.lockButtons = lockButtons;
        }

        public void addOtherButton(ToolItem it) {
            if (it != this.owner) {
                this.otherButtons.add(it);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.lockButtons.get()) {
                return;
            }
            if (this.owner.getSelection()) {
                this.lockButtons.set(true);
                for (ToolItem it : this.otherButtons) {
                    it.setSelection(false);
                }
                this.lockButtons.set(false);
                ((StackLayout)this.content.getLayout()).topControl = this.controledComposite;
                if (this.content instanceof Group) {
                    ((Group)this.content).setText(this.label);
                }
                this.content.setVisible(true);
                this.content.layout(true);
                this.content.getParent().layout(true);
                this.content.getParent().getParent().layout(true);
            } else {
                for (ToolItem it : this.otherButtons) {
                    if (!it.getSelection()) continue;
                    return;
                }
                ((StackLayout)this.content.getLayout()).topControl = null;
                this.content.setVisible(false);
                this.content.getParent().layout();
                this.content.getParent().getParent().layout(true);
            }
        }
    }

    public static class ShrinkedStackLayout
    extends StackLayout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int maxWidth = 0;
            int maxHeight = 0;
            if (this.topControl != null && this.topControl.isVisible()) {
                Point size = this.topControl.computeSize(wHint, hHint, flushCache);
                maxWidth = Math.max(size.x, maxWidth);
                maxHeight = Math.max(size.y, maxHeight);
            }
            int width = maxWidth + 2 * this.marginWidth;
            int height = maxHeight + 2 * this.marginHeight;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
    }
}

