/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.RestWizard;
import com.indy.addons.httprest.wizard.RestWizardControler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class RestWizardBean {
    private String fullURL;
    private List<String[]> headers = new ArrayList<String[]>();
    private String httpEndpoint = "";
    private String httpInputContentType = "";
    private String httpInputMediaType = "";
    private String httpOutputMediaType = "";
    private String httpMethod = "";
    private String httpResourcePath = "";
    private Boolean enableCertificateVerification = true;
    private Boolean enableHostnameVerification = true;
    private List<String> httpResourcePaths = new ArrayList<String>();
    private String inputData;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Map<String, String> outputMimeTypesByHttpResultCode;
    private RestWizard.RestReverseMode reverseMode;

    public RestWizardBean(RestWizard.RestReverseMode reverseMode) {
        this.reverseMode = reverseMode;
    }

    public void addParameter(String name, String value, RestWizardControler.BindingType type, Boolean send, Boolean allowEmptyValue) {
        this.parameters.add(new Parameter(name, value == null ? "" : value, type, send, allowEmptyValue));
    }

    public String getFullURL() {
        return this.fullURL;
    }

    public List<String[]> getHeaders() {
        return this.headers;
    }

    public String getHttpEndpoint() {
        return this.httpEndpoint;
    }

    public String getHttpInputContentType() {
        return this.httpInputContentType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpResourcePath() {
        return this.httpResourcePath;
    }

    public List<String> getHttpResourcePaths() {
        return this.httpResourcePaths;
    }

    public String getInputData() {
        return this.inputData;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setFullURL(String fullURL) {
        this.fullURL = fullURL;
    }

    public void setHttpEndpoint(String httpEndpoint) {
        this.httpEndpoint = httpEndpoint;
    }

    public String getHttpInputMediaType() {
        return this.httpInputMediaType;
    }

    public void setHttpInputMediaType(String httpInputMediaType) {
        this.httpInputMediaType = httpInputMediaType == null ? "" : httpInputMediaType;
    }

    public void setHttpInputContentType(String httpContentType) {
        this.httpInputContentType = httpContentType == null ? "" : httpContentType;
    }

    public void setHttpMethod(String httpMethod) {
        if (httpMethod == null) {
            httpMethod = "GET";
        } else {
            this.httpMethod = httpMethod;
        }
    }

    public void setHttpResourcePath(String httpResourcePath) {
        this.httpResourcePath = httpResourcePath != null ? httpResourcePath : "";
    }

    public void setHttpResourcePaths(List<String> httpResourcePaths) {
        this.httpResourcePaths = httpResourcePaths == null ? new ArrayList<String>() : httpResourcePaths;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    public boolean allowedInput(String httpMethod) {
        if ("GET".equals(httpMethod)) {
            if (this.reverseMode == RestWizard.RestReverseMode.HTTPREST) {
                return true;
            }
            for (Parameter p : this.getParameters()) {
                if (p.type != RestWizardControler.BindingType.MIME_CONTENT) continue;
                return true;
            }
        }
        return !"GET".equals(httpMethod) && !"HEAD".equals(httpMethod);
    }

    public String getHttpOutputMediaType() {
        return this.httpOutputMediaType;
    }

    public void setHttpOutputMediaType(String mediaType) {
        this.httpOutputMediaType = mediaType == null ? "" : mediaType;
    }

    public void setHttpOutputMediaTypePerResultCode(Map<String, String> outputMimeTypesByHttpResultCode) {
        this.outputMimeTypesByHttpResultCode = outputMimeTypesByHttpResultCode;
    }

    public Map<String, String> getHttpOutputMediaTypePerResultCode() {
        return this.outputMimeTypesByHttpResultCode;
    }

    public Boolean getEnableCertificateVerification() {
        return this.enableCertificateVerification;
    }

    public void setEnableCertificateVerification(Boolean enableCertificateVerification) {
        this.enableCertificateVerification = enableCertificateVerification;
    }

    public Boolean getEnableHostnameVerification() {
        return this.enableHostnameVerification;
    }

    public void setEnableHostnameVerification(Boolean enableHostnameVerification) {
        this.enableHostnameVerification = enableHostnameVerification;
    }

    public class Parameter {
        public String name = "";
        public RestWizardControler.BindingType type;
        public String value = "";
        public Boolean send;
        public Boolean allowEmptyValue;

        public Parameter(String name, String value, RestWizardControler.BindingType type, Boolean send, Boolean allowEmptyValue) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.send = send;
            this.allowEmptyValue = allowEmptyValue;
        }
    }

    public class SecurityBean {
        String securityType;
    }
}

