/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.jws;

import com.indy.addons.jws.JWSBean;
import com.indy.addons.jws.JWSTokenGenerator;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JWSLinker {
    JWSBean bean = new JWSBean();
    private MdNode node;
    private boolean refreshBean = false;
    private MdAttributeReader reader = new MdAttributeReader();

    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    public JWSBean getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    private void refreshBean() {
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : "";
        try {
            this.bean.payload = MdAttributeReader.readAttribute((String)"payload", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.secret = MdAttributeReader.readAttribute((String)"secret", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.valueOf(MdAttributeReader.readAttribute((String)"serializationMode", (MdNode)this.node, (String)""));
        }
        catch (Exception ex) {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.COMPACT;
        }
        try {
            this.bean.token = MdAttributeReader.readAttribute((String)"jwsToken", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.COMPACT;
        }
        for (MdNode c : this.node.getNode()) {
            if (!c.getDefType().equals("com.stambia.wsdl.jws.signature")) continue;
            JWSBean.JWSSignature s = new JWSBean.JWSSignature(c.getName());
            this.bean.signatures.add(s);
            try {
                s.protectedHeaders.putAll(MdAttributeReader.readAttributeMap((String)"protectedHeader", (MdNode)c));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.unprotectedHeaders.putAll(MdAttributeReader.readAttributeMap((String)"unprotectedHeader", (MdNode)c));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateMdNode() throws Exception {
        MdNode node = this.node.copy(0);
        node.setName(this.bean.name);
        node.setSubstituteContainer(this.node.getSubstituteContainer());
        this.setAttribute("payload", this.bean.payload, node);
        this.setAttribute("secret", this.bean.secret, node);
        this.setAttribute("jwsToken", this.bean.token, node);
        this.setAttribute("serializationMode", this.bean.serializationMode.getLabel(), node);
        for (JWSBean.JWSSignature s : this.bean.getSignatures()) {
            MdNode c = MdFactoryHelper.createMdNode((String)"com.stambia.wsdl.jws.signature");
            c.setName(s.getSignatureName());
            node.getNode().add((Object)c);
            this.setAttribute("protectedHeader", s.getProtectedHeaders(), c);
            this.setAttribute("unprotectedHeader", s.getUnprotectedHeaders(), c);
        }
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(node, this.node);
        ArrayList nonDeletableAttributes = new ArrayList();
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedObject, nonDeletableAttributes, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    private void setAttribute(String shortCode, Object value, MdNode n) {
        Property p = n.getLevel().getAttributeByShortCode(shortCode);
        Attribute a = MdFactoryHelper.createAttribute((String)(String.valueOf(n.getDefType()) + "." + shortCode));
        if (p.isUnbounded()) {
            boolean addedVal = false;
            if (p.isKeyValue()) {
                for (Object o : ((Map)value).keySet()) {
                    if (o == null) continue;
                    a.getValueEntry().put((Object)((String)o), (Object)((String)((Map)value).get(o)));
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            } else {
                for (Object o : (List)value) {
                    if (o == null) continue;
                    a.getValues().add((Object)o.toString());
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            }
        } else {
            String v = null;
            if (value instanceof String) {
                if (!((String)value).trim().isEmpty()) {
                    v = (String)value;
                }
            } else {
                String string = v = value == null ? "" : value.toString();
            }
            if (p.getType() == PropertyType.PASSWORD) {
                try {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    v = semaphoreManager.setSemaphore(true, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v != null) {
                a.setValue(v);
                n.getAttribute().add((Object)a);
            }
        }
    }
}

