/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.jws;

import com.indy.addons.httprest.Messages;
import com.indy.addons.jws.JWSBean;
import com.indy.addons.jws.JWSLinker;
import com.indy.addons.jws.JWSTokenGenerator;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class JWSPage
extends WizardPage {
    private Text name;
    private Text payload;
    private Text signatureOutput;
    private Text secret;
    private TableViewer signatureViewer;
    private TableViewer protectedHeaderViewer;
    private TableViewer unprotectedHeaderViewer;
    private Combo serializationMode;
    private JWSLinker linker;

    public JWSPage(String pageName, JWSLinker linker) {
        super(pageName);
        this.linker = linker;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(main, 0);
        l.setText(Messages.JWSPage_17);
        l.setLayoutData((Object)new GridData());
        this.name = new Text(main, 2048);
        this.name.setLayoutData((Object)new GridData(4, 1, true, false));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((JWSPage)JWSPage.this).linker.getBean().name = JWSPage.this.name.getText();
            }
        });
        l = new Label(main, 0);
        l.setText(Messages.JWSPage_18);
        l.setLayoutData((Object)new GridData());
        this.serializationMode = new Combo(main, 8);
        this.serializationMode.setLayoutData((Object)new GridData(4, 1, true, false));
        this.serializationMode.setItems(new String[]{JWSTokenGenerator.SerializationMode.COMPACT.name(), JWSTokenGenerator.SerializationMode.JSON.name()});
        l = new Label(main, 0);
        l.setText(Messages.JWSPage_19);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        this.payload = new Text(main, 2114);
        this.payload.setLayoutData((Object)new GridData(4, 4, true, false));
        this.payload.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((JWSPage)JWSPage.this).linker.getBean().payload = JWSPage.this.payload.getText();
            }
        });
        ((GridData)this.payload.getLayoutData()).heightHint = 75;
        l = new Label(main, 0);
        l.setText(Messages.JWSPage_20);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        this.secret = new Text(main, 4196930);
        this.secret.setLayoutData((Object)new GridData(4, 4, true, false));
        this.secret.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((JWSPage)JWSPage.this).linker.getBean().secret = JWSPage.this.secret.getText();
            }
        });
        ((GridData)this.secret.getLayoutData()).heightHint = 75;
        Group signatureComposite = new Group(main, 0);
        signatureComposite.setText(Messages.JWSPage_21);
        signatureComposite.setLayout((Layout)new GridLayout(2, true));
        signatureComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)signatureComposite.getLayoutData()).heightHint = 300;
        ToolBar tb = new ToolBar((Composite)signatureComposite, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ToolItem it = new ToolItem(tb, 8);
        it.setToolTipText(Messages.JWSPage_22);
        it.setImage(AbstractUnboundedControl.addIcon);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JWSPage.this.linker.getBean().getSerializationMode() == JWSTokenGenerator.SerializationMode.COMPACT && !JWSPage.this.linker.getBean().getSignatures().isEmpty()) {
                    MessageDialog.openInformation((Shell)JWSPage.this.getShell(), (String)Messages.JWSPage_23, (String)Messages.JWSPage_24);
                    return;
                }
                InputDialog d = new InputDialog(JWSPage.this.getWizard().getContainer().getShell(), Messages.JWSPage_25, Messages.JWSPage_26, Messages.JWSPage_27, new IInputValidator(){

                    public String isValid(String newText) {
                        for (JWSBean.JWSSignature s : ((JWSPage)(this).JWSPage.this).linker.getBean().signatures) {
                            if (!s.signatureName.equals(newText)) continue;
                            return Messages.JWSPage_28;
                        }
                        return null;
                    }
                });
                if (d.open() == 0) {
                    JWSBean.JWSSignature s = new JWSBean.JWSSignature(d.getValue());
                    s.protectedHeaders.put("alg", JWSTokenGenerator.Algorithm.HS256.name());
                    ((JWSPage)JWSPage.this).linker.getBean().signatures.add(s);
                    JWSPage.this.signatureViewer.refresh();
                    JWSPage.this.signatureViewer.setSelection((ISelection)new StructuredSelection((Object)((JWSPage)JWSPage.this).linker.getBean().signatures.get(((JWSPage)JWSPage.this).linker.getBean().signatures.size() - 1)));
                }
            }
        });
        it = new ToolItem(tb, 8);
        it.setToolTipText(Messages.JWSPage_30);
        it.setImage(AbstractUnboundedControl.delIcon);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((JWSPage)JWSPage.this).linker.getBean().signatures.removeAll(((IStructuredSelection)JWSPage.this.signatureViewer.getSelection()).toList());
                JWSPage.this.signatureViewer.refresh();
            }
        });
        this.signatureViewer = new TableViewer((Composite)signatureComposite, 68352);
        this.signatureViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.signatureViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((JWSBean.JWSSignature)element).getSignatureName();
            }
        });
        this.signatureViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite detailC = new Composite((Composite)signatureComposite, 0);
        detailC.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        detailC.setLayout((Layout)new GridLayout());
        Group g = new Group(detailC, 0);
        g.setText(Messages.JWSPage_31);
        g.setLayout((Layout)new GridLayout());
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        tb = new ToolBar((Composite)g, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        final ToolItem add = new ToolItem(tb, 8);
        add.setEnabled(false);
        add.setToolTipText(Messages.JWSPage_32);
        add.setImage(AbstractUnboundedControl.addIcon);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHeaderDialog d = new NewHeaderDialog(JWSPage.this.getWizard().getContainer().getShell(), Collections.EMPTY_LIST);
                if (d.open() == 0) {
                    String[] v = d.values;
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders.put(v[0], v[1]);
                    JWSPage.this.protectedHeaderViewer.refresh();
                }
            }
        });
        final ToolItem del = new ToolItem(tb, 8);
        del.setEnabled(false);
        del.setToolTipText(Messages.JWSPage_33);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JWSPage.this.protectedHeaderViewer.getSelection().isEmpty()) {
                    return;
                }
                for (Object o : ((IStructuredSelection)JWSPage.this.protectedHeaderViewer.getSelection()).toList()) {
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders.remove(o);
                }
                JWSPage.this.protectedHeaderViewer.refresh();
            }
        });
        this.protectedHeaderViewer = new TableViewer((Composite)g, 68352);
        this.protectedHeaderViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.protectedHeaderViewer.setSorter(new ViewerSorter());
        this.protectedHeaderViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.protectedHeaderViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HashMap<String, String> cur = new HashMap<String, String>(((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders);
                cur.remove(((IStructuredSelection)event.getSelection()).getFirstElement());
                NewHeaderDialog d = new NewHeaderDialog(JWSPage.this.getWizard().getContainer().getShell(), cur.keySet(), new String[]{(String)((IStructuredSelection)event.getSelection()).getFirstElement(), ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders.get(((IStructuredSelection)event.getSelection()).getFirstElement())});
                if (d.open() == 0) {
                    String[] v = d.values;
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders.put(v[0], v[1]);
                    JWSPage.this.protectedHeaderViewer.refresh();
                }
            }
        });
        TableViewerColumn col = new TableViewerColumn(this.protectedHeaderViewer, 0);
        col.getColumn().setText(Messages.JWSPage_34);
        col.getColumn().setWidth(150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        col = new TableViewerColumn(this.protectedHeaderViewer, 0);
        col.getColumn().setText(Messages.JWSPage_35);
        col.getColumn().setWidth(150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).protectedHeaders.get(element);
            }
        });
        final Group g2 = new Group(detailC, 0);
        g2.setText(Messages.JWSPage_36);
        g2.setLayout((Layout)new GridLayout());
        g2.setVisible(false);
        g2.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)g2.getLayoutData()).exclude = true;
        tb = new ToolBar((Composite)g2, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        final ToolItem add2 = new ToolItem(tb, 8);
        add2.setToolTipText(Messages.JWSPage_37);
        add2.setImage(AbstractUnboundedControl.addIcon);
        add2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHeaderDialog d = new NewHeaderDialog(JWSPage.this.getWizard().getContainer().getShell(), Collections.EMPTY_LIST);
                if (d.open() == 0) {
                    String[] v = d.values;
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).unprotectedHeaders.put(v[0], v[1]);
                    JWSPage.this.unprotectedHeaderViewer.refresh();
                }
            }
        });
        final ToolItem del2 = new ToolItem(tb, 8);
        del2.setToolTipText(Messages.JWSPage_38);
        del2.setImage(AbstractUnboundedControl.delIcon);
        del2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JWSPage.this.unprotectedHeaderViewer.getSelection().isEmpty()) {
                    return;
                }
                for (Object o : ((IStructuredSelection)JWSPage.this.unprotectedHeaderViewer.getSelection()).toList()) {
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).unprotectedHeaders.remove(o);
                }
                JWSPage.this.unprotectedHeaderViewer.refresh();
            }
        });
        this.signatureViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    del.setEnabled(false);
                    add.setEnabled(false);
                    del2.setEnabled(false);
                    add2.setEnabled(false);
                    JWSPage.this.unprotectedHeaderViewer.setInput((Object)Collections.EMPTY_LIST);
                    JWSPage.this.protectedHeaderViewer.setInput((Object)Collections.EMPTY_LIST);
                } else {
                    del.setEnabled(true);
                    add.setEnabled(true);
                    del2.setEnabled(true);
                    add2.setEnabled(true);
                    JWSPage.this.protectedHeaderViewer.setInput(((JWSBean.JWSSignature)((IStructuredSelection)event.getSelection()).getFirstElement()).getProtectedHeaders().keySet());
                    JWSPage.this.unprotectedHeaderViewer.setInput(((JWSBean.JWSSignature)((IStructuredSelection)event.getSelection()).getFirstElement()).getUnprotectedHeaders().keySet());
                }
            }
        });
        this.unprotectedHeaderViewer = new TableViewer((Composite)g2, 68352);
        this.unprotectedHeaderViewer.getTable().setHeaderVisible(true);
        this.unprotectedHeaderViewer.getTable().setLinesVisible(true);
        this.unprotectedHeaderViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.unprotectedHeaderViewer.setSorter(new ViewerSorter());
        this.unprotectedHeaderViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.unprotectedHeaderViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HashMap<String, String> cur = new HashMap<String, String>(((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).unprotectedHeaders);
                cur.remove(((IStructuredSelection)event.getSelection()).getFirstElement());
                NewHeaderDialog d = new NewHeaderDialog(JWSPage.this.getWizard().getContainer().getShell(), cur.keySet());
                if (d.open() == 0) {
                    String[] v = d.values;
                    ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).unprotectedHeaders.put(v[0], v[1]);
                    JWSPage.this.unprotectedHeaderViewer.refresh();
                }
            }
        });
        col = new TableViewerColumn(this.unprotectedHeaderViewer, 0);
        col.getColumn().setText(Messages.JWSPage_39);
        col.getColumn().setWidth(150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        col = new TableViewerColumn(this.unprotectedHeaderViewer, 0);
        col.getColumn().setText(Messages.JWSPage_40);
        col.getColumn().setWidth(150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((JWSBean.JWSSignature)((IStructuredSelection)((JWSPage)JWSPage.this).signatureViewer.getSelection()).getFirstElement()).unprotectedHeaders.get(element);
            }
        });
        Group output = new Group(main, 0);
        output.setText(Messages.JWSPage_41);
        output.setLayout((Layout)new GridLayout(2, false));
        output.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Button b = new Button((Composite)output, 8);
        b.setText(Messages.JWSPage_42);
        b.setLayoutData((Object)new GridData());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWSTokenGenerator gen = new JWSTokenGenerator();
                try {
                    String token = null;
                    switch (JWSPage.this.linker.getBean().getSerializationMode()) {
                        case COMPACT: {
                            token = gen.generateCompactToken(JWSPage.this.linker.getBean().getPayload(), ((JWSPage)JWSPage.this).linker.getBean().getSignatures().get((int)0).protectedHeaders, JWSPage.this.linker.getBean().getSecret());
                            break;
                        }
                        case JSON: {
                            throw new Exception(Messages.JWSPage_43);
                        }
                    }
                    JWSPage.this.signatureOutput.setText(token);
                    ((JWSPage)JWSPage.this).linker.getBean().token = token;
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)JWSPage.this.getShell(), (String)Messages.JWSPage_44, (String)(String.valueOf(Messages.JWSPage_45) + ex.getMessage()));
                }
            }
        });
        l = new Label((Composite)output, 0);
        l.setLayoutData((Object)new GridData());
        this.signatureOutput = new Text((Composite)output, 2626);
        this.signatureOutput.setLayoutData((Object)new GridData(4, 4, true, true));
        this.signatureOutput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((JWSPage)JWSPage.this).linker.getBean().token = JWSPage.this.signatureOutput.getText();
            }
        });
        ((GridData)this.signatureOutput.getLayoutData()).heightHint = 100;
        this.setControl((Control)main);
        this.fillData();
        this.serializationMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWSPage.this.linker.getBean().setSerializationMode(JWSTokenGenerator.SerializationMode.values()[JWSPage.this.serializationMode.getSelectionIndex()]);
                if (JWSPage.this.linker.getBean().getSerializationMode() == JWSTokenGenerator.SerializationMode.COMPACT) {
                    g2.setVisible(false);
                    ((GridData)g2.getLayoutData()).exclude = true;
                    g2.getParent().layout(true);
                } else {
                    g2.setVisible(true);
                    ((GridData)g2.getLayoutData()).exclude = false;
                    g2.getParent().layout(true);
                }
            }
        });
    }

    private void fillData() {
        this.name.setText(this.linker.getBean().name);
        this.serializationMode.select(this.linker.getBean().serializationMode.ordinal());
        this.payload.setText(this.linker.getBean().getPayload());
        this.signatureViewer.setInput(this.linker.getBean().getSignatures());
        this.secret.setText(this.linker.getBean().secret);
        this.signatureOutput.setText(this.linker.getBean().token);
    }

    class NewHeaderDialog
    extends Dialog {
        Combo label;
        Combo value;
        String[] values;
        Collection<String> existingHeaders;

        protected NewHeaderDialog(Shell parentShell, Collection<String> existingHeaders) {
            super(parentShell);
            this.values = null;
            this.existingHeaders = existingHeaders;
            JWSPage.this.setTitle(Messages.JWSPage_0);
        }

        protected NewHeaderDialog(Shell parentShell, Collection<String> existingHeaders, String[] values) {
            this(parentShell, existingHeaders);
            this.values = values;
        }

        protected void okPressed() {
            this.values = new String[]{this.label.getText(), this.value.getText()};
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayoutData((Object)new GridData(4, 4, true, false));
            main.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(main, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.JWSPage_1);
            this.label = new Combo(main, 2048);
            this.label.setLayoutData((Object)new GridData(4, 1, true, false));
            this.label.setItems(new String[]{"alg", "jku", "jwk", "kid", "x5u", "x5c", "x5t", "x5t#S256", "typ", "cty", "crit"});
            this.label.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NewHeaderDialog.this.label.getText().equals("alg")) {
                        NewHeaderDialog.this.value.setItems(JWSTokenGenerator.Algorithm.stringValues());
                    } else {
                        NewHeaderDialog.this.value.setItems(new String[0]);
                    }
                }
            });
            l = new Label(main, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.JWSPage_14);
            this.value = new Combo(main, 2048);
            this.value.setLayoutData((Object)new GridData(4, 1, true, false));
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewHeaderDialog.this.updateButtons();
                }
            };
            if (this.values != null) {
                this.label.setText(this.values[0]);
                this.label.notifyListeners(13, new Event());
                this.value.setText(this.values[1]);
            }
            this.label.addModifyListener(listener);
            this.value.addModifyListener(listener);
            return main;
        }

        private void updateButtons() {
            String header = this.label.getText();
            String value = this.value.getText();
            if (header == null || this.existingHeaders.contains(header) || header.isEmpty()) {
                this.getButton(0).setEnabled(false);
                JWSPage.this.setErrorMessage(Messages.JWSPage_15);
            } else if (value == null || value.isEmpty()) {
                this.getButton(0).setEnabled(false);
                JWSPage.this.setErrorMessage(Messages.JWSPage_16);
            } else {
                JWSPage.this.setErrorMessage(null);
                this.getButton(0).setEnabled(true);
            }
        }
    }
}

