/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.ntlm.wizard;

import com.indy.addons.ntlm.wizard.Controler;
import com.indy.addons.ntlm.wizard.INTLMControler;
import com.indy.addons.ntlm.wizard.Messages;
import com.indy.md.ui.editor.ui.MdWizard;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class NTLMWizard
extends MdWizard {
    private INTLMControler controler;
    Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();
    MainPage mainPage;

    public void addPages() {
        this.mainPage = new MainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public void setNode(MdNode node) {
        super.setNode(node);
        this.controler = Controler.createControler(node.getDefType(), node, (MdNode)node.getSubstituteContainer());
    }

    public boolean performFinish() {
        try {
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            MdNode newNode = this.controler.createNewMdNode();
            newNode.setId(this.getNode().getId());
            reversedMap.put(newNode, this.getNode());
            HashMap<String, 1> reverseModes = new HashMap<String, 1>();
            IncrementalReverser.IReverseMatchingStrategy modeById = new IncrementalReverser.IReverseMatchingStrategy(){

                public IncrementalReverser.NodeMatcher getMatcher() {
                    return new IncrementalReverser.NodeMatcher(){

                        public boolean match(MdNode n1, MdNode n2) {
                            return n1.getId().equals(n2.getId());
                        }
                    };
                }
            };
            reverseModes.put(this.controler.getNTLMDefType(), modeById);
            IncrementalReverser reverser = new IncrementalReverser(this.getNode().getSubstituteContainer(), reversedMap, Collections.EMPTY_LIST, true, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, true);
            reverser.reverse();
        }
        catch (Exception ex) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.httprest", Messages.NTLMWizard_6, (Throwable)ex), 1);
            return false;
        }
        return true;
    }

    class MainPage
    extends WizardPage {
        private Text name;
        private Text domain;
        private Text user;
        private Text password;

        protected MainPage() {
            super(Messages.NTLMWizard_0);
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            Label l = new Label(main, 0);
            l.setText(Messages.NTLMWizard_1);
            l.setLayoutData((Object)new GridData());
            this.name = new Text(main, 2048);
            this.name.setLayoutData((Object)new GridData(4, 1, true, false));
            this.name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NTLMWizard.this.controler.getBean().setName(MainPage.this.name.getText());
                }
            });
            l = new Label(main, 0);
            l.setText(Messages.NTLMWizard_2);
            l.setLayoutData((Object)new GridData());
            this.user = new Text(main, 2048);
            this.user.setLayoutData((Object)new GridData(4, 1, true, false));
            this.user.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NTLMWizard.this.controler.getBean().setUserName(MainPage.this.user.getText());
                }
            });
            l = new Label(main, 0);
            l.setText(Messages.NTLMWizard_3);
            l.setLayoutData((Object)new GridData());
            this.password = new Text(main, 0x400800);
            this.password.setLayoutData((Object)new GridData(4, 1, true, false));
            this.password.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NTLMWizard.this.controler.getBean().setPassword(MainPage.this.password.getText());
                }
            });
            l = new Label(main, 0);
            l.setText(Messages.NTLMWizard_4);
            l.setLayoutData((Object)new GridData());
            this.domain = new Text(main, 2048);
            this.domain.setLayoutData((Object)new GridData(4, 1, true, false));
            this.domain.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NTLMWizard.this.controler.getBean().setDomain(MainPage.this.domain.getText());
                }
            });
            this.setControl((Control)main);
            this.fillData();
        }

        private void fillData() {
            this.name.setText(NTLMWizard.this.controler.getBean().getName());
            this.domain.setText(NTLMWizard.this.controler.getBean().getDomain());
            this.user.setText(NTLMWizard.this.controler.getBean().getUserName());
            this.password.setText(NTLMWizard.this.controler.getBean().getPassword());
        }
    }
}

