/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth1.wizard;

import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth1.wizard.BeanMdLinker;
import com.indy.addons.oauth1.wizard.Oauth1Bean;
import com.indy.addons.oauth1.wizard.ParameterControl;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.provider.wizard.IBeanLinker;
import com.stambia.tech.provider.wizard.IMdWizardPage;
import com.stambia.tech.provider.wizard.WizardDescriptor;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.statushandlers.StatusManager;

public class OAuth1Page
extends WizardPage
implements IWizardPage,
IMdWizardPage {
    public static final String[] SIGNATURE_METHOD = new String[]{"HMAC-SHA1", "PLAINTEXT"};
    public static final String[] HTTP_METHOD = new String[]{"GET", "POST", "PUT", "HEAD", "UPDATE", "DELETE"};
    public static final String TEMPLATE_WIZARD_PRECONF_OPTION = "oauth1.preconf";
    public static Image twittericon = null;
    public static Image noicon = null;
    public static Image preseticon = null;
    private Preconf[] preconfTpl;
    static final String[] PRECONF;
    private Text consumerKey;
    private Text consumerSecret;
    private Text requestUrl;
    private Text authorizationUrl;
    private Text accessUrl;
    private Text tokenVerifier;
    private Text token;
    private Text tokenSecret;
    private Text callbackUrl;
    private Combo signatureMehod;
    private Combo requestHttpMethod;
    private Combo accessHttpMethod;
    private ParameterControl requestParamControl;
    private ParameterControl authorizationParamControl;
    private Button tkVerif;
    private Button callbackBt;
    private Button advanced;
    private Button getToken;
    private CTabFolder advancedControl;
    private BeanMdLinker linker;
    private Preconf mdPreconf;

    static {
        try {
            twittericon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.addons/icons/twitter_16x16.png")).createImage();
            noicon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.addons/icons/reset_16x16.png")).createImage();
            preseticon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.addons/icons/preset_16x16.png")).createImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PRECONF = new String[]{Messages.OAuth1Page_22, Messages.OAuth1Page_23};
    }

    public OAuth1Page(MdNode node, WizardDescriptor.WizardPageDescriptor preconf) {
        this(new BeanMdLinker());
        MdNode dummy = preconf.getInitializationNode(node);
        if (dummy == null) {
            dummy = MdFactoryHelper.createMdNode((String)preconf.getResultDefType());
        }
        dummy.setSubstituteContainer((EObject)node);
        this.linker.setNode(dummy);
        String value = (String)preconf.getOptions().get(TEMPLATE_WIZARD_PRECONF_OPTION);
        if (value != null) {
            Preconf[] preconfArray = this.preconfTpl;
            int n = this.preconfTpl.length;
            int n2 = 0;
            while (n2 < n) {
                Preconf p = preconfArray[n2];
                if (p != null && p.name.equalsIgnoreCase(value)) {
                    Oauth1Bean bean = this.getBean();
                    bean.accessTokenBean.url = p.accessUrl;
                    bean.authorizationBean.url = p.authorizationUrl;
                    bean.authorizationBean.callBackURL = p.callbackUrl;
                    bean.requestTokenBean.url = p.requestUrl;
                    bean.requestTokenBean.httpMethod = HTTP_METHOD[p.requestHttp];
                    bean.signatureMethod = SIGNATURE_METHOD[p.signature];
                    bean.accessTokenBean.httpMethod = HTTP_METHOD[p.requestHttp];
                    break;
                }
                ++n2;
            }
        }
    }

    protected OAuth1Page(BeanMdLinker linker) {
        super(Messages.OAuth1Page_24);
        Preconf[] preconfArray = new Preconf[2];
        preconfArray[1] = new Preconf("Twitter", twittericon, "https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/access_token", "", "https://api.twitter.com/oauth/authorize", 0, 1, 1);
        this.preconfTpl = preconfArray;
        this.linker = linker;
        this.setTitle(Messages.OAuth1Page_25);
        this.setDescription(Messages.OAuth1Page_26);
    }

    private Oauth1Bean getBean() {
        return (Oauth1Bean)this.linker.getBean();
    }

    private void fillData() {
        this.accessUrl.setText(this.getBean().accessTokenBean.url == null ? "" : this.getBean().accessTokenBean.url);
        this.authorizationUrl.setText(this.getBean().authorizationBean.url == null ? "" : this.getBean().authorizationBean.url);
        this.authorizationParamControl.setInput(this.getBean().authorizationBean.additionalParams);
        this.consumerKey.setText(this.getBean().consumerKey == null ? "" : this.getBean().consumerKey);
        this.consumerSecret.setText(this.getBean().consumerSecret == null ? "" : this.getBean().consumerSecret);
        this.requestUrl.setText(this.getBean().requestTokenBean.url == null ? "" : this.getBean().requestTokenBean.url);
        this.requestParamControl.setInput(this.getBean().requestTokenBean.additionalParams);
        this.callbackUrl.setText(this.getBean().authorizationBean.callBackURL == null ? "" : this.getBean().authorizationBean.callBackURL);
        int signatureIndex = 0;
        int i = 0;
        while (i < this.signatureMehod.getItemCount()) {
            if (this.signatureMehod.getItem(i).equals(this.getBean().signatureMethod)) {
                signatureIndex = i;
                break;
            }
            ++i;
        }
        this.signatureMehod.select(signatureIndex);
        int accessIndex = 1;
        int i2 = 0;
        while (i2 < this.accessHttpMethod.getItemCount()) {
            if (this.accessHttpMethod.getItem(i2).equals(this.getBean().accessTokenBean.httpMethod)) {
                accessIndex = i2;
                break;
            }
            ++i2;
        }
        this.accessHttpMethod.select(accessIndex);
        int requestIndex = 1;
        int i3 = 0;
        while (i3 < this.requestHttpMethod.getItemCount()) {
            if (this.requestHttpMethod.getItem(i3).equals(this.getBean().requestTokenBean.httpMethod)) {
                requestIndex = i3;
                break;
            }
            ++i3;
        }
        this.requestHttpMethod.select(requestIndex);
        this.requestHttpMethod.notifyListeners(13, new Event());
        this.signatureMehod.notifyListeners(13, new Event());
        this.accessHttpMethod.notifyListeners(13, new Event());
        this.preconfTpl[0] = this.mdPreconf = new Preconf(Messages.OAuth1Page_0, noicon, this.requestUrl.getText(), this.accessUrl.getText(), this.callbackUrl.getText(), this.authorizationUrl.getText(), this.signatureMehod.getSelectionIndex(), this.requestHttpMethod.getSelectionIndex(), this.accessHttpMethod.getSelectionIndex());
        if (this.linker.token != null) {
            this.token.setText(this.linker.token);
        }
        if (this.linker.tokenSecret != null) {
            this.tokenSecret.setText(this.linker.tokenSecret);
        }
    }

    private void selectPreconf(Preconf preconf) {
        this.requestUrl.setText(preconf.requestUrl);
        this.requestHttpMethod.select(preconf.requestHttp);
        this.authorizationUrl.setText(preconf.authorizationUrl);
        this.accessUrl.setText(preconf.accessUrl);
        this.accessHttpMethod.select(preconf.accessHttp);
        this.callbackUrl.setText(preconf.callbackUrl);
        this.signatureMehod.select(preconf.signature);
        this.requestHttpMethod.notifyListeners(13, new Event());
        this.signatureMehod.notifyListeners(13, new Event());
        this.accessHttpMethod.notifyListeners(13, new Event());
        this.getWizard().getContainer().updateButtons();
    }

    private void hookListeners() {
        this.requestUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().requestTokenBean.url = OAuth1Page.this.requestUrl.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.requestHttpMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().requestTokenBean.httpMethod = OAuth1Page.this.requestHttpMethod.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.accessUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean.url = OAuth1Page.this.accessUrl.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.accessHttpMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean.httpMethod = OAuth1Page.this.accessHttpMethod.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.authorizationUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().authorizationBean.url = OAuth1Page.this.authorizationUrl.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.consumerKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().consumerKey = OAuth1Page.this.consumerKey.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.consumerSecret.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().consumerSecret = OAuth1Page.this.consumerSecret.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.signatureMehod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((OAuth1Page)OAuth1Page.this).getBean().signatureMethod = OAuth1Page.this.signatureMehod.getText();
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.callbackUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String s = OAuth1Page.this.callbackUrl.getText();
                ((OAuth1Page)OAuth1Page.this).getBean().authorizationBean.callBackURL = s.trim().isEmpty() ? null : s;
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.tokenVerifier.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean != null) {
                    ((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean.oauth_verifier = OAuth1Page.this.tokenVerifier.getText();
                }
                OAuth1Page.this.getWizard().getContainer().updateButtons();
            }
        });
        this.token.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OAuth1Page.this.token.isEnabled()) {
                    if (((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse != null) {
                        ((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse.oauthToken = OAuth1Page.this.token.getText();
                    }
                    OAuth1Page.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.tokenSecret.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OAuth1Page.this.tokenSecret.isEnabled()) {
                    if (((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse != null) {
                        ((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse.oauthTokenSecret = OAuth1Page.this.tokenSecret.getText();
                    }
                    OAuth1Page.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.getToken.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    try {
                        ((OAuth1Page)OAuth1Page.this).linker.oauth1Controller.getRequestToken();
                    }
                    catch (Throwable ex) {
                        OAuth1Page.this.token.setText("");
                        OAuth1Page.this.tokenSecret.setText("");
                        OAuth1Page.this.tokenVerifier.setText("");
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.OAuth1Page_37, ex), 3);
                        OAuth1Page.this.getWizard().getContainer().updateButtons();
                        return;
                    }
                    BrowserDialog d = new BrowserDialog();
                    try {
                        d.open(((OAuth1Page)OAuth1Page.this).linker.oauth1Controller.getAuthorizationURL().toString());
                    }
                    catch (Exception e1) {
                        OAuth1Page.this.token.setText("");
                        OAuth1Page.this.tokenSecret.setText("");
                        OAuth1Page.this.tokenVerifier.setText("");
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.OAuth1Page_41, (Throwable)e1), 3);
                        OAuth1Page.this.getWizard().getContainer().updateButtons();
                        return;
                    }
                    if (((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean.oauth_verifier == null || ((OAuth1Page)OAuth1Page.this).getBean().accessTokenBean.oauth_verifier.isEmpty()) {
                        MessageDialog.openInformation((Shell)OAuth1Page.this.getShell(), (String)Messages.OAuth1Page_42, (String)Messages.OAuth1Page_43);
                        return;
                    }
                    try {
                        ((OAuth1Page)OAuth1Page.this).linker.oauth1Controller.getAccessToken();
                        OAuth1Page.this.token.setText(((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse.oauthToken);
                        OAuth1Page.this.tokenSecret.setText(((OAuth1Page)OAuth1Page.this).getBean().accessTokenResponse.oauthTokenSecret);
                    }
                    catch (Throwable ex) {
                        OAuth1Page.this.token.setText("");
                        OAuth1Page.this.tokenSecret.setText("");
                        OAuth1Page.this.tokenVerifier.setText("");
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.OAuth1Page_47, ex), 3);
                        OAuth1Page.this.getWizard().getContainer().updateButtons();
                        return;
                    }
                }
                finally {
                    OAuth1Page.this.getWizard().getContainer().updateButtons();
                }
            }
        });
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
        Composite main = new Composite((Composite)scrolled, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout());
        this.createCredentialsGroup(main);
        this.createTokenGenerationGroup(main);
        this.createTokenGroup(main);
        ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)main);
        this.setControl((Control)scrolled);
        this.hookListeners();
        this.fillData();
    }

    private void createTokenGroup(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.OAuth1Page_48);
        main.setLayoutData((Object)new GridData(4, 1, true, false));
        main.setLayout((Layout)new GridLayout(2, false));
        this.getToken = new Button((Composite)main, 8);
        this.getToken.setText(Messages.OAuth1Page_49);
        this.getToken.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        Label l = new Label((Composite)main, 0);
        l.setText(Messages.OAuth1Page_50);
        this.token = new Text((Composite)main, 2048);
        this.token.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label((Composite)main, 0);
        l.setText(Messages.OAuth1Page_51);
        this.tokenSecret = new Text((Composite)main, 0x400800);
        this.tokenSecret.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createTokenGenerationGroup(Composite parent) {
        Group g = new Group(parent, 0);
        g.setText(Messages.OAuth1Page_52);
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        g.setLayout((Layout)new GridLayout(2, true));
        Composite cc = new Composite((Composite)g, 0);
        cc.setLayout((Layout)new GridLayout(2, false));
        cc.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ((GridLayout)cc.getLayout()).marginHeight = 0;
        ((GridLayout)cc.getLayout()).marginWidth = 0;
        Label l = new Label(cc, 0);
        l.setText(Messages.OAuth1Page_53);
        Button preConfBt = new Button(cc, 8);
        preConfBt.setImage(preseticon);
        preConfBt.setToolTipText(Messages.OAuth1Page_54);
        preConfBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] res;
                ListDialog ld = new ListDialog(OAuth1Page.this.getShell());
                ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ld.setInput((Object)OAuth1Page.this.preconfTpl);
                ld.setTitle(Messages.OAuth1Page_55);
                ld.setMessage(Messages.OAuth1Page_56);
                ld.setAddCancelButton(false);
                ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((Preconf)element).getName();
                    }

                    public Image getImage(Object element) {
                        return ((Preconf)element).getIcon();
                    }
                });
                if (ld.open() == 0 && (res = ld.getResult()) != null && res.length > 0) {
                    OAuth1Page.this.selectPreconf((Preconf)ld.getResult()[0]);
                }
            }
        });
        final Composite main = new Composite((Composite)g, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_57);
        this.signatureMehod = new Combo(main, 2056);
        this.signatureMehod.setLayoutData((Object)new GridData(4, 1, true, false));
        this.signatureMehod.setItems(SIGNATURE_METHOD);
        l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_58);
        this.requestUrl = new Text(main, 2048);
        this.requestUrl.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_59);
        this.authorizationUrl = new Text(main, 2048);
        this.authorizationUrl.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_60);
        this.accessUrl = new Text(main, 2048);
        this.accessUrl.setLayoutData((Object)new GridData(4, 1, true, false));
        this.callbackBt = new Button(main, 32);
        this.callbackBt.setText(Messages.OAuth1Page_61);
        this.callbackBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OAuth1Page.this.callbackUrl.setEnabled(OAuth1Page.this.callbackBt.getSelection());
                OAuth1Page.this.getContainer().updateButtons();
            }
        });
        this.callbackUrl = new Text(main, 2048);
        this.callbackUrl.setLayoutData((Object)new GridData(4, 1, true, false));
        this.callbackUrl.setEnabled(false);
        this.tkVerif = new Button(main, 32);
        this.tkVerif.setText(Messages.OAuth1Page_62);
        this.tkVerif.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OAuth1Page.this.tokenVerifier.setEnabled(OAuth1Page.this.tkVerif.getSelection());
            }
        });
        this.tokenVerifier = new Text(main, 2048);
        this.tokenVerifier.setLayoutData((Object)new GridData(4, 1, true, false));
        this.tokenVerifier.setEnabled(false);
        this.advanced = new Button(main, 32);
        this.advanced.setText(Messages.OAuth1Page_63);
        this.advanced.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OAuth1Page.this.advanced.getSelection()) {
                    main.setLayoutData((Object)new GridData(4, 4, true, true));
                    OAuth1Page.this.advancedControl.getParent().setVisible(true);
                } else {
                    main.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                    OAuth1Page.this.advancedControl.getParent().setVisible(false);
                }
                ((Composite)OAuth1Page.this.getControl()).layout(true, true);
            }
        });
        Group advanced = new Group((Composite)g, 0);
        advanced.setText(Messages.OAuth1Page_64);
        advanced.setVisible(false);
        advanced.setLayout((Layout)new GridLayout());
        ((GridLayout)advanced.getLayout()).marginHeight = 0;
        ((GridLayout)advanced.getLayout()).marginWidth = 0;
        advanced.setLayoutData((Object)new GridData(4, 4, true, true));
        this.advancedControl = new CTabFolder((Composite)advanced, 0x800400);
        this.advancedControl.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem f = new CTabItem(this.advancedControl, 0);
        f.setText(Messages.OAuth1Page_65);
        this.advancedControl.setSelection(0);
        f.setControl(this.createAdvancedRequest((Composite)this.advancedControl));
        f = new CTabItem(this.advancedControl, 0);
        f.setText(Messages.OAuth1Page_66);
        f.setControl(this.createAdvancedAuthorization((Composite)this.advancedControl));
        f = new CTabItem(this.advancedControl, 0);
        f.setText(Messages.OAuth1Page_67);
        f.setControl(this.createAccessRequest((Composite)this.advancedControl));
    }

    private Control createAdvancedAuthorization(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        ((GridLayout)main.getLayout()).marginHeight = 0;
        ((GridLayout)main.getLayout()).marginWidth = 0;
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.authorizationParamControl = new ParameterControl();
        this.authorizationParamControl.createControl(main).setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        return main;
    }

    private Control createAccessRequest(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)main.getLayout()).marginHeight = 0;
        ((GridLayout)main.getLayout()).marginWidth = 0;
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_68);
        this.accessHttpMethod = new Combo(main, 2048);
        this.accessHttpMethod.setLayoutData((Object)new GridData(4, 1, true, false));
        this.accessHttpMethod.setItems(HTTP_METHOD);
        return main;
    }

    private Control createAdvancedRequest(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)main.getLayout()).marginHeight = 0;
        ((GridLayout)main.getLayout()).marginWidth = 0;
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(main, 0);
        l.setText(Messages.OAuth1Page_69);
        this.requestHttpMethod = new Combo(main, 2048);
        this.requestHttpMethod.setLayoutData((Object)new GridData(4, 1, true, false));
        this.requestHttpMethod.setItems(HTTP_METHOD);
        this.requestParamControl = new ParameterControl();
        this.requestParamControl.createControl(main).setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        return main;
    }

    private void createCredentialsGroup(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.OAuth1Page_70);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(4, 1, true, false));
        Label l = new Label((Composite)main, 0);
        l.setText(Messages.OAuth1Page_71);
        this.consumerKey = new Text((Composite)main, 2048);
        this.consumerKey.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label((Composite)main, 0);
        l.setText(Messages.OAuth1Page_72);
        this.consumerSecret = new Text((Composite)main, 0x400800);
        this.consumerSecret.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    public boolean isPageComplete() {
        return this.check();
    }

    private String computeErrorMessage() {
        if (this.getBean().consumerSecret == null || this.getBean().consumerSecret.isEmpty()) {
            return Messages.OAuth1Page_73;
        }
        if (this.getBean().consumerKey == null || this.getBean().consumerKey.isEmpty()) {
            return Messages.OAuth1Page_74;
        }
        if (this.getBean().signatureMethod == null || this.getBean().signatureMethod.isEmpty()) {
            return Messages.OAuth1Page_75;
        }
        boolean found = false;
        String[] stringArray = SIGNATURE_METHOD;
        int n = SIGNATURE_METHOD.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (this.getBean().signatureMethod.equals(s)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            return Messages.OAuth1Page_76;
        }
        if (this.getBean().requestTokenBean.url == null || this.getBean().requestTokenBean.url.isEmpty()) {
            return Messages.OAuth1Page_77;
        }
        if (this.getBean().requestTokenBean.httpMethod == null || this.getBean().requestTokenBean.httpMethod.isEmpty()) {
            return Messages.OAuth1Page_78;
        }
        try {
            new URL(this.getBean().requestTokenBean.url);
        }
        catch (Exception ex) {
            return Messages.OAuth1Page_79;
        }
        if (this.callbackUrl.isEnabled()) {
            try {
                new URL(this.getBean().authorizationBean.callBackURL);
            }
            catch (Exception ex) {
                return Messages.OAuth1Page_80;
            }
        }
        if (this.getBean().authorizationBean.url == null || this.getBean().authorizationBean.url.isEmpty()) {
            return Messages.OAuth1Page_81;
        }
        try {
            new URL(this.getBean().authorizationBean.url);
        }
        catch (Exception ex) {
            return Messages.OAuth1Page_82;
        }
        if (this.getBean().accessTokenBean.url == null || this.getBean().accessTokenBean.url.isEmpty()) {
            return Messages.OAuth1Page_83;
        }
        try {
            new URL(this.getBean().accessTokenBean.url);
        }
        catch (Exception ex) {
            return Messages.OAuth1Page_84;
        }
        if (this.getBean().accessTokenBean.httpMethod == null || this.getBean().accessTokenBean.httpMethod.isEmpty()) {
            return Messages.OAuth1Page_85;
        }
        if (this.token.getText().isEmpty() || this.tokenSecret.getText().isEmpty()) {
            return Messages.OAuth1Page_86;
        }
        return null;
    }

    private boolean check() {
        String errorMessage = this.computeErrorMessage();
        if (errorMessage == null) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(errorMessage);
        return false;
    }

    public IBeanLinker getBeanLinker() {
        return this.linker;
    }

    private class BrowserDialog {
        Text url;

        private BrowserDialog() {
        }

        public void open(String url) {
            final Shell sh = new Shell(OAuth1Page.this.getShell(), 112);
            sh.setText(Messages.OAuth1Page_11);
            sh.setSize(800, 600);
            sh.setLayout((Layout)new GridLayout());
            this.url = new Text((Composite)sh, 2048);
            this.url.setLayoutData((Object)new GridData(4, 1, true, false));
            this.url.setEditable(false);
            Browser b = new Browser((Composite)sh, 2048);
            b.setLayoutData((Object)new GridData(1808));
            b.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    BrowserDialog.this.url.setText(event.location);
                    if (event.location.contains("oauth_verifier")) {
                        String[] p;
                        String query = event.location.substring(event.location.indexOf("?") + 1);
                        String[] stringArray = p = query.split("\\&");
                        int n = p.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            String[] ss = s.split("=");
                            if (ss[0].equals("oauth_verifier")) {
                                OAuth1Page.this.tokenVerifier.setText(ss[1]);
                                sh.close();
                            }
                            ++n2;
                        }
                    }
                }

                public void changed(LocationEvent event) {
                }
            });
            b.setUrl(url);
            sh.open();
            Display display = sh.getDisplay();
            Shell loopShell = sh;
            while (loopShell != null && !loopShell.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!display.isDisposed()) {
                display.update();
            }
        }
    }

    private class Preconf {
        String requestUrl;
        String accessUrl;
        String callbackUrl;
        String authorizationUrl;
        int signature;
        int requestHttp;
        int accessHttp;
        String name;
        Image icon;

        public Preconf(String name, Image icon, String requestUrl, String accessUrl, String callbackUrl, String authorizationUrl, int signatureIndex, int requestHttp, int accessHttp) {
            this.name = name;
            this.icon = icon;
            this.requestUrl = requestUrl;
            this.accessUrl = accessUrl;
            this.callbackUrl = callbackUrl;
            this.authorizationUrl = authorizationUrl;
            this.signature = signatureIndex;
            this.requestHttp = requestHttp;
            this.accessHttp = accessHttp;
        }

        public String getName() {
            return this.name;
        }

        public Image getIcon() {
            return this.icon;
        }
    }
}

