/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth1.wizard;

import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth1.wizard.Oauth1Bean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Oauth1Controller {
    private static HostnameVerifier hostNameVerifier = null;
    private static SSLSocketFactory sslSocketFactory = null;
    private HostnameVerifier defaultHostNameVerifier = null;
    private SSLSocketFactory defaultSslSocketFactory = null;
    Oauth1Bean bean;
    boolean automaticCallback = true;

    static {
        TrustManager[] trustManagers = null;
        X509TrustManager trustMgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        trustManagers = new TrustManager[]{trustMgr};
        hostNameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        KeyManager[] keyManagers = null;
        if (keyManagers != null || trustManagers != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Oauth1Controller(Oauth1Bean bean) {
        this.bean = bean;
        this.defaultHostNameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        this.defaultSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HttpsURLConnection.setDefaultHostnameVerifier(hostNameVerifier);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
    }

    public void dispose() {
        HttpsURLConnection.setDefaultHostnameVerifier(this.defaultHostNameVerifier);
        HttpsURLConnection.setDefaultSSLSocketFactory(this.defaultSslSocketFactory);
    }

    private String computeBaseSignature(String url, String httpMethod, List<Oauth1Bean.ParameterBean> parameters) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append(URLEncoder.encode(httpMethod, "UTF-8"));
        b.append("&");
        b.append(URLEncoder.encode(url, "UTF-8"));
        StringBuilder pB = new StringBuilder();
        for (Oauth1Bean.ParameterBean p : parameters) {
            if (pB.length() > 0) {
                pB.append("%26");
            } else {
                b.append("&");
            }
            pB.append(URLEncoder.encode(String.valueOf(p.name) + "=" + p.value, "UTF-8"));
        }
        return String.valueOf(b.toString()) + pB.toString();
    }

    public void getRequestToken() throws Throwable {
        this.resetState();
        Oauth1Bean.RequestTokenBean requestB = this.bean.requestTokenBean;
        ArrayList<Oauth1Bean.ParameterBean> parameters = new ArrayList<Oauth1Bean.ParameterBean>();
        requestB.generateAuthorizationHeaderParameters();
        parameters.addAll(requestB.getAutorizationHeaderParameters());
        Collections.sort(parameters, new ParameterComparator());
        String signatureBaseString = this.computeBaseSignature(requestB.url, requestB.httpMethod, parameters);
        String signedSignature = this.sign(signatureBaseString, "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String header = null;
        for (Oauth1Bean.ParameterBean p : parameters) {
            if (header == null) {
                header = "OAuth ";
                header = String.valueOf(header) + p.name + "=\"" + p.value + "\"";
                continue;
            }
            header = String.valueOf(header) + ", " + p.name + "=\"" + p.value + "\"";
        }
        header = String.valueOf(header) + ", oauth_signature=\"" + signedSignature + "\"";
        headers.put("Authorization", header);
        String response = this.sendHttp(requestB.url, requestB.additionalParams, requestB.httpMethod, headers);
        this.bean.setTokenRequestResponse(response);
    }

    private String sign(String signatureBase, String tokenSecret) throws Exception {
        String base = Oauth1Controller.replaceSpecialCharacters(signatureBase);
        if (this.bean.signatureMethod.equalsIgnoreCase("HMAC-SHA1")) {
            String signKey = String.valueOf(URLEncoder.encode(this.bean.consumerSecret, "UTF-8")) + "&" + URLEncoder.encode(tokenSecret, "UTF-8");
            SecretKeySpec keySpec = new SecretKeySpec(signKey.getBytes(), "HmacSHA1");
            byte[] result = null;
            try {
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(keySpec);
                result = mac.doFinal(base.getBytes());
            }
            catch (Exception e) {
                throw new Exception("Unable to sign the signature with HmacSHA1", e);
            }
            String signature = new String(Base64.getEncoder().encode(result), "UTF-8");
            return URLEncoder.encode(signature, "UTF-8");
        }
        if (this.bean.signatureMethod.equalsIgnoreCase("PLAINTEXT")) {
            return URLEncoder.encode(String.valueOf(URLEncoder.encode(this.bean.consumerSecret, "UTF-8")) + "&" + URLEncoder.encode(tokenSecret, "UTF-8"), "UTF-8");
        }
        throw new Exception("Only signing with HMAC-SHA1, RSA-SHA1 or PLAINTEXT supported");
    }

    private static String replaceSpecialCharacters(String s) {
        s = s.replace("\\+", "%2520");
        s = s.replace("\\%2B", "%252B");
        s = s.replace("\\%2C", "%252C");
        s = s.replace("\\%21", "%2521");
        return s;
    }

    public void getAccessToken() throws Exception {
        Oauth1Bean.AccessTokenBean requestB = this.bean.accessTokenBean;
        ArrayList<Oauth1Bean.ParameterBean> parameters = new ArrayList<Oauth1Bean.ParameterBean>();
        requestB.generateAuthorizationHeaderParameters();
        parameters.addAll(requestB.getAutorizationHeaderParameters());
        Collections.sort(parameters, new ParameterComparator());
        String signatureBaseString = this.computeBaseSignature(requestB.url, requestB.httpMethod, parameters);
        String signedSignature = this.sign(signatureBaseString, this.bean.requestTokenResponse.oauthTokenSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        String header = null;
        for (Oauth1Bean.ParameterBean parameterBean : requestB.getAutorizationHeaderParameters()) {
            if (header == null) {
                header = "OAuth ";
                header = String.valueOf(header) + parameterBean.name + "=" + parameterBean.value;
                continue;
            }
            header = String.valueOf(header) + "," + parameterBean.name + "=" + parameterBean.value;
        }
        header = String.valueOf(header) + ", oauth_signature=" + signedSignature;
        headers.put("Authorization", header);
        String string = this.sendHttp(requestB.url, Collections.EMPTY_LIST, requestB.httpMethod, headers);
        this.bean.setTokenAccessResponse(string);
    }

    private String generateParametersString(List<Oauth1Bean.ParameterBean> parameters) throws Exception {
        String parameterString = null;
        StringBuilder b = new StringBuilder();
        boolean hasParam = false;
        for (Oauth1Bean.ParameterBean p : parameters) {
            if (hasParam) {
                b.append("&");
            } else {
                hasParam = true;
            }
            try {
                b.append(URLEncoder.encode(p.name, "UTF-8"));
                b.append("=");
                b.append(URLEncoder.encode(p.value, "UTF-8"));
            }
            catch (Exception ex) {
                throw new Exception("Failed to encode parameter " + p.name, ex);
            }
        }
        parameterString = b.toString();
        return parameterString;
    }

    private String sendHttp(String baseUrl, List<Oauth1Bean.ParameterBean> parameters, String httpMethod, HashMap<String, String> headers) throws Exception {
        HttpURLConnection connection;
        URL url;
        String _url = baseUrl;
        boolean isGET = false;
        String parameterString = this.generateParametersString(parameters);
        if (httpMethod.equals("GET")) {
            isGET = true;
            while (_url.endsWith("/")) {
                _url = _url.substring(0, _url.length() - 2);
            }
            StringBuilder b = new StringBuilder(_url);
            if (parameterString != null && !parameterString.isEmpty()) {
                b.append("?");
                b.append(parameterString);
            }
            _url = b.toString();
        }
        try {
            url = new URL(_url);
        }
        catch (MalformedURLException e) {
            throw new Exception("Unvalid URL " + _url, e);
        }
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new Exception("Unable to open connection at " + _url, e);
        }
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(httpMethod);
        for (String s : headers.keySet()) {
            connection.setRequestProperty(s, headers.get(s));
        }
        OutputStreamWriter writer = null;
        BufferedReader reader = null;
        try {
            int responseCode = connection.getResponseCode();
            StringBuilder response = new StringBuilder();
            if (responseCode == 200) {
                try {
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                }
                catch (Exception ex) {
                    throw new Exception("Unable to read response", ex);
                }
                String string = response.toString();
                return string;
            }
            if (responseCode == 302 || responseCode == 301) {
                String string = this.sendHttp(response.toString(), parameters, httpMethod, headers);
                return string;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to read response", ex);
            }
            throw new Exception("Http error " + responseCode + " : " + response.toString());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean hasRequestToken() {
        return this.bean.requestTokenResponse != null && this.bean.requestTokenResponse.oauthToken != null;
    }

    public boolean hasAccessToken() {
        return this.bean.accessTokenResponse != null && this.bean.accessTokenResponse.oauthToken != null;
    }

    public boolean hasAuthorization() {
        return this.bean.accessTokenBean != null && this.bean.accessTokenBean.oauth_verifier != null;
    }

    void resetState() {
        if (this.bean.requestTokenResponse != null) {
            this.bean.requestTokenResponse.oauthToken = null;
        }
        if (this.bean.accessTokenBean != null) {
            this.bean.accessTokenBean.oauth_verifier = null;
        }
        if (this.bean.accessTokenResponse != null) {
            this.bean.accessTokenResponse.oauthToken = null;
        }
    }

    public URL getAuthorizationURL() throws Exception {
        if (this.bean.authorizationBean == null) {
            throw new Exception(Messages.Oauth1Controller_0);
        }
        if (this.bean.authorizationBean.url == null) {
            throw new Exception(Messages.Oauth1Controller_64);
        }
        if (this.bean.requestTokenResponse == null || this.bean.requestTokenResponse.oauthToken == null) {
            throw new Exception(Messages.Oauth1Controller_65);
        }
        String s = String.valueOf(this.bean.authorizationBean.url) + "?oauth_token=" + this.bean.requestTokenResponse.oauthToken;
        if (this.bean.authorizationBean.callBackURL != null) {
            s = String.valueOf(s) + "&oauth_callback=" + URLEncoder.encode(this.bean.authorizationBean.callBackURL, "UTF-8");
        }
        if (!this.bean.authorizationBean.additionalParams.isEmpty()) {
            s = String.valueOf(s) + "&" + this.generateParametersString(this.bean.authorizationBean.additionalParams);
        }
        return new URL(s);
    }

    private class ParameterComparator
    implements Comparator<Oauth1Bean.ParameterBean> {
        private ParameterComparator() {
        }

        @Override
        public int compare(Oauth1Bean.ParameterBean p1, Oauth1Bean.ParameterBean p2) {
            if (p1.name.equals(p2.name)) {
                return p1.value.compareTo(p2.value);
            }
            return p1.name.compareTo(p2.name);
        }
    }
}

