/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.HttpHelper;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.URLParser;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import com.indy.ui.conf.custom.Activator;
import com.indy.ui.conf.custom.preference.ConfPreferencePage;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthorizationCodeGrantFlow {
    private final Logger logger = LogManager.getLogger(this.getClass());
    AuthorizationCodeGrantBean bean;

    AuthorizationCodeGrantFlow(AuthorizationCodeGrantBean bean) {
        this.bean = bean;
    }

    public AccessTokenResponse getToken(IWizard w) throws Exception {
        URL authorizationEndPointURL = null;
        try {
            authorizationEndPointURL = this.getAuthorizationEndPointURL();
        }
        catch (MalformedURLException ex) {
            throw new Exception(Messages.AuthorizationCodeGrantFlow_7, ex);
        }
        final BrowserDialog d = new BrowserDialog();
        HttpServer server = null;
        HttpContext ctx = null;
        int port = Activator.getDefault().getPreferenceStore().getInt("com.indy.ui.conf.custom.preference.localHttpServer.port");
        boolean startServer = this.bean.redirectURI.contains("localhost");
        if (startServer) {
            try {
                port = Activator.getDefault().getPreferenceStore().getInt("com.indy.ui.conf.custom.preference.localHttpServer.port");
                InetSocketAddress add = new InetSocketAddress("localhost", port);
                server = HttpServer.create(add, 0);
                ctx = server.createContext("/", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange t) throws IOException {
                        d.handledRedirectionQuery = String.valueOf(AuthorizationCodeGrantFlow.this.bean.redirectURI) + t.getRequestURI().toString();
                        t.getResponseHeaders().add("Location", d.handledRedirectionQuery);
                        t.sendResponseHeaders(203, 1L);
                        d.close();
                    }
                });
                server.setExecutor(null);
                server.start();
                startServer = false;
            }
            catch (BindException ex) {
                if (!MessageDialog.open((int)3, (Shell)w.getContainer().getShell(), (String)Messages.AuthorizationCodeGrantFlow_12, (String)Messages.bind((String)Messages.AuthorizationCodeGrantFlow_13, (Object)port), (int)4)) {
                    return null;
                }
            }
            catch (Exception ex) {
                if (server != null) {
                    if (ctx != null) {
                        server.removeContext(ctx);
                    }
                    server.stop(1);
                }
                throw ex;
            }
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (this.bean.additionalHeaders != null) {
            for (Map.Entry<String, String> entry : this.bean.additionalHeaders.entrySet()) {
                headers.add(String.valueOf(entry.getKey()) + ": " + entry.getValue());
            }
        }
        d.open(w.getContainer().getShell(), authorizationEndPointURL.toString(), headers.toArray(new String[0]));
        try {
            if (server != null) {
                if (ctx != null) {
                    server.removeContext(ctx);
                }
                server.stop(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (d.handledRedirectionQuery != null) {
            String error;
            URLParser p;
            if (this.bean.isImplicit) {
                p = new URLParser(d.handledRedirectionQuery, URLParser.MODE_FRAGMENT);
                HashMap<String, String> res = new HashMap<String, String>();
                for (String s : p.getParameters()) {
                    res.put(s, p.getParameter(s));
                }
                return new AccessTokenResponse(res);
            }
            p = new URLParser(d.handledRedirectionQuery, URLParser.MODE_PARAMETER);
            String code = p.getParameter("code");
            if (code == null && (error = p.getParameter("error")) != null) {
                StringBuffer b = new StringBuffer();
                for (String s : p.getParameters()) {
                    if (s.equals("error")) continue;
                    b.append(String.valueOf(s) + ": " + p.getParameter(s) + "\n");
                }
                throw new Exception(String.valueOf(Messages.AuthorizationCodeGrantFlow_21) + error + "\n" + b.toString());
            }
            URL accessTokenURL = null;
            try {
                accessTokenURL = new URL(this.bean.tokenURI);
            }
            catch (MalformedURLException ex) {
                throw new Exception(Messages.AuthorizationCodeGrantFlow_23, ex);
            }
            String content = this.getAccessTokenEndpointContent(code, null);
            HttpHelper helper = new HttpHelper();
            HttpURLConnection connection = null;
            try {
                Authenticator.setDefault(null);
                connection = helper.connect(accessTokenURL, null, null, this.bean.additionalHeaders, "POST", content.getBytes());
            }
            finally {
                HttpHelper.restoreHttpAuthenticator();
            }
            if (connection.getResponseCode() == 200) {
                String s;
                String[] _p;
                int i;
                String charSet = null;
                String contentType = connection.getHeaderField("Content-Type");
                if (contentType != null && (i = contentType.toLowerCase().indexOf("charset")) > -1 && (_p = (s = contentType.substring(i)).split("=")).length > 1) {
                    charSet = _p[1].trim();
                }
                if (charSet == null) {
                    charSet = "UTF-8";
                }
                HashMap<String, String> res = new HashMap<String, String>();
                try (JsonEventReader reader = null;){
                    reader = new JsonEventReader(connection.getInputStream(), charSet);
                    String propName = null;
                    while (reader.hasNext()) {
                        JSonEvent ev = reader.readNext();
                        switch (ev.getType()) {
                            case MEMBER: {
                                propName = ev.getName();
                                break;
                            }
                            case STRING: 
                            case VALUE: {
                                res.put(propName, ev.getName());
                                propName = null;
                            }
                        }
                    }
                }
                return new AccessTokenResponse(res);
            }
            InputStream is = connection.getErrorStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (is != null) {
                byte[] buf = new byte[1024];
                int sz = -1;
                while ((sz = is.read(buf)) != -1) {
                    bos.write(buf, 0, sz);
                }
            } else {
                String s = connection.getResponseMessage();
                bos.write(s.getBytes());
            }
            throw new Exception(String.valueOf(Messages.AuthorizationCodeGrantFlow_29) + connection.getResponseMessage() + "\n" + new String(bos.toByteArray()));
        }
        return null;
    }

    private String getAccessTokenEndpointContent(String authorizationCode, Map<String, String> additionalParameters) throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("grant_type=authorization_code");
        b.append("&redirect_uri=" + URLEncoder.encode(this.bean.redirectURI, "UTF-8"));
        b.append("&code=" + authorizationCode);
        b.append("&client_id=" + this.bean.clientId);
        b.append("&client_secret=" + this.bean.clientSecret);
        if (additionalParameters != null) {
            for (String s : additionalParameters.keySet()) {
                b.append("&" + s + "=" + URLEncoder.encode(additionalParameters.get(s), "UTF-8"));
            }
        }
        return b.toString();
    }

    private URL getAuthorizationEndPointURL() throws Exception {
        StringBuffer b = new StringBuffer(this.bean.authorizationURI);
        if (this.bean.isImplicit) {
            b.append("?response_type=token");
        } else {
            b.append("?response_type=code");
        }
        b.append("&client_id=" + this.bean.clientId);
        if (!this.bean.redirectURI.trim().isEmpty()) {
            b.append("&redirect_uri=" + URLEncoder.encode(this.bean.redirectURI, "UTF-8"));
        }
        b.append("&state=" + UUID.randomUUID().toString());
        for (String s : this.bean.authParams.keySet()) {
            b.append("&" + s + "=" + URLEncoder.encode(this.bean.authParams.get(s), "UTF-8"));
        }
        StringBuffer scopes = new StringBuffer();
        for (String s : this.bean.scopes) {
            if (scopes.length() > 0) {
                scopes.append(" ");
            }
            scopes.append(s);
        }
        if (scopes.length() > 0) {
            b.append("&scope=" + URLEncoder.encode(scopes.toString(), "UTF-8"));
        }
        return new URL(b.toString());
    }

    public static class AccessTokenResponse {
        String token;
        String tokenType;
        String expireIn;
        String refreshToken;
        HashMap<String, String> allInfos;

        public AccessTokenResponse(HashMap<String, String> m) {
            this.token = m.remove("access_token");
            this.tokenType = m.remove("token_type");
            this.expireIn = m.remove("expires_in");
            this.refreshToken = m.remove("refresh_token");
            this.allInfos = m;
        }
    }

    private class BrowserDialog {
        Text url;
        String handledRedirectionQuery;
        Shell sh = null;

        private BrowserDialog() {
        }

        public void open(Shell parent, String url, String[] headers) {
            this.sh = new Shell(parent, 112);
            this.sh.setText(Messages.AuthorizationCodeGrantFlow_0);
            this.sh.setSize(800, 600);
            this.sh.setLayout((Layout)new GridLayout());
            this.url = new Text((Composite)this.sh, 2048);
            this.url.setLayoutData((Object)new GridData(4, 1, true, false));
            this.url.setEditable(false);
            Browser b = new Browser((Composite)this.sh, 0);
            b.setLayoutData((Object)new GridData(1808));
            b.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    AuthorizationCodeGrantFlow.this.logger.debug(event.location);
                }

                public void changed(LocationEvent event) {
                    BrowserDialog.this.url.setText(event.location);
                    if (event.location.startsWith(((BrowserDialog)BrowserDialog.this).AuthorizationCodeGrantFlow.this.bean.redirectURI)) {
                        BrowserDialog.this.handledRedirectionQuery = event.location;
                        BrowserDialog.this.sh.close();
                    }
                }
            });
            b.setUrl(url, null, headers);
            this.sh.open();
            Display display = this.sh.getDisplay();
            Shell loopShell = this.sh;
            while (loopShell != null && !loopShell.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!display.isDisposed()) {
                display.update();
            }
        }

        public void close() {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BrowserDialog.this.sh.close();
                }
            });
        }
    }

    private class PortWarningDialog
    extends MessageDialog {
        public PortWarningDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button button = this.createButton(parent, 20, Messages.AuthorizationCodeGrantFlow_1, false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfPreferencePage page = new ConfPreferencePage();
                    PreferenceManager mgr = new PreferenceManager();
                    PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                    mgr.addToRoot((IPreferenceNode)node);
                    PreferenceDialog dialog = new PreferenceDialog(PortWarningDialog.this.getShell(), mgr);
                    dialog.create();
                    dialog.setMessage(page.getTitle());
                    dialog.open();
                }
            });
        }
    }
}

