/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.HttpHelper;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizard;

public class ClientCredentialGrantFlow {
    ResourceOwnerGrantBean bean;

    ClientCredentialGrantFlow(ResourceOwnerGrantBean bean) {
        this.bean = bean;
    }

    private String getAccessTokenEndpointURIParameter() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("grant_type=client_credentials");
        if (this.bean.credentialMode == OAuth2.CredentialMode.PARAMETER_CLIENT_ID) {
            b.append("&client_id=" + this.bean.clientId);
        } else if (this.bean.credentialMode == OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET) {
            b.append("&client_id=" + this.bean.clientId);
            b.append("&client_secret=" + this.bean.clientSecret);
        }
        if (this.bean.authParams != null) {
            for (String s : this.bean.authParams.keySet()) {
                b.append("&" + s + "=" + URLEncoder.encode(this.bean.authParams.get(s), "UTF-8"));
            }
        }
        StringBuffer scopes = new StringBuffer();
        for (String s : this.bean.scopes) {
            if (scopes.length() > 0) {
                scopes.append(" ");
            }
            scopes.append(s);
        }
        if (scopes.length() > 0) {
            b.append("&scope=" + URLEncoder.encode(scopes.toString(), "UTF-8"));
        }
        return b.toString();
    }

    public AuthorizationCodeGrantFlow.AccessTokenResponse getToken(IWizard w) throws Exception {
        URL accessTokenURL = null;
        String content = this.getAccessTokenEndpointURIParameter();
        HttpHelper helper = new HttpHelper();
        HttpURLConnection connection = null;
        try {
            String url = this.bean.tokenURI;
            Authenticator.setDefault(null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (this.bean.additionalHeaders != null) {
                headers.putAll(this.bean.additionalHeaders);
            }
            byte[] datas = null;
            if ("POST".equals(this.bean.httpMethod)) {
                headers.put("Content-Type", "application/x-www-form-urlencoded");
                datas = content.getBytes();
            } else {
                url = String.valueOf(url) + "?" + content;
            }
            if (this.bean.credentialMode == OAuth2.CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET) {
                BasicAuthentication b = new BasicAuthentication(this.bean.clientId, this.bean.clientSecret);
                headers.put("Authorization", b.getAuthenticationHeaderValue(null));
            }
            try {
                accessTokenURL = new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new Exception(String.valueOf(Messages.ClientCredentialGrantFlow_1) + url, ex);
            }
            connection = helper.connect(accessTokenURL, null, null, headers, this.bean.httpMethod, datas);
        }
        finally {
            HttpHelper.restoreHttpAuthenticator();
        }
        if (connection.getResponseCode() == 200) {
            String s;
            String[] _p;
            int i;
            String charSet = null;
            String contentType = connection.getHeaderField("Content-Type");
            if (contentType != null && (i = contentType.toLowerCase().indexOf("charset")) > -1 && (_p = (s = contentType.substring(i)).split("=")).length > 1) {
                charSet = _p[1].trim();
            }
            if (charSet == null) {
                charSet = "UTF-8";
            }
            HashMap<String, String> res = new HashMap<String, String>();
            try (JsonEventReader reader = null;){
                reader = new JsonEventReader(connection.getInputStream(), charSet);
                String propName = null;
                while (reader.hasNext()) {
                    JSonEvent ev = reader.readNext();
                    switch (ev.getType()) {
                        case MEMBER: {
                            propName = ev.getName();
                            break;
                        }
                        case STRING: 
                        case VALUE: {
                            res.put(propName, ev.getName());
                            propName = null;
                        }
                    }
                }
            }
            return new AuthorizationCodeGrantFlow.AccessTokenResponse(res);
        }
        InputStream is = connection.getErrorStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (is != null) {
            byte[] buf = new byte[1024];
            int sz = -1;
            while ((sz = is.read(buf)) != -1) {
                bos.write(buf, 0, sz);
            }
        } else {
            String s = connection.getResponseMessage();
            bos.write(s.getBytes());
        }
        throw new Exception("AccessToken refused : " + connection.getResponseMessage() + "\n" + new String(bos.toByteArray()));
    }
}

