/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.OAuth2Wizard;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;

public class Linker
implements OAuth2Wizard.ILinker {
    private MdNode node;
    private boolean refreshBean = false;
    private AuthorizationCodeGrantBean bean = new AuthorizationCodeGrantBean();
    private MdAttributeReader reader = new MdAttributeReader();
    private String _originalAuthURI = "";
    private String _originalTokenURI = "";
    private OAuth2Wizard.FlowType flowType;

    public Linker(OAuth2Wizard.FlowType flowType) {
        this.flowType = flowType;
    }

    @Override
    public OAuth2Wizard.FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    @Override
    public Object getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    public void executeFlow(IWizard w) throws Exception {
        AuthorizationCodeGrantFlow flow = new AuthorizationCodeGrantFlow((AuthorizationCodeGrantBean)this.getBean());
        AuthorizationCodeGrantFlow.AccessTokenResponse response = flow.getToken(w);
        if (response != null) {
            this.bean.token = response.token;
            this.bean.refreshToken = response.refreshToken;
            this.bean.expiresIn = response.expireIn;
            this.bean.responseInfo = response.allInfos;
            if (this.bean.token == null) {
                this.bean.token = "";
            }
            if (this.bean.refreshToken == null) {
                this.bean.refreshToken = "";
            }
            if (this.bean.expiresIn == null) {
                this.bean.expiresIn = "";
            }
        }
    }

    private void refreshBean() {
        try {
            String s = MdAttributeReader.readAttribute((String)"flowType", (MdNode)this.node, (String)"");
            if (OAuth2Wizard.FlowType.IMPLICIT_GRANT.getValue().equals(s)) {
                this.bean.isImplicit = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : null;
        try {
            this.bean.authorizationURI = MdAttributeReader.readAttribute((String)"authorizationEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._originalAuthURI = this.bean.authorizationURI;
        try {
            this.bean.tokenURI = MdAttributeReader.readAttribute((String)"tokenEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._originalTokenURI = this.bean.tokenURI;
        try {
            this.bean.clientId = MdAttributeReader.readAttribute((String)"clientId", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.clientSecret = MdAttributeReader.readAttribute((String)"clientSecret", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.redirectURI = MdAttributeReader.readAttribute((String)"redirectionEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.scopes = new ArrayList<String>(MdAttributeReader.readAttributeList((String)"scope", (MdNode)this.node));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.token = MdAttributeReader.readAttribute((String)"accessToken", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.refreshToken = MdAttributeReader.readAttribute((String)"refreshToken", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.expiresIn = MdAttributeReader.readAttribute((String)"expiresIn", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.authParams = new HashMap(MdAttributeReader.readAttributeMap((String)"authorizationParameter", (MdNode)this.node));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.additionalHeaders = new HashMap(MdAttributeReader.readAttributeMap((String)"additionalHttpHeaders", (MdNode)this.node));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean.preconfs.clear();
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.Linker_0, this._originalAuthURI, this._originalTokenURI, false, false));
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.Linker_26, "", "", false, false));
        this.bean.preconfs.add(AuthorizationCodeGrantBean.googleConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.linkedInConf);
    }

    @Override
    public void dispose() {
        this.node = null;
    }

    @Override
    public void updateMdNode() throws Exception {
        MdNode node = this.node.copy(0);
        node.setName(this.bean.name);
        node.setSubstituteContainer(this.node.getSubstituteContainer());
        this.setAttribute("accessToken", this.bean.token, node);
        this.setAttribute("clientSecret", this.bean.clientSecret, node);
        this.setAttribute("authorizationEndpoint", this.bean.authorizationURI, node);
        this.setAttribute("clientId", this.bean.clientId, node);
        this.setAttribute("expiresIn", this.bean.expiresIn, node);
        this.setAttribute("redirectionEndpoint", this.bean.redirectURI, node);
        this.setAttribute("refreshToken", this.bean.refreshToken, node);
        this.setAttribute("scope", this.bean.scopes, node);
        this.setAttribute("tokenEndpoint", this.bean.tokenURI, node);
        this.setAttribute("authorizationParameter", this.bean.authParams, node);
        this.setAttribute("additionalHttpHeaders", this.bean.additionalHeaders, node);
        this.setAttribute("authorizationProperties", this.bean.responseInfo, node);
        node.setPosition(this.node.getPosition());
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(node, this.node);
        ArrayList<String> nonDeletableAttributes = new ArrayList<String>();
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.connectionTimeout");
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.expiresIn");
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.numberOfAttempts");
        IncrementalReverser ir = new IncrementalReverser(this.node.getSubstituteContainer(), reversedObject, nonDeletableAttributes, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    private void setAttribute(String shortCode, Object value, MdNode n) {
        Property p = this.node.getLevel().getAttributeByShortCode(shortCode);
        Attribute a = MdFactoryHelper.createAttribute((String)(String.valueOf(this.node.getDefType()) + "." + shortCode));
        if (p.isUnbounded()) {
            boolean addedVal = false;
            if (p.isKeyValue()) {
                for (Object o : ((Map)value).keySet()) {
                    if (o == null) continue;
                    a.getValueEntry().put((Object)((String)o), (Object)((String)((Map)value).get(o)));
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            } else {
                for (Object o : (List)value) {
                    if (o == null) continue;
                    a.getValues().add((Object)o.toString());
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            }
        } else {
            String v = null;
            if (value instanceof String) {
                if (!((String)value).trim().isEmpty()) {
                    v = (String)value;
                }
            } else {
                String string = v = value == null ? "" : value.toString();
            }
            if (p.getType() == PropertyType.PASSWORD) {
                try {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    v = semaphoreManager.setSemaphore(true, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v != null) {
                a.setValue(v);
                n.getAttribute().add((Object)a);
            }
        }
    }

    @Override
    public boolean canFinish() {
        return this.bean.hasToken();
    }
}

