/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerLinker;
import com.indy.jdbc.editor.Activator;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.semarchy.xdi.base.core.auth.OAuth2;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResourceOwnerGrantPage
extends WizardPage {
    public static final Image helpImg = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/etool16/help_contents.png").createImage();
    private Text username;
    private Text password;
    private Text access;
    private Text token;
    private Text clientId;
    private Text clientSecret;
    private Button getToken;
    private ResourceOwnerLinker linker;
    private Viewer scopeViewer;
    private Viewer paramViewer;
    private Viewer headerViewer;
    private Combo httpMethod;
    private Combo clientCredentialPolicy;
    Section section = null;

    protected ResourceOwnerGrantPage(ResourceOwnerLinker linker) {
        super(Messages.ResourceOwnerGrantPage_2);
        this.linker = linker;
        this.setTitle(Messages.ResourceOwnerGrantPage_3);
        this.setDescription(Messages.bind((String)Messages.ResourceOwnerGrantPage_4, (Object)linker.getFlowType().getValue()));
    }

    private Composite createAdditionalHeaders(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.ResourceOwnerGrantPage_38);
        main.setLayout((Layout)new FillLayout());
        GridLayout gl = null;
        Composite c = new Composite((Composite)main, 0);
        gl = new GridLayout();
        c.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        GridData gd = null;
        ToolBar tb = new ToolBar(c, 256);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.ResourceOwnerGrantPage_39);
        add.setImage(AbstractUnboundedControl.addIcon);
        final ToolItem del = new ToolItem(tb, 8);
        del.setToolTipText(Messages.ResourceOwnerGrantPage_40);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setEnabled(false);
        final TableViewer headerViewer = new TableViewer(c, 68352);
        gd = new GridData(1808);
        headerViewer.getControl().setLayoutData((Object)gd);
        this.headerViewer = headerViewer;
        headerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        headerViewer.getTable().setHeaderVisible(true);
        headerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                del.setEnabled(!event.getSelection().isEmpty());
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Collection)headerViewer.getInput()).remove(((IStructuredSelection)headerViewer.getSelection()).getFirstElement());
                headerViewer.refresh();
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.put(Messages.ResourceOwnerGrantPage_41, "");
                headerViewer.refresh();
            }
        });
        TableViewerColumn name = new TableViewerColumn(headerViewer, 16384);
        name.getColumn().setText(Messages.ResourceOwnerGrantPage_10);
        name.getColumn().setWidth(50);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        name.setEditingSupport(new EditingSupport((ColumnViewer)headerViewer){
            TextCellEditor editor;
            {
                super($anonymous0);
                this.editor = null;
            }

            void createEditor() {
                this.editor = new TextCellEditor((Composite)headerViewer.getTable());
                this.editor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        for (Object o : (Collection)headerViewer.getInput()) {
                            if (!o.equals(value)) continue;
                            return Messages.bind((String)Messages.ResourceOwnerGrantPage_11, (Object)value);
                        }
                        return null;
                    }
                });
            }

            protected void setValue(Object element, Object value) {
                String oldValue = ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.remove(element);
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.put((String)value, oldValue);
                headerViewer.refresh();
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.editor == null) {
                    this.createEditor();
                }
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn val = new TableViewerColumn(headerViewer, 16384);
        val.getColumn().setText(Messages.ResourceOwnerGrantPage_13);
        val.getColumn().setWidth(200);
        val.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String s = ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.get(element);
                if (s == null) {
                    return "";
                }
                return s;
            }
        });
        val.setEditingSupport(new EditingSupport((ColumnViewer)headerViewer){

            protected void setValue(Object element, Object value) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.put((String)element, (String)value);
                headerViewer.refresh();
            }

            protected Object getValue(Object element) {
                return ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().additionalHeaders.get(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)headerViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        return main;
    }

    private Composite createAutorizationParameters(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.ResourceOwnerGrantPage_5);
        main.setLayout((Layout)new FillLayout());
        GridLayout gl = null;
        Composite c = new Composite((Composite)main, 0);
        gl = new GridLayout();
        c.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        GridData gd = null;
        ToolBar tb = new ToolBar(c, 256);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.ResourceOwnerGrantPage_6);
        add.setImage(AbstractUnboundedControl.addIcon);
        final ToolItem del = new ToolItem(tb, 8);
        del.setToolTipText(Messages.ResourceOwnerGrantPage_7);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setEnabled(false);
        final TableViewer paramViewer = new TableViewer(c, 68352);
        gd = new GridData(1808);
        paramViewer.getControl().setLayoutData((Object)gd);
        this.paramViewer = paramViewer;
        paramViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        paramViewer.getTable().setHeaderVisible(true);
        paramViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                del.setEnabled(!event.getSelection().isEmpty());
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Collection)paramViewer.getInput()).remove(((IStructuredSelection)paramViewer.getSelection()).getFirstElement());
                paramViewer.refresh();
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.put(Messages.ResourceOwnerGrantPage_8, "");
                paramViewer.refresh();
            }
        });
        TableViewerColumn name = new TableViewerColumn(paramViewer, 16384);
        name.getColumn().setText(Messages.ResourceOwnerGrantPage_10);
        name.getColumn().setWidth(50);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        name.setEditingSupport(new EditingSupport((ColumnViewer)paramViewer){
            TextCellEditor editor;
            {
                super($anonymous0);
                this.editor = null;
            }

            void createEditor() {
                this.editor = new TextCellEditor((Composite)paramViewer.getTable());
                this.editor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        for (Object o : (Collection)paramViewer.getInput()) {
                            if (!o.equals(value)) continue;
                            return Messages.bind((String)Messages.ResourceOwnerGrantPage_11, (Object)value);
                        }
                        return null;
                    }
                });
            }

            protected void setValue(Object element, Object value) {
                String oldValue = ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.remove(element);
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.put((String)value, oldValue);
                paramViewer.refresh();
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.editor == null) {
                    this.createEditor();
                }
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn val = new TableViewerColumn(paramViewer, 16384);
        val.getColumn().setText(Messages.ResourceOwnerGrantPage_13);
        val.getColumn().setWidth(200);
        val.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String s = ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.get(element);
                if (s == null) {
                    return "";
                }
                return s;
            }
        });
        val.setEditingSupport(new EditingSupport((ColumnViewer)paramViewer){

            protected void setValue(Object element, Object value) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.put((String)element, (String)value);
                paramViewer.refresh();
            }

            protected Object getValue(Object element) {
                return ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().authParams.get(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)paramViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        return main;
    }

    private Composite createScopeControl(Composite parent) {
        Group main = new Group(parent, 0);
        main.setText(Messages.ResourceOwnerGrantPage_16);
        GridLayout gl = null;
        gl = new GridLayout();
        main.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        GridData gd = null;
        ToolBar tb = new ToolBar((Composite)main, 256);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.ResourceOwnerGrantPage_17);
        add.setImage(AbstractUnboundedControl.addIcon);
        final ToolItem del = new ToolItem(tb, 8);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setToolTipText(Messages.ResourceOwnerGrantPage_18);
        del.setEnabled(false);
        ToolItem helper = new ToolItem(tb, 8);
        helper.setToolTipText(Messages.ResourceOwnerGrantPage_19);
        helper.setImage(helpImg);
        helper.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopePopup p = new ScopePopup(ResourceOwnerGrantPage.this.getShell());
                if (p.open() == 0) {
                    for (String s : p.res) {
                        ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().scopes.add(s);
                    }
                    ResourceOwnerGrantPage.this.scopeViewer.refresh();
                }
            }
        });
        final TableViewer scopeViewer = new TableViewer((Composite)main, 2560);
        gd = new GridData(1808);
        scopeViewer.getControl().setLayoutData((Object)gd);
        scopeViewer.getTable().setLayout((Layout)new TableLayout());
        gd.heightHint = 200;
        scopeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        scopeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        scopeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                del.setEnabled(!scopeViewer.getSelection().isEmpty());
            }
        });
        TableViewerColumn name = new TableViewerColumn(scopeViewer, 16384);
        name.getColumn().setText(Messages.ResourceOwnerGrantPage_20);
        name.getColumn().setWidth(200);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        name.setEditingSupport(new EditingSupport((ColumnViewer)scopeViewer){
            TextCellEditor editor;
            {
                super($anonymous0);
                this.editor = null;
            }

            void createEditor() {
                this.editor = new TextCellEditor((Composite)scopeViewer.getTable());
                this.editor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        for (String o : ((ResourceOwnerGrantPage)(this).ResourceOwnerGrantPage.this).getBean().scopes) {
                            if (!o.equals(value)) continue;
                            return Messages.ResourceOwnerGrantPage_21;
                        }
                        return null;
                    }
                });
            }

            protected void setValue(Object element, Object value) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().scopes.remove(element);
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().scopes.add((String)value);
                scopeViewer.refresh();
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.editor == null) {
                    this.createEditor();
                }
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        ((TableLayout)scopeViewer.getTable().getLayout()).addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = Messages.ResourceOwnerGrantPage_22;
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().scopes.add(s);
                scopeViewer.refresh();
                scopeViewer.setSelection((ISelection)new StructuredSelection((Object)s));
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = (String)((IStructuredSelection)scopeViewer.getSelection()).getFirstElement();
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().scopes.remove(s);
                scopeViewer.refresh();
            }
        });
        this.scopeViewer = scopeViewer;
        return main;
    }

    public void createControl(Composite parent) {
        Section s;
        ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
        Composite main = new Composite((Composite)scrolled, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite c = new Composite(main, 0);
        c.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout gl = null;
        gl = new GridLayout(2, false);
        c.setLayout((Layout)gl);
        Group g = new Group(main, 0);
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        g.setText(Messages.ResourceOwnerGrantPage_23);
        Label l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ResourceOwnerGrantPage_24);
        this.clientId = new Text((Composite)g, 2048);
        this.clientId.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ResourceOwnerGrantPage_25);
        this.clientSecret = new Text((Composite)g, 0x400800);
        this.clientSecret.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ResourceOwnerGrantPage_0);
        this.clientCredentialPolicy = new Combo((Composite)g, 8);
        this.clientCredentialPolicy.setLayoutData((Object)new GridData());
        this.clientCredentialPolicy.setItems(new String[]{OAuth2.CredentialMode.NONE.getLabel(), OAuth2.CredentialMode.PARAMETER_CLIENT_ID.getLabel(), OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET.getLabel(), OAuth2.CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET.getLabel()});
        if (!this.linker.isClientCredentialFlow) {
            l = new Label((Composite)g, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.ResourceOwnerGrantPage_26);
            this.username = new Text((Composite)g, 2048);
            this.username.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)g, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.ResourceOwnerGrantPage_27);
            this.password = new Text((Composite)g, 0x400800);
            this.password.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        g = new Group(main, 0);
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        g.setText(Messages.ResourceOwnerGrantPage_28);
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ResourceOwnerGrantPage_29);
        ComboViewer cv = new ComboViewer((Composite)g, 8);
        cv.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        cv.setContentProvider((IContentProvider)new ArrayContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AuthorizationCodeGrantBean.Preconf) {
                    return ((AuthorizationCodeGrantBean.Preconf)element).name;
                }
                return "----";
            }
        });
        cv.setInput(this.getBean().preconfs);
        cv.setSelection((ISelection)new StructuredSelection((Object)this.getBean().preconfs.get(0)));
        cv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof AuthorizationCodeGrantBean.Preconf) {
                    ResourceOwnerGrantPage.this.access.setText(((AuthorizationCodeGrantBean.Preconf)o).tokenEndPoint);
                }
            }
        });
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.ResourceOwnerGrantPage_31);
        this.access = new Text((Composite)g, 2048);
        this.access.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData());
        l.setText("Http Method");
        this.httpMethod = new Combo((Composite)g, 2048);
        this.httpMethod.setLayoutData((Object)new GridData(4, 1, true, false));
        this.httpMethod.setItems(new String[]{"POST", "GET"});
        this.httpMethod.select(0);
        GridData gd = null;
        this.section = s = new Section((Composite)g, 4);
        s.setText(Messages.ResourceOwnerGrantPage_32);
        gd = new GridData(4, 1, true, false, 2, 1);
        s.setLayoutData((Object)gd);
        s.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    ResourceOwnerGrantPage.this.getShell().setRedraw(false);
                    Rectangle shellBounds = ResourceOwnerGrantPage.this.getShell().getBounds();
                    Point sz = ResourceOwnerGrantPage.this.getShell().computeSize(-1, -1);
                    if (shellBounds.height < sz.y) {
                        shellBounds.height = sz.y;
                        ResourceOwnerGrantPage.this.getShell().setBounds(shellBounds);
                    }
                    ResourceOwnerGrantPage.this.getShell().setRedraw(true);
                }
            }
        });
        Composite client = new Composite((Composite)s, 0);
        client.setLayout((Layout)new GridLayout(2, true));
        s.setClient((Control)client);
        this.createScopeControl(client).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createAutorizationParameters(client).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createAdditionalHeaders(client).setLayoutData((Object)new GridData(4, 4, true, true));
        g = new Group(main, 0);
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        g.setText(Messages.ResourceOwnerGrantPage_33);
        this.getToken = new Button((Composite)g, 8);
        this.getToken.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.getToken.setText(Messages.ResourceOwnerGrantPage_34);
        this.getToken.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ResourceOwnerGrantPage.this.token.setText(ResourceOwnerGrantPage.this.linker.executeFlow(ResourceOwnerGrantPage.this.getWizard()));
                }
                catch (Exception e1) {
                    ResourceOwnerGrantPage.this.token.setText("");
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.ResourceOwnerGrantPage_36, (Throwable)e1), 5);
                }
                ResourceOwnerGrantPage.this.getContainer().updateButtons();
            }
        });
        l = new Label((Composite)g, 0);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        l.setText(Messages.ResourceOwnerGrantPage_37);
        this.token = new Text((Composite)g, 2626);
        this.token.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.token.getLayoutData()).widthHint = 100;
        ((GridData)this.token.getLayoutData()).heightHint = 50;
        this.token.setEditable(false);
        ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)main);
        this.setControl((Control)scrolled);
        this.fillData();
        this.hookListeners();
    }

    private void fillData() {
        if (!this.linker.isClientCredentialFlow) {
            this.username.setText(this.getBean().userName);
            this.password.setText(this.getBean().password);
        }
        this.access.setText(this.getBean().tokenURI.toString());
        this.clientId.setText(this.getBean().clientId);
        this.clientSecret.setText(this.getBean().clientSecret);
        if (this.getBean().httpMethod != null) {
            this.httpMethod.setText(this.getBean().httpMethod);
        }
        this.scopeViewer.setInput(this.getBean().scopes);
        ((Table)this.scopeViewer.getControl()).getColumns()[0].pack();
        this.paramViewer.setInput(this.getBean().authParams.keySet());
        this.headerViewer.setInput(this.getBean().additionalHeaders.keySet());
        this.clientCredentialPolicy.setText(this.getBean().credentialMode.getLabel());
        this.updateGetTokenButton();
        this.getContainer().updateButtons();
    }

    private void hookListeners() {
        this.clientCredentialPolicy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().credentialMode = OAuth2.CredentialMode.fromLabel((String)((Combo)e.widget).getText());
            }
        });
        this.clientId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().clientId = ResourceOwnerGrantPage.this.clientId.getText();
                ResourceOwnerGrantPage.this.getBean().changed();
                ResourceOwnerGrantPage.this.getContainer().updateButtons();
            }
        });
        this.clientSecret.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().clientSecret = ResourceOwnerGrantPage.this.clientSecret.getText();
                ResourceOwnerGrantPage.this.getBean().changed();
                ResourceOwnerGrantPage.this.getContainer().updateButtons();
            }
        });
        this.httpMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().httpMethod = ResourceOwnerGrantPage.this.httpMethod.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.httpMethod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().httpMethod = ResourceOwnerGrantPage.this.httpMethod.getText();
            }
        });
        if (!this.linker.isClientCredentialFlow) {
            this.username.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().userName = ResourceOwnerGrantPage.this.username.getText();
                    ResourceOwnerGrantPage.this.getBean().changed();
                    ResourceOwnerGrantPage.this.getContainer().updateButtons();
                }
            });
            this.password.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().password = ResourceOwnerGrantPage.this.password.getText();
                    ResourceOwnerGrantPage.this.getBean().changed();
                    ResourceOwnerGrantPage.this.getContainer().updateButtons();
                }
            });
        }
        this.access.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ResourceOwnerGrantPage)ResourceOwnerGrantPage.this).getBean().tokenURI = ResourceOwnerGrantPage.this.access.getText();
                ResourceOwnerGrantPage.this.updateGetTokenButton();
            }
        });
    }

    private ResourceOwnerGrantBean getBean() {
        return (ResourceOwnerGrantBean)this.linker.getBean();
    }

    private void updateGetTokenButton() {
        URL u = null;
        boolean ok = true;
        try {
            u = new URL(this.getBean().tokenURI);
        }
        catch (Exception ex) {
            ok = false;
        }
        this.getToken.setEnabled(ok);
    }

    public boolean isPageComplete() {
        return true;
    }

    private class ScopePopup
    extends Dialog {
        TreeViewer tv;
        List<String> res;

        protected ScopePopup(Shell parentShell) {
            super(parentShell);
            this.res = null;
            ResourceOwnerGrantPage.this.setTitle(Messages.ResourceOwnerGrantPage_15);
        }

        protected Control createDialogArea(Composite parent) {
            this.tv = new TreeViewer(parent, 68354);
            GridData gd = null;
            gd = new GridData(1808);
            this.tv.getControl().setLayoutData((Object)gd);
            gd.heightHint = 200;
            this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AuthorizationCodeGrantBean.ScopeProvider) {
                        return ((AuthorizationCodeGrantBean.ScopeProvider)element).name;
                    }
                    return super.getText(element);
                }

                public Image getImage(Object element) {
                    if (element instanceof AuthorizationCodeGrantBean.ScopeProvider) {
                        return ((AuthorizationCodeGrantBean.ScopeProvider)element).img;
                    }
                    return null;
                }
            });
            this.tv.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return element instanceof AuthorizationCodeGrantBean.ScopeProvider;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    Collection c = (Collection)inputElement;
                    return c.toArray(new Object[c.size()]);
                }

                public Object[] getChildren(Object parentElement) {
                    Set<String> c = ((AuthorizationCodeGrantBean.ScopeProvider)parentElement).scope.keySet();
                    return c.toArray(new Object[c.size()]);
                }
            });
            this.tv.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof String) || !((Collection)ResourceOwnerGrantPage.this.scopeViewer.getInput()).contains(element);
                }
            });
            this.tv.setAutoExpandLevel(-1);
            this.tv.setInput(AuthorizationCodeGrantBean.scopeProvider);
            return this.tv.getTree();
        }

        protected void okPressed() {
            this.res = new ArrayList<String>();
            IStructuredSelection s = (IStructuredSelection)this.tv.getSelection();
            if (!s.isEmpty()) {
                for (Object o : s.toList()) {
                    if (o instanceof String) {
                        this.res.add((String)o);
                        continue;
                    }
                    if (!(o instanceof AuthorizationCodeGrantBean.ScopeProvider)) continue;
                    this.res.addAll(((AuthorizationCodeGrantBean.ScopeProvider)o).scope.keySet());
                }
            }
            super.okPressed();
        }
    }
}

