/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.ClientCredentialGrantFlow;
import com.indy.addons.oauth2.wizard.OAuth2Wizard;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantFlow;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;

public class ResourceOwnerLinker
implements OAuth2Wizard.ILinker {
    private MdNode node;
    private boolean refreshBean = false;
    private ResourceOwnerGrantBean bean = new ResourceOwnerGrantBean();
    protected MdAttributeReader reader = new MdAttributeReader();
    private String _originalTokenURI = "";
    boolean isClientCredentialFlow = false;
    private OAuth2Wizard.FlowType flowType;

    public ResourceOwnerLinker(OAuth2Wizard.FlowType flowType) {
        this.flowType = flowType;
    }

    @Override
    public OAuth2Wizard.FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    @Override
    public Object getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    public String executeFlow(IWizard w) throws Exception {
        AuthorizationCodeGrantFlow.AccessTokenResponse response = null;
        if (this.isClientCredentialFlow) {
            ClientCredentialGrantFlow flow = new ClientCredentialGrantFlow((ResourceOwnerGrantBean)this.getBean());
            response = flow.getToken(w);
        } else {
            ResourceOwnerGrantFlow flow = new ResourceOwnerGrantFlow((ResourceOwnerGrantBean)this.getBean());
            response = flow.getToken(w);
        }
        if (response != null) {
            this.bean.responseInfo = response.allInfos;
        }
        return response.token;
    }

    private void refreshBean() {
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : null;
        try {
            this.bean.tokenURI = MdAttributeReader.readAttribute((String)"tokenEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._originalTokenURI = this.bean.tokenURI;
        try {
            this.bean.userName = MdAttributeReader.readAttribute((String)"username", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.password = MdAttributeReader.readAttribute((String)"password", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.clientId = MdAttributeReader.readAttribute((String)"clientId", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.clientSecret = MdAttributeReader.readAttribute((String)"clientSecret", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String clientCredentialPolicy = null;
        try {
            clientCredentialPolicy = MdAttributeReader.readAttribute((String)"sendClientCredentialsPolicy", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("".equals(clientCredentialPolicy)) {
            Boolean includeClientSecret = null;
            Boolean includeClientId = null;
            try {
                includeClientSecret = Boolean.valueOf(MdAttributeReader.readAttribute((String)"useClientSecret4TokenGeneration", (MdNode)this.node, (String)""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                includeClientId = Boolean.valueOf(MdAttributeReader.readAttribute((String)"useClientId4TokenGeneration", (MdNode)this.node, (String)""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clientCredentialPolicy = includeClientId != null && includeClientId.booleanValue() ? (includeClientSecret != null && includeClientSecret.booleanValue() ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET.getLabel() : OAuth2.CredentialMode.PARAMETER_CLIENT_ID.getLabel()) : OAuth2.CredentialMode.NONE.getLabel();
        }
        this.bean.credentialMode = OAuth2.CredentialMode.fromLabel((String)clientCredentialPolicy);
        try {
            this.bean.scopes = new ArrayList<String>(MdAttributeReader.readAttributeList((String)"scope", (MdNode)this.node));
        }
        catch (Exception includeClientSecret) {
            // empty catch block
        }
        try {
            this.bean.authParams = new HashMap(MdAttributeReader.readAttributeMap((String)"authorizationParameter", (MdNode)this.node));
        }
        catch (Exception includeClientSecret) {
            // empty catch block
        }
        try {
            this.bean.additionalHeaders = new HashMap(MdAttributeReader.readAttributeMap((String)"additionalHttpHeaders", (MdNode)this.node));
        }
        catch (Exception includeClientSecret) {
            // empty catch block
        }
        this.isClientCredentialFlow = false;
        try {
            String s = MdAttributeReader.readAttribute((String)"flowType", (MdNode)this.node, (String)"");
            if (OAuth2Wizard.FlowType.CLIENT_CREDENTIALS_GRANT.getValue().equals(s)) {
                this.isClientCredentialFlow = true;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            this.bean.httpMethod = MdAttributeReader.readAttribute((String)"tokenEndpointHttpMethod", (MdNode)this.node);
        }
        catch (Exception ex) {
            this.bean.httpMethod = "POST";
        }
        if (this.bean.httpMethod == null) {
            this.bean.httpMethod = "POST";
        }
        this.bean.preconfs.clear();
        boolean b = this._originalTokenURI.equals(AuthorizationCodeGrantBean.salesForceConf.tokenEndPoint);
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.ResourceOwnerLinker_15, null, this._originalTokenURI, b, b));
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.ResourceOwnerLinker_16, "", "", false, false));
        this.bean.preconfs.add(AuthorizationCodeGrantBean.googleConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.linkedInConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.salesForceConf);
    }

    @Override
    public void dispose() {
        this.node = null;
    }

    @Override
    public void updateMdNode() throws Exception {
        MdNode node = MdFactoryHelper.createMdNode((String)this.node.getDefType());
        node.setName(this.bean.name);
        node.setSubstituteContainer(this.node.getSubstituteContainer());
        this.setAttribute("clientId", this.bean.clientId, node);
        this.setAttribute("clientSecret", this.bean.clientSecret, node);
        this.setAttribute("password", this.bean.password, node);
        this.setAttribute("username", this.bean.userName, node);
        this.setAttribute("scope", this.bean.scopes, node);
        this.setAttribute("tokenEndpoint", this.bean.tokenURI, node);
        this.setAttribute("authorizationParameter", this.bean.authParams, node);
        this.setAttribute("additionalHttpHeaders", this.bean.additionalHeaders, node);
        this.setAttribute("sendClientCredentialsPolicy", this.bean.credentialMode.getLabel(), node);
        this.setAttribute("tokenEndpointHttpMethod", this.bean.httpMethod, node);
        this.setAttribute("flowType", this.flowType.getValue(), node);
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(node, this.node);
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedObject, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    private void setAttribute(String shortCode, Object value, MdNode n) {
        Property p = this.node.getLevel().getAttributeByShortCode(shortCode);
        Attribute a = MdFactoryHelper.createAttribute((String)(String.valueOf(this.node.getDefType()) + "." + shortCode));
        if (p.isUnbounded()) {
            boolean addedVal = false;
            if (p.isKeyValue()) {
                for (Object o : ((Map)value).keySet()) {
                    if (o == null) continue;
                    a.getValueEntry().put((Object)((String)o), (Object)((String)((Map)value).get(o)));
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            } else {
                for (Object o : (List)value) {
                    if (o == null) continue;
                    a.getValues().add((Object)o.toString());
                    addedVal = true;
                }
                if (addedVal) {
                    n.getAttribute().add((Object)a);
                }
            }
        } else {
            String v = null;
            if (value instanceof String) {
                if (!((String)value).trim().isEmpty()) {
                    v = (String)value;
                }
            } else {
                String string = v = value == null ? "" : value.toString();
            }
            if (p.getType() == PropertyType.PASSWORD) {
                try {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    v = semaphoreManager.setSemaphore(true, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (v != null) {
                a.setValue(v);
                n.getAttribute().add((Object)a);
            }
        }
    }

    @Override
    public boolean canFinish() {
        return true;
    }
}

