/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.externalvalueresolver.vault;

import com.indy.engine.core.IDecryptService;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.stambia.externalvalueresolver.vault.AppRoleAuthenticationService;
import com.stambia.externalvalueresolver.vault.BeanConfig;
import com.stambia.externalvalueresolver.vault.Messages;
import com.stambia.externalvalueresolver.vault.VaultTemplateCustom;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultResponse;
import org.springframework.web.client.RestTemplate;

public class VaultExternalValueResolverInternalPlugin
implements IExternalValueResolverPlugin {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TOKEN = "token";
    public static final String UNCRYPTED_TOKEN = "uncryptedToken";
    public static final String SCHEME = "scheme";
    public static final String START_PATH = "startPath";
    public static final String BACKEND_API_VERSION = "backendVersion";
    public static final String SECURITY_LEVEL = "securityLevel";
    public static final String AUTH_METHOD = "authMethod";
    public static final String ROLE_ID = "roleId";
    public static final String SECRET_ID = "secretId";
    public static final String NAMESPACE = "namespace";
    public static final String UNCRYPTED_SECRET_ID = "uncryptedSecretId";
    private static final String VALUE_NOT_FOUND_ERROR = Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_0);
    private static final String PATH_INCORRECT = Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_1);
    private static final String PATH_INVALID = Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_2);
    private static final String KEY_NOT_FOUND = Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_3);
    private VaultTemplate vaultTemplate;
    private String host;
    private String port;
    private String uncryptedToken;
    private String authMethod;
    private String roleId;
    private String secretId;
    private String uncryptedSecretId;
    private String namespace;
    private String scheme;
    private String startPath;
    private IExternalValueResolverPlugin.SecurityLevel securityLevel = IExternalValueResolverPlugin.SecurityLevel.level2;
    private VaultKeyValueOperationsSupport.KeyValueBackend backendAPI;
    private static final AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{BeanConfig.class});

    public void init(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        this.host = cnf.getProperty(HOST);
        if (this.host == null) {
            throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_4));
        }
        if (this.host.endsWith("/")) {
            this.host = this.host.substring(0, this.host.length() - 1);
        }
        this.authMethod = cnf.getProperty(AUTH_METHOD);
        if (this.authMethod == null || this.authMethod.equals(TOKEN)) {
            this.uncryptedToken = cnf.getProperty(UNCRYPTED_TOKEN);
            if (this.uncryptedToken == null) {
                String token = cnf.getProperty(TOKEN);
                if (token == null) {
                    throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_5));
                }
                IDecryptService decrypt = UtilsService.getDecryptService((String)"default");
                char[] chs = decrypt.decrypt("7A113D01950F4697AB3A492A2E53A9BF695A29FD5F7B8F5DF9C1E887F00472C3B074490C3521D8A3B67A19DAFB001F338889890B96CBCD1DEB50B7F6FCF1F871745B41292AA6A8CD1910B8A0E8366E123FE1136A9865606A5E1835025BB26C2D", token);
                if (chs == null) {
                    throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_6));
                }
                this.uncryptedToken = new String(chs);
            }
        } else if (this.authMethod.equals("appRole")) {
            this.roleId = cnf.getProperty(ROLE_ID);
            if (this.roleId == null) {
                throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_7));
            }
            this.namespace = cnf.getProperty(NAMESPACE);
            this.secretId = cnf.getProperty(SECRET_ID);
            if (this.secretId != null) {
                IDecryptService decrypt = UtilsService.getDecryptService((String)"default");
                char[] decryptSecretId = decrypt.decrypt("7A113D01950F4697AB3A492A2E53A9BF695A29FD5F7B8F5DF9C1E887F00472C3B074490C3521D8A3B67A19DAFB001F338889890B96CBCD1DEB50B7F6FCF1F871745B41292AA6A8CD1910B8A0E8366E123FE1136A9865606A5E1835025BB26C2D", this.secretId);
                if (decryptSecretId == null) {
                    throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_8));
                }
                this.uncryptedSecretId = new String(decryptSecretId);
            } else if (this.secretId == null) {
                this.uncryptedSecretId = cnf.getProperty(UNCRYPTED_SECRET_ID);
                if (this.uncryptedSecretId == null) {
                    throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_9));
                }
            }
        }
        this.port = cnf.getProperty(PORT);
        this.scheme = cnf.getProperty(SCHEME);
        this.startPath = cnf.getProperty(START_PATH);
        if (cnf.getProperty(SECURITY_LEVEL) != null) {
            throw new Exception(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_10));
        }
        String apiV = cnf.getProperty(BACKEND_API_VERSION);
        if (apiV == null) {
            throw new Exception(String.format(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_11), BACKEND_API_VERSION));
        }
        try {
            this.backendAPI = VaultKeyValueOperationsSupport.KeyValueBackend.valueOf((String)apiV);
        }
        catch (Exception ex) {
            throw new Exception(String.format(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_12), apiV, BACKEND_API_VERSION), ex);
        }
        if (this.port == null) {
            if (this.scheme == null) {
                this.port = "443";
            } else if (this.scheme.equals("http")) {
                this.port = "80";
            } else if (this.scheme.equals("https")) {
                this.port = "443";
            }
        }
        int portInt = Integer.parseInt(this.port);
        VaultEndpoint ep = VaultEndpoint.create((String)this.host, (int)portInt);
        if (this.scheme != null) {
            ep.setScheme(this.scheme);
        }
        if (this.authMethod == null || this.authMethod.equals(TOKEN)) {
            this.vaultTemplate = new VaultTemplate(ep, (ClientAuthentication)new TokenAuthentication(this.uncryptedToken));
        } else if (this.authMethod.equals("appRole")) {
            this.appRoleConnection();
        }
    }

    private void appRoleConnection() {
        AppRoleAuthenticationService appRoleAuthService = new AppRoleAuthenticationService((RestTemplate)context.getBean(RestTemplate.class), this.roleId, this.uncryptedSecretId, this.host, this.scheme, this.port, this.namespace);
        VaultEndpoint vaultEp = appRoleAuthService.vaultEndpoint();
        ClientAuthentication auth = appRoleAuthService.clientAuthentication();
        if (this.namespace != null) {
            LifecycleAwareSessionManager sessionManager = new LifecycleAwareSessionManager(auth, (TaskScheduler)appRoleAuthService.getTaskScheduler(), appRoleAuthService.restOperations());
            this.vaultTemplate = new VaultTemplateCustom(vaultEp, auth, this.namespace, sessionManager);
        } else {
            this.vaultTemplate = new VaultTemplate(vaultEp, auth);
        }
    }

    public IExternalValueResolverPlugin.Value getvalue(String key, IExternalValueResolverPlugin.SecurityLevel type) {
        String fullPath;
        IExternalValueResolverPlugin.Value value = new IExternalValueResolverPlugin.Value();
        if (type == IExternalValueResolverPlugin.SecurityLevel.level1 && this.securityLevel == IExternalValueResolverPlugin.SecurityLevel.level2) {
            value.errorMessage = String.format(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_13), key);
            return value;
        }
        String enginePath = "";
        String path = "";
        String vaultKey = "";
        if (this.startPath != null) {
            fullPath = this.startPath;
            fullPath = String.valueOf(fullPath) + key;
        } else {
            fullPath = key;
        }
        fullPath = this.correctPath(fullPath);
        int i = fullPath.indexOf("/", 1);
        int j = fullPath.lastIndexOf("/");
        if (i == j) {
            value.errorMessage = PATH_INVALID;
            return value;
        }
        enginePath = fullPath.substring(0, i);
        path = fullPath.substring(i + 1, j);
        vaultKey = fullPath.substring(j + 1);
        if (type == this.securityLevel || type == IExternalValueResolverPlugin.SecurityLevel.level2 && this.securityLevel == IExternalValueResolverPlugin.SecurityLevel.level1) {
            VaultKeyValueOperations ops = this.vaultTemplate.opsForKeyValue(enginePath, this.backendAPI);
            VaultResponse response = ops.get(path);
            if (response == null) {
                value.errorMessage = String.format(PATH_INCORRECT, key);
                return value;
            }
            String temp = (String)((Map)response.getData()).get(vaultKey);
            if (temp == null) {
                value.errorMessage = KEY_NOT_FOUND;
                return value;
            }
            value.data = temp.getBytes(Charset.forName("UTF-8"));
            if (!(value.data instanceof byte[])) {
                value.errorMessage = VALUE_NOT_FOUND_ERROR;
                return value;
            }
            return value;
        }
        value.errorMessage = String.format(Messages.getString(Messages.VaultExternalValueResolverInternalPlugin_15), type.name());
        return value;
    }

    public String correctPath(String path) {
        Pattern p = Pattern.compile("(\\/)\\1+");
        Matcher m = p.matcher(path);
        if (m.find()) {
            path = path.replaceAll("(\\/)\\1+", "/");
        }
        return path;
    }

    protected VaultExternalValueResolverInternalPlugin() {
    }
}

