/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant.xsl.gene;

import com.indy.ant.xsl.gene.Helper;
import com.indy.ant.xsl.gene.Messages;
import com.indy.xsl.gene.process.internal.configuration.MdConfigurationCompilation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MdConfigurationCallback
extends Task {
    private String folderPath;
    private String modelName;
    private String extPrefix;
    private String extSuffix;
    private boolean externalize;
    private boolean preserveExternalizationOffset = false;

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public void setExternalize(boolean externalize) {
        this.externalize = externalize;
    }

    public void setExtPrefix(String extPrefix) {
        this.extPrefix = extPrefix;
    }

    public void setExtSuffix(String extSuffix) {
        this.extSuffix = extSuffix;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setPreserveExternalizationOffset(boolean preserveExternalizationOffset) {
        this.preserveExternalizationOffset = preserveExternalizationOffset;
    }

    public void execute() throws BuildException {
        MdConfigurationCompilation mdCompiler = Helper.getHelper(this.getProject().getBaseDir().getPath(), this.getProject().getProperty("levelIconsPerDefType")).getMdCompiler();
        String outputFile = this.folderPath.replace("\\", "/").replace("/wrk1", "/wrk2");
        String configurationName = this.getProject().getProperty("conf");
        String configurationFileName = this.getProject().getProperty("conf.file");
        Properties properties = null;
        if (configurationFileName != null && !configurationFileName.isEmpty()) {
            try {
                properties = this.loadConfigurationFile(configurationFileName);
            }
            catch (FileNotFoundException ex) {
                this.log(String.format(Messages.MdConfigurationCallback_0, configurationFileName), 2);
            }
        }
        this.log(String.format(Messages.MdConfigurationCallback_1, this.folderPath, outputFile, configurationName));
        try {
            mdCompiler.compileMd(this.externalize, outputFile, this.folderPath, this.modelName, configurationName, this.extPrefix, this.extSuffix, properties, this.preserveExternalizationOffset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(Messages.MdConfigurationCallback_2, ex, 0);
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Properties loadConfigurationFile(String configurationFileName) throws FileNotFoundException {
        Properties p = new Properties();
        File file = new File(configurationFileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(String.format(Messages.MdConfigurationCallback_3, configurationFileName));
        }
        FileReader freader = null;
        BufferedReader lnreader = null;
        try {
            freader = new FileReader(file);
            lnreader = new LineNumberReader(freader);
            String line = null;
            while ((line = ((LineNumberReader)lnreader).readLine()) != null) {
                int curIndex;
                if (line.startsWith("#") || (curIndex = line.indexOf("/")) == -1) continue;
                String id = line.substring(0, curIndex);
                if (!(line = line.substring(curIndex + 1)).contains("=")) continue;
                curIndex = line.indexOf("=");
                String propName = line.substring(0, curIndex);
                if (curIndex + 1 >= line.length()) continue;
                String value = line.substring(curIndex + 1);
                p.setProperty(String.valueOf(id) + "/" + propName, value);
            }
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            this.log(String.format(Messages.MdConfigurationCallback_4, configurationFileName, ((LineNumberReader)lnreader).getLineNumber()), e, 1);
            return null;
        }
        finally {
            if (lnreader != null) {
                try {
                    lnreader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

