/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant.xsl.gene;

import com.indy.ant.xsl.gene.Helper;
import com.indy.ant.xsl.gene.Messages;
import com.indy.xsl.DiagnosticException;
import com.indy.xsl.gene.process.Graph;
import com.indy.xsl.gene.process.internal.OneProcCompilation;
import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class OneProcCompilatorCallback
extends Task
implements ErrorListener {
    private String modelURI;
    private String fileOutputFolder;
    public String mode;

    public void setModelURI(String modelURI) {
        int index;
        this.modelURI = modelURI;
        String lastSegment = this.getProject().getProperty("in.name");
        if (lastSegment != null && lastSegment.contains("\\") && (index = this.modelURI.lastIndexOf(lastSegment)) >= 0) {
            String suffix = this.modelURI.substring(index + lastSegment.length());
            this.modelURI = String.valueOf(this.modelURI.substring(0, index)) + lastSegment.replace("\\", "") + suffix;
        }
    }

    public void setOutputFolder(String fileOutputFolder) {
        this.fileOutputFolder = fileOutputFolder;
    }

    public void execute() throws BuildException {
        OneProcCompilation generator = Helper.getHelper(this.getProject().getBaseDir().getPath(), null).getProcCompoiler();
        File f = new File(this.fileOutputFolder != null ? this.fileOutputFolder : String.valueOf(this.getProject().getBaseDir().getPath()) + "/build/tmp/wrk3");
        String defaultScriptingEngine = this.getProject().getProperty("default.scripting");
        try {
            String conf = this.getProject().getProperty("conf");
            this.log(String.format(Messages.OneProcCompilatorCallback_0, this.modelURI, f.getAbsolutePath(), conf));
            String processAltId = generator.generateXSL(f, this.modelURI, conf, defaultScriptingEngine, this);
            this.project.setProperty("compileOneProcJava.processId", processAltId);
        }
        catch (Throwable ex) {
            ex = this.extractDiagnosticError(ex);
            this.log(String.valueOf(Messages.OneProcCompilatorCallback_1) + ex.getMessage(), 0);
            throw new BuildException(ex.getMessage(), ex);
        }
    }

    private Throwable extractDiagnosticError(Throwable t) {
        if (t instanceof XPathException && ((XPathException)t).getException() instanceof DiagnosticException) {
            return ((XPathException)t).getException();
        }
        return t;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        Throwable t = this.extractDiagnosticError(exception.getException());
        if (!(t instanceof DiagnosticException)) {
            t = exception;
        }
        this.log(t.getMessage(), 0);
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        Throwable t = this.extractDiagnosticError(exception.getException());
        if (!(t instanceof DiagnosticException)) {
            Expression expr;
            t = exception;
            SourceLocator locator = exception.getLocator();
            if (locator instanceof NodeInfo) {
                NodeInfo node = (NodeInfo)locator;
                XSLTemplate template = null;
                while (template == null && node != null) {
                    if (node instanceof XSLTemplate) {
                        template = (XSLTemplate)node;
                        continue;
                    }
                    if (node instanceof XSLFunction) {
                        if (((XSLFunction)node).getObjectName().toString().equals("func:repetitionValues")) {
                            node = (NodeInfo)locator;
                            while (node != null && !(node instanceof XSLWhen)) {
                                node = node.getParent();
                            }
                            if (node == null) continue;
                            String hash = ((XSLWhen)node).getAttributeValue("test");
                            hash = hash.replace("$queryHash=", "").replace("'", "");
                            StringBuffer b = new StringBuffer();
                            for (Graph.Node n : Graph.getCurrentGraph().findByRepetitionQueryHash(hash)) {
                                if (b.length() > 0) {
                                    b.append("\n");
                                }
                                b.append("- " + n.getDiagnosticPath());
                            }
                            if (b.length() <= 0) break;
                            t = new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_2, b.toString()), exception);
                            break;
                        }
                        NodeInfo n = node.getParent();
                        t = new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_3, ((XSLFunction)node).getObjectName(), n instanceof XSLStylesheet ? ((XSLStylesheet)n).getBaseURI() : ""), exception);
                        break;
                    }
                    node = node.getParent();
                }
                if (template != null) {
                    String templateName = template.getTemplateName().getLocalName();
                    DiagnosticException d = this.diagnostic(templateName, exception);
                    if (d != null) {
                        throw d;
                    }
                } else if (t instanceof DiagnosticException) {
                    throw (DiagnosticException)t;
                }
            } else if (locator instanceof Expression && (expr = (Expression)locator).getContainer() instanceof Template) {
                try {
                    DiagnosticException d;
                    String tplName = ((Template)expr.getContainer()).getTemplateName().getLocalName();
                    if (tplName != null && (d = this.diagnostic(tplName, exception)) != null) {
                        d = new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_5, d.getMessage(), exception.getMessage(), expr.toString()), exception);
                        throw d;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        throw exception;
    }

    private DiagnosticException diagnostic(String templateName, Exception ex) {
        if (templateName.contains("_")) {
            int i = templateName.indexOf("_");
            String teplType = templateName.substring(0, i);
            String objectId = templateName.substring(i + 1);
            if (teplType.equals("initParameter")) {
                return new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_6, Graph.getCurrentGraph().getParameterDiagnosticPath(objectId)), ex);
            }
            if (teplType.equals("initVar")) {
                return new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_7, Graph.getCurrentGraph().getXslVariableDiagnosticPath(objectId)), ex);
            }
            Graph.Node n = Graph.getCurrentGraph().getNodeBySrcId(objectId);
            if (n != null) {
                String type = null;
                if (teplType.equals("initAction")) {
                    type = "code";
                } else if (teplType.equals("initExecutionConditionLink")) {
                    type = "executionCondition";
                } else if (teplType.equals("initStepDynamicName")) {
                    type = "dynamicName";
                } else if (teplType.equals("initStepSemaphoreName")) {
                    type = "semaphoreName";
                }
                return new DiagnosticException(String.format(Messages.OneProcCompilatorCallback_8, type, n.getDiagnosticPath()), ex);
            }
        }
        return null;
    }
}

