/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant.xsl.gene;

import com.indy.ant.xsl.gene.Messages;
import com.indy.ant.xsl.gene.XSLGeneratorUDFCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class UDFXslGenerator {
    String[] avoidEscape = new String[]{"&#xD;", "&#xA;", "&#x9;"};
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();

    private static String formatCode(Map<String, String> prefix, String udfCode) throws Exception {
        Lexer l = new Lexer(prefix.keySet(), udfCode);
        Token token = null;
        Node root = new Node(token);
        Stack<Node> stack = new Stack<Node>();
        stack.push(root);
        while ((token = l.read()) != null) {
            Node n = new Node(token);
            ((Node)stack.peek()).addChildren(n);
            if (token.event == Event.END_FUNCTION) {
                stack.pop();
                continue;
            }
            if (token.event != Event.START_FUNCTION && token.event != Event.UDF) continue;
            stack.push(n);
        }
        Visitor v = new Visitor(prefix);
        v.accept(root);
        return v.getResult();
    }

    public void generateXsl(List<XSLGeneratorUDFCallback.LightUDF> udfs, File userXslFile, boolean append) throws Exception {
        HashMap<String, String> udfPrefixReplacements = new HashMap<String, String>();
        HashMap<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix = new HashMap<XSLGeneratorUDFCallback.LightUDF, String>();
        ArrayList<XSLGeneratorUDFCallback.LightUDF> implementedUDF = new ArrayList<XSLGeneratorUDFCallback.LightUDF>();
        for (XSLGeneratorUDFCallback.LightUDF u : udfs) {
            if (u.implPerCode.isEmpty()) continue;
            implementedUDF.add(u);
            String prefix = u.prefix;
            if (prefix == null || prefix.trim().isEmpty()) {
                prefix = "udf";
            }
            String libId = u.libId;
            libId = libId.replace("-", "_");
            libId = String.valueOf(libId) + "_";
            udfPrefixReplacements.put(prefix, libId);
            udfPRefix.put(u, "udf:" + libId);
        }
        if (append && userXslFile.exists()) {
            if (implementedUDF.isEmpty()) {
                return;
            }
            TransformerFactory f = TransformerFactory.newInstance();
            try {
                f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            TransformerHandler serializer = ((SAXTransformerFactory)f).newTransformerHandler();
            File tmpFile = new File(String.valueOf(userXslFile.getAbsolutePath()) + ".agg");
            EscapingBufferedOutputStream os = new EscapingBufferedOutputStream(new FileOutputStream(tmpFile));
            StreamResult res = new StreamResult(os);
            serializer.setResult(res);
            XslAggregatorFilter filter = new XslAggregatorFilter(os, implementedUDF, udfPRefix, udfPrefixReplacements);
            filter.setContentHandler(serializer);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(filter);
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(userXslFile));
                reader.parse(new InputSource(is));
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            userXslFile.delete();
            tmpFile.renameTo(userXslFile);
            return;
        }
        FilterOutputStream os = null;
        XMLStreamWriter xmlWriter = null;
        try {
            userXslFile.getParentFile().mkdirs();
            os = new EscapingBufferedOutputStream(new FileOutputStream(userXslFile));
            xmlWriter = outputFactory.createXMLStreamWriter(os, "UTF-8");
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("xsl", "stylesheet", "http://www.w3.org/1999/XSL/Transform");
            xmlWriter.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
            xmlWriter.writeNamespace("fn", "http://www.w3.org/2005/02/xpath-functions");
            xmlWriter.writeNamespace("md", "http://www.stambia.com/md");
            xmlWriter.writeNamespace("mdj", "java:com.indy.xsl.global.Functions");
            xmlWriter.writeNamespace("mds", "java:com.indy.xsl.global.Strings");
            xmlWriter.writeNamespace("mdv", "java:com.indy.xsl.global.Variables");
            xmlWriter.writeNamespace("proc", "http://www.example.org/proc");
            xmlWriter.writeNamespace("saxon", "http://saxon.sf.net/");
            xmlWriter.writeNamespace("sql", "java://com.indy.xsl.sql.SQLElementFactory");
            xmlWriter.writeNamespace("tech", "http://www.stambia.com/tech");
            xmlWriter.writeNamespace("udf", "http://www.stambia.com/udf");
            xmlWriter.writeNamespace("user", "http://www.stambia.com/user");
            xmlWriter.writeAttribute("extension-element-prefixes", "saxon sql");
            for (XSLGeneratorUDFCallback.LightUDF u : implementedUDF) {
                xmlWriter.writeStartElement("xsl:function");
                xmlWriter.writeAttribute("name", String.valueOf(udfPRefix.get(u)) + u.name);
                xmlWriter.writeStartElement("xsl:param");
                xmlWriter.writeAttribute("name", "context");
                xmlWriter.writeEndElement();
                for (String p : u.parameters) {
                    xmlWriter.writeStartElement("xsl:param");
                    xmlWriter.writeAttribute("name", p);
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeStartElement("xsl:variable");
                xmlWriter.writeAttribute("name", "var");
                xmlWriter.writeStartElement("xsl:choose");
                String defaultCode = null;
                boolean hasImpl = false;
                for (String productCode : u.implPerCode.keySet()) {
                    String code = u.implPerCode.get(productCode);
                    if ("__default__".equals(productCode)) {
                        if (defaultCode != null) continue;
                        defaultCode = code;
                        continue;
                    }
                    if (code == null || code.trim().isEmpty()) continue;
                    hasImpl = true;
                    xmlWriter.writeStartElement("xsl:when");
                    xmlWriter.writeAttribute("test", "$context/ancestor-or-self::product/@code='" + productCode + "'");
                    xmlWriter.writeStartElement("xsl:value-of");
                    try {
                        try {
                            ((EscapingBufferedOutputStream)os).escape = true;
                            xmlWriter.writeAttribute("select", UDFXslGenerator.formatCode(udfPrefixReplacements, code));
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.UDFXslGenerator_0, productCode, u.libId), ex);
                        }
                    }
                    finally {
                        ((EscapingBufferedOutputStream)os).escape = false;
                    }
                    xmlWriter.writeEndElement();
                    xmlWriter.writeEndElement();
                }
                if (defaultCode != null && !defaultCode.isEmpty()) {
                    if (hasImpl) {
                        xmlWriter.writeStartElement("xsl:otherwise");
                    } else {
                        xmlWriter.writeStartElement("xsl:when");
                        xmlWriter.writeAttribute("test", "1=1");
                    }
                    xmlWriter.writeStartElement("xsl:value-of");
                    try {
                        try {
                            ((EscapingBufferedOutputStream)os).escape = true;
                            xmlWriter.writeAttribute("select", UDFXslGenerator.formatCode(udfPrefixReplacements, defaultCode));
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.UDFXslGenerator_3, u.libId), ex);
                        }
                    }
                    finally {
                        ((EscapingBufferedOutputStream)os).escape = false;
                    }
                    xmlWriter.writeEndElement();
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("xsl:value-of");
                xmlWriter.writeAttribute("select", "string($var)");
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected String getImplementationCode(XSLGeneratorUDFCallback.LightUDF udf, String productCode) {
        return udf.implPerCode.get(productCode);
    }

    private class EscapingBufferedOutputStream
    extends BufferedOutputStream {
        boolean escape;

        public EscapingBufferedOutputStream(OutputStream out) {
            super(out);
            this.escape = false;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (!this.escape) {
                super.write(b);
            } else {
                char c = (char)b;
                String specWhiteChar = null;
                switch (c) {
                    case '\r': {
                        specWhiteChar = "&#xD;";
                        break;
                    }
                    case '\n': {
                        specWhiteChar = "&#xA;";
                        break;
                    }
                    case '\t': {
                        specWhiteChar = "&#x9;";
                    }
                }
                if (specWhiteChar != null) {
                    char[] cArray = specWhiteChar.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char a = cArray[n2];
                        super.write(a);
                        ++n2;
                    }
                } else {
                    super.write(b);
                }
            }
        }
    }

    private static enum Event {
        START_FUNCTION,
        END_FUNCTION,
        STRING,
        PARAMETER,
        DATA,
        SEPARATOR,
        UDF,
        WHITESPACE;

    }

    private static class Lexer {
        private Queue<Token> readTokens = new LinkedList<Token>();
        private char previousChar;
        private String data;
        private int curIndex;
        private Collection<String> prefixes;

        public Lexer(Collection<String> prefixes, String data) {
            this.data = data;
            this.prefixes = prefixes;
        }

        public Token read() throws Exception {
            if (!this.readTokens.isEmpty()) {
                return this.readTokens.poll();
            }
            StringBuffer buf = new StringBuffer();
            while (this.curIndex < this.data.length() && this.readTokens.isEmpty()) {
                char currentChar = this.data.charAt(this.curIndex++);
                block0 : switch (currentChar) {
                    case '\'': {
                        if (buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuffer();
                        buf.append(currentChar);
                        while (this.curIndex < this.data.length()) {
                            this.previousChar = currentChar;
                            currentChar = this.data.charAt(this.curIndex++);
                            if (this.previousChar != '\\' && currentChar == '\'') {
                                buf.append(currentChar);
                                this.readTokens.add(new Token(buf.toString(), Event.STRING));
                                buf = new StringBuffer();
                                break block0;
                            }
                            buf.append(currentChar);
                            if (this.curIndex != this.data.length()) continue;
                            throw new Exception(String.format(Messages.UDFXslGenerator_1, buf.toString()));
                        }
                        break;
                    }
                    case '(': {
                        buf.append(currentChar);
                        String v = buf.toString();
                        String[] p = v.split("\\s+");
                        String fName = p[p.length - 1];
                        boolean prefixed = false;
                        for (String s : this.prefixes) {
                            if (!fName.startsWith(String.valueOf(s) + "::")) continue;
                            prefixed = true;
                            break;
                        }
                        if (prefixed) {
                            this.readTokens.add(new Token(buf.toString(), Event.UDF));
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.START_FUNCTION));
                        break;
                    }
                    case ')': {
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuffer();
                        this.readTokens.add(new Token(null, Event.END_FUNCTION));
                        break;
                    }
                    case '$': {
                        if (this.data.charAt(this.curIndex) == '{') {
                            int i = this.data.indexOf("}$", this.curIndex - 1);
                            buf.append(this.data.substring(this.curIndex - 1, i + 2));
                            this.curIndex = i + 2;
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                            buf = new StringBuffer();
                            break;
                        }
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuffer();
                        while (this.curIndex < this.data.length()) {
                            if (Character.isJavaIdentifierPart(currentChar = this.data.charAt(this.curIndex++))) {
                                buf.append(currentChar);
                                continue;
                            }
                            --this.curIndex;
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.PARAMETER));
                        buf = new StringBuffer();
                        break;
                    }
                    case ',': {
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        this.readTokens.add(new Token(null, Event.SEPARATOR));
                        buf = new StringBuffer();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(currentChar)) {
                            buf.append(currentChar);
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        this.readTokens.add(new Token(String.valueOf(currentChar), Event.WHITESPACE));
                        buf = new StringBuffer();
                    }
                }
                this.previousChar = currentChar;
            }
            if (this.curIndex >= this.data.length() && buf.length() > 0) {
                this.readTokens.add(new Token(buf.toString(), Event.DATA));
            }
            return this.readTokens.isEmpty() ? null : this.readTokens.poll();
        }
    }

    private static class Node {
        Token token;
        Node parent = null;
        List<Node> children = new ArrayList<Node>();

        Node(Token token) {
            this.token = token;
        }

        void addChildren(Node child) {
            if (this.token != null && this.token.event == Event.UDF) {
                if (child.token.event == Event.WHITESPACE || child.token.event == Event.SEPARATOR) {
                    return;
                }
                if (child.token.event == Event.DATA && child.token.val.isEmpty()) {
                    return;
                }
            }
            child.parent = this;
            this.children.add(child);
        }
    }

    private static class Token {
        String val;
        Event event;

        Token(String val, Event event) {
            this.val = val;
            this.event = event;
        }
    }

    private static class Visitor {
        StringBuffer buf = new StringBuffer();
        Map<String, String> prefix;

        Visitor(Map<String, String> prefix) {
            this.prefix = prefix;
        }

        void accept(Node root) {
            if (root.children.size() == 0) {
                return;
            }
            this.buf.append("concat(");
            if (root.children.size() == 1) {
                this.buf.append("'', ");
            }
            for (Node n : root.children) {
                this.visit(n);
            }
            this.buf.append(")");
        }

        void visit(Node n) {
            boolean needComa = false;
            if (n.parent.token != null && n.parent.token.event == Event.UDF && n.parent.children.indexOf(n) == n.parent.children.size() - 1) {
                needComa = false;
            } else if (n.parent.children.indexOf(n) > 0 || n.parent.token != null && n.parent.token.event == Event.START_FUNCTION) {
                needComa = true;
            }
            if (needComa) {
                this.buf.append(", ");
            }
            switch (n.token.event) {
                case DATA: {
                    this.buf.append("'" + n.token.val + "'");
                    break;
                }
                case STRING: {
                    this.buf.append("'" + n.token.val.replace("'", "''") + "'");
                    break;
                }
                case PARAMETER: {
                    this.buf.append("$" + n.token.val);
                    break;
                }
                case SEPARATOR: {
                    this.buf.append("','");
                    break;
                }
                case UDF: {
                    for (String s : this.prefix.keySet()) {
                        if (!n.token.val.startsWith(String.valueOf(s) + "::")) continue;
                        this.buf.append(String.valueOf(n.token.val.replace(String.valueOf(s) + "::", "udf:" + this.prefix.get(s))) + "$context");
                        break;
                    }
                    if (n.children.size() <= 1) break;
                    this.buf.append(",");
                    break;
                }
                case START_FUNCTION: {
                    this.buf.append("'" + n.token.val + "'");
                    break;
                }
                case END_FUNCTION: {
                    if (n.parent.token != null && n.parent.token.event == Event.START_FUNCTION) {
                        this.buf.append("')'");
                        break;
                    }
                    this.buf.append(")");
                    break;
                }
                case WHITESPACE: {
                    String sss = "";
                    char[] cArray = n.token.val.toCharArray();
                    int n2 = cArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        char currentChar = cArray[n3];
                        sss = String.valueOf(sss) + currentChar;
                        ++n3;
                    }
                    this.buf.append("'" + sss + "'");
                }
            }
            for (Node c : n.children) {
                this.visit(c);
            }
        }

        String getResult() {
            return this.buf.toString();
        }
    }

    private static class XslAggregatorFilter
    extends XMLFilterImpl {
        List<XSLGeneratorUDFCallback.LightUDF> implementedUDF;
        HashMap<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix;
        HashMap<String, String> udfPrefixReplacements;
        EscapingBufferedOutputStream os;
        Stack<String> elementStack = new Stack();
        Set<String> functionNames = new HashSet<String>();

        public XslAggregatorFilter(EscapingBufferedOutputStream os, List<XSLGeneratorUDFCallback.LightUDF> implementedUDF, HashMap<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix, HashMap<String, String> udfPrefixReplacements) {
            this.implementedUDF = implementedUDF;
            this.udfPRefix = udfPRefix;
            this.udfPrefixReplacements = udfPrefixReplacements;
            this.os = os;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.elementStack.size() == 1) {
                for (XSLGeneratorUDFCallback.LightUDF u : this.implementedUDF) {
                    if (this.functionNames.contains(String.valueOf(this.udfPRefix.get(u)) + u.name)) continue;
                    AttributesImpl a = new AttributesImpl();
                    a.addAttribute("", "name", "name", "CDATA", String.valueOf(this.udfPRefix.get(u)) + u.name);
                    super.startElement(uri, "function", "xsl:function", a);
                    a = new AttributesImpl();
                    a.addAttribute("", "name", "name", "CDATA", "context");
                    super.startElement(uri, "param", "xsl:param", a);
                    super.endElement(uri, "param", "xsl:param");
                    for (String p : u.parameters) {
                        a = new AttributesImpl();
                        a.addAttribute("", "name", "name", "CDATA", p);
                        super.startElement(uri, "param", "xsl:param", a);
                        super.endElement(uri, "param", "xsl:param");
                    }
                    a = new AttributesImpl();
                    a.addAttribute("", "name", "name", "CDATA", "var");
                    super.startElement(uri, "variable", "xsl:variable", a);
                    a = new AttributesImpl();
                    super.startElement(uri, "choose", "xsl:choose", a);
                    for (String productCode : u.implPerCode.keySet()) {
                        String code = u.implPerCode.get(productCode);
                        if (code == null || code.trim().isEmpty()) continue;
                        a = new AttributesImpl();
                        a.addAttribute("", "test", "test", "CDATA", "$context/ancestor-or-self::product/@code='" + productCode + "'");
                        super.startElement(uri, "when", "xsl:when", a);
                        a = new AttributesImpl();
                        try {
                            try {
                                a.addAttribute("", "select", "select", "CDATA", UDFXslGenerator.formatCode(this.udfPrefixReplacements, code));
                                this.os.escape = true;
                                super.startElement(uri, "value-of", "xsl:value-of", a);
                            }
                            catch (Exception ex) {
                                throw new SAXException(String.format(Messages.UDFXslGenerator_0, productCode, u.libId), ex);
                            }
                        }
                        finally {
                            this.os.escape = false;
                        }
                        super.endElement(uri, "value-of", "xsl:value-of");
                        super.endElement(uri, "when", "xsl:when");
                    }
                    super.endElement(uri, "choose", "xsl:choose");
                    super.endElement(uri, "variable", "xsl:variable");
                    a = new AttributesImpl();
                    a.addAttribute("", "select", "select", "CDATA", "string($var)");
                    super.startElement(uri, "value-of", "xsl:value-of", a);
                    super.endElement(uri, "value-of", "xsl:value-of");
                    super.endElement(uri, "function", "xsl:function");
                }
            }
            super.endElement(uri, localName, qName);
            this.elementStack.pop();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.elementStack.push(localName);
            if (localName.equals("function")) {
                this.functionNames.add(atts.getValue("name"));
            }
            super.startElement(uri, localName, qName, atts);
        }
    }
}

