/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene;

import com.indy.xsl.gene.GenerationMap;
import com.indy.xsl.gene.Messages;
import com.indy.xsl.global.Functions;
import com.indy.xsl.global.XPathEvaluatorI;
import com.indy.xsl.global.XSLException;
import com.indy.xsl.global.Xpath;
import com.indy.xsl.saxon.extension.impl.Configuration4Generation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;

public class GenerationEvaluator {
    private Map<String, List<String[]>> evaluationMap = new HashMap<String, List<String[]>>();
    private Map<String, String> pathMap = new HashMap<String, String>();
    private NodeInfo rootNode;
    private GenerationMap geneMap;

    public GenerationEvaluator(GenerationMap geneMap) {
        this.geneMap = geneMap;
    }

    public void generateExpression(XPathContext context, NodeInfo documentRootNode) throws XPathException, XPathExpressionException, XSLException {
        this.rootNode = documentRootNode;
        for (String nodeId : this.evaluationMap.keySet()) {
            for (String[] entries : this.evaluationMap.get(nodeId)) {
                String genMapKey = entries[0];
                if (this.geneMap.getCode(genMapKey) != null) continue;
                String expression = entries[1];
                String nodePath = this.pathMap.get(nodeId);
                List l = Functions.evaluate(context, this.rootNode, nodePath);
                if (l.isEmpty()) {
                    throw new XPathException(String.format(Messages.GenerationEvaluator_0, nodePath, this.rootNode.getBaseURI()));
                }
                NodeInfo node = (NodeInfo)l.get(0);
                boolean isExternalizationMode = genMapKey.startsWith("ext.") && node.getConfiguration() instanceof Configuration4Generation;
                try {
                    try {
                        if (isExternalizationMode) {
                            ((Configuration4Generation)node.getConfiguration()).enablePlaceHolderSupport(true);
                        }
                        String value = this.evaluateX(context, node, expression);
                        this.geneMap.store(genMapKey, value);
                    }
                    catch (Exception ex) {
                        throw new XPathException(String.format(Messages.GenerationEvaluator_1, expression, nodePath, this.rootNode.getBaseURI()), (Throwable)ex);
                    }
                }
                finally {
                    if (isExternalizationMode) {
                        ((Configuration4Generation)node.getConfiguration()).enablePlaceHolderSupport(false);
                    }
                }
            }
        }
        this.evaluationMap.clear();
    }

    public void addEvaluationExpression(String nodeId, String nodePath, String genMapKey, String expression) {
        this.pathMap.put(nodeId, nodePath);
        List<String[]> l = this.evaluationMap.get(nodeId);
        if (l == null) {
            l = new ArrayList<String[]>();
            this.evaluationMap.put(nodeId, l);
        }
        l.add(new String[]{genMapKey, expression});
    }

    public String evaluateX(XPathContext context, NodeInfo node, String expression) throws Exception {
        String toEval;
        String s = new String(expression);
        StringBuffer buf = new StringBuffer();
        while (s.contains("%{")) {
            int sstart = s.indexOf("%{");
            int send = s.indexOf("}%", sstart);
            if (send < 0) break;
            if (sstart > 0) {
                buf.append(s.substring(0, sstart));
            }
            toEval = s.substring(sstart + 2, send);
            s = s.substring(send + 2);
            List r = Functions.getMdRef(context, node, toEval);
            if (r == null) {
                XPathEvaluatorI eval = Functions.getXPathEvaluator(node, context.getController());
                Object o = eval.evaluate("../variable[@name='" + toEval + "']/tech:columnName()", node, XPathConstants.NODESET);
                for (Object v : (Collection)o) {
                    if (v instanceof NodeInfo) {
                        buf.append(((NodeInfo)v).getStringValue());
                        continue;
                    }
                    buf.append(v.toString());
                }
                continue;
            }
            if (!r.isEmpty()) {
                NodeInfo mdLinkNode = (NodeInfo)r.get(0);
                List res = Xpath.call(context, (ValueRepresentation)mdLinkNode, "columnName");
                if (res == null) continue;
                for (Object o : res) {
                    if (o instanceof NodeInfo) {
                        buf.append(((NodeInfo)o).getStringValue());
                        continue;
                    }
                    buf.append(o.toString());
                }
                continue;
            }
            throw new Exception(String.format(Messages.GenerationEvaluator_2, toEval));
        }
        buf.append(s);
        s = new String(buf.toString());
        buf = new StringBuffer();
        while (s.contains("%x{")) {
            int start = s.indexOf("%x{");
            int end = s.indexOf("}x%", start);
            if (end < 0) break;
            if (start > 0) {
                String sub = s.substring(0, start);
                while (sub.contains("%{")) {
                    int sstart = sub.indexOf("%{");
                    int send = sub.indexOf("}%", sstart);
                    if (send < 0) break;
                    if (sstart > 0) {
                        buf.append(sub.substring(0, sstart));
                    }
                    String toEval2 = sub.substring(sstart + 2, send);
                    sub = sub.substring(send + 2);
                    List r = Functions.getMdRef(context, node, toEval2);
                    if (r == null) {
                        XPathEvaluatorI eval = Functions.getXPathEvaluator(node, context.getController());
                        Object o = eval.evaluate("../variable[@name='" + toEval2 + "']/tech:columnName()", node, XPathConstants.NODESET);
                        for (Object v : (Collection)o) {
                            if (v instanceof NodeInfo) {
                                buf.append(((NodeInfo)v).getStringValue());
                                continue;
                            }
                            buf.append(v.toString());
                        }
                        continue;
                    }
                    if (!r.isEmpty()) {
                        NodeInfo mdLinkNode = (NodeInfo)r.get(0);
                        List res = Xpath.call(context, (ValueRepresentation)mdLinkNode, "columnName");
                        for (Object o : res) {
                            if (o instanceof NodeInfo) {
                                buf.append(((NodeInfo)o).getStringValue());
                                continue;
                            }
                            buf.append(o.toString());
                        }
                        continue;
                    }
                    throw new Exception(String.format(Messages.GenerationEvaluator_2, toEval2));
                }
                buf.append(sub);
            }
            toEval = s.substring(start + 3, end);
            s = s.substring(end + 3);
            Object o = Functions.evaluate(context, node, toEval, XPathConstants.STRING);
            buf.append(o);
        }
        buf.append(s);
        return buf.toString();
    }
}

