/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene.checksum;

import com.indy.xsl.gene.checksum.DeliveryChecksumNode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Deprecated
public class DeliveryParser {
    public DeliveryChecksumNode parse(InputStream is, ParserConfiguration conf) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        DeliveryContentHandler handler = new DeliveryContentHandler(conf);
        saxReader.setContentHandler(handler);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        InputSource source = new InputSource(reader);
        saxReader.parse(source);
        ((Reader)reader).close();
        return handler.root;
    }

    class DeliveryContentHandler
    implements ContentHandler {
        ParserConfiguration conf;
        Stack<DeliveryChecksumNode> stack = new Stack();
        Stack<String> ignoredStack = new Stack();
        DeliveryChecksumNode root;
        StringBuffer buf = null;

        public DeliveryContentHandler(ParserConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.buf != null && this.buf.length() > 0 && !this.stack.isEmpty()) {
                String s = this.buf.toString();
                this.buf = null;
                boolean empty = true;
                char[] cArray = s.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isWhitespace(c)) {
                        empty = false;
                        break;
                    }
                    ++n2;
                }
                if (!empty) {
                    this.stack.peek().appendToContent(s);
                }
            }
            if (this.conf.isIgnoredElement(qName)) {
                this.ignoredStack.push(qName);
            } else {
                DeliveryChecksumNode current = new DeliveryChecksumNode(qName, this.conf.getAttributeKeyOrder(qName));
                int i = 0;
                while (i < atts.getLength()) {
                    String n = atts.getLocalName(i);
                    if (!this.conf.getIgnoredAttribute(qName).contains(n)) {
                        current.setAttribute(n, atts.getValue(n));
                    }
                    ++i;
                }
                if (!this.stack.isEmpty()) {
                    this.stack.peek().addChildren(current);
                } else {
                    this.root = current;
                }
                this.stack.push(current);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.ignoredStack.isEmpty()) {
                this.ignoredStack.pop();
            } else {
                this.stack.pop();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.ignoredStack.isEmpty()) {
                if (this.buf == null) {
                    this.buf = new StringBuffer();
                }
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    public static class ParserConfiguration {
        private Map<String, Set<String>> ignoredAttributesPerElementName = new HashMap<String, Set<String>>();
        private Map<String, List<String>> elementOrderKey = new HashMap<String, List<String>>();
        private Set<String> ignoredElements = new HashSet<String>();

        public ParserConfiguration() throws Exception {
            this(new BufferedInputStream(DeliveryParser.class.getResourceAsStream("deliveries-checksum-configuration.properties")));
        }

        public ParserConfiguration(InputStream is) throws Exception {
            Properties p = new Properties();
            try {
                p.load(is);
            }
            finally {
                is.close();
            }
            for (Object o : p.keySet()) {
                Collection<String> l;
                if ("ignoredElements".equals(o)) {
                    this.ignoredElements.addAll(Arrays.asList(p.getProperty((String)o).split(",")));
                    continue;
                }
                String[] k = ((String)o).split("\\.");
                if ("elementKey".equals(k[0])) {
                    l = this.elementOrderKey.get(k[1]);
                    if (l == null) {
                        l = new ArrayList<String>();
                        this.elementOrderKey.put(k[1], (List<String>)l);
                    }
                    l.addAll(Arrays.asList(p.getProperty((String)o).split(",")));
                    continue;
                }
                if (!"ignoredAttributes".equals(k[0])) continue;
                l = this.ignoredAttributesPerElementName.get(k[1]);
                if (l == null) {
                    l = new HashSet();
                    this.ignoredAttributesPerElementName.put(k[1], (Set<String>)l);
                }
                l.addAll(Arrays.asList(p.getProperty((String)o).split(",")));
            }
        }

        boolean isIgnoredElement(String elementName) {
            return this.ignoredElements.contains(elementName);
        }

        public List<String> getAttributeKeyOrder(String elementName) {
            return this.elementOrderKey.get(elementName);
        }

        public Set<String> getIgnoredAttribute(String elementName) {
            Set<String> l = this.ignoredAttributesPerElementName.get(elementName);
            if (l == null) {
                return Collections.EMPTY_SET;
            }
            return l;
        }
    }
}

