/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene.process.internal;

import com.indy.xsl.gene.process.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XSLParseGenerator {
    private XMLStreamWriter writer;

    public XSLParseGenerator(XMLStreamWriter writer) {
        this.writer = writer;
    }

    protected void generateXSLStuff(Graph graph) throws XMLStreamException {
        ArrayList<String> templatesName = new ArrayList<String>();
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("xsl:stylesheet");
        this.writer.writeNamespace("mdj", "java:com.indy.xsl.global.Functions");
        this.writer.writeNamespace("mdv", "java:com.indy.xsl.global.Variables");
        this.writer.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.writer.writeNamespace("ref", "http://www.stambia.com/ref");
        this.writer.writeNamespace("saxon", "http://saxon.sf.net/");
        this.writer.writeNamespace("tech", "http://www.stambia.com/tech");
        this.writer.writeNamespace("indyParse", "http://www.stambia.com/indyParse");
        this.writer.writeNamespace("ecore", "http://www.eclipse.org/emf/2002/Ecore");
        this.writer.writeNamespace("proc", "http://www.example.org/proc");
        this.writer.writeNamespace("func", "http://www.stambia.com/func");
        this.writer.writeNamespace("rdbms", "http://www.stambia.com/rdbms");
        this.writer.writeNamespace("md", "http://www.stambia.com/md");
        this.writer.writeNamespace("user", "http://www.stambia.com/user");
        this.writer.writeNamespace("UUID", "java.util.UUID");
        this.writer.writeNamespace("mds", "java:com.indy.xsl.global.Strings");
        this.writer.writeNamespace("map", "http://www.stambia.com/map");
        this.writer.writeNamespace("saxono", "http://www.example.org/saxono");
        this.writer.writeNamespace("xslo", "http://www.example.org/xslo");
        this.writer.writeNamespace("gen", "java:com.indy.xsl.gene.GenerationMap");
        this.writer.writeAttribute("version", "2.0");
        this.writer.writeAttribute("extension-element-prefixes", "saxon ref indyParse tech");
        this.writer.writeAttribute("exclude-result-prefixes", "ecore tech UUID proc func md rdbms mds user mdj mdv tech map saxon gen");
        this.writer.writeStartElement("xsl:output");
        this.writer.writeAttribute("method", "xml");
        this.writer.writeAttribute("encoding", "UTF-8");
        this.writer.writeAttribute("cdata-section-elements", "generationCondition executionCondition code step resultCode metaData");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:preserve-space");
        this.writer.writeAttribute("elements", "code CData resultCode");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:namespace-alias");
        this.writer.writeAttribute("stylesheet-prefix", "xslo");
        this.writer.writeAttribute("result-prefix", "xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:namespace-alias");
        this.writer.writeAttribute("stylesheet-prefix", "saxono");
        this.writer.writeAttribute("result-prefix", "saxon");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:include");
        this.writer.writeAttribute("href", "global.xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:include");
        this.writer.writeAttribute("href", "parse.xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "substitutionMap");
        this.writer.writeEndElement();
        this.writeGenTpl();
        this.writeSubsitutionTpl();
        this.writer.writeStartElement("xsl:template");
        this.writer.writeAttribute("name", "main");
        this.writer.writeAttribute("match", "/");
        this.writer.writeStartElement("root");
        templatesName.addAll(this.writeParseTemplate(graph));
        this.writer.writeStartElement("xsl:for-each");
        this.writer.writeAttribute("select", "node");
        this.writer.writeStartElement("xsl:call-template");
        this.writer.writeAttribute("name", "substitute");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    private void writeSubsitutionTpl() throws XMLStreamException {
        this.writer.writeStartElement("xsl:template");
        this.writer.writeAttribute("name", "substitute");
        this.writer.writeStartElement("xsl:if");
        this.writer.writeAttribute("test", "gen:getCode($substitutionMap, concat(@id, '.condition'))='' and matches(@condition, '\\$\\{[a-zA-Z\\d_ ]*\\}\\$')");
        this.writer.writeStartElement("xsl:value-of");
        this.writer.writeAttribute("select", "gen:store($substitutionMap, concat(@id, '.condition'), mdj:resolveExpressionValue(@condition))");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:if");
        this.writer.writeAttribute("test", "gen:getCode($substitutionMap, concat(@id, '.repetitionQuery'))='' and matches(@repetitionQuery, '\\$\\{[a-zA-Z\\d_ ]*\\}\\$')");
        this.writer.writeStartElement("xsl:value-of");
        this.writer.writeAttribute("select", "gen:store($substitutionMap, concat(@id, '.repetitionQuery'), mdj:resolveExpressionValue(@repetitionQuery))");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:for-each");
        this.writer.writeAttribute("select", "./node");
        this.writer.writeStartElement("xsl:call-template");
        this.writer.writeAttribute("name", "substitute");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeGenTpl() throws XMLStreamException {
        this.writer.writeStartElement("xsl:template");
        this.writer.writeAttribute("name", "parseExpression");
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "__srcCode");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "__templateId");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:choose");
        this.writer.writeStartElement("xsl:when");
        this.writer.writeAttribute("test", "matches($__srcCode, '[%\\{]')");
        this.writer.writeStartElement("xsl:variable");
        this.writer.writeAttribute("name", "current");
        this.writer.writeAttribute("select", "mds:prepareToParse1($__srcCode,1)");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:variable");
        this.writer.writeAttribute("name", "parse");
        this.writer.writeAttribute("select", "saxon:parse($current)");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:variable");
        this.writer.writeAttribute("name", "__parseVar");
        this.writer.writeStartElement("xsl:apply-templates");
        this.writer.writeAttribute("mode", "parse");
        this.writer.writeAttribute("select", "$parse");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xslo:template");
        this.writer.writeStartElement("xsl:attribute");
        this.writer.writeAttribute("name", "name");
        this.writer.writeStartElement("xsl:value-of");
        this.writer.writeAttribute("select", "$__templateId");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:copy-of");
        this.writer.writeAttribute("select", "$__parseVar");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:otherwise");
        this.writer.writeStartElement("xslo:template");
        this.writer.writeStartElement("xsl:attribute");
        this.writer.writeAttribute("name", "name");
        this.writer.writeStartElement("xsl:value-of");
        this.writer.writeAttribute("select", "$__templateId");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:copy-of");
        this.writer.writeAttribute("select", "$__srcCode");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private Collection<String> writeParseTemplate(Graph graph) throws XMLStreamException {
        HashSet<String> res = new HashSet<String>();
        for (Graph.Node n : graph.getNodes()) {
            String srcId;
            StringBuffer sb = new StringBuffer();
            for (String s : n.getContext().getMdLinkVariables()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            for (Graph.Parameter p : n.getContext().getParameters()) {
                if (!p.needParse() || !res.add("initParameter_" + p.md5Id)) continue;
                this.writeCallTpl("initParameter_" + p.md5Id, p.value, sb.toString());
            }
            if (n instanceof Graph.Action) {
                if (((Graph.Action)n).getActionCode() != null && ((Graph.Action)n).needParse() && res.add("initAction_" + ((Graph.Action)n).getSrcId())) {
                    this.writeCallTpl("initAction_" + ((Graph.Action)n).getSrcId(), ((Graph.Action)n).getActionCode(), sb.toString());
                }
                if (((Graph.Action)n).getModuleName() != null && ((Graph.Action)n).needParseModuleName() && res.add("initActionModuleName_" + ((Graph.Action)n).getSrcId())) {
                    this.writeCallTpl("initActionModuleName_" + ((Graph.Action)n).getSrcId(), ((Graph.Action)n).getModuleName(), sb.toString());
                }
            }
            if (n.getModelInfo().needParse4SemaphoreName() && res.add("initStepSemaphoreName_" + (srcId = n.getBaseId()))) {
                this.writeCallTpl("initStepSemaphoreName_" + srcId, n.getModelInfo().semaphoreName, sb.toString());
            }
            if (n.getModelInfo().needParse4DynamicName() && res.add("initStepDynamicName_" + (srcId = n.getBaseId()))) {
                this.writeCallTpl("initStepDynamicName_" + srcId, n.getModelInfo().dynamicName, sb.toString());
            }
            for (Graph.XslVariable v : n.getContext().variables) {
                if (!v.needParse() || !res.add("initVar_" + v.md5Id) || v.id.endsWith("_this")) continue;
                this.writeCallTpl("initVar_" + v.md5Id, v.code, sb.toString());
            }
            if (n.getType() != Graph.Type.LINK || !n.getModelInfo().needParse()) continue;
            this.writeCallTpl("initExecutionConditionLink_" + n.getSrcId(), n.getModelInfo().executionCondition, sb.toString());
        }
        return res;
    }

    private void writeCallTpl(String tplId, String code, String mdLinkVariables) throws XMLStreamException {
        this.writer.writeStartElement("xsl:call-template");
        this.writer.writeAttribute("name", "parseExpression");
        this.writer.writeStartElement("xsl:with-param");
        this.writer.writeAttribute("name", "__templateId");
        this.writer.writeCharacters(tplId);
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:with-param");
        this.writer.writeAttribute("name", "__mdLinkNamesSet");
        this.writer.writeAttribute("tunnel", "yes");
        this.writer.writeAttribute("select", "tokenize('" + mdLinkVariables + "', ',')");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:with-param");
        this.writer.writeAttribute("name", "__srcCode");
        this.writer.writeCharacters(code);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }
}

