/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.global;

import com.indy.xsl.global.Messages;
import com.indy.xsl.global.UnsupportedEscapingFormatException;
import com.indy.xsl.parser.XslParser;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class Strings {
    public static String[] split(String str, String regex) {
        return str.split(regex);
    }

    public static void main(String[] argv) throws UnsupportedEncodingException {
        String str = "0D0A";
        String encoded = Strings.encodeOctalString(Strings.decodeHexString(str));
        System.out.println(encoded);
        System.out.println(Strings.decodeHexString(encoded, false));
        String encode = Strings.encodeHexString("\u00a3");
        String decode = Strings.decodeHexString(encode);
        String tmp = Strings.decodeHexString("14");
        String code = "%x{hey(ho)} %}%";
        String _code = code.replaceAll("\\}%", tmp);
        _code = _code.replaceAll("(%([\\w]*)\\{[^" + tmp + "]*)(" + tmp + ")", "$1}$2%");
        _code = _code.replaceAll(tmp, "}%");
        System.out.println(Strings.countOf("tottotot", "t"));
        System.out.println(Strings.replace("fefgef${defefez}$fefef", "${", "${{"));
    }

    public static int countOf(String str, String exp) {
        int retour = 0;
        String str2 = str;
        while (str2.lastIndexOf(exp) >= 0) {
            ++retour;
            str2 = str2.substring(0, str2.lastIndexOf(exp));
        }
        return retour;
    }

    public static String replace(String str, String target, String replacement) {
        return str.replace(target, replacement);
    }

    public static String replaceAll(String str, String target, String replacement) {
        String[] regexp = new String[]{target};
        String[] replace = new String[]{replacement};
        return Strings.replaceAll(str, regexp, replace);
    }

    public static String replaceAll3(String src, String start, String newStart, String middle, String newMiddle, String end, String newEnd) {
        String[] regexp = new String[]{start, middle, end};
        String[] replacement = new String[]{newStart, newMiddle, newEnd};
        return Strings.replaceAll(src, regexp, replacement);
    }

    public static String replaceAll(String src, String[] regexp, String[] replacement) {
        if (regexp.length == replacement.length) {
            String retour = "";
            String pattern = "";
            int i = 0;
            while (i < regexp.length) {
                pattern = String.valueOf(pattern) + regexp[i];
                ++i;
            }
            Pattern pDeb = Pattern.compile(pattern);
            Matcher mDeb = pDeb.matcher(src);
            int lastFin = 0;
            while (mDeb.find()) {
                int iDeb = mDeb.start();
                int iFin = mDeb.end();
                retour = String.valueOf(retour) + src.substring(lastFin, iDeb);
                String str = src.substring(iDeb, iFin);
                String tmp = "";
                int i2 = 0;
                while (i2 < regexp.length) {
                    Matcher t = Pattern.compile(regexp[i2]).matcher(str);
                    t.find();
                    int size = t.end() - t.start();
                    if (size > 0) {
                        tmp = replacement[i2] == null || replacement[i2].equals("md:nullValue") ? String.valueOf(tmp) + str.substring(t.start(), t.end()) : String.valueOf(tmp) + replacement[i2];
                    }
                    str = str.substring(size);
                    ++i2;
                }
                retour = String.valueOf(retour) + tmp;
                lastFin = iFin;
            }
            retour = String.valueOf(retour) + src.substring(lastFin, src.length());
            return retour;
        }
        return src;
    }

    public static String replaceAll2(String src, String regex1, String regex2, String replacement) {
        String retour = "";
        Pattern pDeb = Pattern.compile(regex1);
        Matcher mDeb = pDeb.matcher(src);
        int lastFin = 0;
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            retour = String.valueOf(retour) + src.substring(lastFin, iDeb);
            String temp = src.substring(iDeb, iFin).replaceAll(regex2, replacement);
            retour = String.valueOf(retour) + temp;
            lastFin = iFin;
        }
        retour = String.valueOf(retour) + src.substring(lastFin, src.length());
        return retour;
    }

    public static String encodeHexString(String sourceText, boolean replaceSpecialChar) throws UnsupportedEncodingException {
        String tmp = null;
        if (replaceSpecialChar) {
            tmp = sourceText.replaceAll("\\\\n", "\n");
            tmp = tmp.replaceAll("\\\\t", "\t");
            tmp = tmp.replaceAll("\\\\r", "\r");
            tmp = tmp.replaceAll("\\\\f", "\f");
        } else {
            tmp = sourceText;
        }
        byte[] rawData = tmp.getBytes("UTF8");
        StringBuffer hexText = new StringBuffer();
        String initialHex = null;
        int initHexLength = 0;
        int i = 0;
        while (i < rawData.length) {
            int positiveValue = rawData[i] & 0xFF;
            initialHex = Integer.toHexString(positiveValue);
            initHexLength = initialHex.length();
            while (initHexLength++ < 2) {
                hexText.append("0");
            }
            hexText.append(initialHex);
            ++i;
        }
        return hexText.toString().toUpperCase();
    }

    public static String encodeHexString(String sourceText) throws UnsupportedEncodingException {
        return Strings.encodeHexString(sourceText, true);
    }

    public static String encodeOctalString(String sourceText, boolean replaceSpecialChar) throws UnsupportedEncodingException {
        String tmp = null;
        if (replaceSpecialChar) {
            tmp = sourceText.replaceAll("\\\\n", "\n");
            tmp = tmp.replaceAll("\\\\t", "\t");
            tmp = tmp.replaceAll("\\\\r", "\r");
            tmp = tmp.replaceAll("\\\\f", "\f");
        } else {
            tmp = sourceText;
        }
        byte[] rawData = tmp.getBytes("UTF8");
        StringBuffer octalText = new StringBuffer();
        String initialOctal = null;
        int initOctalLength = 0;
        int i = 0;
        while (i < rawData.length) {
            int positiveValue = rawData[i] & 0xFF;
            initialOctal = Integer.toOctalString(positiveValue);
            initOctalLength = initialOctal.length();
            while (initOctalLength++ < 3) {
                octalText.append("0");
            }
            octalText.append(initialOctal);
            ++i;
        }
        return octalText.toString().toUpperCase();
    }

    public static String encodeOctalString(String sourceText) throws UnsupportedEncodingException {
        return Strings.encodeOctalString(sourceText, true);
    }

    public static String decodeHexString(String hexa) throws UnsupportedEncodingException {
        return Strings.decodeHexString(hexa, true);
    }

    public static String decodeHexString(String hexa, boolean replaceSpecialChar) throws UnsupportedEncodingException {
        if (hexa.length() % 2 == 0) {
            String txtInHex = hexa;
            byte[] txtInByte = new byte[txtInHex.length() / 2];
            int j = 0;
            int i = 0;
            while (i < txtInHex.length()) {
                txtInByte[j++] = (byte)Integer.parseInt(txtInHex.substring(i, i + 2), 16);
                i += 2;
            }
            String txt = new String(txtInByte, "UTF8");
            if (replaceSpecialChar) {
                String result = "";
                int i2 = 0;
                while (i2 < txt.length()) {
                    result = txt.charAt(i2) == '\n' ? String.valueOf(result) + "\\n" : (txt.charAt(i2) == '\t' ? String.valueOf(result) + "\\t" : (txt.charAt(i2) == '\r' ? String.valueOf(result) + "\\r" : (txt.charAt(i2) == '\f' ? String.valueOf(result) + "\\f" : String.valueOf(result) + txt.charAt(i2))));
                    ++i2;
                }
                return result;
            }
            return txt;
        }
        return "";
    }

    public static String decodeOctalString(String octal) throws UnsupportedEncodingException {
        return Strings.decodeOctalString(octal, true);
    }

    public static String decodeOctalString(String octal, boolean replaceSpecialChar) throws UnsupportedEncodingException {
        if (octal.length() % 3 == 0) {
            String txtInOctal = octal;
            byte[] txtInByte = new byte[txtInOctal.length() / 3];
            int j = 0;
            int i = 0;
            while (i < txtInOctal.length()) {
                txtInByte[j++] = (byte)Integer.parseInt(txtInOctal.substring(i, i + 3), 8);
                i += 3;
            }
            String txt = new String(txtInByte, "UTF8");
            if (replaceSpecialChar) {
                String result = "";
                int i2 = 0;
                while (i2 < txt.length()) {
                    result = txt.charAt(i2) == '\n' ? String.valueOf(result) + "\\n" : (txt.charAt(i2) == '\t' ? String.valueOf(result) + "\\t" : (txt.charAt(i2) == '\r' ? String.valueOf(result) + "\\r" : (txt.charAt(i2) == '\f' ? String.valueOf(result) + "\\f" : String.valueOf(result) + txt.charAt(i2))));
                    ++i2;
                }
                return result;
            }
            return txt;
        }
        return "";
    }

    public static String escape(String textToEscape, String format) throws UnsupportedEscapingFormatException {
        String escapedText = "";
        switch (format = format.toUpperCase()) {
            case "CSV": {
                escapedText = StringEscapeUtils.escapeCsv((String)textToEscape);
                break;
            }
            case "ECMASCRIPT": {
                escapedText = StringEscapeUtils.escapeEcmaScript((String)textToEscape);
                break;
            }
            case "HTML3": {
                escapedText = StringEscapeUtils.escapeHtml3((String)textToEscape);
                break;
            }
            case "HTML4": {
                escapedText = StringEscapeUtils.escapeHtml4((String)textToEscape);
                break;
            }
            case "JAVA": {
                escapedText = StringEscapeUtils.escapeJava((String)textToEscape);
                break;
            }
            case "JSON": {
                escapedText = StringEscapeUtils.escapeJson((String)textToEscape);
                break;
            }
            case "XML10": {
                escapedText = StringEscapeUtils.escapeXml10((String)textToEscape);
                break;
            }
            case "XML11": {
                escapedText = StringEscapeUtils.escapeXml11((String)textToEscape);
                break;
            }
            case "XSI": {
                escapedText = StringEscapeUtils.unescapeXSI((String)textToEscape);
                break;
            }
            default: {
                throw new UnsupportedEscapingFormatException(String.format(Messages.Strings_0, format));
            }
        }
        return escapedText;
    }

    public static String decodeSpecialChar(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t").replaceAll("\\\\r", "\r").replaceAll("\\\\f", "\f");
    }

    public static String prepareToParse1(String str, int mode) throws XslParser.XSLParseException {
        String middle;
        String start = "<indyParse:root xmlns:indyParse=\"http://www.stambia.com/indyParse\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xslo=\"http://www.example.org/xslo\" xmlns:saxono=\"http://www.example.org/saxono\">";
        String end = "</indyParse:root>";
        if (str != null && !str.isEmpty()) {
            String _code = Strings.removeSpecialCharacter(str, mode);
            XslParser parser = new XslParser(_code);
            parser.parse();
            middle = parser.printXml();
        } else {
            middle = str;
        }
        return String.valueOf(start) + middle + end;
    }

    public static String prepareToParse1Bak(String str, int mode) throws UnsupportedEncodingException {
        String _code = Strings.removeSpecialCharacter(str, mode);
        String start = "<indyParse:root xmlns:indyParse=\"http://www.stambia.com/indyParse\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"> ";
        String tmp = Strings.decodeHexString("14");
        _code = _code.replaceAll("\\}%", tmp);
        _code = _code.replaceAll("(%([\\w]*)\\{[^\\{" + tmp + "]*)(" + tmp + ")", "$1}$2%");
        _code = _code.replaceAll(tmp, "}%");
        _code = _code.replaceAll("%(\\w*)\\((\\w*)\\)\\{", "%$1 language=\"$2\"{");
        _code = _code.replaceAll("}(\\w*)\\((\\w*)\\)%", "}$1%");
        _code = _code.replaceAll("\\}(\\w*)%", "</indyParse:$1>");
        _code = _code.replaceAll("%(\\w*)( [^%^\\{]*)?\\{", "<indyParse:$1$2>");
        String end = "</indyParse:root>";
        _code = String.valueOf(start) + _code + end;
        return _code;
    }

    public static String prepareToParse2(String str, int mode) {
        String _code = Strings.restoreSpecialCharacter(str, mode);
        String start = "<tmp xmlns:indyParse=\"http://www.stambia.com/indyParse\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"  xmlns:xslo=\"http://www.example.org/xslo\" xmlns:saxono=\"http://www.example.org/saxono\">";
        String end = "</tmp>";
        _code = String.valueOf(start) + _code + end;
        return _code;
    }

    public static String restoreSpecialCharacter(String str, int mode) {
        String retour = str.replaceAll("\u00a4\u00a4\u00a3\u00a4\u00a4", "<").replaceAll("\u00a7\u00a7\u00a4\u00a7\u00a7", "&").replaceAll("\u00a3\u00a3\u00a4\u00a3\u00a3", "<>");
        return retour;
    }

    public static String removeSpecialCharacter(String str, int mode) {
        String retour = str;
        return retour;
    }
}

