/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;

public class Variables {
    public static String string = "";
    public static int integer;
    public static ArrayList<String> stringList;
    public static Map<String, String> map;
    public static Map<String, Map> allMaps;
    public static Map<QName, ValueRepresentation> valueRepresentationMap;
    public static Map<QName, MetaDataLinkPath> metaDataLinkPathMap;
    private static Map<String, String> metaDataLinkPathIdMap;
    static Map<String, String> properties;
    static Variables INSTANCE;

    static {
        stringList = new ArrayList();
        allMaps = new HashMap<String, Map>();
        valueRepresentationMap = new HashMap<QName, ValueRepresentation>();
        metaDataLinkPathMap = new HashMap<QName, MetaDataLinkPath>();
        metaDataLinkPathIdMap = new HashMap<String, String>();
        INSTANCE = new Variables();
    }

    public static void resetVariableSet() {
        valueRepresentationMap = new HashMap<QName, ValueRepresentation>();
    }

    public static void resetProperties() {
        properties = new HashMap<String, String>();
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String prop) {
        if (properties != null) {
            return properties.get(prop);
        }
        return null;
    }

    public static List getMapKeys() {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(map.keySet());
        return list;
    }

    public static void resetMetaDataLinkSet() {
        metaDataLinkPathMap = new HashMap<QName, MetaDataLinkPath>();
    }

    public static String addMetaDataLinkPath(String name, String value) {
        if (name != null) {
            MetaDataLinkPath mdlp = metaDataLinkPathMap.get(QName.valueOf(name));
            if (mdlp == null) {
                mdlp = INSTANCE.new MetaDataLinkPath();
                metaDataLinkPathMap.put(QName.valueOf(name), mdlp);
            }
            String id = mdlp.addValue(value);
            return id;
        }
        return null;
    }

    public static String getMetaDataLinkPath(String name) {
        MetaDataLinkPath mdlp;
        if (name != null && (mdlp = metaDataLinkPathMap.get(QName.valueOf(name))) != null) {
            return mdlp.currentValue;
        }
        return null;
    }

    public static void removeMetaDataLinkPath(String name, String id) {
        MetaDataLinkPath mdlp;
        if (name != null && (mdlp = metaDataLinkPathMap.get(QName.valueOf(name))) != null) {
            mdlp.removeValue(id);
            if (mdlp.isEmpty()) {
                metaDataLinkPathMap.remove(QName.valueOf(name));
            }
        }
    }

    public static void addVariable(String name, ValueRepresentation value) {
        valueRepresentationMap.put(QName.valueOf(name), value);
    }

    public static ValueRepresentation getVariable(String name) {
        return valueRepresentationMap.get(QName.valueOf(name));
    }

    public static void addMap(String key, String value) {
        if (map == null) {
            Variables.resetMap();
        }
        map.put(key, value);
    }

    public static String getMapValue(String key) {
        if (map == null) {
            Variables.resetMap();
        }
        String value = map.get(key);
        return value;
    }

    public static List getMapKeys(String mapName) {
        Map map = allMaps.get(mapName);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        list.addAll(map.keySet());
        return list;
    }

    public static void resetMap() {
        map = new TreeMap<String, String>();
    }

    public static void resetAllMap() {
        Variables.resetMap();
        if (allMaps != null) {
            allMaps.clear();
        }
    }

    public static void resetMap(String name) {
        TreeMap map = new TreeMap();
        allMaps.put(name, map);
    }

    public static void putMapValue(String mapName, String key, String value) {
        Map map = allMaps.get(mapName);
        if (map == null) {
            Variables.resetMap(mapName);
        }
        map = allMaps.get(mapName);
        map.put(key, value);
    }

    public static void putMapNode(String mapName, String key, NodeInfo value) {
        Map map = allMaps.get(mapName);
        if (map == null) {
            Variables.resetMap(mapName);
        }
        map = allMaps.get(mapName);
        map.put(key, value);
    }

    public static NodeInfo getMapNode(String mapName, String key) {
        Map map = allMaps.get(mapName);
        if (map == null) {
            Variables.resetMap(mapName);
            return null;
        }
        return (NodeInfo)map.get(key);
    }

    public static String getMapValue(String mapName, String key) {
        Map map = allMaps.get(mapName);
        if (map == null) {
            Variables.resetMap(mapName);
            return null;
        }
        return (String)map.get(key);
    }

    public static void setString(String str) {
        string = str;
    }

    public static void setString(int indice, String str) {
        if (stringList.size() < indice + 1) {
            stringList.add(str);
        } else {
            stringList.set(indice, str);
        }
    }

    public static String getString(int indice) {
        return stringList.get(indice);
    }

    public static String getString() {
        return string;
    }

    public static void setInteger(int i) {
        integer = i;
    }

    public static int getInteger() {
        return integer;
    }

    public static void addVariableToStackFrame(XPathContext c, String varName, ValueRepresentation val) {
        XPathContext o = c.getCaller();
        XPathContextMajor contextMajor = (XPathContextMajor)(c instanceof XPathContextMajor ? c : (o instanceof XPathContextMajor ? o : null));
        if (contextMajor != null) {
            StackFrame oldstack = contextMajor.getStackFrame();
            SlotManager slot = oldstack.getStackFrameMap();
            int position = -1;
            int j = -1;
            for (Object k : oldstack.getStackFrameMap().getVariableMap()) {
                ++j;
                if (!(k instanceof StructuredQName) || !k.equals(StructuredQName.fromClarkName((String)varName))) continue;
                position = j;
            }
            if (position == -1) {
                position = oldstack.getStackFrameMap().allocateSlotNumber(StructuredQName.fromClarkName((String)varName));
                ValueRepresentation[] vars = oldstack.getStackFrameValues();
                ValueRepresentation[] newvars = new ValueRepresentation[vars.length + 1];
                System.arraycopy(vars, 0, newvars, 0, vars.length);
                contextMajor.setStackFrame(oldstack.getStackFrameMap(), newvars);
            }
            contextMajor.setLocalVariable(position, val);
        }
    }

    class MetaDataLinkPath {
        String currentValue;
        List<String> precValues = new ArrayList<String>();
        List<String> precIds = new ArrayList<String>();

        MetaDataLinkPath() {
        }

        String addValue(String value) {
            String id = UUID.randomUUID().toString();
            this.precValues.add(value);
            this.precIds.add(id);
            this.currentValue = value;
            return id;
        }

        void removeValue(String id) {
            int index = this.precIds.indexOf(id);
            this.precIds.remove(index);
            this.precValues.remove(index);
            this.currentValue = this.precValues.size() > 0 ? this.precValues.get(this.precValues.size() - 1) : null;
        }

        public boolean isEmpty() {
            return this.precIds.isEmpty();
        }
    }
}

