/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.global;

import com.indy.xsl.global.XPathExpressionImplI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathEvaluator;

public class XPathEvaluatorI
extends XPathEvaluator {
    protected Receiver receiver;
    protected Controller controller;
    private static Map<String, String> namespaces = new HashMap<String, String>();
    private static Map<String, String> uris = new HashMap<String, String>();
    private HashMap<String, XPathExpressionImplI> cachedXPathExpression = new HashMap();
    private HashMap<String, XPathExpression> basecachedXPathExpression = new HashMap();

    static {
        namespaces.put("mdj", "java:com.indy.xsl.global.Functions");
        uris.put(namespaces.get("mdj"), "mdj");
        namespaces.put("mdv", "java:com.indy.xsl.global.Variables");
        uris.put(namespaces.get("mdv"), "mdv");
        namespaces.put("mds", "java:com.indy.xsl.global.Strings");
        uris.put(namespaces.get("mds"), "mds");
        namespaces.put("md", "http://www.stambia.com/md");
        uris.put(namespaces.get("md"), "md");
        namespaces.put("set", "http://exslt.org/sets");
        uris.put(namespaces.get("set"), "set");
        namespaces.put("tech", "http://www.stambia.com/tech");
        uris.put(namespaces.get("tech"), "tech");
        namespaces.put("user", "http://www.stambia.com/user");
        uris.put(namespaces.get("user"), "user");
        namespaces.put("rdbms", "http://www.stambia.com/rdbms");
        uris.put(namespaces.get("rdbms"), "rdbms");
        namespaces.put("ref", "http://www.stambia.com/re");
        uris.put(namespaces.get("ref"), "ref");
        namespaces.put("internal", "http://www.stambia.com/internal");
        uris.put(namespaces.get("internal"), "internal");
        namespaces.put("indyParse", "http://www.stambia.com/indyParse");
        uris.put(namespaces.get("indyParse"), "indyParse");
        namespaces.put("udf", "http://www.stambia.com/udf");
        uris.put(namespaces.get("udf"), "udf");
    }

    public XPathEvaluatorI(Source source) throws XPathException {
        super(source);
    }

    public XPathEvaluatorI(Configuration config) {
        super(config);
    }

    public void setMessageEmitter(Receiver messageEmitter) {
        this.receiver = messageEmitter;
    }

    public void initControler(Controller controller) {
        this.controller = controller;
        if (controller != null) {
            this.setMessageEmitter(controller.getMessageEmitter());
            FunctionLibraryList fl = (FunctionLibraryList)controller.getExecutable().getFunctionLibrary();
            this.getExecutable().setFunctionLibrary((FunctionLibrary)fl);
            this.getExecutable().setRuleManager(controller.getExecutable().getRuleManager());
            Bindery b = controller.getBindery();
            if (b.getGlobalVariableMap() != null) {
                SlotManager sm = this.getExecutable().getGlobalVariableMap();
                sm.setNumberOfVariables(b.getGlobalVariableMap().getNumberOfVariables());
                for (Object o : b.getGlobalVariableMap().getVariableMap()) {
                    sm.getVariableMap().add(o);
                }
            }
            Bindery bindery = b;
        }
    }

    public void initNamespaces() {
        this.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)namespaces.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)uris.get(namespaceURI);
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
    }

    public Object evaluate2(String expr, Object node, QName mode, boolean doJavaConversion) throws XPathExpressionException {
        if (expr.trim().equals("")) {
            return null;
        }
        XPathExpressionImplI exp = this.compile2(expr, doJavaConversion);
        exp.setMessageEmitter(this.receiver);
        return exp.evaluate(node, mode);
    }

    public XPathExpressionImplI compile2(String expr, boolean doJavaConversion) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        try {
            String cacheKey = String.valueOf(expr) + "." + doJavaConversion;
            XPathExpressionImplI x = this.cachedXPathExpression.get(cacheKey);
            if (x == null) {
                x = this.createExpressionInternal2(expr, doJavaConversion);
                this.cachedXPathExpression.put(cacheKey, x);
            }
            return x;
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public XPathExpression compile(String expr) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        XPathExpression x = this.basecachedXPathExpression.get(expr);
        if (x == null) {
            x = super.compile(expr);
            this.basecachedXPathExpression.put(expr, x);
        }
        return x;
    }

    protected XPathExpressionImplI createExpressionInternal2(String expression, boolean doJavaConvertion) throws XPathException {
        XPathVariableResolver o = this.getXPathVariableResolver();
        Expression exp = ExpressionTool.make((String)expression, (StaticContext)this.getStaticContext(), (int)0, (int)-1, (int)1, (boolean)false);
        ExpressionVisitor visitor = ExpressionVisitor.make((StaticContext)this.getStaticContext());
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.getStaticContext().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)exp, (int)0, (SlotManager)map);
        exp.setContainer((Container)this.getStaticContext());
        XPathExpressionImplI xpe = this.controller == null ? new XPathExpressionImplI(exp, this.getExecutable(), doJavaConvertion) : new XPathExpressionImplI(exp, this.controller, doJavaConvertion);
        xpe.setStackFrameMap(map);
        return xpe;
    }
}

