/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xpath.XPathEvaluator;

public class XpathCache {
    private XPathContext context;
    private List value;
    private static TreeMap<String, XpathCache> cache = new TreeMap();
    private static TreeMap<String, NodeInfo> queryCache = new TreeMap();
    public static Map catchVariableMap = new HashMap();

    public XpathCache(XPathContext context, List value) {
        this.context = context;
        this.value = value;
    }

    public static void resetCache() {
        if (cache != null) {
            cache.clear();
        }
        cache = null;
        cache = new TreeMap();
    }

    public static List getValue(XPathContext context, String id) {
        XpathCache xc;
        if (cache != null && (xc = cache.get(id)) != null) {
            if (xc.context.getConfiguration().isCompatible(context.getConfiguration())) {
                return xc.value;
            }
            cache.remove(id);
            return null;
        }
        return null;
    }

    public static void putValue(XPathContext context, String id, List value) {
        if (cache != null) {
            cache.put(id, new XpathCache(context, value));
        }
    }

    public static NodeInfo xpathCache(XPathContext c, NodeInfo context, String query) throws XPathExpressionException {
        NodeInfo retour = XpathCache.getNode(c, query);
        if (retour == null) {
            XPathEvaluator xpe = new XPathEvaluator(c.getConfiguration());
            retour = (NodeInfo)xpe.evaluate(query, (Object)context, XPathConstants.NODE);
            XpathCache.putNode(c, query, retour);
        }
        return retour;
    }

    public static NodeInfo xpathCache(XPathContext c, String query) throws XPathExpressionException {
        NodeInfo retour = XpathCache.getNode(c, query);
        if (retour == null) {
            XPathEvaluator xpe = new XPathEvaluator(c.getConfiguration());
            retour = (NodeInfo)xpe.evaluate(query, (Object)c, XPathConstants.NODE);
            queryCache.put(query, retour);
        }
        return retour;
    }

    public static NodeInfo putNode(XPathContext c, String name, NodeInfo nodeInfo) throws XPathExpressionException {
        queryCache.put(name, nodeInfo);
        return nodeInfo;
    }

    public static NodeInfo getNode(XPathContext c, String name) throws XPathExpressionException {
        NodeInfo retour = queryCache.get(name);
        if (retour != null) {
            if (retour.getConfiguration().isCompatible(c.getConfiguration())) {
                return retour;
            }
            queryCache.remove(name);
        }
        return null;
    }

    public static void resetXpathCache() {
        queryCache = new TreeMap();
    }

    public static void addCatchVariable(String name) {
        catchVariableMap.put(name, null);
    }

    public static void removeCatchVariable(String name) {
        catchVariableMap.remove(name);
    }

    public static boolean isCatchedVariable(String name) {
        return catchVariableMap.containsKey(name);
    }

    public static List getCatchVariable(String name) {
        Object result = catchVariableMap.get(name);
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public static void putCatchVariable(String name, Object value) {
        catchVariableMap.put(name, value);
    }

    public static void resetCatchVariable() {
        catchVariableMap.clear();
    }

    public static boolean catchVariableIsEmpty() {
        return catchVariableMap.size() == 0;
    }
}

