/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.parser;

import com.indy.xsl.parser.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XslParser {
    String textToParse;
    String textTaged;
    String fieldsRegexp;
    String stringRegexp;
    private Set<String> fields;
    private ArrayList<Bloc> blocs;
    private HashSet<String> unMatched;
    private String startRegexp;
    public static String xslRegexp = "%((\\w+)?(\\((\\w+)\\))?( [^%^\\{]*)?)\\{|\\}(([\\w\\(\\)]*))%";
    MainBloc mainBloc;
    List<MainBloc> pile = new ArrayList<MainBloc>();

    public XslParser(String textToParse) {
        this.textToParse = textToParse;
        this.startRegexp = xslRegexp;
    }

    public void parse() throws XSLParseException {
        this.mainBloc = new MainBloc();
        this.pile.add(this.mainBloc);
        Pattern pDeb = Pattern.compile(this.startRegexp);
        String textToParse = this.textToParse;
        Matcher mDeb = pDeb.matcher(textToParse);
        int deb = 0;
        this.blocs = new ArrayList();
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            if (deb < iDeb) {
                this.detectCharacterSequence(textToParse.substring(deb, iDeb));
            }
            String group1 = mDeb.group(0);
            String start = mDeb.group(1);
            String startName = mDeb.group(2);
            startName = startName == null ? "var" : startName;
            String group4 = mDeb.group(3);
            String language = mDeb.group(4);
            String attributes = mDeb.group(5);
            String end = mDeb.group(6);
            String endName = mDeb.group(7);
            if (start != null) {
                this.blocStart(startName, attributes, language, start);
                deb = iFin;
                continue;
            }
            if (end != null) {
                this.blocEnd(endName, iDeb, end);
                deb = iFin;
                continue;
            }
            this.detectCharacterSequence(textToParse.substring(iDeb, iFin));
        }
        if (textToParse.length() > deb) {
            this.detectCharacterSequence(textToParse.substring(deb));
        }
        this.fields = new HashSet<String>();
    }

    public String doubleQuoteResult() {
        DoubleTextQuoteVisitor v = new DoubleTextQuoteVisitor();
        v.accept();
        return v.b.toString();
    }

    public String printXml() {
        return this.mainBloc.printXml();
    }

    void blocStart(String part1, String part2, String language, String fullGroup) throws XSLParseException {
        if (this.pile.size() <= 0) {
            throw new XSLParseException(Messages.XslParser_0);
        }
        MainBloc parent = this.pile.get(this.pile.size() - 1);
        Bloc bloc = new Bloc(part1, part2, language, fullGroup, parent);
        parent.children.add(bloc);
        this.pile.add(bloc);
    }

    void detectCharacterSequence(String sequence) {
        if (this.pile.size() == 1) {
            MainBloc parent = this.pile.get(this.pile.size() - 1);
            parent.children.add(new StringBloc(sequence, true, parent));
        } else if (this.pile.size() > 1) {
            MainBloc parent = this.pile.get(this.pile.size() - 1);
            this.pile.get((int)(this.pile.size() - 1)).children.add(new StringBloc(sequence, false, parent));
        }
    }

    MainBloc getCurrentBloc() {
        if (this.pile.size() > 0) {
            return this.pile.get(this.pile.size() - 1);
        }
        return null;
    }

    void depile() {
        this.pile.remove(this.pile.size() - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void blocEnd(String name, int start, String fullGroup) throws XSLParseException {
        if (this.pile.size() <= 1) throw new XSLParseException(String.format(Messages.XslParser_2, fullGroup));
        Bloc currentBloc = (Bloc)this.getCurrentBloc();
        currentBloc.originalEnd = fullGroup;
        if (name == null || name.isEmpty()) {
            this.depile();
            return;
        } else if (name.equals(currentBloc.name)) {
            this.depile();
            return;
        } else {
            if (!name.equals(currentBloc.originalStart)) throw new XSLParseException(String.format(Messages.XslParser_1, start, currentBloc.originalStart, currentBloc.printEnd()), start);
            this.depile();
        }
    }

    class Bloc
    extends MainBloc {
        private String originalStart;
        private String originalEnd;
        private String attributes;
        private String language;
        MainBloc parent;
        String code;
        String name;

        public Bloc(String name, String attributes, String language, String originalStart, MainBloc parent) {
            this.name = name;
            this.attributes = attributes != null ? attributes : "";
            this.language = language;
            this.originalStart = originalStart;
            this.parent = parent;
        }

        public Bloc() {
        }

        public String printOriginalStart() {
            return this.originalStart;
        }

        public String printOriginalEndt() {
            return this.originalEnd;
        }

        public String printEnd() {
            return "}" + this.name + "%";
        }

        @Override
        public String print() {
            String start = "%" + this.name + (this.language != null ? " language=\"" + this.language + "\"" : "") + this.attributes + "{";
            for (BlocI bloc : this.children) {
                start = String.valueOf(start) + bloc.print();
            }
            start = String.valueOf(start) + this.printEnd();
            return start;
        }

        @Override
        public String printXml() {
            String start = "<indyParse:" + this.name + (this.language != null ? " language=\"" + this.language + "\"" : "") + this.attributes + ">";
            for (BlocI bloc : this.children) {
                start = String.valueOf(start) + bloc.printXml();
            }
            start = String.valueOf(start) + "</indyParse:" + this.name + ">";
            return start;
        }
    }

    public static interface BlocI {
        public String print();

        public String printXml();
    }

    public class DoubleTextQuoteVisitor {
        StringBuffer b = new StringBuffer();

        public void accept() {
            for (BlocI c : XslParser.this.mainBloc.children) {
                if (c instanceof Bloc) {
                    this.visit((Bloc)c);
                    continue;
                }
                if (!(c instanceof StringBloc)) continue;
                this.visit((StringBloc)c);
            }
        }

        void visit(StringBloc bloc) {
            if (bloc.parentIsMain) {
                this.b.append(bloc.text.replace("'", "''"));
            } else {
                this.b.append(bloc.text);
            }
        }

        void visit(Bloc bloc) {
            String start = "%" + bloc.name + (bloc.language != null ? " language=\"" + bloc.language + "\"" : "") + bloc.attributes + "{";
            this.b.append(start);
            for (BlocI c : bloc.children) {
                if (c instanceof Bloc) {
                    this.visit((Bloc)c);
                    continue;
                }
                if (!(c instanceof StringBloc)) continue;
                this.visit((StringBloc)c);
            }
            this.b.append(bloc.printEnd());
        }
    }

    class MainBloc
    implements BlocI {
        List<BlocI> children = new ArrayList<BlocI>();

        MainBloc() {
        }

        public boolean hasXslOrXpath() {
            if (!(this instanceof Bloc)) {
                return false;
            }
            if (((Bloc)this).name != null && (((Bloc)this).name.equals("x") || ((Bloc)this).name.equals("xsl"))) {
                return true;
            }
            if (((Bloc)this).parent != null) {
                return ((Bloc)this).parent.hasXslOrXpath();
            }
            return false;
        }

        @Override
        public String print() {
            String result = "";
            for (BlocI bloc : this.children) {
                result = String.valueOf(result) + bloc.print();
            }
            return result;
        }

        @Override
        public String printXml() {
            String result = "";
            for (BlocI bloc : this.children) {
                result = String.valueOf(result) + bloc.printXml();
            }
            return result;
        }
    }

    class StringBloc
    implements BlocI {
        String text;
        boolean parentIsMain = false;
        MainBloc parent;

        public StringBloc(String string, boolean b, MainBloc parent) {
            this.text = string;
            this.parentIsMain = b;
            this.parent = parent;
        }

        @Override
        public String print() {
            String result = this.text;
            if (result != null) {
                if (this.parent.hasXslOrXpath()) {
                    result = result.replaceAll("&amp;", "\u00a7\u00a7\u00a4\u00a7\u00a7");
                    result = result.replaceAll("<(/)?xsl:", "<$1xslo:");
                    result = result.replaceAll("<(/)?saxon:", "<$1saxono:");
                } else {
                    result = result.replaceAll("<", "\u00a4\u00a4\u00a3\u00a4\u00a4");
                    result = "<indyParse:text>" + result + "</indyParse:text>";
                    result = result.replaceAll("&", "\u00a7\u00a7\u00a4\u00a7\u00a7");
                }
            }
            return result;
        }

        @Override
        public String printXml() {
            return this.print();
        }
    }

    public class XSLParseException
    extends Exception {
        int position;

        public int getPosition() {
            return this.position;
        }

        public XSLParseException(String string) {
            super(string);
            this.position = -1;
        }

        public XSLParseException(String string, int position) {
            super(string);
            this.position = -1;
            this.position = position;
        }
    }
}

