/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.sql;

import com.indy.xsl.sql.Messages;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLQuery
extends net.sf.saxon.sql.SQLQuery {
    Expression connection;
    Expression query;
    String rowTag;
    String colTag;
    boolean disable = false;

    public void prepareAttributes() throws XPathException {
        String disableAtt;
        String dbQuery = this.getAttributeValue("", "query");
        if (dbQuery == null) {
            this.reportAbsence("query");
        } else {
            this.query = this.makeAttributeValueTemplate(dbQuery);
        }
        String connectAtt = this.getAttributeValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
        this.rowTag = this.getAttributeValue("", "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.getAttributeValue("", "column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((disableAtt = this.getAttributeValue("", "disable-output-escaping")) != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.query = this.typeCheck("where", this.query);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new QueryInstruction(this.connection, this.query, this.rowTag, this.colTag, this.disable);
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int QUERY = 1;
        String rowTag;
        String colTag;
        int options;

        public QueryInstruction(Expression connection, Expression query, String rowTag, String colTag, boolean disable) {
            Expression[] sub = new Expression[]{connection, query};
            this.setArguments(sub);
            this.rowTag = rowTag;
            this.colTag = colTag;
            this.options = disable ? 1 : 0;
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:query";
        }

        public void process(XPathContext context) throws XPathException {
            Controller controller = context.getController();
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                XPathException de = new XPathException(Messages.SQLQuery_0);
                de.setXPathContext(context);
                throw de;
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            String dbQuery = this.arguments[1].evaluateAsString(context).toString();
            NamePool pool = controller.getNamePool();
            int rowCode = pool.allocate("", "", this.rowTag);
            int colCode = pool.allocate("", "", this.colTag);
            int attrCode = pool.allocate("", "", "name");
            Statement ps = null;
            ResultSet rs = null;
            XPathException de = null;
            try {
                try {
                    StringBuilder statement = new StringBuilder();
                    statement.append(dbQuery);
                    ps = connection.prepareStatement(statement.toString());
                    controller.setUserData((Object)this, "sql:statement", (Object)ps);
                    rs = ps.executeQuery();
                    SequenceReceiver out = context.getReceiver();
                    String result = "";
                    int icol = rs.getMetaData().getColumnCount();
                    while (rs.next()) {
                        out.startElement(rowCode, 630, this.locationId, 0);
                        int col = 1;
                        while (col <= icol) {
                            result = rs.getString(col);
                            String name = rs.getMetaData().getColumnName(col);
                            if (result != null) {
                                out.startElement(colCode, 630, this.locationId, 0);
                                out.attribute(attrCode, 631, (CharSequence)name, 0, 0);
                                out.characters((CharSequence)result, this.locationId, this.options);
                                out.endElement();
                            }
                            ++col;
                        }
                        out.endElement();
                    }
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage());
                    de.setXPathContext(context);
                    throw de;
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        de = new XPathException("(SQL) " + ex.getMessage());
                        de.setXPathContext(context);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ex) {
                        de = new XPathException("(SQL) " + ex.getMessage());
                        de.setXPathContext(context);
                    }
                }
            }
            if (de != null) {
                throw de;
            }
        }
    }
}

