/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.sqlparser;

import com.indy.xsl.global.XSLException;
import com.indy.xsl.sqlparser.Messages;
import com.indy.xsl.sqlparser.RemoveAndRestoreVarTags;
import com.indy.xsl.sqlparser.StandardVisitor;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.saxon.value.TextFragmentValue;

public class OuterJoinVisitorModificator
extends StandardVisitor {
    public static final int RIGHT_OUTER_SIDE = 1;
    public static final int OPERATOR_INNER_SIDE = 2;
    public static final int JOIN_MODE = 1;
    public static final int FILTER_MODE = 2;
    public static final int JOIN_MODE_BAK = 3;
    protected String outerExpression;
    protected int side;
    protected List<String> alias;

    public static String addOuterWord(String where, String outerExpression, List<String> alias, List<String> allInnerAlias, int mode) throws XSLException {
        int side = 0;
        if (outerExpression.equals("(+)")) {
            side = 1;
        } else if (outerExpression.equals("*")) {
            side = 2;
        }
        try {
            return OuterJoinVisitorModificator.addOuterWord(where, outerExpression, alias, side, mode);
        }
        catch (JSQLParserException e) {
            String message = String.format(Messages.OuterJoinVisitorModificator_0, outerExpression, where);
            XSLException ex = new XSLException(message, e);
            throw ex;
        }
    }

    public static void main(String[] args) {
    }

    public static String addOuterWord(String where, String outerExpression, List<String> alias, int side, int mode) throws JSQLParserException {
        String header;
        String statement = header = "select * from table_qui_nexiste_pas where (1=1) and ";
        statement = String.valueOf(statement) + where;
        RemoveAndRestoreVarTags rarsc = new RemoveAndRestoreVarTags(statement);
        Statement parsedStm = CCJSqlParserUtil.parse((Reader)new StringReader(statement = rarsc.remove()));
        if (parsedStm instanceof Select) {
            Select select = (Select)parsedStm;
            String tmpOuter = "\u00a4\u00a4\u00a4\u00a4\u00a4";
            OuterJoinVisitorModificator ovm = new OuterJoinVisitorModificator(tmpOuter, alias, side);
            select.getSelectBody().accept((SelectVisitor)ovm);
            String retour = parsedStm.toString();
            retour = retour.replaceAll(", '" + tmpOuter + "'\\)[ ]*", ")" + tmpOuter);
            retour = mode == 2 ? retour.replaceAll("[ ]*" + tmpOuter + "[ ]*", outerExpression) : retour.replaceAll(tmpOuter, outerExpression);
            retour = retour.substring(header.length() + 2);
            retour = rarsc.restore(retour);
            return retour;
        }
        return where;
    }

    public static String addOuterWord(String where, String outerExpression, String innerAlias, String outerAlias, int side, int mode) throws JSQLParserException, ParseException {
        ArrayList<String> alias = new ArrayList<String>();
        alias.add(String.valueOf(innerAlias) + "," + outerAlias);
        return OuterJoinVisitorModificator.addOuterWord(where, outerExpression, alias, side, mode);
    }

    public static String addOuterWord(String where, String outerExpression, String innerAlias, String outerAlias, List<String> allInnerAlias, int mode) throws JSQLParserException, ParseException, XSLException {
        ArrayList<String> alias = new ArrayList<String>();
        alias.add(String.valueOf(innerAlias) + "," + outerAlias);
        return OuterJoinVisitorModificator.addOuterWord(where, outerExpression, alias, allInnerAlias, mode);
    }

    public OuterJoinVisitorModificator(String outerExpression, List<String> alias, int side) {
        this.outerExpression = outerExpression;
        this.alias = alias;
        this.side = side;
    }

    private void add(Expression left, Expression right) {
        Column leftCol = null;
        Column rightCol = null;
        if (this.alias != null) {
            block4: for (String _tmp : this.alias) {
                List<Column> tmp3;
                List<Column> tmp2;
                ArrayList<Column> innerCol = new ArrayList<Column>();
                ArrayList<Column> outerCol = new ArrayList<Column>();
                String tmp = null;
                String innerSide = "";
                tmp = _tmp instanceof TextFragmentValue ? ((TextFragmentValue)_tmp).getStringValue() : _tmp;
                String innerAlias = null;
                String outerAlias = null;
                if (tmp.toString().contains(",")) {
                    innerAlias = tmp.substring(0, tmp.indexOf(","));
                    outerAlias = tmp.substring(tmp.indexOf(",") + 1);
                } else {
                    innerAlias = tmp.toString();
                    outerAlias = tmp.toString();
                }
                if (innerAlias == null || outerAlias == null) continue;
                if (left instanceof Column) {
                    leftCol = (Column)left;
                    if (leftCol.getTable().getName().equals(innerAlias)) {
                        innerCol.add(leftCol);
                        innerSide = "left";
                    } else if (leftCol.getTable().getName().equals(outerAlias)) {
                        outerCol.add(leftCol);
                    }
                } else {
                    tmp2 = OuterJoinVisitorModificator.findColumn(left, innerAlias);
                    tmp3 = OuterJoinVisitorModificator.findColumn(left, outerAlias);
                    if (tmp2.size() > 0) {
                        innerCol.addAll(tmp2);
                        innerSide = "left";
                    } else if (tmp3.size() > 0) {
                        outerCol.addAll(tmp3);
                    }
                }
                if (right instanceof Column) {
                    rightCol = (Column)right;
                    if (rightCol.getTable().getName().equals(innerAlias)) {
                        innerCol.add(rightCol);
                        innerSide = "right";
                    } else if (rightCol.getTable().getName().equals(outerAlias)) {
                        outerCol.add(rightCol);
                    }
                } else {
                    tmp2 = OuterJoinVisitorModificator.findColumn(right, innerAlias);
                    tmp3 = OuterJoinVisitorModificator.findColumn(right, outerAlias);
                    if (tmp2.size() > 0) {
                        innerCol.addAll(tmp2);
                        innerSide = "right";
                    } else if (tmp3.size() > 0) {
                        outerCol.addAll(tmp3);
                    }
                }
                if (innerCol.size() > 0 && outerCol.size() > 0) {
                    switch (this.side) {
                        case 1: {
                            for (Column c : outerCol) {
                                OuterJoinVisitorModificator.putOuterWordOnTheRight(c, this.outerExpression);
                            }
                            continue block4;
                        }
                        case 2: {
                            if (innerSide.equals("left")) {
                                if (left instanceof Function) {
                                    OuterJoinVisitorModificator.putOuterWordOnTheRight((Function)left, this.outerExpression);
                                    break;
                                }
                                OuterJoinVisitorModificator.putOuterWordOnTheRight((Column)innerCol.get(0), this.outerExpression);
                                break;
                            }
                            if (right instanceof Function) {
                                OuterJoinVisitorModificator.putOuterWordOnTheLeft((Function)right, this.outerExpression);
                                break;
                            }
                            OuterJoinVisitorModificator.putOuterWordOnTheLeft((Column)innerCol.get(0), this.outerExpression);
                        }
                    }
                    continue;
                }
                if (this.side != 1 || outerCol.size() <= 0 || innerCol.size() != 0) continue;
                for (Column c : outerCol) {
                    OuterJoinVisitorModificator.putOuterWordOnTheRight(c, this.outerExpression);
                }
            }
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression left = binaryExpression.getLeftExpression();
        Expression right = binaryExpression.getRightExpression();
        if (binaryExpression instanceof EqualsTo || binaryExpression instanceof NotEqualsTo || binaryExpression instanceof GreaterThan || binaryExpression instanceof GreaterThanEquals || binaryExpression instanceof MinorThan || binaryExpression instanceof MinorThanEquals) {
            this.add(left, right);
        }
        left.accept((ExpressionVisitor)this);
        right.accept((ExpressionVisitor)this);
    }

    public static List<Column> findColumnIntoFunction(Function f, String alias) {
        ArrayList<Column> retour = new ArrayList<Column>();
        for (Object exp : f.getParameters().getExpressions()) {
            if (exp instanceof Column && ((Column)exp).getTable() != null && ((Column)exp).getTable().getName().equals(alias)) {
                retour.add((Column)exp);
                continue;
            }
            if (!(exp instanceof Function)) continue;
            retour.addAll(OuterJoinVisitorModificator.findColumnIntoFunction((Function)exp, alias));
        }
        return retour;
    }

    public static List<Column> findColumn(Expression expr, final String alias) {
        final ArrayList<Column> retour = new ArrayList<Column>();
        if (expr != null) {
            if (expr instanceof Column) {
                if (expr instanceof Column && ((Column)expr).getTable() != null && ((Column)expr).getTable().getName().equals(alias)) {
                    retour.add((Column)expr);
                }
            } else {
                expr.accept((ExpressionVisitor)new StandardVisitor(){

                    @Override
                    public void visit(Column tableColumn) {
                        if (tableColumn instanceof Column && tableColumn.getTable() != null && tableColumn.getTable().getName() != null && tableColumn.getTable().getName().equals(alias)) {
                            retour.add(tableColumn);
                        }
                    }
                });
            }
        }
        return retour;
    }

    public static void putOuterWordOnTheLeft(Column c, String outer) {
        if (c.getTable().getName().indexOf(outer) == -1) {
            c.getTable().setName(String.valueOf(outer) + c.getTable().getName());
        }
    }

    public static void putOuterWordOnTheRight(Column c, String outer) {
        if (c.getColumnName().indexOf(outer) == -1) {
            c.setColumnName(String.valueOf(c.getColumnName()) + outer);
        }
    }

    public static void putOuterWordOnTheRight(Function f, String outer) {
        if (f.getParameters().getExpressions().size() > 0 && f.getParameters().getExpressions().get(f.getParameters().getExpressions().size() - 1) instanceof StringValue) {
            return;
        }
        f.getParameters().getExpressions().add(new StringValue(" " + outer + " "));
    }

    public static void putOuterWordOnTheLeft(Function f, String outer) {
        if (f.getName().indexOf(outer) == -1) {
            f.setName(String.valueOf(outer) + f.getName());
        }
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
        }
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        Expression left = isNullExpression.getLeftExpression();
        this.add(left, null);
        left.accept((ExpressionVisitor)this);
    }
}

