/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit;

import com.indy.emf.compare.integration.internal.StorageAdapter;
import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.egit.internal.adapter.BlobStoragePathProvider;
import org.eclipse.emf.compare.egit.internal.storage.WorkspaceGitBlobStorage;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider;
import org.eclipse.jgit.lib.Repository;

public class EGITStorageAdapter
implements IAdapterFactory {
    public <T> T getAdapter(final Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof GitBlobStorage && adapterType == IStoragePathProvider.class) {
            return (T)new BlobStoragePathProvider(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public IPath computeFixedPath(IStorage storage) {
                    if (storage instanceof WorkspaceGitBlobStorage) {
                        return ((WorkspaceGitBlobStorage)storage).getWorkspacePath();
                    }
                    if (!(storage instanceof GitBlobStorage)) {
                        return null;
                    }
                    IPath absolutePath = ((GitBlobStorage)storage).getAbsolutePath();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile fileForLocation = root.getFileForLocation(absolutePath);
                    if (fileForLocation != null) {
                        return fileForLocation.getFullPath();
                    }
                    try {
                        Field f = GitBlobStorage.class.getDeclaredField("db");
                        boolean accessible = f.isAccessible();
                        try {
                            f.setAccessible(true);
                            Object db = f.get(adaptableObject);
                            File file = ((Repository)db).getDirectory();
                            File repoGitFolder = file.getParentFile();
                            String s = null;
                            String ext = storage.getFullPath().getFileExtension();
                            if (ext.contains(" ")) {
                                ext = ext.substring(0, ext.indexOf(" "));
                                s = String.valueOf(repoGitFolder.getParentFile().toURI().toString()) + storage.getFullPath().removeFileExtension().addFileExtension(ext);
                            } else if (ext.contains("%20")) {
                                ext = ext.substring(0, ext.indexOf("%20"));
                                s = String.valueOf(repoGitFolder.getParentFile().toURI().toString()) + storage.getFullPath().removeFileExtension().addFileExtension(ext);
                            } else {
                                s = String.valueOf(repoGitFolder.getParentFile().toURI().toString()) + storage.getFullPath();
                            }
                            StringBuffer buf = new StringBuffer();
                            String[] stringArray = s.split("/");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    java.net.URI uri = new java.net.URI(buf.toString());
                                    IFile[] candidates = root.findFilesForLocationURI(uri);
                                    if (candidates != null && candidates.length > 0) {
                                        IPath iPath = candidates[0].getFullPath();
                                        return iPath;
                                    }
                                    break;
                                }
                                String p = stringArray[n2];
                                if (buf.length() > 0) {
                                    buf.append("/");
                                }
                                buf.append(URI.encodeSegment((String)p, (boolean)true));
                                ++n2;
                            }
                        }
                        finally {
                            f.setAccessible(accessible);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    StorageAdapter.FullPathVisitor v = new StorageAdapter.FullPathVisitor(storage.getFullPath());
                    try {
                        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)v);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (v.getMatchingFiles().isEmpty()) return new Path("file:/").append(((GitBlobStorage)storage).getAbsolutePath());
                    return ((IFile)v.getMatchingFiles().get(0)).getFullPath();
                }
            };
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IStoragePathProvider.class};
    }
}

