/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit.command;

import com.indy.emf.compare.integration.egit.command.AbstactGitLogicalCommand;
import com.indy.emf.compare.integration.egit.command.GitLogicalMergeCommand;
import com.indy.emf.compare.integration.egit.command.Messages;
import com.indy.emf.compare.integration.handler.EnableEMFCompareHandler;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=xdi", "osgi.command.function=gitLogicalPull"}, service={Command.class}, enabled=true)
public class GitLogicalPullCommand
extends AbstactGitLogicalCommand {
    @ShellCommandParameter(commutator="repositoryName")
    private String repositoryName;
    @ShellCommandParameter(commutator="verbose")
    private boolean verbose;

    public void gitLogicalPull(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(this.getName()) + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(String.valueOf(s) + " ");
            } else {
                b.append(String.format("\"%s\" ", s));
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    @Override
    protected String doExecute() throws Exception {
        Repository repository = null;
        for (String dir : RepositoryUtil.INSTANCE.getConfiguredRepositories()) {
            File repoDir = new File(dir);
            try {
                Repository repo = RepositoryCache.INSTANCE.lookupRepository(repoDir);
                if (!repoDir.getParentFile().getName().equals(this.repositoryName)) continue;
                repository = repo;
            }
            catch (IOException repo) {
                // empty catch block
            }
        }
        if (repository == null) {
            throw new Exception(String.format(Messages.GitLogicalPullCommand_repositoryNotFoundError, this.repositoryName));
        }
        EnableEMFCompareHandler.enableEMFCompare((boolean)true);
        PullOperation pull = new PullOperation(new HashSet<Repository>(Arrays.asList(repository)), GitSettings.getRemoteConnectionTimeout());
        pull.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }
        });
        final AtomicReference statusRef = new AtomicReference();
        JobChangeAdapter jobLIstener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getName().startsWith("Pulling")) {
                    statusRef.set(event.getResult());
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)jobLIstener);
        pull.execute((IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)jobLIstener);
        PullResult result = (PullResult)pull.getResults().get(repository);
        if (result == null) {
            if (statusRef.get() != null) {
                throw (Exception)((IStatus)statusRef.get()).getException();
            }
            throw new Exception(Messages.GitLogicalPullCommand_unexpectedErrorMessage);
        }
        if (!result.isSuccessful()) {
            if (result.getMergeResult() != null) {
                throw new GitLogicalMergeCommand.MergeFailureException(result.getMergeResult(), this.verbose);
            }
            if (result.getRebaseResult() != null) {
                throw new RebaseFailureException(result.getRebaseResult());
            }
        }
        return String.format(Messages.GitLogicalPullCommand_pullSuccessMessage, new Object[0]);
    }

    public String getName() {
        return "gitLogicalPull";
    }

    public String getUsage() {
        return "gitLogicalPull -repositoryName <repository> [-verbose]";
    }

    public String getShortDescription() {
        return "Performs a pull. It uses xDI EMFCompare simple conflict resolution strategy.";
    }

    @Override
    protected void clearParameters() {
        this.verbose = false;
        this.repositoryName = null;
    }

    class RebaseFailureException
    extends Exception {
        RebaseResult result;

        RebaseFailureException(RebaseResult result) {
            this.result = result;
        }

        @Override
        public String getMessage() {
            String message = Messages.GitLogicalPullCommand_pullRebaseErrorMessage;
            if (this.result.getStatus() == RebaseResult.Status.CONFLICTS) {
                message = Messages.GitLogicalPullCommand_pullRebaseConflictMessage;
            }
            if (!GitLogicalPullCommand.this.verbose) {
                message = String.valueOf(message) + Messages.GitLogicalPullCommand_verboseOptionMessage;
            }
            return String.format("%s\n%s", message, GitLogicalPullCommand.this.verbose ? this.dumpFailure() : "");
        }

        String dumpFailure() {
            String message = null;
            message = this.result.getStatus() == RebaseResult.Status.FAILED ? this.result.getFailingPaths().keySet().stream().map(p -> String.format("%s=%s", p, this.result.getFailingPaths().get(p))).sorted().collect(Collectors.joining("\n")) : this.result.getConflicts().stream().sorted().collect(Collectors.joining("\n"));
            return message;
        }
    }
}

