/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit.jgit;

import com.indy.emf.compare.integration.egit.jgit.StbEMFResourceMerger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.TreeWalkResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.WorkspaceGitBlobStorage;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class StbRecursiveMerger
extends RecursiveMerger {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private AbstractTreeIterator aBaseTree;
    private RevTree aHeadTree;
    private RevTree aMergeTree;
    private int inCoreLimit;
    TreeWalkResourceVariantTreeProvider variantTreeProvider;
    GitResourceVariantTreeSubscriber subscriber;
    Set<String> emfCompareMergeFileExtension = null;

    private static int getInCoreLimit(Config config) {
        return config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    private static MergeResult<SubmoduleConflict> createGitLinksMergeResult(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        return new MergeResult(Arrays.asList(new SubmoduleConflict(base == null ? null : base.getEntryObjectId()), new SubmoduleConflict(ours == null ? null : ours.getEntryObjectId()), new SubmoduleConflict(theirs == null ? null : theirs.getEntryObjectId())));
    }

    private static final void setContainsConflicts(MergeResult r, boolean value) {
        boolean accessible = false;
        Method m = null;
        try {
            try {
                m = r.getClass().getMethod("setContainsConflict", Boolean.TYPE);
                accessible = m.isAccessible();
                m.setAccessible(value);
                m.invoke((Object)r, true);
            }
            catch (Exception ex) {
                LogManager.getLogger(StbRecursiveMerger.class).warn("unexpected", (Throwable)ex);
                if (m != null) {
                    m.setAccessible(accessible);
                }
            }
        }
        finally {
            if (m != null) {
                m.setAccessible(accessible);
            }
        }
    }

    protected StbRecursiveMerger(Repository local, boolean inCore) {
        super(local, inCore);
        this.inCoreLimit = StbRecursiveMerger.getInCoreLimit((Config)local.getConfig());
    }

    protected StbRecursiveMerger(Repository local) {
        this(local, false);
    }

    protected StbRecursiveMerger(ObjectInserter inserter, Config config) {
        super(inserter, config);
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, Instant lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(p.getEntryFileMode());
            e.setObjectId((AnyObjectId)p.getEntryObjectId());
            e.setLastModified(lastMod);
            e.setLength(len);
            this.builder.add(e);
            return e;
        }
        return null;
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        DirCacheEntry newEntry = new DirCacheEntry(e.getRawPath(), e.getStage());
        newEntry.setFileMode(e.getFileMode());
        newEntry.setObjectId((AnyObjectId)e.getObjectId());
        newEntry.setLastModified(e.getLastModified());
        newEntry.setLength(e.getLength());
        this.builder.add(newEntry);
        return newEntry;
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts, Attributes[] attributes) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        boolean gitLinkMerging;
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        boolean bl = gitLinkMerging = StbRecursiveMerger.isGitLink(modeO) || StbRecursiveMerger.isGitLink(modeT) || StbRecursiveMerger.isGitLink(modeB);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (StbRecursiveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId((AnyObjectId)this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (StbRecursiveMerger.nonTree(modeO) && StbRecursiveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (!ignoreConflicts) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            }
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (StbRecursiveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                if (e != null) {
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (modeT != 0 && modeT == modeB) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), StbRecursiveMerger.nonTree(modeO), attributes[1]);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (StbRecursiveMerger.nonTree(modeO) && !StbRecursiveMerger.nonTree(modeT)) {
                if (ignoreConflicts) {
                    this.enterSubtree = false;
                    return true;
                }
                if (StbRecursiveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                if (StbRecursiveMerger.nonTree(modeO)) {
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                }
                if (StbRecursiveMerger.nonTree(modeT)) {
                    this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                }
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!StbRecursiveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (StbRecursiveMerger.nonTree(modeO) && StbRecursiveMerger.nonTree(modeT)) {
            boolean worktreeDirty = this.isWorktreeDirty(work, ourDce);
            if (!attributes[1].canBeContentMerged() && worktreeDirty) {
                return false;
            }
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (gitLinkMerging) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                MergeResult<SubmoduleConflict> result = StbRecursiveMerger.createGitLinksMergeResult(base, ours, theirs);
                StbRecursiveMerger.setContainsConflicts(result, true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes[1].canBeContentMerged()) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry theirEntry = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), theirEntry, attributes);
                        return true;
                    }
                }
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (worktreeDirty) {
                return false;
            }
            MergeResult result = null;
            try {
                result = this.contentMerge(base, ours, theirs, attributes, this.getContentMergeStrategy());
            }
            catch (BinaryBlobException e) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry theirEntry = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), theirEntry, attributes);
                        return true;
                    }
                }
                result = new MergeResult(Collections.emptyList());
                StbRecursiveMerger.setContainsConflicts(result, false);
            }
            this.handleConflict((MergeResult<RawText>)result, base, ours, theirs, ignoreConflicts, attributes);
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
            } else if (gitLinkMerging) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                MergeResult<SubmoduleConflict> result = StbRecursiveMerger.createGitLinksMergeResult(base, ours, theirs);
                StbRecursiveMerger.setContainsConflicts(result, true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult<RawText> result;
                try {
                    result = this.contentMerge(base, ours, theirs, attributes, ContentMergeStrategy.CONFLICT);
                }
                catch (BinaryBlobException e) {
                    result = new MergeResult<RawText>(Collections.emptyList());
                    StbRecursiveMerger.setContainsConflicts(result, true);
                }
                if (ignoreConflicts) {
                    StbRecursiveMerger.setContainsConflicts(result, false);
                    this.updateIndex(base, ours, theirs, result, attributes[1], false);
                } else {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                    if (modeO == 0) {
                        if (this.isWorktreeDirty(work, ourDce)) {
                            return false;
                        }
                        if (StbRecursiveMerger.nonTree(modeT) && e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
            }
        }
        return true;
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, Attributes[] attributes, ContentMergeStrategy strategy) throws BinaryBlobException, IOException {
        RawText baseText = base == null ? RawText.EMPTY_TEXT : this.getRawText(base.getEntryObjectId(), attributes[0]);
        RawText ourText = ours == null ? RawText.EMPTY_TEXT : this.getRawText(ours.getEntryObjectId(), attributes[1]);
        RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : this.getRawText(theirs.getEntryObjectId(), attributes[2]);
        this.mergeAlgorithm.setContentMergeStrategy(strategy);
        return this.mergeAlgorithm.merge((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)baseText, (Sequence)ourText, (Sequence)theirsText);
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = StbRecursiveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && StbRecursiveMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result, Attributes attributes, boolean handledByEMFCompare) throws FileNotFoundException, IOException {
        TemporaryBuffer rawMerged = null;
        try {
            rawMerged = this.doMerge(result);
            File mergedFile = null;
            if (result.containsConflicts()) {
                if (!handledByEMFCompare) {
                    if (!this.inCore) {
                        mergedFile = this.writeMergedFile(rawMerged, attributes);
                    }
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                    this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
                return;
            }
            mergedFile = this.inCore ? null : this.writeMergedFile(rawMerged, attributes);
            DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            dce.setFileMode(newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits((int)newMode));
            if (mergedFile != null) {
                dce.setLastModified(this.nonNullRepo().getFS().lastModified(mergedFile));
                dce.setLength((int)mergedFile.length());
            }
            dce.setObjectId((AnyObjectId)this.insertMergeResult(rawMerged, attributes));
            this.builder.add(dce);
        }
        finally {
            if (rawMerged != null) {
                rawMerged.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer rawMerged, Attributes attributes) throws FileNotFoundException, IOException {
        File of;
        File parentFolder;
        File workTree = this.nonNullRepo().getWorkTree();
        FS fs = this.nonNullRepo().getFS();
        if (!fs.exists(parentFolder = (of = new File(workTree, this.tw.getPathString())).getParentFile())) {
            parentFolder.mkdirs();
        }
        CoreConfig.EolStreamType streamType = EolStreamTypeUtil.detectStreamType((TreeWalk.OperationType)TreeWalk.OperationType.CHECKOUT_OP, (WorkingTreeOptions)this.workingTreeOptions, (Attributes)attributes);
        Throwable throwable = null;
        Object var9_10 = null;
        try (OutputStream os = EolStreamTypeUtil.wrapOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(of)), (CoreConfig.EolStreamType)streamType);){
            rawMerged.writeTo(os, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return of;
    }

    private TemporaryBuffer doMerge(MergeResult<RawText> result) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.inCoreLimit);
        try {
            new MergeFormatter().formatMerge((OutputStream)buf, result, Arrays.asList(this.commitNames), Constants.CHARACTER_ENCODING);
            buf.close();
        }
        catch (IOException e) {
            buf.destroy();
            throw e;
        }
        return buf;
    }

    private ObjectId insertMergeResult(TemporaryBuffer buf, Attributes attributes) throws IOException {
        InputStream in = buf.openInputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (LfsFactory.LfsInputStream is = LfsFactory.getInstance().applyCleanFilter(this.getRepository(), in, buf.length(), attributes.get("merge"));){
            return this.getObjectInserter().insert(3, is.getLength(), (InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private RawText getRawText(ObjectId id, Attributes attributes) throws IOException, BinaryBlobException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open((AnyObjectId)id, 3), attributes.get("merge"));
        int threshold = 0x3200000;
        return RawText.load((ObjectLoader)loader, (int)threshold);
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    private void refreshRoots(IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            GitProvider provider;
            IResource root = iResourceArray[n2];
            if (root.isAccessible() && (provider = ResourceUtil.getGitProvider((IProject)root.getProject())) != null) {
                root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        this.aBaseTree = baseTree;
        this.aHeadTree = headTree;
        this.aMergeTree = mergeTree;
        return super.mergeTrees(baseTree, headTree, mergeTree, ignoreConflicts);
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        this.variantTreeProvider = new TreeWalkResourceVariantTreeProvider.Builder().setRepository(this.getRepository()).setaBaseTree(this.aBaseTree).setHeadTree(this.aHeadTree).setMergeTree(this.aMergeTree).setDircache(this.dircache).setReader(this.reader).build();
        this.subscriber = new GitResourceVariantTreeSubscriber((GitResourceVariantTreeProvider)this.variantTreeProvider);
        try {
            this.refreshRoots(this.subscriber.roots());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return super.mergeTreeWalk(treeWalk, ignoreConflicts);
    }

    private boolean isHandledByEMFCompare(IResource resource) {
        if (this.emfCompareMergeFileExtension == null) {
            this.emfCompareMergeFileExtension = new HashSet<String>();
            IContentType[] iContentTypeArray = ContentTypeManager.getInstance().getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] s;
                IContentType ct = iContentTypeArray[n2];
                if (ct.getId().startsWith("com.indy.emf.compare.integration.contenttype") && (s = ct.getFileSpecs(8)) != null) {
                    String[] stringArray = s;
                    int n3 = s.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String ext = stringArray[n4];
                        this.emfCompareMergeFileExtension.add(ext);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.emfCompareMergeFileExtension.contains(resource.getFileExtension());
    }

    private void handleConflict(MergeResult<RawText> result, CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, boolean ignoreConflicts, Attributes[] attributes) throws FileNotFoundException, IOException {
        String currentPath = this.tw.getPathString();
        int modeBase = this.tw.getRawMode(0);
        int modeOurs = this.tw.getRawMode(1);
        int modeTheirs = this.tw.getRawMode(2);
        int nonZeroMode = modeBase != 0 ? modeBase : (modeOurs != 0 ? modeOurs : modeTheirs);
        IResource resource = this.variantTreeProvider.getResourceHandleForLocation(this.getRepository(), currentPath, FileMode.fromBits((int)nonZeroMode) == FileMode.TREE);
        boolean useEMFCompare = this.isHandledByEMFCompare(resource);
        this.updateIndex(base, ours, theirs, result, attributes[1], useEMFCompare);
        if (useEMFCompare) {
            block28: {
                if (result.containsConflicts() && !ignoreConflicts) {
                    Object oursStorage = null;
                    oursStorage = !resource.exists() ? new GitBlobStorage(this.getRepository(), currentPath, ours.getEntryObjectId()) : new WorkspaceGitBlobStorage(this.getRepository(), currentPath, resource.getFullPath(), ours.getEntryObjectId());
                    IStatus mergeStatus = null;
                    try {
                        StbEMFResourceMerger merger = new StbEMFResourceMerger((IStorage)oursStorage, (IStorage)new GitBlobStorage(this.getRepository(), currentPath, theirs.getEntryObjectId()), (IStorage)(base == null ? null : new GitBlobStorage(this.getRepository(), currentPath, base.getEntryObjectId())));
                        mergeStatus = merger.merge(null, null);
                        if (!mergeStatus.isOK()) {
                            this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                            this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                            this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                            this.mergeResults.put(this.tw.getPathString(), result);
                            this.unmergedPaths.add(currentPath);
                            this.mergeResults.put(this.tw.getPathString(), result);
                            break block28;
                        }
                        DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
                        File mergedFile = new File(String.valueOf(this.nonNullRepo().getDirectory().getParentFile().getAbsolutePath()) + "/" + currentPath);
                        int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
                        dce.setFileMode(newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits((int)newMode));
                        if (mergedFile != null) {
                            dce.setLastModified(this.nonNullRepo().getFS().lastModified(mergedFile));
                            dce.setLength((int)mergedFile.length());
                        }
                        Throwable throwable = null;
                        Object var21_23 = null;
                        try (TemporaryBuffer.LocalFile b = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.inCoreLimit);){
                            block29: {
                                if (merger.savedResourceURI != null) {
                                    ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
                                    Throwable throwable2 = null;
                                    Object var25_29 = null;
                                    try (BufferedInputStream is = new BufferedInputStream(uriConverter.createInputStream(merger.savedResourceURI));){
                                        b.copy((InputStream)is);
                                        break block29;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                b.copy(oursStorage.getContents());
                            }
                            dce.setObjectId((AnyObjectId)this.insertMergeResult((TemporaryBuffer)b, attributes[1]));
                            this.builder.add(dce);
                            this.modifiedFiles.add(currentPath);
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn(String.format("Git merge failed on file %s", currentPath), (Throwable)ex);
                        ex.printStackTrace();
                        this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                        this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                        this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                        this.mergeResults.put(this.tw.getPathString(), result);
                        this.unmergedPaths.add(currentPath);
                        this.mergeResults.put(this.tw.getPathString(), result);
                    }
                } else {
                    this.modifiedFiles.add(currentPath);
                }
            }
            this.addCheckoutMetadata(this.getCleanupMetadata(), currentPath, attributes[1]);
            this.addCheckoutMetadata(this.getCheckoutMetadata(), currentPath, attributes[2]);
        } else {
            if (result.containsConflicts() && !ignoreConflicts) {
                this.unmergedPaths.add(currentPath);
            }
            this.modifiedFiles.add(currentPath);
            this.addCheckoutMetadata(this.getCleanupMetadata(), currentPath, attributes[1]);
            this.addCheckoutMetadata(this.getCheckoutMetadata(), currentPath, attributes[2]);
        }
    }

    private Object readField(String fieldName) throws IOException {
        Field f = ResolveMerger.class.getDeclaredField(fieldName);
        boolean access = f.isAccessible();
        try {
            f.setAccessible(true);
            Map map = (Map)f.get((Object)this);
            f.setAccessible(access);
            return map;
        }
        catch (Throwable throwable) {
            try {
                f.setAccessible(access);
                throw throwable;
            }
            catch (Exception ex) {
                throw new IOException(String.format("Could not read %s from class %s. EMFCompare version has been changed", fieldName, ResolveMerger.class.getName()), ex);
            }
        }
    }

    private Map<String, DirCacheCheckout.CheckoutMetadata> getCleanupMetadata() throws IOException {
        return (Map)this.readField("cleanupMetadata");
    }

    private Map<String, DirCacheCheckout.CheckoutMetadata> getCheckoutMetadata() throws IOException {
        return (Map)this.readField("checkoutMetadata");
    }
}

