/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IntervalUnit implements Enumerator
{
    HOUR(0, "HOUR", "HOUR"),
    MINUTE(1, "MINUTE", "MINUTE"),
    SECOND(2, "SECOND", "SECOND");

    public static final int HOUR_VALUE = 0;
    public static final int MINUTE_VALUE = 1;
    public static final int SECOND_VALUE = 2;
    private static final IntervalUnit[] VALUES_ARRAY;
    public static final List<IntervalUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IntervalUnit[]{HOUR, MINUTE, SECOND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IntervalUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntervalUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntervalUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntervalUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntervalUnit get(int value) {
        switch (value) {
            case 0: {
                return HOUR;
            }
            case 1: {
                return MINUTE;
            }
            case 2: {
                return SECOND;
            }
        }
        return null;
    }

    private IntervalUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

