/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PurgeUnit implements Enumerator
{
    MINUTE(0, "Minute", "Minute"),
    HOUR(1, "Hour", "Hour"),
    DAY(2, "Day", "Day"),
    SESSION(3, "Session", "Session");

    public static final int MINUTE_VALUE = 0;
    public static final int HOUR_VALUE = 1;
    public static final int DAY_VALUE = 2;
    public static final int SESSION_VALUE = 3;
    private static final PurgeUnit[] VALUES_ARRAY;
    public static final List<PurgeUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PurgeUnit[]{MINUTE, HOUR, DAY, SESSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PurgeUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PurgeUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PurgeUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PurgeUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PurgeUnit get(int value) {
        switch (value) {
            case 0: {
                return MINUTE;
            }
            case 1: {
                return HOUR;
            }
            case 2: {
                return DAY;
            }
            case 3: {
                return SESSION;
            }
        }
        return null;
    }

    private PurgeUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

