/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RuntimeStatus implements Enumerator
{
    DONE(0, "Done", "Done"),
    ERROR(1, "Error", "Error"),
    KILLED(2, "Killed", "Killed"),
    DEAD(3, "Dead", "Dead");

    public static final int DONE_VALUE = 0;
    public static final int ERROR_VALUE = 1;
    public static final int KILLED_VALUE = 2;
    public static final int DEAD_VALUE = 3;
    private static final RuntimeStatus[] VALUES_ARRAY;
    public static final List<RuntimeStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RuntimeStatus[]{DONE, ERROR, KILLED, DEAD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RuntimeStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuntimeStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuntimeStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuntimeStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuntimeStatus get(int value) {
        switch (value) {
            case 0: {
                return DONE;
            }
            case 1: {
                return ERROR;
            }
            case 2: {
                return KILLED;
            }
            case 3: {
                return DEAD;
            }
        }
        return null;
    }

    private RuntimeStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

