/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron.util;

import com.indy.engine.core.common.FunctionType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.stambia.quartz.cron.BasicCronType;
import com.stambia.quartz.cron.BasicCronTypeMode;
import com.stambia.quartz.cron.CronFactory;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.DailyIntervalTrigger;
import com.stambia.quartz.cron.Day;
import com.stambia.quartz.cron.DayCronType;
import com.stambia.quartz.cron.DayCronTypeMode;
import com.stambia.quartz.cron.DayOfMonthMode;
import com.stambia.quartz.cron.DeliveryType;
import com.stambia.quartz.cron.DocumentRoot;
import com.stambia.quartz.cron.ExecType;
import com.stambia.quartz.cron.IntervalUnit;
import com.stambia.quartz.cron.MonthCronType;
import com.stambia.quartz.cron.MonthCronTypeMode;
import com.stambia.quartz.cron.PurgeType;
import com.stambia.quartz.cron.PurgeUnit;
import com.stambia.quartz.cron.ScheduleParameter;
import com.stambia.quartz.cron.parser.CronParser;
import com.stambia.quartz.cron.util.CronResourceFactoryImpl;
import com.stambia.ui.resource.ResourcePluginStambia;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class CronUtils {
    private static ResourceSet initTmpCronResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new CronResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/quartz/cron", (Object)CronPackage.eINSTANCE);
        return resourceSet;
    }

    private static void createDefaultPurgeEditorModel(URI uri, String name, String host, int port) {
        ResourceSet resourceSet = CronUtils.initTmpCronResourceSet();
        Resource resource = resourceSet.createResource(uri);
        DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
        PurgeType root = CronFactory.eINSTANCE.createPurgeType();
        if (name != null && !name.isEmpty()) {
            root.setName(name);
        }
        CronTrigger cron = CronUtils.createDefaultCronTrigger();
        root.setTrigger(cron);
        root.setPurgeUnit(PurgeUnit.SESSION);
        documentRoot.setPurgeSchedule(root);
        resource.getContents().add((Object)documentRoot);
        try {
            resource.save(null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createDefaultScheduleEditorModel(URI uri, String name, String host, int port, String user, String password) {
        List schedules;
        ResourceSet resourceSet = CronUtils.initTmpCronResourceSet();
        Resource resource = resourceSet.createResource(uri);
        DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
        DeliveryType root = CronFactory.eINSTANCE.createDeliveryType();
        root.setRuntimeParameter(CronFactory.eINSTANCE.createRuntimeParameter());
        root.setExecutionType(ExecType.MEMORY);
        if (name != null && !name.isEmpty()) {
            root.setName(name);
        }
        if ((schedules = EngineRegistry.getDefault().getLstSchedules(host, Integer.valueOf(port), user, password, name)) != null && !schedules.isEmpty()) {
            for (Map schedule : schedules) {
                String jobName;
                if (!schedule.containsKey("jobName") || !(jobName = (String)schedule.get("jobName")).equals(name) || !schedule.containsKey("executionType")) continue;
                root.setExecutionType((Integer)schedule.get("executionType") == 1 ? ExecType.MEMORY : ExecType.COMMAND_LINE);
                break;
            }
        }
        try {
            Map mapParam;
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, Integer.valueOf(port), user, password);
            HashMap<String, String> mapDeliv = new HashMap<String, String>();
            mapDeliv.put("name", name);
            HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
            Map mapAnswer = null;
            try {
                mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
                mapAnswer = engine.get(mapQuestion);
            }
            catch (Exception e) {
                mapQuestion = new HashMap();
                mapQuestion.put(FunctionType.getDeliveryParams.name(), name);
                mapAnswer = engine.get(mapQuestion);
            }
            if (mapAnswer != null && (mapParam = (Map)mapAnswer.get(FunctionType.getDeliveryParams.name())) != null) {
                Map parameters = (Map)mapParam.get("parameters");
                for (String key : parameters.keySet()) {
                    ScheduleParameter param = CronFactory.eINSTANCE.createScheduleParameter();
                    param.setName(key);
                    param.setValue((String)((Map)parameters.get(key)).get("value"));
                    param.setIsEnabled(false);
                    root.getParameter().add((Object)param);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        CronTrigger cron = CronUtils.createDefaultCronTrigger();
        root.setTrigger(cron);
        documentRoot.setDeliverySchedule(root);
        resource.getContents().add((Object)documentRoot);
        try {
            resource.save(null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static DailyIntervalTrigger createDefaultDailyIntervalTrigger() {
        DailyIntervalTrigger trigger = CronFactory.eINSTANCE.createDailyIntervalTrigger();
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(11, 8);
        cal.set(12, 0);
        cal.set(13, 0);
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            trigger.setStartTimeOfDay(df.newXMLGregorianCalendarTime(8, 0, 0, null, Integer.MIN_VALUE));
            trigger.setEndTimeOfDay(df.newXMLGregorianCalendarTime(18, 0, 0, null, Integer.MIN_VALUE));
            trigger.setInterval(1);
            trigger.setIntervalUnit(IntervalUnit.HOUR);
            trigger.getDayOfWeek().addAll(Day.VALUES);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return trigger;
    }

    public static CronTrigger createDefaultCronTrigger() {
        CronTrigger cronTrigger = CronFactory.eINSTANCE.createCronTrigger();
        BasicCronType second = CronFactory.eINSTANCE.createBasicCronType();
        second.setMode(BasicCronTypeMode.SELECTED);
        BasicCronType minute = CronFactory.eINSTANCE.createBasicCronType();
        minute.setMode(BasicCronTypeMode.SELECTED);
        BasicCronType hour = CronFactory.eINSTANCE.createBasicCronType();
        hour.setMode(BasicCronTypeMode.SELECTED);
        DayCronType day = CronFactory.eINSTANCE.createDayCronType();
        day.setMode(DayCronTypeMode.DAY_OF_MONTH);
        day.setDayOfMonth(CronFactory.eINSTANCE.createDayOfMonth());
        day.getDayOfMonth().setMode(DayOfMonthMode.EVERY_DAY);
        day.setDayOfWeek(CronFactory.eINSTANCE.createDayOfWeek());
        MonthCronType month = CronFactory.eINSTANCE.createMonthCronType();
        month.setMode(MonthCronTypeMode.EVERY_MONTH);
        BasicCronType year = CronFactory.eINSTANCE.createBasicCronType();
        year.setMode(BasicCronTypeMode.EVERY);
        cronTrigger.setSecond(second);
        cronTrigger.setMinute(minute);
        cronTrigger.setHour(hour);
        cronTrigger.setDay(day);
        cronTrigger.setMonth(month);
        cronTrigger.setYear(year);
        return cronTrigger;
    }

    private static URI createDefaultTemporaryCronFile(String name, String host, int port) {
        String fileName = UUID.randomUUID().toString();
        File file = ResourcePluginStambia.getDefault().getStambiaWebAppTemp().append(String.valueOf(fileName) + ".cron").toFile();
        file.deleteOnExit();
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            URI uri = URI.createURI((String)("file:///" + file.getPath()));
            return uri;
        }
        return null;
    }

    public static URI createDefaultTmpScheduleCronFile(String name, String host, int port, String user, String password) {
        URI uri = CronUtils.createDefaultTemporaryCronFile(name, host, port);
        if (uri != null) {
            CronUtils.createDefaultScheduleEditorModel(uri, name, host, port, user, password);
        }
        return uri;
    }

    public static URI createDefaultTmpPurgeCronFile(String name, String host, int port) {
        URI uri = CronUtils.createDefaultTemporaryCronFile(name, host, port);
        if (uri != null) {
            CronUtils.createDefaultPurgeEditorModel(uri, name, host, port);
        }
        return uri;
    }

    public static URI createTemporaryDeliveryCronFile(String deliveryName, String triggerName, String host, int port, String user, String password) {
        String fileName = UUID.randomUUID().toString();
        File file = ResourcePluginStambia.getDefault().getStambiaWebAppTemp().append(String.valueOf(fileName) + ".cron").toFile();
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            URI uri = URI.createURI((String)("file:///" + file.getPath()));
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new CronResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/quartz/cron", (Object)CronPackage.eINSTANCE);
            Resource resource = resourceSet.createResource(uri);
            DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
            DeliveryType delivery = CronParser.deliveryToModel(deliveryName, triggerName, host, port, user, password);
            documentRoot.setDeliverySchedule(delivery);
            resource.getContents().add((Object)documentRoot);
            try {
                resource.save(null);
                return uri;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI createTemporaryPurgeCronFile(String triggerName, String host, int port, String user, String password) {
        String fileName = UUID.randomUUID().toString();
        File file = ResourcePluginStambia.getDefault().getStambiaWebAppTemp().append(String.valueOf(fileName) + ".cron").toFile();
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            URI uri = URI.createURI((String)("file:///" + file.getPath()));
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new CronResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/quartz/cron", (Object)CronPackage.eINSTANCE);
            Resource resource = resourceSet.createResource(uri);
            DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
            PurgeType purge = CronParser.purgeToModel(triggerName, host, port, user, password);
            documentRoot.setPurgeSchedule(purge);
            resource.getContents().add((Object)documentRoot);
            try {
                resource.save(null);
                return uri;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

