/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.indy.administration.AdministrationService;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IModelTranslationProvider;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.services.IRegistryContributionHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.IDependencyHelper;
import com.semarchy.xdi.designer.core.services.registry.RegistrationDescriptor;
import com.semarchy.xdi.designer.index.internal.CacheContent;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.DependencyHelper;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolderRegistry;
import com.semarchy.xdi.designer.index.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

@Component(service={IOverrideService.class, ICacheService.class, IRegistryContributionHelper.class}, scope=ServiceScope.SINGLETON)
public class CacheComponent
extends CacheImpl {
    private final String CROSS_REF_REGISTRY_ID = Messages.CacheComponent_0;
    ServiceRegistration<ICacheService.IWorkspaceSynchronizer> syncRegistration;
    ServiceRegistration internalResourceRegistration;
    CacheImpl.RegistryItemListener registryItemListener = new CacheImpl.RegistryItemListener(this);
    private IDependencyHelper dependencyHelper;
    @Reference
    private ServiceComponentRuntime scr;

    @Override
    @Reference(service=ICacheService.ICacheServiceListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addCacheServiceListener(ICacheService.ICacheServiceListener listener) {
        super.addCacheServiceListener(listener);
    }

    @Reference(service=XDIModelURIResolver.class)
    public void bind(XDIModelURIResolver modelProvider) {
        this.modelProvider = modelProvider;
    }

    @Override
    public void removeCacheServiceListener(ICacheService.ICacheServiceListener listener) {
        super.removeCacheServiceListener(listener);
    }

    @Reference(service=IRegistryService.class)
    public void bindRegistry(IRegistryService registryService) {
        this.registryService = registryService;
    }

    @Reference(service=AdministrationService.class)
    public void bindAdmin(AdministrationService adminService) {
    }

    @Activate
    public void activate(BundleContext ctx) {
        this.content = new CacheContent(this.modelProvider);
        this.syncRegistration = ctx.registerService(ICacheService.IWorkspaceSynchronizer.class, (Object)this.getWorkspaceSynchronizer(), null);
        this.internalResourceRegistration = ctx.registerService(new String[]{IInternalResourceRegistry.class.getName(), IModelTranslationProvider.class.getName()}, (Object)InternalResourceFolderRegistry.INSTANCE, null);
        this.dependencyHelper = new DependencyHelper(this);
        this.saveJob.setRule(this.modelProvider.createSchedulingRule(null));
        Job j = new Job(Messages.CacheComponent_crossRefRegistryJobName0){

            protected IStatus run(IProgressMonitor monitor) {
                ComponentDescriptionDTO dto = CacheComponent.this.scr.getComponentDescriptionDTO(Platform.getBundle((String)"com.indy.cross"), CacheComponent.this.CROSS_REF_REGISTRY_ID);
                try {
                    CacheComponent.this.scr.enableComponent(dto);
                }
                catch (Throwable t) {
                    return new Status(2, "com.semarchy.xdi.designer.index", String.format(Messages.CacheComponent_crossRefRegistryStartupFailure, CacheComponent.this.CROSS_REF_REGISTRY_ID), t);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule(10L);
    }

    @Deactivate
    public void deactivate(BundleContext ctx) {
        this.saveJob.cancel();
        this.dependencyHelper = null;
        this.syncRegistration.unregister();
        this.syncRegistration = null;
        this.internalResourceRegistration.unregister();
        this.internalResourceRegistration = null;
        IRegistryService.IRegistry techRegistry = this.registryService.getRegistry(RegistrationDescriptor.class);
        techRegistry.removeRegistryItemEventListener((IRegistryService.IRegistryItemEventListener)this.registryItemListener);
        techRegistry.removeRegistryBatchEventListener((IRegistryService.IRegistryBatchEventListener)this.registryItemListener);
        if (this.isInit()) {
            this.saveCache();
        }
    }

    public IDependencyHelper getDependencyHelper() {
        return this.dependencyHelper;
    }
}

