/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.indy.administration.AdministrationHelper;
import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.models.ModelWithDuplicateIdException;
import com.semarchy.xdi.designer.core.models.XSDValidityException;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.services.IRegistryContributionHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import com.semarchy.xdi.designer.core.services.cache.ICacheServiceInitializationFeedbackProvider;
import com.semarchy.xdi.designer.core.services.cache.ICacheState;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import com.semarchy.xdi.designer.core.services.registry.RegistrationDescriptor;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.services.registry.UDFImplementation;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.core.utils.MemoryMonitor;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.index.internal.CacheChangedJob;
import com.semarchy.xdi.designer.index.internal.CacheContent;
import com.semarchy.xdi.designer.index.internal.CacheState;
import com.semarchy.xdi.designer.index.internal.CacheStatistics;
import com.semarchy.xdi.designer.index.internal.EMFAnalyzer;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolderRegistry;
import com.semarchy.xdi.designer.index.internal.LoadSourceException;
import com.semarchy.xdi.designer.index.internal.MdTechRegistry;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.internal.MissingCrossRefInfo;
import com.semarchy.xdi.designer.index.internal.SourceStateImpl;
import com.semarchy.xdi.designer.index.internal.UnparsedResourceInfo;
import com.semarchy.xdi.designer.index.model.CacheFactory;
import com.semarchy.xdi.designer.index.model.CachePackage;
import com.semarchy.xdi.designer.index.model.DocumentRoot;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import com.semarchy.xdi.designer.index.model.Super;
import com.semarchy.xdi.designer.index.model.impl.CacheFactoryImpl;
import com.semarchy.xdi.designer.index.model.impl.EltImpl;
import com.semarchy.xdi.designer.index.model.impl.SourceImpl;
import com.semarchy.xdi.designer.index.model.impl.SuperImpl;
import com.semarchy.xdi.designer.index.model.util.CacheResourceFactoryImpl;
import com.semarchy.xdi.designer.index.model.util.CacheResourceImpl;
import com.semarchy.xdi.designer.index.parsers.StaxFastResourceLoader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public abstract class CacheImpl
implements IOverrideService,
ICacheService,
IRegistryContributionHelper,
ICacheService.ICacheSourceEventListener,
ICacheServiceInitializationFeedbackProvider.InitializableWithFeedBack {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private ResourceSet rs;
    private List<ICacheService.ICacheServiceListener> cacheListeners = Collections.synchronizedList(new ArrayList());
    private HashMap<URI, URI> overridenUri = new HashMap();
    protected CacheContent content;
    private Set<URI> toCheckBuildState = new HashSet<URI>();
    protected IRegistryService registryService;
    protected XDIModelURIResolver modelProvider;
    protected CacheChangedJob updateStateJob = new CacheChangedJob(this);
    private IRegistryService.IRegistryItemEventListener udfRegistryListener = new IRegistryService.IRegistryItemEventListener(){

        private void updateRegistrySourceDate() {
            Source source = CacheImpl.this.getSuper().getSource("UUID_REGISTRY_UDF");
            if (source != null) {
                source.setDateFile((XMLGregorianCalendar)new XMLCalendar(new Date(), 0));
            }
        }

        public void handleItemUpdated(IRegistryService.IRegistryKey registrationKey, Object item) {
        }

        public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
            String eltID = CacheHelper.extractEltID((String)((UDF)item).getURI().fragment());
            String fileID = CacheHelper.extractFileID((String)((UDF)item).getURI().fragment());
            Elt elt = CacheImpl.this.getSuper().findElt(eltID, fileID);
            if (elt != null) {
                elt.setState(StateType.INEXISTENT);
            }
            this.updateRegistrySourceDate();
        }

        public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
            String eltID = CacheHelper.extractEltID((String)((UDF)item).getURI().fragment());
            String fileID = CacheHelper.extractFileID((String)((UDF)item).getURI().fragment());
            Elt elt = CacheImpl.this.getSuper().findElt(eltID, fileID);
            try {
                if (elt == null) {
                    elt = ((SuperImpl)CacheImpl.this.getSuper()).createElt(eltID, fileID);
                }
                if (elt != null) {
                    elt.setState(StateType.EXISTS);
                }
                this.updateRegistrySourceDate();
            }
            catch (Exception e) {
                CacheImpl.this.logger.warn("unexpected", (Throwable)e);
            }
        }
    };
    private Super sup;
    private Resource cacheResource;
    private EMFAnalyzer sourceAnalyzer;
    private volatile boolean lock = false;
    private volatile boolean init = false;
    private IPath cacheLocation;
    long lastUpdate = -1L;
    protected Job saveJob = new Job("Save Cache"){

        protected IStatus run(IProgressMonitor monitor) {
            CacheImpl.this.saveCache();
            return Status.OK_STATUS;
        }
    };
    private volatile boolean triggerEnabled = true;
    private volatile boolean handledEvents = false;

    private void setInited(boolean inited) {
        this.init = inited;
        if (inited) {
            this.getCacheState().handleCacheInited();
        }
    }

    protected ResourceSet getRs() {
        if (this.rs == null) {
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
            editingDomain.setID("com.indy.emf.uri");
            this.rs = editingDomain.getResourceSet();
            ((ResourceSetImpl)this.rs).setURIResourceMap(new WeakHashMap());
            this.rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
            this.rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
            this.rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
            this.rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
            this.rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
            this.rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.rs.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
            this.rs.getLoadOptions().put("com.indy.md.ui.validateMdXML", Boolean.TRUE);
            this.rs.getLoadOptions().put("com.indy.emf.uri.resource.load.detectDuplicateId", Boolean.TRUE);
        }
        return this.rs;
    }

    protected Resource getCacheResource() {
        return this.cacheResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRs() {
        if (this.rs != null) {
            ((ResourceSetImpl)this.rs).getURIResourceMap().clear();
            ResourceSet resourceSet = this.rs;
            synchronized (resourceSet) {
                for (Resource r : this.rs.getResources()) {
                    try {
                        r.unload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.rs.getResources().clear();
            }
        }
    }

    private EMFAnalyzer getSourceAnalyzer() {
        if (this.sourceAnalyzer == null) {
            this.sourceAnalyzer = new EMFAnalyzer(this, this.registryService);
        }
        return this.sourceAnalyzer;
    }

    public void init(boolean force) {
        HashSet<URI> withDuplicate = new HashSet<URI>();
        if (force) {
            this.setInited(false);
            URI uri = URI.createFileURI((String)this.getLocation().toString());
            File file2 = new File(uri.toFileString());
            if (file2.exists()) {
                file2.delete();
            }
            if (this.sup != null) {
                for (Source s : this.sup.getResource()) {
                    URI f;
                    if (s.getDuplicates().isEmpty() || (f = s.getURI()) == null || !this.modelProvider.exists(f)) continue;
                    withDuplicate.add(f);
                }
            }
            IRegistryService.IRegistry udfRegistry = this.registryService.getRegistry(UDF.class);
            udfRegistry.removeRegistryItemEventListener(this.udfRegistryListener);
            this.cacheResource = null;
            this.sup = null;
            this.sourceAnalyzer = null;
        }
        if (!this.isInit() && !this.lock) {
            ICacheServiceInitializationFeedbackProvider feedBackProvider = (ICacheServiceInitializationFeedbackProvider)E4InjectorHelper.getService(ICacheServiceInitializationFeedbackProvider.class);
            if (feedBackProvider != null) {
                feedBackProvider.invokeWithFeadback((ICacheServiceInitializationFeedbackProvider.InitializableWithFeedBack)this, force, withDuplicate);
            } else {
                this.doInit((IProgressMonitor)new NullProgressMonitor(), force, withDuplicate);
            }
            this.setTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit(IProgressMonitor monitor, boolean force, Set<URI> withDuplicate) {
        try {
            try {
                this.lock = true;
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
                Object object = this;
                synchronized (object) {
                    this.saveJob.cancel();
                    try {
                        this.saveJob.join();
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("interrupted", (Throwable)e1);
                        Thread.currentThread().interrupt();
                    }
                    this.overridenUri.clear();
                    long start = new Date().getTime();
                    List<ICacheService.ICacheServiceListener> list = this.cacheListeners;
                    synchronized (list) {
                        for (ICacheService.ICacheServiceListener l : new ArrayList<ICacheService.ICacheServiceListener>(this.cacheListeners)) {
                            try {
                                l.handleCacheInitializing();
                            }
                            catch (Exception t) {
                                this.logger.info(Messages.CacheImpl_7, (Throwable)t);
                            }
                        }
                    }
                    Object cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_8);
                    this.resetRs();
                    cur.done();
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_9);
                    this.loadCache();
                    if (force) {
                        this.registryService.clear();
                    }
                    this.resetRs();
                    cur.done();
                    this.getCacheState().getUnparsedResources().clear();
                    this.getCacheState().getUnbuiltResources().clear();
                    this.getCacheState().getInvalidXMLResources().clear();
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_1);
                    this.createAndSynchronizeSourceFromRegistries();
                    Collection internalResourceURI = this.getInternalResourceRegistry().getInternalResourceURI();
                    HashSet<Source> srcs = new HashSet<Source>((Collection<Source>)this.getSuper().getResource());
                    for (Source s : srcs) {
                        if (s.getURI() == null || !s.getURI().isPlatformPlugin()) continue;
                        if (internalResourceURI.contains(s.getURI())) {
                            if (s.getState() == StateType.INEXISTENT || s.getState() == StateType.UNDEFINED) {
                                cur.subTask(String.valueOf(Messages.CacheImpl_create) + s.getURI());
                                this.handleEvent(new CacheSourceEvent(s.getId(), s.getURI(), null, CacheSourceEvent.Event.CREATE));
                                continue;
                            }
                            cur.subTask(String.valueOf(Messages.CacheImpl_update) + s.getURI());
                            this.handleEvent(new CacheSourceEvent(s.getId(), s.getURI(), null, CacheSourceEvent.Event.UPDATE));
                            continue;
                        }
                        cur.subTask(String.valueOf(Messages.CacheImpl_delete) + s.getURI());
                        this.handleEvent(new CacheSourceEvent(s.getId(), s.getURI(), null, CacheSourceEvent.Event.DELETE));
                    }
                    for (URI u2 : internalResourceURI) {
                        String srcId = null;
                        StaxFastResourceLoader loader = new StaxFastResourceLoader();
                        try {
                            srcId = loader.fastParse(u2);
                        }
                        catch (Exception e) {
                            this.logger.warn("unexpected", (Throwable)e);
                        }
                        if (srcId == null) continue;
                        Source s = this.getSuper().getSource(srcId);
                        if (s == null || s.getState() != StateType.SYNCHRO && s.getState() != StateType.EXISTS) {
                            cur.subTask(String.valueOf(Messages.CacheImpl_create) + u2);
                            this.handleEvent(new CacheSourceEvent(srcId, u2, null, CacheSourceEvent.Event.CREATE));
                            continue;
                        }
                        cur.subTask(String.valueOf(Messages.CacheImpl_update) + u2);
                        this.handleEvent(new CacheSourceEvent(srcId, u2, null, CacheSourceEvent.Event.UPDATE));
                    }
                    cur.done();
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_11);
                    try {
                        this.getWorkspaceSynchronizer().initialize(this);
                    }
                    catch (Exception ex) {
                        this.logger.warn("unexpected", (Throwable)ex);
                    }
                    cur.done();
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_12);
                    List allResource = this.modelProvider.getAllModels().stream().filter(u -> this.isElligibleResource((URI)u)).collect(Collectors.toList());
                    this.freeMemory(true);
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_14);
                    for (URI r : allResource) {
                        Source c = this.getSuper().getSource(r);
                        if (c == null || c.getState() == StateType.UNDEFINED || c.getState() == StateType.EXISTS || c.getState() == StateType.INEXISTENT) {
                            cur.subTask(String.valueOf(Messages.CacheImpl_create) + r.path());
                            this.getWorkspaceSynchronizer().handleAddedFile(r);
                        } else {
                            boolean needUpdate;
                            boolean bl = needUpdate = c.getLastScan() == null;
                            if (!needUpdate) {
                                Long t = this.modelProvider.resolve(r).lastModified();
                                GregorianCalendar gc = new GregorianCalendar();
                                gc.setTimeInMillis(t);
                                XMLCalendar xc = new XMLCalendar(gc.getTime(), 0);
                                if (c.getLastScan().compare((XMLGregorianCalendar)xc) < 0) {
                                    needUpdate = true;
                                }
                            }
                            if (needUpdate) {
                                cur.subTask(String.valueOf(Messages.CacheImpl_update) + r.path());
                                this.getWorkspaceSynchronizer().handleModifiedFile(c.getURI());
                            } else {
                                c = this.getSuper().getSource(r);
                                if (c != null && c.getState() == StateType.SYNCHRO) {
                                    this.appendToBuildCheck(c.getURI());
                                    if (c.getRemark().get((Object)"com.stambia.resource.marker.invalidXML") != null) {
                                        this.getCacheState().addInvalidResource(c.getURI(), new UnparsedResourceInfo((String)c.getRemark().get((Object)"com.stambia.resource.marker.invalidXML"), true, "com.stambia.resource.marker.invalidXML"));
                                    } else if (c.getRemark().get((Object)"com.stambia.resource.marker.duplicateid") != null) {
                                        this.getCacheState().addResourceWithDuplicateIds(c.getURI(), new UnparsedResourceInfo((String)c.getRemark().get((Object)"com.stambia.resource.marker.duplicateid"), true, "com.stambia.resource.marker.duplicateid"));
                                    }
                                }
                            }
                        }
                        if (c == null) {
                            c = this.getSuper().getSource(r);
                        }
                        if (c == null || c.getState() != StateType.SYNCHRO) continue;
                        this.updateOutdated(c);
                    }
                    srcs = new HashSet<Source>((Collection<Source>)this.getSuper().getResource());
                    for (Source s : srcs) {
                        if (s.getURI() == null || !s.getURI().isPlatformResource() || allResource.contains(s.getURI())) continue;
                        cur.subTask(String.valueOf(Messages.CacheImpl_delete) + s.getURI());
                        this.getWorkspaceSynchronizer().handleDeletedFile(s.getURI());
                    }
                    for (URI uri : withDuplicate) {
                        try {
                            Source current;
                            String id = this.getSourceId(uri);
                            if (id == null || (current = this.getSuper().getSource(id)) == null) continue;
                            for (Source s : current.getDuplicates()) {
                                if (s.getURI() == null || !s.getURI().equals(uri)) continue;
                                this.getWorkspaceSynchronizer().handleReplace(current.getURI(), s.getURI());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    cur.done();
                    cur = sub.newChild(1);
                    cur.setTaskName(Messages.CacheImpl_13);
                    this.getCacheState().analyseProblem(this);
                    this.setInited(true);
                    cur.done();
                    long end = new Date().getTime();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("CACHE BUILT IN {}", (Object)Math.abs(start - end));
                    }
                    this.lock = false;
                    this.setTimeStamp();
                    this.enableTrigger(true);
                    this.registryService.persist();
                    cur.done();
                }
                object = this.cacheListeners;
                synchronized (object) {
                    ArrayList<ICacheService.ICacheServiceListener> uu = new ArrayList<ICacheService.ICacheServiceListener>(this.cacheListeners);
                    for (ICacheService.ICacheServiceListener l : uu) {
                        try {
                            l.handleCacheInitialized();
                        }
                        catch (Exception t) {
                            this.logger.error(Messages.CacheImpl_17, (Throwable)t);
                        }
                    }
                }
                this.notifyContentChanged();
            }
            catch (EMFAnalyzer.OperationDeniedByCacheInconsistencyException ex) {
                IOException deleteException = null;
                try {
                    this.saveCache();
                }
                catch (Exception ex2) {
                    this.logger.error(Messages.CacheImpl_21, (Throwable)ex2);
                }
                File cacheFile = null;
                File cacheBackupFile = null;
                try {
                    cacheFile = this.getLocation().toFile();
                    cacheBackupFile = new File(cacheFile.getParentFile(), String.valueOf(cacheFile.getName()) + "_backup");
                    Files.copy(cacheFile.toPath(), cacheBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception ex2) {
                    cacheBackupFile = null;
                    this.logger.error(Messages.CacheImpl_26, (Throwable)ex2);
                }
                try {
                    Files.deleteIfExists(cacheFile.toPath());
                }
                catch (IOException e) {
                    deleteException = e;
                }
                String message = null;
                message = deleteException != null ? String.valueOf(message) + Messages.CacheImpl_29 : String.valueOf(message) + Messages.CacheImpl_30;
                message = String.valueOf(message) + Messages.CacheImpl_31;
                Status status = new Status(4, "com.semarchy.xdi.designer.index", Messages.CacheImpl_32, (Throwable)new Exception(String.format(message, cacheFile.getAbsolutePath(), cacheBackupFile.getAbsolutePath()), deleteException));
                ((ICacheService.ICacheInconsistencyErrorHandler)E4InjectorHelper.getService(ICacheService.ICacheInconsistencyErrorHandler.class)).handleError((IStatus)status);
                this.lock = false;
            }
            catch (Exception t) {
                this.logger.error(Messages.CacheImpl_indexationError, (Throwable)t);
                this.lock = false;
            }
        }
        finally {
            this.lock = false;
        }
    }

    public boolean isInit() {
        return this.init;
    }

    @Deprecated
    private void freeMemory() {
        this.freeMemory(false);
    }

    private void freeMemory(boolean force) {
        if (force || MemoryMonitor.isMemoryLow((int)15)) {
            this.logger.info("Available Heap Size is getting thin, trying to release EMF resources ...");
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)this.getRs());
            if (editingDomain != null) {
                editingDomain.getCommandStack().flush();
            }
            this.resetRs();
            System.gc();
        }
    }

    public IInternalResourceRegistry getInternalResourceRegistry() {
        return InternalResourceFolderRegistry.INSTANCE;
    }

    private void createAndSynchronizeSourceFromRegistries() {
        IRegistryService.IRegistry udfRegistry = this.registryService.getRegistry(UDF.class);
        Source source = this.getSuper().getSource("UUID_REGISTRY_UDF");
        if (source == null) {
            try {
                source = this.getSuper().addSource("UUID_REGISTRY_UDF", UDF.UDF_REGISTRY_SOURCE_URI, null);
                source.setState(StateType.SYNCHRO);
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        if (source != null && source.getState() != StateType.SYNCHRO) {
            source.setState(StateType.SYNCHRO);
        }
        HashSet<Elt> handled = new HashSet<Elt>();
        for (UDF u : udfRegistry.getAll()) {
            String eltID = CacheHelper.extractEltID((String)u.getURI().fragment());
            String fileID = CacheHelper.extractFileID((String)u.getURI().fragment());
            Elt elt = this.getSuper().findElt(eltID, fileID);
            if (elt == null) continue;
            elt.setState(StateType.EXISTS);
            handled.add(elt);
        }
        if (source != null) {
            for (Elt elt : source.getElt()) {
                if (handled.contains(elt)) continue;
                elt.setState(StateType.INEXISTENT);
            }
            source.setDateFile((XMLGregorianCalendar)new XMLCalendar(new Date(), 0));
        }
    }

    protected void checkBuiltState(URI r, boolean checkBuiltFiles) {
        String ext = r.fileExtension();
        URI mdFile = null;
        URI procFile = null;
        URI mapFile = null;
        if ("map".equals(ext)) {
            mdFile = URIUtils.getMappingBuiltMdFile((URI)r);
            procFile = URIUtils.getMappingBuiltProcFile((URI)r);
            mapFile = r;
        } else if (checkBuiltFiles && r.segment(2).equals("indy.build") && ("proc".equals(ext) || "md".equals(ext))) {
            String s = r.trimFileExtension().appendFileExtension("map").toString();
            s = s.replace("/indy.build/", "/");
            mapFile = URI.createURI((String)s, (boolean)true);
            mdFile = URIUtils.getMappingBuiltMdFile((URI)mapFile);
            procFile = URIUtils.getMappingBuiltProcFile((URI)mapFile);
        }
        if (mdFile != null && procFile != null && mapFile != null) {
            boolean isBuilt = true;
            if (this.modelProvider.exists(r)) {
                if (this.modelProvider.exists(mapFile)) {
                    if (this.modelProvider.exists(mdFile) && this.modelProvider.exists(procFile)) {
                        long mapModification = this.modelProvider.resolve(mapFile).lastModified();
                        long mdModification = this.modelProvider.resolve(mdFile).lastModified();
                        long procModification = this.modelProvider.resolve(procFile).lastModified();
                        isBuilt = mapModification <= mdModification && mapModification <= procModification;
                    } else {
                        isBuilt = false;
                    }
                } else {
                    isBuilt = false;
                }
            } else {
                isBuilt = !this.modelProvider.exists(mapFile);
            }
            if (isBuilt) {
                this.logger.debug("{} detected as built ", (Object)mapFile.path());
                this.getCacheState().removeUnbuilt(mapFile);
            } else if (this.getCacheState().addUnbuilt(mapFile)) {
                this.logger.debug("{} detected as unbuilt ", (Object)mapFile.path());
            }
        }
    }

    private Resource loadOrReload(ResourceSet rs, URI uri) throws WrappedException, IOException {
        Long before = System.currentTimeMillis();
        Resource re = null;
        re = rs.getResource(uri, false);
        if (re == null) {
            re = rs.getResource(uri, true);
        } else {
            if (re.isLoaded()) {
                re.unload();
            }
            if (re instanceof IndyResourceUtil.IndyResource && ((IndyResourceUtil.IndyResource)re).getIntrinsicIDToEObjectMap() != null) {
                ((IndyResourceUtil.IndyResource)re).setIntrinsicIDToEObjectMap(new TreeMap());
            }
            re = rs.getResource(uri, true);
        }
        if (this.logger.isDebugEnabled()) {
            Long after = System.currentTimeMillis();
            Long time = after - before;
            this.logger.debug("Load {} {}", (Object)uri, (Object)time);
        }
        return re;
    }

    private boolean isElligibleResource(URI resource) {
        return resource != null && IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(resource.fileExtension()) && (!"tech".equals(resource.fileExtension()) || AdministrationHelper.supportTechModelFromWorkspace());
    }

    private void checkLicense() {
        ICacheService.ILicenseValidator lv = (ICacheService.ILicenseValidator)E4InjectorHelper.getService(ICacheService.ILicenseValidator.class);
        if (lv != null) {
            lv.validateLicense();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadCache() {
        block23: {
            if (this.sup != null && (state = this.sup.getCacheState()) != null) {
                state.dispose();
            }
            this.checkLicense();
            time = System.currentTimeMillis();
            SourceImpl.REGISTRY.reset();
            EltImpl.getEltRegistry().resetMap();
            cacheResourceSet = new ResourceSetImpl();
            cacheResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new CacheResourceFactoryImpl());
            cacheResourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/cache", (Object)CachePackage.eINSTANCE);
            uri = URI.createFileURI((String)this.getLocation().toString());
            this.cacheResource = null;
            referenceAdapter = new CrossReferenceAdapter();
            try {
                this.cacheResource = cacheResourceSet.getResource(uri, true);
                cacheResourceSet.eAdapters().add((Object)referenceAdapter);
                sup = (Super)((EObject)this.cacheResource.getContents().get(0)).eContents().get(0);
                if (sup.getInternalVersion() == null || !"4.5".equals(sup.getInternalVersion())) {
                    this.logger.info("The Cache internalVersion does not match, we need to fully rebuild it");
                    this.cacheResource = null;
                    throw new Exception(Messages.CacheImpl_65);
                }
                this.logger.info("The Cache internalVersion matches.");
                break block23;
            }
            catch (Exception ex) {
                cacheResourceSet.eAdapters().remove((Object)referenceAdapter);
                ** for (r : cacheResourceSet.getResources())
            }
lbl-1000:
            // 1 sources

            {
                r.unload();
                continue;
            }
lbl32:
            // 1 sources

            cacheResourceSet.getResources().clear();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("loading issue", (Throwable)ex);
            }
            EltImpl.getEltRegistry().resetMap();
            SourceImpl.REGISTRY.reset();
        }
        if (this.cacheResource != null) {
            this.sup = (Super)EMFResourceUtil.getFirstElement((Resource)this.cacheResource);
            this.cacheResource.setModified(true);
        } else {
            this.registryService.clear();
            this.cacheResource = cacheResourceSet.createResource(uri);
            cacheResourceSet.eAdapters().add((Object)referenceAdapter);
            this.logger.info("create cacheResource at {}", (Object)uri.toFileString());
            eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)CachePackage.eINSTANCE);
            rootObject = CacheFactoryImpl.eINSTANCE.create(eClass);
            this.cacheResource.getContents().add((Object)rootObject);
            this.cacheResource.setModified(true);
            this.sup = CacheFactory.eINSTANCE.createSuper();
            this.sup.setInternalVersion("4.5");
            if (rootObject instanceof DocumentRoot) {
                ((DocumentRoot)rootObject).setRoot(this.sup);
            }
        }
        for (Elt e : this.sup.getElt()) {
            EltImpl.getEltRegistry().getIdMap().put(e.getId(), e);
            EltImpl.getEltRegistry().getIdMapCache().put(e.getId(), e);
        }
        udfRegistry = this.registryService.getRegistry(UDF.class);
        udfRegistry.addRegistryItemEventListener(this.udfRegistryListener);
        ((CacheResourceImpl)this.cacheResource).setIntrinsicIDToEObjectMap(null);
        internalResourceURI = this.getInternalResourceRegistry().getInternalResourceURI();
        m = new HashMap<String, URI>();
        m2 = new HashMap<String, URI>();
        for (URI u : internalResourceURI) {
            srcId = null;
            loader = new StaxFastResourceLoader();
            try {
                srcId = loader.fastParse(u);
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
            if (srcId == null) continue;
            m.put(srcId, u);
            m2.put(u.toString(), u);
            s = this.sup.getSource(srcId);
            if (s != null) {
                if (s.getURI() != null && s.getURI().isPlatformResource()) {
                    s.setOverridenPluginUri(u.toString());
                    continue;
                }
                if (s.getURI() != null) continue;
                try {
                    this.getSourceAnalyzer().create(u);
                }
                catch (Exception e1) {
                    this.logger.warn("An exception occured while creating missing resources", (Throwable)e1);
                }
                continue;
            }
            try {
                this.getSourceAnalyzer().create(u);
            }
            catch (Exception e1) {
                this.logger.warn("unexpected", (Throwable)e1);
            }
        }
        this.freeMemory(true);
        for (Source s : this.sup.getResource()) {
            u = (URI)m.get(s.getId());
            if (u != null && s.getURI() != null && s.getURI().isPlatformResource()) {
                s.setOverridenPluginUri(u.toString());
            }
            if (s.getOverridenPluginUri() == null) continue;
            if (u == null) {
                s.setOverridenPluginUri(null);
                continue;
            }
            this.overridenUri.put(s.getURI(), URI.createURI((String)s.getOverridenPluginUri()));
        }
        for (Source s : this.sup.getResource()) {
            if (s.getState() != StateType.DUPLICATE || (src = this.sup.getSource(s.getId())) == null || src.getState() == StateType.DUPLICATE) continue;
            src.getDuplicates().add((Object)s);
        }
        this.logger.info("Load cache file {}", (Object)(System.currentTimeMillis() - time));
        EcoreUtil.resolveAll((EObject)this.sup);
    }

    public synchronized boolean saveCache() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", StandardCharsets.UTF_8.name());
        try {
            if (this.cacheResource.isModified()) {
                Map map = EcoreUtil.ProxyCrossReferencer.find((Resource)this.cacheResource);
                if (map.size() > 0) {
                    this.logger.warn("STOP Pb de cross reference");
                }
                this.cacheResource.save(saveOptions);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error(Messages.CacheImpl_72, (Throwable)e);
        }
        return false;
    }

    public URI resolve(String fragment) {
        if (fragment != null) {
            String fileId = CacheHelper.extractFileID((String)fragment);
            URI uri = null;
            if (fileId != null) {
                Source s = this.sup.getSource(fileId);
                if (s != null) {
                    uri = s.getURI();
                }
            } else {
                throw new RuntimeException("fragment " + fragment + " has no fileID");
            }
            if (uri != null) {
                return uri.appendFragment(fragment);
            }
        }
        return null;
    }

    public boolean isLock() {
        return this.lock;
    }

    public synchronized void clean() {
        Long before = System.currentTimeMillis();
        ArrayList<Source> sources = new ArrayList<Source>((Collection<Source>)this.sup.getResource());
        Date s = new Date();
        Date e = new Date();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RESOLVING ALL {}", (Object)(e.getTime() - s.getTime()));
        }
        s = new Date();
        for (Source source : sources) {
            this.sup.cleanSource(source);
        }
        e = new Date();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SOURCE CLEANING {}", (Object)(e.getTime() - s.getTime()));
        }
        ArrayList<Elt> list = new ArrayList<Elt>((Collection<Elt>)this.sup.getElt());
        for (Elt elt : list) {
            this.sup.cleanElt(elt);
        }
        Long after = System.currentTimeMillis();
        Long time = after - before;
        this.logger.info("Clean All  {}", (Object)time);
    }

    public IPath getLocation() {
        if (this.cacheLocation == null) {
            this.cacheLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.semarchy.xdi.designer.index")).append("cache.xml");
        }
        return this.cacheLocation;
    }

    public Super getSuper() {
        return this.sup;
    }

    public String getEltName(String eltID, String fileID) {
        Elt elt = this.sup.findElt(eltID, fileID);
        if (elt != null) {
            return elt.getName();
        }
        return null;
    }

    public synchronized Collection<URI> getAllResources() {
        return this.getSuper().getResource().stream().map(Source::getURI).filter(u -> u != null).collect(Collectors.toSet());
    }

    public synchronized List<URI> findResourceURI(String pattern) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (Source source : new ArrayList<Source>((Collection<Source>)this.getSuper().getResource())) {
            if (source.getState() != StateType.SYNCHRO || source.getUriStr() == null || !source.getUriStr().matches(pattern) || !source.getURI().isPlatformPlugin() && !this.modelProvider.exists(source.getURI())) continue;
            result.add(source.getURI());
        }
        if (!result.isEmpty()) {
            return result;
        }
        return Collections.emptyList();
    }

    public long getTimeStamp() {
        return this.lastUpdate;
    }

    public void setTimeStamp() {
        if (this.lock) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.saveJob.schedule(3000L);
    }

    protected synchronized void releaseLoadedResources() {
        this.resetRs();
    }

    public URI getResourceURIByFileId(String sourceId) throws Exception {
        Source s = this.getSuper().getSource(sourceId);
        if (s != null) {
            if (s.getState() == StateType.SYNCHRO) {
                return s.getURI();
            }
            if (s.getState() == StateType.INEXISTENT) {
                throw new Exception(Messages.bind((String)Messages.CacheImpl_79, (Object)sourceId));
            }
            if (s.getState() == StateType.EXISTS) {
                return s.getURI();
            }
        }
        return null;
    }

    public String getSourceId(URI uri) {
        String id;
        Source source = this.getSuper().getSource(uri);
        if (source == null && uri.fragment() != null && (id = CacheHelper.extractEltInfo((String)uri.fragment(), (String)"fileId")) != null) {
            try {
                URI realURI = this.getResourceURIByFileId(id);
                source = this.getSuper().getSource(realURI);
            }
            catch (Exception ex) {
                this.logger.error("unexpected", (Throwable)ex);
            }
        }
        return source == null ? null : source.getId();
    }

    public boolean isOverrider(URI workspaceUri) {
        for (URI key : this.overridenUri.keySet()) {
            if (!key.equals(workspaceUri)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverriden(URI workspaceUri) {
        return this.overridenUri.keySet().stream().anyMatch(key -> this.overridenUri.get(key).equals(workspaceUri));
    }

    public URI getOverridenURI(URI workspaceUri) {
        return this.overridenUri.keySet().stream().filter(key -> this.overridenUri.get(key).equals(workspaceUri)).findFirst().orElse(null);
    }

    public IMdTechRegistry getMdTechRegistry() {
        ArrayList<URI> techFiles = new ArrayList<URI>();
        HashMap<String, List<URI>> mdLevelCodeMap = new HashMap<String, List<URI>>();
        for (Source s : this.getSuper().getResource()) {
            if (s.getState() != StateType.SYNCHRO) continue;
            if ("md".equals(s.getURI().fileExtension())) {
                String key = null;
                for (Elt elt : s.getElt()) {
                    if (!elt.isRootElt()) continue;
                    key = elt.getLevelCode();
                    break;
                }
                if (key != null) {
                    List<URI> uris = mdLevelCodeMap.get(key);
                    if (uris == null) {
                        uris = new ArrayList<URI>();
                        mdLevelCodeMap.put(key, uris);
                    }
                    uris.add(s.getURI());
                }
            }
            if (!"tech".equals(s.getURI().fileExtension())) continue;
            techFiles.add(s.getURI());
        }
        return new MdTechRegistry(mdLevelCodeMap, techFiles);
    }

    public synchronized List<URI> getReferencedResources(URI fileURI) {
        ArrayList<URI> l = new ArrayList<URI>();
        Source s = this.getSuper().getSource(fileURI);
        if (s == null) {
            this.logger.info(() -> NLS.bind((String)Messages.CacheImpl_85, (Object)fileURI));
            return l;
        }
        for (Elt elt : s.getElt()) {
            for (Elt r : elt.getReference()) {
                try {
                    URI uri;
                    if (r.getSource() == null || (uri = r.getSource().getURI()) == null || uri.equals(fileURI) || l.contains(uri)) continue;
                    l.add(uri);
                }
                catch (Exception ex) {
                    this.logger.error("unexpected", (Throwable)ex);
                }
            }
        }
        return l;
    }

    public boolean isSynchronized(URI eltUri) {
        String sourceId = this.getSourceId(eltUri.trimFragment());
        Source src = this.getSuper().getSource(sourceId);
        if (src != null && src.getState() == StateType.SYNCHRO) {
            String fragment = eltUri.fragment();
            String eltID = CacheHelper.extractEltID((String)fragment);
            String fileID = CacheHelper.extractFileID((String)fragment);
            Elt elt = this.getSuper().findElt(eltID, fileID);
            if (elt != null) {
                return elt.getState() == StateType.EXISTS;
            }
            if (sourceId.equals(eltID)) {
                return true;
            }
        }
        return false;
    }

    public synchronized void enableTrigger(boolean triggerState) {
        this.triggerEnabled = triggerState;
        if (triggerState) {
            HashSet<URI> buildStateToCheck = new HashSet<URI>(this.toCheckBuildState);
            this.toCheckBuildState.clear();
            for (URI f : buildStateToCheck) {
                if (f == null) continue;
                this.checkBuiltState(f, true);
            }
        }
        if (this.getSuper() != null) {
            ((SuperImpl)this.getSuper()).enableCacheTrigger(triggerState);
        }
        if (this.triggerEnabled && this.handledEvents) {
            this.handledEvents = false;
            this.setTimeStamp();
            this.releaseLoadedResources();
            this.notifyContentChanged();
        }
    }

    public ICacheService.SourceState getSourceState(URI uri) {
        Source s;
        String sourceID = null;
        if (uri.fragment() != null) {
            sourceID = CacheHelper.extractFileID((String)uri.fragment());
        }
        Source source = s = sourceID == null ? ((SuperImpl)this.getSuper()).getSource(uri) : ((SuperImpl)this.getSuper()).getSource(sourceID);
        if (s == null) {
            return new SourceStateImpl();
        }
        CacheState st = this.getCacheState();
        return new SourceStateImpl(s, st, this.modelProvider.resolve(uri).lastModified());
    }

    public void addCacheServiceListener(ICacheService.ICacheServiceListener listener) {
        if (!this.cacheListeners.contains(listener)) {
            this.cacheListeners.add(listener);
        }
    }

    public void removeCacheServiceListener(ICacheService.ICacheServiceListener listener) {
        this.cacheListeners.remove(listener);
    }

    public URI findResourceURIByFileId(String fileId) {
        Source src = this.getSuper().getSource(fileId);
        if (src != null) {
            return src.getURI();
        }
        return null;
    }

    public boolean isSourceDuplicate(URI uri) {
        Source s = this.getSuper().getSource(uri);
        return s != null && s.getState() == StateType.DUPLICATE;
    }

    public HashMap<URI, List<URI>> getDuplicatedResources() {
        HashMap<URI, List<URI>> l = new HashMap<URI, List<URI>>();
        for (Source s : this.getSuper().getResource()) {
            if (s.getDuplicates().isEmpty()) continue;
            ArrayList<URI> list = new ArrayList<URI>();
            l.put(s.getURI(), list);
            for (Source d : s.getDuplicates()) {
                if (!d.getURI().isPlatformResource()) continue;
                list.add(d.getURI());
            }
        }
        return l;
    }

    CacheContent getWorkspaceSynchronizer() {
        return this.content;
    }

    public synchronized void handleEvent(CacheSourceEvent event) throws EMFAnalyzer.OperationDeniedByCacheInconsistencyException {
        this.logger.debug("handling {} for {}", (Object)event.getType(), (Object)event.getCurrentURI());
        this.handledEvents = true;
        try {
            URI file = !event.getCurrentURI().isPlatformResource() ? null : event.getCurrentURI();
            Source s = null;
            switch (event.getType()) {
                case DELETE_DUPLICATE: {
                    try {
                        s = this.getSourceAnalyzer().deleteDuplicate(event.getSourceId(), event.getCurrentURI());
                        s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                        s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                        if (s != null) {
                            this.overridenUri.remove(s.getURI());
                        }
                        this.getCacheState().removeInvalidResource(file);
                        this.getCacheState().removeResourceWithDuplicateIds(file);
                        this.getCacheState().removeUnparsedResource(file);
                        this.getCacheState().removeOutdated(file);
                    }
                    catch (Exception t) {
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(t));
                    }
                    break;
                }
                case CREATE: {
                    try {
                        IComponentService.IComponent component = this.getInternalResourceRegistry().getProvidingComponent(event.getSourceId());
                        if (component == null || AdministrationHelper.componentAuthorized((IComponentService.IComponent)component)) {
                            try {
                                s = this.getSourceAnalyzer().create(event.getCurrentURI());
                                s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                                s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                                this.getCacheState().removeUnparsedResource(file);
                                this.getCacheState().removeInvalidResource(file);
                                this.getCacheState().removeResourceWithDuplicateIds(file);
                                this.getCacheState().removeDiscardedByLicense(file, component);
                            }
                            catch (LoadSourceException ex) {
                                s = this.handleException(file, ex);
                            }
                            this.overridenUri.remove(s.getURI());
                            this.appendToBuildCheck(event.getCurrentURI());
                            this.updateOutdated(s);
                            break;
                        }
                        if (component != null) {
                            this.getCacheState().addDiscardedByLicense(file, component);
                        }
                    }
                    catch (Exception t) {
                        this.logger.warn("unexpected", (Throwable)t);
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(t));
                    }
                    break;
                }
                case DELETE: {
                    s = this.getSourceAnalyzer().remove(event.getSourceId());
                    s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                    s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                    s.getRemark().removeKey((Object)"com.stambia.resource.marker.featureNotFound");
                    this.getCacheState().removeInvalidResource(file);
                    this.getCacheState().removeResourceWithDuplicateIds(file);
                    this.getCacheState().removeUnparsedResource(file);
                    this.overridenUri.remove(s.getURI());
                    this.getCacheState().removeOutdated(file);
                    this.appendToBuildCheck(event.getCurrentURI());
                    break;
                }
                case DUPLICATE: {
                    try {
                        Long t = this.modelProvider.resolve(file).lastModified();
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.setTimeInMillis(t);
                        XMLCalendar xc = new XMLCalendar(gc.getTime(), 0);
                        s = this.getSourceAnalyzer().duplicate(event.getSourceId(), event.getCurrentURI(), file, xc);
                        s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                        s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                        s.getRemark().removeKey((Object)"com.stambia.resource.marker.featureNotFound");
                        this.getCacheState().removeInvalidResource(file);
                        this.getCacheState().removeResourceWithDuplicateIds(file);
                        this.overridenUri.remove(s.getURI());
                        this.getCacheState().removeUnparsedResource(file);
                        this.getCacheState().removeOutdated(file);
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(e));
                    }
                    break;
                }
                case MOVE: {
                    s = this.getSourceAnalyzer().move(event.getPreviousURI(), event.getCurrentURI());
                    if (this.overridenUri.remove(event.getPreviousURI()) != null) {
                        this.overridenUri.put(s.getURI(), URI.createURI((String)s.getOverridenPluginUri()));
                    }
                    try {
                        if (event.getPreviousURI() != null) {
                            ICacheState.IUnparsedResourceInfo i = this.getCacheState().removeInvalidResource(event.getPreviousURI());
                            if (i != null) {
                                this.getCacheState().addInvalidResource(event.getCurrentURI(), i);
                            }
                            if ((i = this.getCacheState().removeResourceWithDuplicateIds(event.getPreviousURI())) != null) {
                                this.getCacheState().addResourceWithDuplicateIds(event.getCurrentURI(), i);
                            }
                            if (this.getCacheState().removeOutdated(event.getPreviousURI())) {
                                this.getCacheState().addOutdated(event.getCurrentURI());
                            }
                            if (this.getCacheState().removeUnbuilt(event.getPreviousURI())) {
                                this.getCacheState().addUnbuilt(event.getCurrentURI());
                            }
                            if ((i = this.getCacheState().removeUnparsedResource(event.getPreviousURI())) != null) {
                                this.getCacheState().addUnparsedResource(event.getCurrentURI(), i);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn("unexpected", (Throwable)ex);
                    }
                    break;
                }
                case OVERRIDE: {
                    try {
                        IComponentService.IComponent component = this.getInternalResourceRegistry().getProvidingComponent(event.getSourceId());
                        if (component == null || AdministrationHelper.componentAuthorized((IComponentService.IComponent)component)) {
                            try {
                                s = this.getSourceAnalyzer().override(event.getSourceId(), event.getCurrentURI(), event.getPreviousURI());
                                s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                                s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                                this.getCacheState().removeUnparsedResource(file);
                                this.getCacheState().removeInvalidResource(file);
                            }
                            catch (LoadSourceException ex) {
                                s = this.handleException(file, ex);
                            }
                            this.overridenUri.put(event.getCurrentURI(), URI.createURI((String)s.getOverridenPluginUri()));
                            this.updateOutdated(s);
                            break;
                        }
                        this.getCacheState().addDiscardedByLicense(file, component);
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(e));
                    }
                    break;
                }
                case REPLACE: {
                    try {
                        Source replaced = this.getSuper().getSource(event.getSourceId());
                        try {
                            s = this.getSourceAnalyzer().replace(event.getSourceId(), event.getCurrentURI());
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                            this.getCacheState().removeUnparsedResource(file);
                            this.getCacheState().removeInvalidResource(file);
                        }
                        catch (LoadSourceException ex) {
                            s = this.handleException(file, ex);
                        }
                        if (this.overridenUri.remove(replaced.getURI()) != null) {
                            this.overridenUri.put(s.getURI(), URI.createURI((String)s.getOverridenPluginUri()));
                        }
                        this.appendToBuildCheck(event.getCurrentURI());
                        this.updateOutdated(s);
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(e));
                    }
                    break;
                }
                case RESTORE: {
                    try {
                        URI oldURI = this.getSuper().getSource(event.getSourceId()).getURI();
                        try {
                            s = this.getSourceAnalyzer().restore(event.getSourceId(), event.getCurrentURI());
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                            this.getCacheState().removeUnparsedResource(file);
                            this.getCacheState().removeInvalidResource(file);
                        }
                        catch (LoadSourceException ex) {
                            s = this.handleException(file, ex);
                        }
                        this.overridenUri.remove(oldURI);
                        this.appendToBuildCheck(event.getCurrentURI());
                        this.updateOutdated(s);
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(e));
                    }
                    break;
                }
                case UPDATE: {
                    try {
                        try {
                            s = this.getSourceAnalyzer().update(event.getCurrentURI());
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
                            s.getRemark().removeKey((Object)"com.stambia.resource.marker.duplicateid");
                            this.getCacheState().removeUnparsedResource(file);
                            this.getCacheState().removeInvalidResource(file);
                        }
                        catch (LoadSourceException ex) {
                            s = this.handleException(file, ex);
                        }
                        this.appendToBuildCheck(event.getCurrentURI());
                        this.updateOutdated(s);
                        break;
                    }
                    catch (Exception t) {
                        this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(t));
                    }
                }
            }
        }
        finally {
            this.logger.debug("handled {} for {}({})", (Object)event.getType(), (Object)event.getCurrentURI(), (Object)event.getSourceId());
            this.freeMemory();
        }
    }

    private void appendToBuildCheck(URI uri) {
        if (uri != null && uri.isPlatformResource() && ("map".equals(uri.fileExtension()) || "md".equals(uri.fileExtension()) || "proc".equals(uri.fileExtension()) && "indy.build".equals(uri.segment(2)))) {
            this.toCheckBuildState.add(uri);
        }
    }

    private void updateOutdated(Source s) {
        if (s.getURI() != null) {
            if (s.isOutdated()) {
                this.getCacheState().addOutdated(s.getURI());
            } else {
                this.getCacheState().removeOutdated(s.getURI());
            }
        }
    }

    public void addEventListener(ICacheService.ICacheSourceEventListener listener) {
        this.getWorkspaceSynchronizer().addEventListener(listener);
    }

    public void removeEventListener(ICacheService.ICacheSourceEventListener listener) {
        this.getWorkspaceSynchronizer().removeEventListener(listener);
    }

    public boolean isModelContributeToRegistry(URI modelCacheURI, Class<? extends IRegistryService.RegistryItem> registryItemClass) {
        Source source = this.getSuper().getSource(modelCacheURI);
        if (source != null && source.getState() == StateType.SYNCHRO) {
            return source.getContributedRegistry().contains((Object)registryItemClass.getName());
        }
        return false;
    }

    public Collection<URI> listNonTemplatesProcesses() {
        ArrayList<URI> proc = new ArrayList<URI>();
        for (Source s : this.getSuper().getResource()) {
            if (s.getState() != StateType.SYNCHRO || s.getURI() == null || !"proc".equals(s.getURI().fileExtension())) continue;
            boolean isTpl = false;
            block1: for (Elt e : s.getElt()) {
                for (Elt f : e.getUsage()) {
                    if (f.getSource() == null || f.getSource().getURI() == null || !"tpc".equals(f.getSource().getURI().fileExtension())) continue;
                    isTpl = true;
                    continue block1;
                }
            }
            if (isTpl) continue;
            proc.add(s.getURI());
        }
        return proc;
    }

    private Source handleException(URI file, LoadSourceException ex) {
        WrappedException w = ex.getWrappedException();
        if (w.getCause() instanceof XSDValidityException) {
            ex.getSource().getRemark().put((Object)"com.stambia.resource.marker.invalidXML", (Object)ex.getWrappedException().getCause().getMessage());
            this.getCacheState().addInvalidResource(file, new UnparsedResourceInfo(ex.getWrappedException().getCause()));
        } else if (w.getCause() instanceof ModelWithDuplicateIdException) {
            ex.getSource().getRemark().put((Object)"com.stambia.resource.marker.duplicateid", (Object)ex.getWrappedException().getCause().getMessage());
            this.getCacheState().addResourceWithDuplicateIds(file, new UnparsedResourceInfo(ex.getWrappedException().getCause()));
        } else {
            ex.getSource().getRemark().removeKey((Object)"com.stambia.resource.marker.invalidXML");
            this.getCacheState().addUnparsedResource(file, new UnparsedResourceInfo(ex.getWrappedException()));
        }
        return ex.getSource();
    }

    /*
     * Unable to fully structure code
     */
    public HashMap<String, Set<URI>> getUsedVariableURI(UDF udf) {
        varMgrURI = new HashMap<String, Set<URI>>();
        mdNodeURI = udf.getMdNodeSourceURI();
        elt = this.getSuper().findElt(CacheHelper.extractFileID((String)mdNodeURI.fragment()), CacheHelper.extractFileID((String)mdNodeURI.fragment()));
        refByVariableMdModelId = new HashMap<Source, HashSet<Elt>>();
        if (elt == null || elt.getSource() == null) {
            return varMgrURI;
        }
        for (Elt ref : elt.getSource().getMandatoryElt()) {
            if (ref.getSource() == null || (srcID = ref.getSource().getId()) == null || (variableSetElt = this.getSuper().findElt(srcID, srcID)) == null || variableSetElt.getState() != StateType.EXISTS || !"com.stambia.variable.set".equals(variableSetElt.getLevelCode())) continue;
            s = (HashSet<Elt>)refByVariableMdModelId.get(ref.getSource());
            if (s == null) {
                s = new HashSet<Elt>();
                refByVariableMdModelId.put(ref.getSource(), s);
            }
            s.add(ref);
        }
        p = EPackage.Registry.INSTANCE.getEPackage("http://www.stambia.com/md");
        feature = ((EClass)p.getEClassifier("MdNode")).getEStructuralFeature("name");
        editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        rs = editingDomain.getResourceSet();
        ((ResourceSetImpl)rs).setURIResourceMap(new WeakHashMap<K, V>());
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
        rs.getLoadOptions().put("com.indy.md.ui.validateMdXML", Boolean.TRUE);
        try {
            for (Source src : refByVariableMdModelId.keySet()) {
                r = null;
                try {
                    try {
                        r = this.loadOrReload(rs, src.getURI());
                        block21: for (Elt ref : (Set)refByVariableMdModelId.get(src)) {
                            o = r.getEObject(ref.getRealId());
                            try {
                                variableName = (String)o.eGet(feature);
                                if (variableName == null) continue;
                                for (UDFImplementation i : udf.getImplementations()) {
                                    if (!i.getExpression().contains("%{" + variableName + "}%")) continue;
                                    localURI = ref.getSource().getURI().appendFragment(String.valueOf(ref.getRealId()) + "?fileId=" + src.getId() + "?");
                                    if (varMgrURI.get(variableName) == null) {
                                        varMgrURI.put(variableName, new HashSet<E>());
                                    }
                                    varMgrURI.get(variableName).add(localURI);
                                    continue block21;
                                }
                            }
                            catch (Exception var16_18) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        if (r == null) continue;
                        try {
                            r.unload();
                            rs.getResources().remove((Object)r);
                        }
                        catch (Exception ex) {
                            this.logger.warn("unexpected", (Throwable)ex);
                        }
                        continue;
                    }
                }
                catch (Throwable var20_26) {
                    if (r != null) {
                        try {
                            r.unload();
                            rs.getResources().remove((Object)r);
                        }
                        catch (Exception ex) {
                            this.logger.warn("unexpected", (Throwable)ex);
                        }
                    }
                    throw var20_26;
                }
                if (r == null) continue;
                try {
                    r.unload();
                    rs.getResources().remove((Object)r);
                }
                catch (Exception ex) {
                    this.logger.warn("unexpected", (Throwable)ex);
                }
            }
        }
        finally {
            ** for (r : rs.getResources())
        }
lbl-1000:
        // 1 sources

        {
            try {
                r.unload();
            }
            catch (Exception ex) {
                this.logger.warn("unexpected", (Throwable)ex);
            }
            continue;
        }
lbl102:
        // 1 sources

        editingDomain.dispose();
        return varMgrURI;
    }

    public String getEltLevelCode(String fileID, String eltID) {
        Elt e = this.getSuper().findElt(eltID, fileID);
        if (e != null) {
            return e.getLevelCode();
        }
        return null;
    }

    public void enableResources(Map<String, URI> modelURI) {
        try {
            this.enableTrigger(false);
            block3: for (Map.Entry<String, URI> e : modelURI.entrySet()) {
                Source current = this.getSuper().getSource(e.getKey());
                for (Source s : current.getDuplicates()) {
                    if (s.getURI() == null || !s.getURI().equals(e.getValue())) continue;
                    this.getWorkspaceSynchronizer().handleReplace(current.getURI(), s.getURI());
                    this.appendToBuildCheck(current.getURI());
                    this.appendToBuildCheck(s.getURI());
                    continue block3;
                }
            }
            this.setTimeStamp();
        }
        finally {
            this.enableTrigger(true);
        }
    }

    public CacheState getCacheState() {
        return this.getSuper().getCacheState();
    }

    public boolean isContributingToRegistry(String modelId, Class class1) {
        Source s = this.getSuper().getSource(modelId);
        return class1 != null && s != null && s.getContributedRegistry().contains((Object)class1.getName());
    }

    private int checkVersion(String versionA, String versionB) {
        if (versionA.equalsIgnoreCase(versionB)) {
            return 0;
        }
        String[] versionAarr = versionA.split("\\.");
        String[] versionBarr = versionB.split("\\.");
        int depth = 0;
        int biggest = -1;
        String[] stringArray = versionAarr;
        int n = versionAarr.length;
        int n2 = 0;
        while (n2 < n) {
            String versionAtom = stringArray[n2];
            if (versionBarr.length >= depth + 1) {
                int b;
                int a = Integer.parseInt(versionAtom);
                if (a > (b = Integer.parseInt(versionBarr[depth]))) {
                    biggest = 1;
                    break;
                }
                if (a < b) {
                    biggest = -1;
                    break;
                }
            } else {
                biggest = 1;
                break;
            }
            ++depth;
            ++n2;
        }
        return biggest;
    }

    public int compareVersion() {
        String cacheVersion = this.getSuper().getInternalVersion();
        String targetVersion = "4.5";
        return this.checkVersion(targetVersion, cacheVersion);
    }

    public synchronized Collection<String> getSourceIdsContirbutingToRegistry(Class<? extends IRegistryService.RegistryItem> class1) {
        ArrayList<String> sourcesIds = new ArrayList<String>();
        for (Source s : this.getSuper().getResource()) {
            if (s.getState() != StateType.SYNCHRO || !s.getContributedRegistry().contains((Object)class1.getName())) continue;
            sourcesIds.add(s.getId());
        }
        return sourcesIds;
    }

    public List<URI> getSourceWithCrossReferences() {
        return this.getSuper().getResource().stream().filter(s -> s.getURI() != null && s.getURI().isPlatformResource() && s.getId() != null && s.getState() == StateType.SYNCHRO && s.getContributedRegistry().contains((Object)ICrossReference.class.getName())).map(Source::getURI).collect(Collectors.toList());
    }

    public ICacheService.Statistics getStatistics() {
        return new CacheStatistics(this.getSuper().getResource().size(), this.getSuper().getElt().size());
    }

    private void notifyContentChanged() {
        this.updateStateJob.cancel();
        this.updateStateJob.schedule(100L);
    }

    public void addUpdateTask(String taskName, Runnable task) {
        this.updateStateJob.cancel();
        try {
            this.updateStateJob.join();
        }
        catch (InterruptedException e) {
            this.logger.debug("interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.updateStateJob.addSubtask(taskName, task);
    }

    public void removeUpdateTask(String taskName) {
        this.updateStateJob.removeSubtask(taskName);
    }

    public Map<URI, ICacheService.MissingCrossReferenceInfo> computeMissingCrossReferenceInfo() {
        HashMap<URI, ICacheService.MissingCrossReferenceInfo> res = new HashMap<URI, ICacheService.MissingCrossReferenceInfo>();
        Iterator<Elt> iterator = this.getSuper().getElementInexistent().iterator();
        while (iterator.hasNext()) {
            Elt elt;
            Elt curElt = elt = iterator.next();
            for (Elt ref : curElt.getUsage()) {
                URI file;
                if (ref.getSource() == elt.getSource() || ref.getSource() == null || (file = ref.getSource().getURI()) == null || !this.modelProvider.exists(file) || res.get(file) != null) continue;
                String id = String.valueOf(elt.getRealId()) + "=>" + ref.getRealId();
                String message = "";
                if (elt.getName() != null && !elt.getName().isEmpty()) {
                    message = String.valueOf(message) + String.format(Messages.CacheImpl_refIdMissing, elt.getName());
                }
                if (elt.getSource() != null && elt.getSource().getUriStr() != null && !elt.getSource().getUriStr().isEmpty()) {
                    message = String.valueOf(message) + " (file: " + elt.getSource().getUriStr() + ")";
                }
                if (elt.getType() != null && !elt.getType().isEmpty()) {
                    message = String.valueOf(message) + " (type: " + elt.getType() + ")";
                }
                if (!message.isEmpty()) {
                    message = String.valueOf(message) + " (id: " + elt.getRealId() + ")";
                }
                message = URI.decode((String)message);
                String newLocation = ref.getName();
                res.put(file, new MissingCrossRefInfo(message, newLocation, id));
            }
        }
        return res;
    }

    public Map<String, String> generateResourcePathPerId(boolean absoluthPath) {
        return SourceImpl.REGISTRY.generateIdSourceMap(absoluthPath, this.modelProvider);
    }

    protected class RegistryItemListener
    implements IRegistryService.IRegistryItemEventListener,
    IRegistryService.IRegistryBatchEventListener {
        private Collection<Source> toUpdate = new HashSet<Source>();

        protected RegistryItemListener() {
        }

        public void handleItemUpdated(IRegistryService.IRegistryKey registrationKey, Object item) {
        }

        public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
            block7: {
                RegistrationDescriptor obj = (RegistrationDescriptor)item;
                String ID = obj.getRegistrationKey().getProviderFileID();
                try {
                    URI techResourceURI = CacheImpl.this.findResourceURIByFileId(ID);
                    HashMap<Class, IRegistryService.IRegistry> regMap = new HashMap<Class, IRegistryService.IRegistry>();
                    for (Class c : obj.getRegistryItemsClass()) {
                        IRegistryService.IRegistry reg = CacheImpl.this.registryService.getRegistry(c);
                        if (reg == null) continue;
                        regMap.put(c, reg);
                    }
                    Source s = CacheImpl.this.getSuper().getSource(techResourceURI);
                    if (s != null) {
                        HashSet<Source> dependancies = new HashSet<Source>();
                        for (Elt elt : s.getElt()) {
                            for (Elt u : elt.getUsage()) {
                                if (u.getSource() == null || u.getSource().getState() != StateType.SYNCHRO || !dependancies.add(u.getSource())) continue;
                                ArrayList<String> registryToRemove = new ArrayList<String>();
                                for (Class regId : obj.getRegistryItemsClass()) {
                                    IRegistryService.IRegistry reg = (IRegistryService.IRegistry)regMap.get(regId);
                                    if (reg == null) continue;
                                    reg.unregisterFrom(u.getSource().getId());
                                    registryToRemove.add(regId.getName());
                                }
                                u.getSource().getContributedRegistry().removeAll(registryToRemove);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (CacheImpl.this.sup == null) break block7;
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        }

        public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
            RegistrationDescriptor obj = (RegistrationDescriptor)item;
            String objID = obj.getRegistrationKey().getProviderFileID();
            URI techResourceURI = CacheImpl.this.findResourceURIByFileId(objID);
            HashMap<String, IRegistryService.IRegistry> regMap = new HashMap<String, IRegistryService.IRegistry>();
            for (Class c : obj.getRegistryItemsClass()) {
                IRegistryService.IRegistry reg = CacheImpl.this.registryService.getRegistry(c);
                if (reg == null) continue;
                regMap.put(c.getName(), reg);
            }
            Source s = CacheImpl.this.getSuper().getSource(techResourceURI);
            if (s != null) {
                for (Elt elt : s.getElt()) {
                    for (Elt u : elt.getUsage()) {
                        if (u.getSource() == null || u.getSource().getState() != StateType.SYNCHRO) continue;
                        this.toUpdate.add(u.getSource());
                    }
                }
            }
        }

        public void handleBatchedEvent() {
            CacheImpl.this.freeMemory(true);
            for (Source s : this.toUpdate) {
                SafeRunner.run(() -> CacheImpl.this.handleEvent(new CacheSourceEvent(s.getId(), s.getURI(), null, CacheSourceEvent.Event.UPDATE)));
            }
            this.toUpdate.clear();
        }
    }
}

