/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CacheListenerServiceTrackerCustomizer
implements ServiceTrackerCustomizer<ICacheListener, ICacheListener> {
    private final BundleContext context;
    private Collection<ICacheListener> listeners = Collections.synchronizedSet(new HashSet());
    private List<ICacheListener> unsynclisteners = new ArrayList<ICacheListener>();

    public CacheListenerServiceTrackerCustomizer(BundleContext ctx) {
        this.context = ctx;
    }

    public ICacheListener addingService(ServiceReference<ICacheListener> reference) {
        ICacheListener listener = (ICacheListener)this.context.getService(reference);
        this.handleListenerAdded(listener);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleListenerAdded(ICacheListener listener) {
        if (this.listeners.add(listener)) {
            List<ICacheListener> list = this.unsynclisteners;
            synchronized (list) {
                this.unsynclisteners = new ArrayList<ICacheListener>(this.listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleListenerRemoved(ICacheListener listener) {
        if (this.listeners.remove(listener)) {
            List<ICacheListener> list = this.unsynclisteners;
            synchronized (list) {
                this.unsynclisteners = new ArrayList<ICacheListener>(this.listeners);
            }
        }
    }

    public void modifiedService(ServiceReference<ICacheListener> reference, ICacheListener service) {
    }

    public void removedService(ServiceReference<ICacheListener> reference, ICacheListener service) {
        this.handleListenerRemoved(service);
        this.context.ungetService(reference);
    }

    public List<ICacheListener> getListeners() {
        return this.unsynclisteners;
    }
}

